/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui;

import com.floreantpos.ITicketList;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentStatusFilter;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.ui.order.TicketListView;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXCollapsiblePane;

public class OrderFilterPanel
extends JXCollapsiblePane {
    private ITicketList ticketList;
    private TicketListView ticketLists;
    private POSToggleButton btnFilterByOpenStatus;
    private POSToggleButton btnFilterByUnPaidStatus;

    public OrderFilterPanel(ITicketList ticketList) {
        this.ticketList = ticketList;
        this.ticketLists = (TicketListView)ticketList;
        this.setCollapsed(true);
        this.getContentPane().setLayout((LayoutManager)new MigLayout("fill", "fill, grow", ""));
        this.createPaymentStatusFilterPanel();
        this.createOrderTypeFilterPanel();
        this.createMyTicketPanel();
    }

    private void createPaymentStatusFilterPanel() {
        this.btnFilterByOpenStatus = new POSToggleButton(PaymentStatusFilter.OPEN.getDisplayString());
        this.btnFilterByOpenStatus.setActionCommand(PaymentStatusFilter.OPEN.name());
        this.btnFilterByUnPaidStatus = new POSToggleButton(PaymentStatusFilter.CLOSED.getDisplayString());
        this.btnFilterByUnPaidStatus.setActionCommand(PaymentStatusFilter.CLOSED.name());
        ButtonGroup paymentGroup = new ButtonGroup();
        paymentGroup.add(this.btnFilterByOpenStatus);
        paymentGroup.add(this.btnFilterByUnPaidStatus);
        PaymentStatusFilter paymentStatusFilter = TerminalConfig.getPaymentStatusFilter();
        switch (paymentStatusFilter) {
            case OPEN: {
                this.btnFilterByOpenStatus.setSelected(true);
                break;
            }
            case PAID: {
                break;
            }
            case CLOSED: {
                this.btnFilterByUnPaidStatus.setSelected(true);
            }
        }
        ActionListener psFilterHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String actionCommand = e.getActionCommand();
                String filter = actionCommand.replaceAll("\\s", "_");
                TerminalConfig.setPaymentStatusFilter(filter);
                OrderFilterPanel.this.doUpdateTicketList();
            }
        };
        this.btnFilterByOpenStatus.addActionListener(psFilterHandler);
        this.btnFilterByUnPaidStatus.addActionListener(psFilterHandler);
        JPanel filterByPaymentStatusPanel = new JPanel((LayoutManager)new MigLayout("", "fill, grow", ""));
        filterByPaymentStatusPanel.setBorder(new TitledBorder(Messages.getString("SwitchboardView.3")));
        filterByPaymentStatusPanel.add(this.btnFilterByOpenStatus);
        filterByPaymentStatusPanel.add(this.btnFilterByUnPaidStatus);
        this.getContentPane().add(filterByPaymentStatusPanel);
    }

    private void createOrderTypeFilterPanel() {
        OrderTypeFilterButton btnFilterByOrderTypeALL = new OrderTypeFilterButton(POSConstants.ALL);
        JPanel filterByOrderPanel = new JPanel((LayoutManager)new MigLayout("", "fill, grow", ""));
        filterByOrderPanel.setBorder(new TitledBorder(Messages.getString("SwitchboardView.4")));
        ButtonGroup orderTypeGroup = new ButtonGroup();
        orderTypeGroup.add(btnFilterByOrderTypeALL);
        filterByOrderPanel.add(btnFilterByOrderTypeALL);
        List<OrderType> orderTypes = Application.getInstance().getOrderTypes();
        for (OrderType orderType : orderTypes) {
            OrderTypeFilterButton orderTypeFilterButton = new OrderTypeFilterButton(orderType.getName());
            orderTypeGroup.add(orderTypeFilterButton);
            filterByOrderPanel.add(orderTypeFilterButton);
        }
        this.getContentPane().add(filterByOrderPanel);
    }

    private void createMyTicketPanel() {
        JPanel filterByOwnTicketPanel = new JPanel((LayoutManager)new MigLayout("", "fill, grow", ""));
        filterByOwnTicketPanel.setBorder(new TitledBorder("FILTER TICKETS BY OWNER"));
        POSToggleButton btnFilterByOrderTypeMyTickets = new POSToggleButton(POSConstants.MY_TICKETS);
        filterByOwnTicketPanel.add((Component)btnFilterByOrderTypeMyTickets, "");
        btnFilterByOrderTypeMyTickets.setSelected(TerminalConfig.isFilterByOwner());
        btnFilterByOrderTypeMyTickets.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int state = e.getStateChange();
                if (state == 1) {
                    TerminalConfig.setFilterByOwner(true);
                    OrderFilterPanel.this.doUpdateTicketList();
                } else {
                    TerminalConfig.setFilterByOwner(false);
                    OrderFilterPanel.this.doUpdateTicketList();
                }
            }
        });
        this.getContentPane().add(filterByOwnTicketPanel);
    }

    private void updateButton() {
        PaymentStatusFilter paymentStatusFilter = TerminalConfig.getPaymentStatusFilter();
        if (paymentStatusFilter.name().equals(PaymentStatusFilter.OPEN.getDisplayString())) {
            this.btnFilterByOpenStatus.setSelected(true);
        } else if (paymentStatusFilter.name().equals(PaymentStatusFilter.CLOSED.getDisplayString())) {
            this.btnFilterByUnPaidStatus.setSelected(true);
        }
    }

    private void doUpdateTicketList() {
        this.ticketList.updateTicketList();
        this.ticketLists.updateButtonStatus();
    }

    private class OrderTypeFilterButton
    extends POSToggleButton
    implements ActionListener {
        public OrderTypeFilterButton(String name) {
            String orderTypeFilter = TerminalConfig.getOrderTypeFilter();
            if (orderTypeFilter.equals(name)) {
                this.setSelected(true);
            }
            this.setText(name);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setSelected(true);
            String actionCommand = e.getActionCommand();
            TerminalConfig.setOrderTypeFilter(actionCommand);
            OrderFilterPanel.this.doUpdateTicketList();
        }
    }
}

