/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.AppProperties;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.CashDrawerTransactionReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.swing.JRViewer;

@Deprecated
public class CashDrawerTransactionInfoDialog
extends POSDialog {
    private JPanel reportViewPanel;
    private TitlePanel titlePanel;
    private CashDrawer cashDrawerReport;
    private PosButton btnPrint;
    private List<CashDrawer> drawerReports;

    public CashDrawerTransactionInfoDialog(CashDrawer report) {
        super(POSUtil.getFocusedWindow(), "");
        this.setModal(true);
        this.cashDrawerReport = report;
        this.initComponents();
        this.setSize(PosUIManager.getSize(870, 670));
    }

    public CashDrawerTransactionInfoDialog(CashDrawer report, List<CashDrawer> drawerReports) {
        super(POSUtil.getFocusedWindow(), "");
        this.setModal(true);
        this.drawerReports = drawerReports;
        this.cashDrawerReport = report;
        this.initComponents();
        this.setSize(PosUIManager.getSize(870, 670));
    }

    public void initialize(JasperPrint jasperPrint) throws Exception {
        this.reportViewPanel.removeAll();
        JRViewer receiptView = new JRViewer(jasperPrint);
        this.reportViewPanel.add((Component)receiptView);
        this.reportViewPanel.revalidate();
        this.reportViewPanel.repaint();
    }

    public void setServerDetailsInfo() throws Exception {
        this.reportViewPanel.removeAll();
        ArrayList<PosTransaction> allTransactionsList = new ArrayList<PosTransaction>();
        if (this.cashDrawerReport == null) {
            return;
        }
        List<PosTransaction> transactions = PosTransactionDAO.getInstance().findTransactionsForServer(this.cashDrawerReport.getStoreOperationData().getId(), this.cashDrawerReport.getAssignedUser().getId());
        allTransactionsList.addAll(transactions);
        CashDrawerTransactionReportModel reportModel = new CashDrawerTransactionReportModel();
        reportModel.setItems(allTransactionsList);
        HashMap<String, String> map = new HashMap<String, String>();
        Store store = Application.getInstance().getStore();
        map.put("headerLine1", store.getName());
        map.put("headerLine2", store.getAddressLine1());
        map.put("receiptType", "Server Detail Report");
        if (this.cashDrawerReport.getAssignedUser() != null) {
            map.put("serverName", "Server: " + this.cashDrawerReport.getAssignedUser());
        }
        Date storeCloseTime = this.cashDrawerReport.getStoreOperationData() != null ? this.cashDrawerReport.getStoreOperationData().getCloseTime() : new Date();
        String strDate = "<b>From:</b> " + DateUtil.formatFullDateAndTimeAsString(this.cashDrawerReport.getStartTime()) + " <b>To:</b> " + DateUtil.formatFullDateAndTimeAsString(storeCloseTime != null ? storeCloseTime : new Date());
        map.put("startDate", strDate);
        map.put("status", allTransactionsList == null || allTransactionsList.isEmpty() ? "No transaction found." : null);
        JasperReport masterReport = ReportUtil.getReport("server_details_report");
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)masterReport, map, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        JRViewer receiptView = new JRViewer(jasperPrint);
        this.reportViewPanel.add((Component)receiptView);
        this.reportViewPanel.revalidate();
        this.reportViewPanel.repaint();
    }

    public void generateSessionDetailReport() throws Exception {
        this.reportViewPanel.removeAll();
        ArrayList<PosTransaction> allTransactionsList = new ArrayList<PosTransaction>();
        if (this.cashDrawerReport == null) {
            return;
        }
        List<PosTransaction> transactions = PosTransactionDAO.getInstance().findTransactionsForSession(this.cashDrawerReport.getStoreSessionId());
        allTransactionsList.addAll(transactions);
        CashDrawerTransactionReportModel reportModel = new CashDrawerTransactionReportModel();
        reportModel.setItems(allTransactionsList);
        HashMap<String, String> map = new HashMap<String, String>();
        Store store = Application.getInstance().getStore();
        map.put("headerLine1", store.getName());
        map.put("headerLine2", store.getAddressLine1());
        map.put("receiptType", "Session Detail Report");
        Date storeCloseTime = this.cashDrawerReport.getStoreOperationData() != null ? this.cashDrawerReport.getStoreOperationData().getCloseTime() : new Date();
        String strDate = "<b>From:</b> " + DateUtil.formatFullDateAndTimeAsString(this.cashDrawerReport.getStartTime()) + " <b>To:</b> " + DateUtil.formatFullDateAndTimeAsString(storeCloseTime != null ? storeCloseTime : new Date());
        map.put("startDate", strDate);
        map.put("status", allTransactionsList == null || allTransactionsList.isEmpty() ? "No transaction found." : null);
        JasperReport masterReport = ReportUtil.getReport("server_details_report");
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)masterReport, map, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        JRViewer receiptView = new JRViewer(jasperPrint);
        this.reportViewPanel.add((Component)receiptView);
        this.reportViewPanel.revalidate();
        this.reportViewPanel.repaint();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.titlePanel = new TitlePanel();
        this.add((Component)this.titlePanel, "North");
        this.reportViewPanel = new JPanel(new BorderLayout());
        PosScrollPane scrollPane = new PosScrollPane(this.reportViewPanel);
        this.add(scrollPane);
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,ins 5 5 5 5,wrap 4", "[grow]", ""));
        this.btnPrint = new PosButton(Messages.getString("DrawerPullReportDialog.8"));
        PosButton btnCancel = new PosButton(POSConstants.CANCEL_BUTTON_TEXT);
        buttonPanel.add((Component)new JSeparator(), "grow,span,wrap");
        buttonPanel.add((Component)btnCancel, "grow");
        this.add((Component)buttonPanel, "South");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CashDrawerTransactionInfoDialog.this.doCloseDialog();
            }
        });
        this.btnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CashDrawerTransactionInfoDialog.this.doPrintReport();
            }
        });
    }

    private void doCloseDialog() {
        this.dispose();
    }

    @Override
    public void setTitle(String title) {
        this.titlePanel.setTitle(title);
        super.setTitle(AppProperties.getAppName());
    }

    private void doPrintReport() {
    }
}

