/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public abstract class EmailSelectionDialog
extends OkCancelOptionDialog {
    private JRadioButton rbPrimaryEmail = new JRadioButton(Messages.getString("EmailSelectionDialog.0"));
    private JRadioButton rbSecondaryEmail = new JRadioButton(Messages.getString("EmailSelectionDialog.1"));
    private JRadioButton rbNewEmail = new JRadioButton(Messages.getString("EmailSelectionDialog.2"));
    private JLabel lblPrimaryEmail = new JLabel();
    private JLabel lblSecondaryEmail = new JLabel();
    private FixedLengthTextField tfNewEmail = new FixedLengthTextField();
    private String email1;
    private String email2;

    public EmailSelectionDialog(String title, String email1, String email2) {
        super(POSUtil.getFocusedWindow());
        this.setCaption(title);
        this.email1 = email1;
        this.email2 = email2;
        this.initComponents();
    }

    private void initComponents() {
        this.setOkButtonText(Messages.getString("EmailSelectionDialog.3"));
        Font f = new Font(this.lblPrimaryEmail.getFont().getName(), 0, 17);
        Color textColor = Color.gray;
        JPanel contentPanel = this.getContentPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("center,fillx,wrap 1", "[grow]"));
        JSeparator sep = new JSeparator();
        JSeparator sep2 = new JSeparator();
        String gapLeft = ",gapleft 20";
        String grow = "growx,span";
        this.rbPrimaryEmail.setFocusable(false);
        this.rbSecondaryEmail.setFocusable(false);
        this.rbNewEmail.setFocusable(false);
        this.tfNewEmail.setFocusable(false);
        this.tfNewEmail.setEditable(false);
        if (StringUtils.isNotEmpty((String)this.email1)) {
            this.rbPrimaryEmail.setSelected(true);
        } else if (StringUtils.isNotEmpty((String)this.email2)) {
            this.rbSecondaryEmail.setSelected(true);
        } else {
            this.tfNewEmail.setFocusable(true);
            this.rbNewEmail.setSelected(true);
            this.tfNewEmail.setEditable(true);
            this.tfNewEmail.requestFocus();
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbPrimaryEmail);
        buttonGroup.add(this.rbSecondaryEmail);
        buttonGroup.add(this.rbNewEmail);
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmailSelectionDialog.this.tfNewEmail.setEditable(EmailSelectionDialog.this.rbNewEmail.isSelected());
                EmailSelectionDialog.this.tfNewEmail.setFocusable(EmailSelectionDialog.this.rbNewEmail.isSelected());
                if (EmailSelectionDialog.this.tfNewEmail.isFocusable()) {
                    EmailSelectionDialog.this.tfNewEmail.requestFocus();
                }
            }
        };
        this.rbNewEmail.addActionListener(l);
        this.rbPrimaryEmail.addActionListener(l);
        this.rbSecondaryEmail.addActionListener(l);
        this.lblPrimaryEmail.setForeground(textColor);
        this.lblSecondaryEmail.setForeground(textColor);
        this.rbPrimaryEmail.setFont(f);
        this.rbSecondaryEmail.setFont(f);
        this.rbNewEmail.setFont(f);
        String noEmailString = Messages.getString("EmailSelectionDialog.8");
        this.lblPrimaryEmail.setText(StringUtils.isNotEmpty((String)this.email1) ? this.email1 : noEmailString);
        this.lblSecondaryEmail.setText(StringUtils.isNotEmpty((String)this.email2) ? this.email2 : noEmailString);
        QwertyKeyPad keypad = new QwertyKeyPad(true);
        contentPanel.add((Component)this.rbPrimaryEmail, grow);
        contentPanel.add((Component)this.lblPrimaryEmail, grow + gapLeft);
        contentPanel.add((Component)sep, "growx,span,h 1!");
        contentPanel.add((Component)this.rbSecondaryEmail, grow);
        contentPanel.add((Component)this.lblSecondaryEmail, grow + gapLeft);
        contentPanel.add((Component)sep2, "growx,span,h 1!");
        contentPanel.add((Component)this.rbNewEmail, grow);
        contentPanel.add((Component)this.tfNewEmail, "h 40!,span,growx,");
        contentPanel.add((Component)((Object)keypad), "grow,span");
    }

    public abstract boolean doSendEmail(String var1);

    @Override
    public void doOk() {
        if (this.rbNewEmail.isSelected() && StringUtils.isEmpty((String)this.tfNewEmail.getText())) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("EmailSelectionDialog.13"));
            return;
        }
        if (this.rbPrimaryEmail.isSelected() && StringUtils.isEmpty((String)this.email1)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("EmailSelectionDialog.14"));
            return;
        }
        if (this.rbSecondaryEmail.isSelected() && StringUtils.isEmpty((String)this.email2)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("EmailSelectionDialog.14"));
            return;
        }
        if (!this.doSendEmail(this.getEmailAddress())) {
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    private String getEmailAddress() {
        if (this.rbPrimaryEmail.isSelected()) {
            return this.email1;
        }
        if (this.rbSecondaryEmail.isSelected()) {
            return this.email2;
        }
        return this.tfNewEmail.getText();
    }
}

