/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.GiftCard;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.swing.JRViewer;
import net.sf.jasperreports.swing.JRViewerToolbar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GiftCardInfo
extends POSDialog {
    private GiftCard giftCard;
    private static Log log = LogFactory.getLog(GiftCardInfo.class);
    private JasperPrint print;

    public GiftCardInfo(GiftCard giftCard) {
        this.giftCard = giftCard;
        this.initializeComponents();
    }

    private String cardNumberWithDashe(String symbol) {
        String cardNumber = this.giftCard.getCardNumber();
        StringBuilder gcn = new StringBuilder(cardNumber);
        for (int i = 0; i < gcn.length(); ++i) {
            if (i != 4 && i != 9 && i != 14) continue;
            gcn.insert(i, "-");
        }
        return gcn.toString();
    }

    public JRViewer createReport() {
        JRViewer viewer;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("cafeName", Application.getInstance().getStore().getName());
        parameters.put("cardNumber", this.cardNumberWithDashe("-"));
        parameters.put("cardHolder", this.giftCard.getOwnerName());
        parameters.put("cardStatus", this.giftCard.isActive());
        parameters.put("cardExpireDate", this.giftCard.getExpiryDate());
        parameters.put("batchNumber", this.giftCard.getBatchNo());
        parameters.put("balance", String.valueOf(POSUtil.getRoundedDouble(this.giftCard.getBalance())));
        parameters.put("cardLogo", Application.getApplicationIcon().getImage());
        parameters.put("bgImage", new ImageIcon(this.getClass().getResource("/images/giftCardBackground.jpg")).getImage());
        parameters.put("currency_symbol", CurrencyUtil.getCurrencySymbol());
        JasperReport report = ReportUtil.getReport("gift_card");
        try {
            Component[] viewerComponents;
            this.print = JasperFillManager.fillReport((JasperReport)report, parameters, (JRDataSource)new JREmptyDataSource());
            viewer = new JRViewer(this.print);
            for (Component component : viewerComponents = viewer.getComponents()) {
                PosLog.info(this.getClass(), "");
                if (!(component instanceof JRViewerToolbar)) continue;
                component.setVisible(false);
            }
        }
        catch (JRException e) {
            log.error((Object)e);
            return null;
        }
        return viewer;
    }

    private void initializeComponents() {
        if (this.giftCard == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardInfo.0"));
            return;
        }
        this.setTitle(Messages.getString("GiftCardInfo.1"));
        this.setLayout(new BorderLayout(10, 10));
        JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BorderLayout());
        northPanel.add((Component)this.createReport(), "Center");
        JPanel southPanel = new JPanel(new BorderLayout());
        PosButton btnPrint = new PosButton(Messages.getString("GiftCardInfo.2"));
        PosButton btnClose = new PosButton(Messages.getString("GiftCardInfo.3"));
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftCardInfo.this.dispose();
            }
        });
        btnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GiftCardInfo.this.print.setName(Messages.getString("GiftCardInfo.4"));
                    ReceiptPrintService.printQuitely(GiftCardInfo.this.print);
                }
                catch (JRException e1) {
                    log.error((Object)e);
                }
            }
        });
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout((LayoutManager)new MigLayout("fill,center"));
        btnPanel.add((Component)btnPrint, "split 2,grow");
        btnPanel.add((Component)btnClose, "grow");
        southPanel.add((Component)btnPanel, "South");
        mainPanel.add((Component)northPanel, "Center");
        mainPanel.add((Component)southPanel, "South");
        this.add((Component)mainPanel, "Center");
        PosButton btnPrintStoreCopy = new PosButton(Messages.getString("TransactionCompletionDialog.38"));
    }
}

