/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;

public class MultipleNumberSelectionDialog
extends POSDialog
implements ActionListener {
    private TitlePanel titlePanel;
    private List<Integer> numbers = new ArrayList<Integer>();
    private List<Integer> selectedNumbers = new ArrayList<Integer>();
    private PosButton btnOk;

    public MultipleNumberSelectionDialog(List<Integer> numbers) {
        this.numbers = numbers;
        this.init();
    }

    private void init() {
        this.setTitle("SELECT SPLIT TICKETS");
        this.setLayout(new BorderLayout());
        MigLayout layout = new MigLayout("fillx,wrap 3,inset 10", "sg fill", "");
        JPanel contentPane = new JPanel();
        contentPane.setLayout((LayoutManager)layout);
        this.titlePanel = new TitlePanel();
        this.titlePanel.setTitle("Select tickets to share item.");
        this.add((Component)this.titlePanel, "North");
        int h = PosUIManager.getSize(70);
        for (Integer seat : this.numbers) {
            POSToggleButton posButton = new POSToggleButton();
            posButton.setActionCommand("" + seat);
            posButton.setFocusable(false);
            posButton.setFont(posButton.getFont().deriveFont(1, 24.0f));
            posButton.setText(String.valueOf(seat));
            if (!this.selectedNumbers.isEmpty() && this.selectedNumbers.contains(seat)) {
                posButton.setBackground(Color.GREEN);
            }
            posButton.addActionListener(this);
            String constraints = "grow, height " + h;
            contentPane.add((Component)posButton, constraints);
        }
        this.add(contentPane);
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("fill", "sg fill"));
        this.btnOk = new PosButton("DONE");
        this.btnOk.setFocusable(false);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MultipleNumberSelectionDialog.this.selectedNumbers.isEmpty()) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select splitted tickets no.");
                    return;
                }
                MultipleNumberSelectionDialog.this.setCanceled(false);
                MultipleNumberSelectionDialog.this.dispose();
            }
        });
        buttonPanel.add((Component)new JSeparator(), "span,grow,gapbottom 3,wrap");
        buttonPanel.add((Component)this.btnOk, "grow,height " + h);
        PosButton btnCancel = new PosButton(Messages.getString("SeatSelectionDialog.2"));
        btnCancel.setFocusable(false);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultipleNumberSelectionDialog.this.setCanceled(true);
                MultipleNumberSelectionDialog.this.dispose();
            }
        });
        buttonPanel.add((Component)btnCancel, "grow, height " + h);
        this.add((Component)buttonPanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        POSToggleButton btnNumber = (POSToggleButton)e.getSource();
        Integer command = null;
        try {
            command = Integer.valueOf(e.getActionCommand());
        }
        catch (Exception ex) {
            return;
        }
        if (command != null && !this.selectedNumbers.contains(command)) {
            this.selectedNumbers.add(command);
            btnNumber.setBackground(Color.GREEN);
        } else {
            this.selectedNumbers.remove(command);
            btnNumber.setBackground(this.btnOk.getBackground());
        }
    }

    public List<Integer> getViewNumbers() {
        return this.selectedNumbers;
    }

    public void setDialogTitle(String title) {
        super.setTitle(title);
    }
}

