/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.config.AppProperties;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.NumericKeypad;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NumberSelectionDialog2
extends OkCancelOptionDialog {
    private int defaultValue;
    private JTextField tfNumber;
    private boolean floatingPoint;
    private PosButton incrementQuantitybtn;
    private PosButton decrementQuantitybtn;

    public NumberSelectionDialog2() {
        super(POSUtil.getFocusedWindow());
        this.init();
    }

    public NumberSelectionDialog2(boolean allowFlotingPoint) {
        super(POSUtil.getFocusedWindow());
        this.setFloatingPoint(allowFlotingPoint);
        this.init();
    }

    private void init() {
        this.setResizable(false);
        JPanel contentPane = this.getContentPanel();
        contentPane.setLayout(new BorderLayout(5, 5));
        JPanel firstpanel = new JPanel(new BorderLayout(5, 0));
        this.tfNumber = this.isFloatingPoint(true) ? new DoubleTextField(10) : new IntegerTextField(10);
        this.tfNumber.setHorizontalAlignment(11);
        this.tfNumber.setFont(this.tfNumber.getFont().deriveFont(1, PosUIManager.getNumberFieldFontSize()));
        this.tfNumber.setFocusable(true);
        this.tfNumber.setBackground(Color.WHITE);
        firstpanel.add((Component)this.tfNumber, "Center");
        this.incrementQuantitybtn = new PosButton("+");
        this.incrementQuantitybtn.setFont(new Font("Arial", 0, 30));
        this.incrementQuantitybtn.setFocusable(false);
        firstpanel.add((Component)this.incrementQuantitybtn, "East");
        this.incrementQuantitybtn.setPreferredSize(PosUIManager.getSize(60, 60));
        this.decrementQuantitybtn = new PosButton("-");
        this.decrementQuantitybtn.setPreferredSize(PosUIManager.getSize(60, 60));
        this.decrementQuantitybtn.setFont(new Font("Arial", 1, 30));
        this.decrementQuantitybtn.setFocusable(false);
        firstpanel.add((Component)this.decrementQuantitybtn, "West");
        contentPane.add((Component)firstpanel, "North");
        JPanel secondpanel = new JPanel(new BorderLayout());
        NumericKeypad numericKeypad = new NumericKeypad();
        secondpanel.add((Component)numericKeypad, "Center");
        contentPane.add((Component)secondpanel, "South");
        this.tfNumber.requestFocus();
        this.setControlButtonsVisible(true);
        this.buttonAction();
    }

    @Override
    public void doOk() {
        if (!this.validate(this.tfNumber.getText())) {
            POSMessageDialog.showError(this, POSConstants.INVALID_NUMBER);
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    public void buttonAction() {
        try {
            this.incrementQuantitybtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    double total = Double.parseDouble(NumberSelectionDialog2.this.tfNumber.getText());
                    if (total == Math.floor(total) || !Double.isInfinite(total)) {
                        NumberSelectionDialog2.this.tfNumber.setText("" + NumberUtil.trimDecilamIfNotNeeded(total += 1.0));
                    }
                }
            });
            this.decrementQuantitybtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    double total = Double.parseDouble(NumberSelectionDialog2.this.tfNumber.getText());
                    if ((total == Math.floor(total) || !Double.isInfinite(total)) && (total -= 1.0) >= 0.0) {
                        NumberSelectionDialog2.this.tfNumber.setText("" + NumberUtil.trimDecilamIfNotNeeded(total));
                    }
                }
            });
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public void setControlButtonsVisible(boolean visible) {
        this.incrementQuantitybtn.setVisible(visible);
        this.decrementQuantitybtn.setVisible(visible);
    }

    private boolean validate(String str) {
        if (this.isFloatingPoint(false)) {
            try {
                Double.parseDouble(str);
            }
            catch (Exception x) {
                return false;
            }
        }
        try {
            Long.parseLong(str);
        }
        catch (Exception x) {
            return false;
        }
        return true;
    }

    @Override
    public void setTitle(String title) {
        super.setCaption(title);
        super.setTitle(title);
    }

    public void setDialogTitle(String title) {
        super.setTitle(title);
    }

    public double getValue() {
        return Double.parseDouble(this.tfNumber.getText());
    }

    public void setValue(double value) {
        if (value == 0.0) {
            if (this.floatingPoint) {
                this.tfNumber.setText("0");
                this.tfNumber.selectAll();
            } else {
                this.tfNumber.setText("");
            }
        } else if (this.isFloatingPoint(true)) {
            this.tfNumber.setText(String.valueOf(value));
        } else {
            this.tfNumber.setText(String.valueOf((int)value));
        }
        this.tfNumber.selectAll();
    }

    public boolean isFloatingPoint(boolean b) {
        return this.floatingPoint;
    }

    public void setFloatingPoint(boolean decimalAllowed) {
        this.floatingPoint = decimalAllowed;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(int defaultValue) {
        this.defaultValue = defaultValue;
        this.tfNumber.setText(String.valueOf(defaultValue));
    }

    public static long takeIntInput(String title) {
        NumberSelectionDialog2 dialog = new NumberSelectionDialog2(false);
        dialog.setTitle(title);
        dialog.pack();
        dialog.open();
        if (dialog.isCanceled()) {
            return -1L;
        }
        return (long)dialog.getValue();
    }

    public static long takeIntInput(String title, double initialAmount) {
        NumberSelectionDialog2 dialog = new NumberSelectionDialog2(false);
        dialog.setTitle(title);
        dialog.setValue(initialAmount);
        dialog.pack();
        dialog.open();
        if (dialog.isCanceled()) {
            return -1L;
        }
        return (long)dialog.getValue();
    }

    public static double takeDoubleInput(String title, String dialogTitle, double initialAmount) {
        NumberSelectionDialog2 dialog = new NumberSelectionDialog2(true);
        dialog.setValue(initialAmount);
        dialog.setTitle(title);
        dialog.setDialogTitle(dialogTitle);
        dialog.pack();
        dialog.open();
        if (dialog.isCanceled()) {
            return -1.0;
        }
        return dialog.getValue();
    }

    public static double takeDoubleInput(String title, double initialAmount) {
        NumberSelectionDialog2 dialog = new NumberSelectionDialog2(true);
        dialog.setTitle(title);
        dialog.setValue(initialAmount);
        dialog.pack();
        dialog.open();
        if (dialog.isCanceled()) {
            return -1.0;
        }
        return dialog.getValue();
    }

    public static double show(Component parent, String title, double initialAmount) {
        NumberSelectionDialog2 dialog2 = new NumberSelectionDialog2(true);
        dialog2.setTitle(title);
        dialog2.pack();
        dialog2.setLocationRelativeTo(parent);
        dialog2.setValue(initialAmount);
        dialog2.setVisible(true);
        if (dialog2.isCanceled()) {
            return Double.NaN;
        }
        return dialog2.getValue();
    }

    public static double takeDoubleInput(String title, double initialAmount, boolean floatingPoint) {
        NumberSelectionDialog2 dialog = new NumberSelectionDialog2(true);
        dialog.setTitle(AppProperties.getAppName());
        dialog.setCaption(title);
        dialog.setValue(initialAmount);
        dialog.setFloatingPoint(floatingPoint);
        dialog.pack();
        dialog.open();
        if (dialog.isCanceled()) {
            return -1.0;
        }
        return dialog.getValue();
    }

    public void setUtilityButtonsVisible(boolean visible) {
        this.incrementQuantitybtn.setVisible(visible);
        this.decrementQuantitybtn.setVisible(visible);
    }
}

