/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public abstract class OkCancelOptionDialog
extends POSDialog {
    private PosButton btnOk;
    private PosButton btnCancel;
    private TitlePanel titlePanel;
    private TransparentPanel contentPanel;
    private TransparentPanel buttonPanel;

    public OkCancelOptionDialog() {
        super(POSUtil.getFocusedWindow(), "", true);
        this.init();
        this.titlePanel.setTitle("");
    }

    public OkCancelOptionDialog(String title) {
        super((Frame)Application.getPosWindow(), title);
        this.init();
        this.titlePanel.setTitle(title);
    }

    public OkCancelOptionDialog(Window owner) {
        super(owner, "");
        this.init();
    }

    public OkCancelOptionDialog(Frame owner, boolean model) {
        super(owner, model);
        this.init();
    }

    public OkCancelOptionDialog(Dialog owner, boolean model) {
        super(owner, model);
        this.init();
    }

    public OkCancelOptionDialog(Window owner, String title) {
        super(owner, title);
        this.init();
        this.titlePanel.setTitle(title);
    }

    private void init() {
        this.setLayout(new BorderLayout(10, 10));
        this.setIconImage(Application.getApplicationIcon().getImage());
        this.setDefaultCloseOperation(0);
        this.titlePanel = new TitlePanel();
        this.add((Component)this.titlePanel, "North");
        this.contentPanel = new TransparentPanel();
        this.contentPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add((Component)this.contentPanel, "Center");
        JSeparator jSeparator1 = new JSeparator();
        this.buttonPanel = new TransparentPanel();
        this.buttonPanel.setLayout(new FlowLayout());
        this.btnOk = new PosButton();
        this.btnCancel = new PosButton();
        TransparentPanel southPanel = new TransparentPanel();
        southPanel.setLayout(new BorderLayout());
        this.buttonPanel.setLayout(new FlowLayout());
        this.btnOk.setText(POSConstants.OK.toUpperCase());
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OkCancelOptionDialog.this.doOk();
            }
        });
        this.buttonPanel.add(this.btnOk);
        this.btnCancel.setText(POSConstants.CANCEL.toUpperCase());
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OkCancelOptionDialog.this.doCancel();
            }
        });
        this.buttonPanel.add(this.btnCancel);
        southPanel.add((Component)jSeparator1, "North");
        southPanel.add((Component)this.buttonPanel, "Center");
        this.contentPanel.setLayout(new BorderLayout());
        this.add((Component)southPanel, "South");
    }

    public TransparentPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void setCaption(String caption) {
        this.titlePanel.setTitle(caption);
    }

    public void setOkButtonText(String text) {
        this.btnOk.setText(text);
    }

    public void setCancelButtonText(String text) {
        this.btnCancel.setText(text);
    }

    public void setCancelButtonVisible(boolean visible) {
        this.btnCancel.setVisible(visible);
    }

    public void setOkButtonVisible(boolean visible) {
        this.btnOk.setVisible(visible);
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    public abstract void doOk();

    public void doCancel() {
        this.setCanceled(true);
        this.dispose();
    }
}

