/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.POSConstants;
import com.floreantpos.config.AppProperties;
import com.floreantpos.main.Application;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.RefreshableView;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class POSMessageDialog {
    private static Logger logger = Logger.getLogger(Application.class);

    private static void showDialog(Component parent, String message, int messageType, int optionType) {
        POSMessageDialog.showDialog(parent, message, messageType, optionType, null);
    }

    private static boolean showDialog(Component parent, String message, int messageType, int optionType, String option) {
        Component[] options;
        JOptionPane optionPane = null;
        optionPane = option != null ? new JOptionPane(message, messageType, optionType, null, new String[]{option, POSConstants.OK}) : new JOptionPane(message, messageType, optionType);
        for (Component object : options = optionPane.getComponents()) {
            Component[] components;
            if (!(object instanceof JPanel)) continue;
            JPanel panel = (JPanel)object;
            for (Component component : components = panel.getComponents()) {
                if (!(component instanceof JButton)) continue;
                component.setPreferredSize(new Dimension(component.getPreferredSize().width, 60));
            }
        }
        JDialog dialog = optionPane.createDialog(parent, AppProperties.getAppName());
        dialog.setModal(true);
        dialog.setVisible(true);
        if (option == null) {
            return false;
        }
        Object selectedValue = optionPane.getValue();
        return selectedValue != null && selectedValue.equals(option);
    }

    public static void showMessage(String message) {
        POSMessageDialog.showDialog(Application.getPosWindow(), message, 1, -1);
    }

    public static void showMessage(Component parent, String message) {
        POSMessageDialog.showDialog(parent, message, 1, -1);
    }

    public static void showError(String message) {
        POSMessageDialog.showDialog(Application.getPosWindow(), message, 0, -1);
    }

    public static void showError(Component parent, String message) {
        POSMessageDialog.showDialog(parent, message, 0, -1);
    }

    public static boolean showErrorWithOption(Component parent, String message, String option) {
        return POSMessageDialog.showDialog(parent, message, 0, -1, option);
    }

    public static void showError(Component parent, String message, Throwable x) {
        logger.error((Object)message, x);
        POSMessageDialog.showDialog(parent, message, 0, -1);
    }

    public static int showYesNoQuestionDialog(Component parent, String message, String title) {
        return POSMessageDialog.showYesNoQuestionDialog(parent, message, title, null, null);
    }

    public static int showYesNoQuestionDialog(Component parent, String message, String title, String yesButtonText, String noButtonText) {
        Component[] options;
        JOptionPane optionPane = null;
        optionPane = yesButtonText != null && noButtonText != null ? new JOptionPane(message, 3, 1, null, new String[]{yesButtonText, noButtonText}) : new JOptionPane(message, 3, 0);
        for (Component object : options = optionPane.getComponents()) {
            Component[] components;
            if (!(object instanceof JPanel)) continue;
            JPanel panel = (JPanel)object;
            for (Component component : components = panel.getComponents()) {
                if (!(component instanceof JButton)) continue;
                component.setPreferredSize(new Dimension(component.getPreferredSize().width, 60));
            }
        }
        JDialog dialog = optionPane.createDialog(parent, title);
        dialog.setVisible(true);
        Object selectedValue = optionPane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (selectedValue instanceof String) {
            return selectedValue.equals(noButtonText) ? 1 : 0;
        }
        return (Integer)selectedValue;
    }

    public static String showOptionDialog(Component parent, String message, String title, String ... options) {
        Component[] optionComponents;
        JOptionPane optionPane = null;
        optionPane = options != null ? new JOptionPane(message, 3, 1, null, options) : new JOptionPane(message, 3, 0);
        for (Component object : optionComponents = optionPane.getComponents()) {
            Component[] components;
            if (!(object instanceof JPanel)) continue;
            JPanel panel = (JPanel)object;
            for (Component component : components = panel.getComponents()) {
                if (!(component instanceof JButton)) continue;
                component.setPreferredSize(new Dimension(component.getPreferredSize().width, 60));
            }
        }
        JDialog dialog = optionPane.createDialog(parent, title);
        dialog.setVisible(true);
        Object selectedValue = optionPane.getValue();
        if (selectedValue != null) {
            return selectedValue.toString();
        }
        return null;
    }

    public static boolean showMessageAndPromtToPrint(String msg) {
        return POSMessageDialog.showMessageAndPromtToPrint(null, msg);
    }

    public static boolean showMessageAndPromtToPrint(Component parent, String msg) {
        Component[] optionValues;
        JOptionPane promtPane = new JOptionPane(msg, 1, 1, null, new String[]{POSConstants.PRINT, POSConstants.OK.toUpperCase()});
        for (Component object : optionValues = promtPane.getComponents()) {
            if (!(object instanceof JPanel)) continue;
            JPanel panel = (JPanel)object;
            Component[] components = panel.getComponents();
            boolean printIcon = true;
            for (Component component : components) {
                if (!(component instanceof JButton)) continue;
                component.setPreferredSize(PosUIManager.getSize(100, 50));
                JButton button = (JButton)component;
                if (!printIcon) continue;
                button.setIcon(IconFactory.getIcon("/ui_icons/", "print_32.png"));
                button.setText("PRINT");
                printIcon = false;
                button.setFocusable(false);
            }
        }
        JDialog dialog = promtPane.createDialog(parent == null ? Application.getPosWindow() : parent, "Message");
        dialog.setDefaultCloseOperation(0);
        dialog.setIconImage(Application.getApplicationIcon().getImage());
        dialog.setVisible(true);
        String selectedValue = (String)promtPane.getValue();
        return selectedValue.equals(POSConstants.PRINT);
    }

    public static void showMessageDialogWithReloadButton(Component parent, RefreshableView refreshView) {
        POSMessageDialog.showMessageDialogWithReloadButton(parent, refreshView, "Data has been changed in other terminal. Please reload this window and try again.");
    }

    public static void showMessageDialogWithReloadButton(Component parent, RefreshableView refreshView, String msg) {
        Component[] options;
        JOptionPane reloadPane = new JOptionPane(msg, 0, 0, null, new String[]{"RELOAD", POSConstants.CANCEL.toUpperCase()});
        for (Component object : options = reloadPane.getComponents()) {
            Component[] components;
            if (!(object instanceof JPanel)) continue;
            JPanel panel = (JPanel)object;
            for (Component component : components = panel.getComponents()) {
                if (!(component instanceof JButton)) continue;
                component.setPreferredSize(new Dimension(component.getPreferredSize().width, 60));
            }
        }
        JDialog dialog = reloadPane.createDialog(parent == null ? Application.getPosWindow() : parent, AppProperties.getAppName());
        dialog.setDefaultCloseOperation(2);
        dialog.setIconImage(Application.getApplicationIcon().getImage());
        dialog.setVisible(true);
        String selectedValue = (String)reloadPane.getValue();
        if (selectedValue.equals("RELOAD") && refreshView != null) {
            refreshView.refresh();
        }
    }
}

