/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.VoidTransaction;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.GlobalInputDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class RefundDialog
extends OkCancelOptionDialog {
    private Ticket ticket;
    private Map<String, PosButton> buttonMap = new HashMap<String, PosButton>();
    private PosButton btnCashRefund;
    private PosButton btnGiftCardRefund;
    private JPanel buttonsPanel;
    private double totalTransactionTaxAmount = 0.0;
    private SettleTicketProcessor settleTicketProcessor;

    public RefundDialog(Window window, Ticket ticket, SettleTicketProcessor settleTicketProcessor) {
        super(window, "");
        this.ticket = ticket;
        this.settleTicketProcessor = settleTicketProcessor;
        this.initComponents();
        this.rendererTransactions();
        this.calculateTaxAmount();
    }

    private void initComponents() {
        this.setCaption("Refund " + CurrencyUtil.getCurrencySymbol() + this.getRefundableAmount());
        this.setOkButtonText(POSConstants.SAVE_BUTTON_TEXT);
        this.setDefaultCloseOperation(0);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("inset 0,fill,hidemode 3", "[grow]", ""));
        Font font2 = new Font("Tahoma", 1, PosUIManager.getFontSize(16));
        JPanel inputPanel = new JPanel((LayoutManager)new MigLayout("fill,ins 0 5 2 5,hidemode 3", "[grow]", "[grow]"));
        this.buttonsPanel = new JPanel((LayoutManager)new MigLayout("wrap 3,center", "sg,fill", ""));
        this.btnCashRefund = new PosButton("<html><center><h2> CASH </h2></center></html>");
        this.btnCashRefund.setAction(new CashRefundAction());
        this.btnCashRefund.setMinimumSize(PosUIManager.getSize(120, 110));
        this.btnGiftCardRefund = new PosButton("<html><center><h2> GIFT CARD </h2></center></html>");
        this.btnGiftCardRefund.setAction(new GiftCardRefundAction());
        this.btnGiftCardRefund.setMinimumSize(PosUIManager.getSize(120, 110));
        JLabel lblTransaction = new JLabel("Select transaction to refund");
        lblTransaction.setFont(font2);
        PosScrollPane scrollPane = new PosScrollPane(this.buttonsPanel);
        scrollPane.setBorder(BorderFactory.createTitledBorder(null, "REFUND USING", 2, 2));
        inputPanel.add((Component)scrollPane, "grow,aligny bottom,span");
        contentPanel.add((Component)inputPanel, "grow");
        this.getContentPanel().add(contentPanel);
    }

    private void rendererTransactions() {
        this.buttonsPanel.removeAll();
        this.buttonsPanel.add((Component)this.btnCashRefund, "aligny top");
        this.buttonsPanel.add((Component)this.btnGiftCardRefund, "aligny top");
        if (this.ticket != null && this.ticket.getTransactions() != null) {
            for (PosTransaction t : this.ticket.getTransactions()) {
                if (t.isVoided().booleanValue() || t instanceof RefundTransaction || t instanceof VoidTransaction || t instanceof CashTransaction) continue;
                PosButton btnRefund = new PosButton();
                btnRefund.putClientProperty("transaction", t);
                btnRefund.setAction(new RefundAction());
                btnRefund.setMinimumSize(PosUIManager.getSize(120, 110));
                this.updateButtonText(t, btnRefund);
                this.buttonsPanel.add((Component)btnRefund, "aligny top");
                this.buttonMap.put(t.getId(), btnRefund);
            }
        }
        boolean enableButton = this.ticket.getPaidAmount() != this.ticket.getRefundAmount();
        this.btnCashRefund.setEnabled(enableButton);
        this.btnCashRefund.setText("<html><center><b>CASH </b></center></html>");
        this.btnGiftCardRefund.setEnabled(enableButton);
        this.btnGiftCardRefund.setText("<html><center><b>GIFT CARD </b></center></html>");
        this.buttonsPanel.revalidate();
        this.buttonsPanel.repaint();
    }

    private void updateButtonText(PosTransaction t, PosButton btnRefund) {
        double refundedAmountForTransaction = this.getRefundedAmount(t);
        if (refundedAmountForTransaction > 0.0) {
            btnRefund.setText("<html><center>" + (Object)((Object)t.getPaymentType()) + "<br><h2>" + CurrencyUtil.getCurrencySymbol() + t.getAmount() + "</h2><h5>Refunded -" + CurrencyUtil.getCurrencySymbol() + refundedAmountForTransaction + "</h5></html>");
            btnRefund.setEnabled(t.getAmount() != refundedAmountForTransaction);
            if (t.getAmount() != refundedAmountForTransaction) {
                btnRefund.setSelected(true);
            }
        } else {
            btnRefund.setSelected(true);
            btnRefund.setText("<html><center>" + (Object)((Object)t.getPaymentType()) + "<br><h2>" + CurrencyUtil.getCurrencySymbol() + t.getAmount() + "<h2></center></html>");
        }
    }

    private double getTotalTransactionAmount(List<PosTransaction> selectedTransactions) {
        double refundAmount = 0.0;
        for (PosTransaction transaction : selectedTransactions) {
            if (transaction.isVoided().booleanValue()) continue;
            refundAmount += transaction.getAmount().doubleValue();
        }
        return refundAmount;
    }

    private void calculateTaxAmount() {
        this.totalTransactionTaxAmount = 0.0;
        for (PosTransaction t : this.ticket.getTransactions()) {
            if (t instanceof RefundTransaction || t.isVoided().booleanValue()) continue;
            this.totalTransactionTaxAmount += t.getTaxAmount().doubleValue();
        }
    }

    @Override
    public void doOk() {
        this.setCanceled(false);
        this.dispose();
    }

    private void doRefund(List<PosTransaction> selectedTransactions, boolean forceCashRefund) {
        this.doRefund(selectedTransactions, forceCashRefund, false);
    }

    private void doRefund(List<PosTransaction> selectedTransactions, boolean forceCashRefund, boolean refundUsingGiftCard) {
        try {
            double refundAmount;
            DrawerUtil.kickDrawer();
            double refundableAmount = this.getRefundableAmount();
            String giftCardNo = null;
            if (refundUsingGiftCard) {
                GlobalInputDialog inputDialog = new GlobalInputDialog();
                inputDialog.setCaption("Enter gift card number ");
                inputDialog.open();
                if (inputDialog.isCanceled()) {
                    return;
                }
                giftCardNo = inputDialog.getInput();
                if (giftCardNo == null) {
                    return;
                }
            }
            if ((refundAmount = NumberSelectionDialog2.takeDoubleInput("Enter refund amount", refundableAmount)) < 0.0) {
                return;
            }
            if (refundAmount == 0.0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refund amount must be greater than zero.");
                return;
            }
            if (refundAmount > refundableAmount) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refund amount cannot be greater than " + refundableAmount);
                return;
            }
            Double refundTaxAmount = NumberUtil.roundToTwoDigit(this.totalTransactionTaxAmount * refundAmount / this.ticket.getPaidAmount());
            double refundedAmount = PosTransactionService.getInstance().refundTicket(this.ticket, refundAmount, refundTaxAmount, Application.getCurrentUser(), selectedTransactions, forceCashRefund, giftCardNo);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refunded " + CurrencyUtil.getCurrencySymbol() + refundedAmount);
            this.ticket.calculatePrice();
            if (NumberUtil.isZero(this.ticket.getDueAmount())) {
                this.doOk();
            }
            this.settleTicketProcessor.doInformListenerPaymentUpdate();
            this.setCaption("Refund " + CurrencyUtil.getCurrencySymbol() + this.getRefundableAmount());
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private double getRefundableAmount() {
        double refundableAmount = 0.0;
        if (this.ticket.getDueAmount() >= 0.0) {
            return 0.0;
        }
        refundableAmount = Math.abs(this.ticket.getDueAmount());
        return NumberUtil.roundToTwoDigit(refundableAmount);
    }

    private double getRefundedAmount(List<PosTransaction> selectedTransactions) {
        double refundedAmountForTransaction = 0.0;
        for (PosTransaction posTransaction : selectedTransactions) {
            String refundedAmountText;
            if (posTransaction.isVoided().booleanValue() || !StringUtils.isNotEmpty((String)(refundedAmountText = posTransaction.getProperty("REFUNDED_AMOUNT")))) continue;
            try {
                refundedAmountForTransaction += Double.parseDouble(refundedAmountText);
            }
            catch (Exception exception) {}
        }
        return NumberUtil.roundToTwoDigit(refundedAmountForTransaction);
    }

    private double getRefundedAmount(PosTransaction posTransaction) {
        double refundedAmountForTransaction = 0.0;
        String refundedAmountText = posTransaction.getProperty("REFUNDED_AMOUNT");
        if (StringUtils.isNotEmpty((String)refundedAmountText)) {
            try {
                refundedAmountForTransaction = Double.parseDouble(refundedAmountText);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return NumberUtil.roundToTwoDigit(refundedAmountForTransaction);
    }

    private class GiftCardRefundAction
    extends PosAction {
        @Override
        public void execute() {
            ArrayList<PosTransaction> selectedTransactions = new ArrayList<PosTransaction>();
            for (PosTransaction t : RefundDialog.this.ticket.getTransactions()) {
                if (t instanceof RefundTransaction || t instanceof VoidTransaction) continue;
                selectedTransactions.add(t);
            }
            RefundDialog.this.doRefund(selectedTransactions, false, true);
        }
    }

    private class CashRefundAction
    extends PosAction {
        @Override
        public void execute() {
            ArrayList<PosTransaction> selectedTransactions = new ArrayList<PosTransaction>();
            for (PosTransaction t : RefundDialog.this.ticket.getTransactions()) {
                if (t instanceof RefundTransaction || t instanceof VoidTransaction) continue;
                selectedTransactions.add(t);
            }
            RefundDialog.this.doRefund(selectedTransactions, true);
        }
    }

    private class RefundAction
    extends PosAction {
        public RefundAction() {
            this.setRequiredPermission(UserPermission.PERFORM_MANAGER_TASK);
            this.setMandatoryPermission(true);
        }

        @Override
        public void execute() {
            PosButton button = (PosButton)this.event.getSource();
            PosTransaction transaction = (PosTransaction)button.getClientProperty("transaction");
            String refundedAmountText = transaction.getProperty("REFUNDED_AMOUNT");
            double refundAmount = 0.0;
            if (StringUtils.isNotEmpty((String)refundedAmountText)) {
                try {
                    refundAmount = Double.parseDouble(refundedAmountText);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (refundAmount >= transaction.getAmount()) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Transaction already refunded.");
                    button.setSelected(false);
                    return;
                }
            }
            ArrayList<PosTransaction> selectedTransactions = new ArrayList<PosTransaction>();
            selectedTransactions.add(transaction);
            RefundDialog.this.doRefund(selectedTransactions, false);
        }
    }
}

