/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.Discount;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosOptionPane;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ScrollableFlowPanel;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.util.DiscountUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;

public class TicketDiscountSelectionDialog
extends OkCancelOptionDialog {
    private ScrollableFlowPanel orderDiscountButtonPanel;
    private Ticket ticket;
    private JPanel itemSearchPanel;
    private JTextField txtSearchItem;
    private JPanel discountInfoPanel;
    private JTable discountTable;
    private DiscountTableModel discountTableModel;

    public TicketDiscountSelectionDialog(Ticket ticket) {
        super(POSUtil.getFocusedWindow(), "SELECT ORDER DISCOUNT");
        this.ticket = ticket;
        this.initComponent();
    }

    private void initComponent() {
        this.setOkButtonText(POSConstants.SAVE_BUTTON_TEXT);
        this.setCancelButtonVisible(false);
        this.createCouponSearchPanel();
        this.getContentPanel().setBorder(new EmptyBorder(0, 10, 0, 10));
        this.getContentPanel().add((Component)this.itemSearchPanel, "North");
        this.orderDiscountButtonPanel = new ScrollableFlowPanel(3);
        TitledBorder orderPanelBorder = BorderFactory.createTitledBorder(null, Messages.getString("TicketDiscountSelectionDialog.0"), 2, 0);
        this.orderDiscountButtonPanel.setBorder(orderPanelBorder);
        PosScrollPane orderScrollPane = new PosScrollPane(this.orderDiscountButtonPanel, 20, 31);
        orderScrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(80, 0));
        this.getContentPanel().add((Component)this.orderDiscountButtonPanel, "Center");
        this.createTicketDiscountPanel();
        this.rendererDiscounts();
        this.setSize(1024, 720);
    }

    public void createTicketDiscountPanel() {
        this.discountInfoPanel = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,ins 8 5 2 5"));
        this.discountTable = new JTable();
        this.discountTable.setGridColor(Color.LIGHT_GRAY);
        this.discountTable.setCellSelectionEnabled(false);
        this.discountTable.setColumnSelectionAllowed(false);
        this.discountTable.setRowSelectionAllowed(false);
        this.discountTable.setAutoscrolls(true);
        this.discountTable.setRowHeight(PosUIManager.getSize(40));
        this.discountTable.setShowGrid(true);
        this.discountTable.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.discountTable.setFocusable(false);
        this.discountTable.setAutoResizeMode(4);
        this.discountTableModel = new DiscountTableModel();
        this.discountTable.setModel(this.discountTableModel);
        this.discountTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component rendererComponent = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                this.setHorizontalAlignment(4);
                if (isSelected) {
                    return rendererComponent;
                }
                rendererComponent.setBackground(table.getBackground());
                return rendererComponent;
            }

            @Override
            protected void setValue(Object value) {
                if (value == null) {
                    this.setText("");
                    return;
                }
                String text = value.toString();
                if (value instanceof Double || value instanceof Float) {
                    text = NumberUtil.formatNumberAcceptNegative(((Number)value).doubleValue());
                }
                this.setText(text);
            }
        });
        this.setColumnWidth(0, PosUIManager.getSize(250));
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = Integer.parseInt(e.getActionCommand());
                TicketDiscount item = (TicketDiscount)TicketDiscountSelectionDialog.this.discountTableModel.getRowData(row);
                List<TicketDiscount> discounts = TicketDiscountSelectionDialog.this.ticket.getDiscounts();
                if (discounts != null) {
                    Iterator<TicketDiscount> iterator = discounts.iterator();
                    while (iterator.hasNext()) {
                        TicketDiscount ticketDiscount = iterator.next();
                        if (ticketDiscount != item) continue;
                        iterator.remove();
                        break;
                    }
                    OrderController.saveOrder(TicketDiscountSelectionDialog.this.ticket);
                    TicketDiscountSelectionDialog.this.rendererTicketDiscounts();
                }
            }
        };
        ButtonColumn coloum = new ButtonColumn(this.discountTable, action, 0){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JPanel panel = (JPanel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                int verticalGap = PosUIManager.getSize(15);
                int horizontalGap = PosUIManager.getSize(2);
                PosButton button = (PosButton)panel.getComponent(0);
                button.setOpaque(false);
                button.setBorder(new EmptyBorder(verticalGap, horizontalGap, verticalGap, horizontalGap));
                button.setIcon(IconFactory.getIcon("/ui_icons/", "delete-icon.png"));
                table.setRowHeight(row, table.getRowHeight(0));
                return panel;
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return super.getTableCellEditorComponent(table, value, false, row, column);
            }
        };
        coloum.showColumnValueInLabel(true);
        JScrollPane scrollPane = new JScrollPane(this.discountTable);
        this.discountInfoPanel.add((Component)scrollPane, "grow,span");
        this.getContentPanel().add((Component)this.discountInfoPanel, "West");
        this.rendererTicketDiscounts();
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.discountTable.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMinWidth(width);
    }

    private void rendererTicketDiscounts() {
        List<TicketDiscount> discounts = this.ticket.getDiscounts();
        this.discountTableModel.setRows(discounts);
        this.discountInfoPanel.revalidate();
        this.discountInfoPanel.repaint();
    }

    private void createCouponSearchPanel() {
        this.itemSearchPanel = new JPanel(new BorderLayout(5, 5));
        this.itemSearchPanel.setBorder(new EmptyBorder(0, 5, 0, 5));
        PosButton btnSearch = new PosButton(IconFactory.getIcon("/ui_icons/", "search.png"));
        btnSearch.setPreferredSize(new Dimension(60, 40));
        JLabel lblCoupon = new JLabel(Messages.getString("DiscountSelectionDialog.4"));
        this.txtSearchItem = new JTextField();
        this.txtSearchItem.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                TicketDiscountSelectionDialog.this.txtSearchItem.setText(Messages.getString("DiscountSelectionDialog.5"));
                TicketDiscountSelectionDialog.this.txtSearchItem.setForeground(Color.gray);
            }

            @Override
            public void focusGained(FocusEvent e) {
                TicketDiscountSelectionDialog.this.txtSearchItem.setForeground(Color.black);
                TicketDiscountSelectionDialog.this.txtSearchItem.setText("");
            }
        });
        this.txtSearchItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TicketDiscountSelectionDialog.this.txtSearchItem.getText().equals("")) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DiscountSelectionDialog.8"));
                    return;
                }
                if (!TicketDiscountSelectionDialog.this.addCouponByBarcode(TicketDiscountSelectionDialog.this.txtSearchItem.getText()) && TicketDiscountSelectionDialog.this.addCouponById(TicketDiscountSelectionDialog.this.txtSearchItem.getText())) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("DiscountSelectionDialog.11"));
                }
                TicketDiscountSelectionDialog.this.txtSearchItem.setText("");
            }
        });
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String value = PosOptionPane.showInputDialog(Messages.getString("DiscountSelectionDialog.10"));
                if (value == null || value.isEmpty()) {
                    return;
                }
                TicketDiscountSelectionDialog.this.txtSearchItem.requestFocus();
                if (!TicketDiscountSelectionDialog.this.addCouponByBarcode(value) && !TicketDiscountSelectionDialog.this.addCouponById(value)) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("DiscountSelectionDialog.11"));
                }
            }
        });
        this.itemSearchPanel.add((Component)lblCoupon, "West");
        this.itemSearchPanel.add(this.txtSearchItem);
        this.itemSearchPanel.add((Component)btnSearch, "East");
    }

    private boolean addCouponById(String id) {
        Discount discount = DiscountDAO.getInstance().get(id);
        if (discount == null) {
            return false;
        }
        this.doApplyDiscountOnTicket(discount);
        return true;
    }

    private boolean addCouponByBarcode(String barcode) {
        Discount discount = DiscountDAO.getInstance().getDiscountByBarcode(barcode, 1);
        if (discount == null) {
            return false;
        }
        this.doApplyDiscountOnTicket(discount);
        return true;
    }

    private void rendererDiscounts() {
        List<Discount> discounts = DiscountDAO.getInstance().getTicketValidCoupon();
        for (Discount discount : discounts) {
            DiscountButton btnDiscount = new DiscountButton(discount);
            btnDiscount.setSelected(false);
            this.orderDiscountButtonPanel.add(btnDiscount);
        }
        this.orderDiscountButtonPanel.repaint();
        this.orderDiscountButtonPanel.revalidate();
    }

    @Override
    public void doOk() {
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void doCancel() {
        this.setCanceled(true);
        this.dispose();
    }

    private void doApplyDiscountOnTicket(Discount discount) {
        Discount existingDiscount;
        TicketDiscount orderDiscount = null;
        List<TicketDiscount> couponAndDiscounts = this.ticket.getDiscounts();
        if (couponAndDiscounts == null || couponAndDiscounts.isEmpty() || !(orderDiscount = couponAndDiscounts.get(0)).getDiscountId().equals(discount.getId())) {
            // empty if block
        }
        if (orderDiscount != null && orderDiscount.getCouponQuantity() <= discount.getMaximumOff()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TicketDiscountSelectionDialog.2"));
            return;
        }
        if (orderDiscount != null && (existingDiscount = DiscountDAO.getInstance().get(orderDiscount.getDiscountId())) != null && existingDiscount.getType() == 2) {
            return;
        }
        boolean rePrice = discount.getType() == 2;
        Double discountValue = 0.0;
        if (rePrice) {
            String dialogTitle = Messages.getString("TicketItemDiscountSelectionDialog.17");
            double repriceValue = NumberSelectionDialog2.takeDoubleInput(dialogTitle, 0.0, true);
            if (repriceValue == -1.0 || repriceValue > this.ticket.getTotalAmount()) {
                return;
            }
            discountValue = repriceValue;
            if (discountValue == 0.0) {
                return;
            }
        } else {
            discountValue = discount.getValue();
            if (discount.isModifiable().booleanValue() && (discountValue = this.getModifiedValue(discount)) == null) {
                return;
            }
        }
        if (orderDiscount == null || orderDiscount.getValue().doubleValue() != discountValue.doubleValue()) {
            orderDiscount = Ticket.convertToTicketDiscount(discount, this.ticket);
            this.ticket.addTodiscounts(orderDiscount);
        } else {
            orderDiscount.setCouponQuantity(orderDiscount.getCouponQuantity() + 1.0);
        }
        orderDiscount.setValue(discountValue);
        this.rendererTicketDiscounts();
    }

    private Double getModifiedValue(Discount discount) {
        this.ticket.calculatePrice();
        Double newValue = NumberSelectionDialog2.takeDoubleInput(Messages.getString("TicketDiscountSelectionDialog.3"), discount.getValue(), true);
        if (newValue == -1.0) {
            return null;
        }
        if (newValue > 0.0) {
            return newValue;
        }
        return 0.0;
    }

    public class DiscountTableModel
    extends ListTableModel<TicketDiscount> {
        public DiscountTableModel() {
            super(new String[]{POSConstants.NAME, POSConstants.PRICE});
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TicketDiscount discount = (TicketDiscount)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return discount.getNameDisplay();
                }
                case 1: {
                    if (discount.getType() == 2) {
                        return discount.getValue();
                    }
                    return NumberUtil.formatNumberAcceptNegative(-DiscountUtil.calculateDiscountAmount(TicketDiscountSelectionDialog.this.ticket.getSubtotalAmount(), discount).doubleValue() * discount.getCouponQuantity());
                }
            }
            return null;
        }
    }

    private class DiscountButton
    extends JPanel
    implements ActionListener {
        private Discount discount;
        private PosButton btnDiscount;

        DiscountButton(Discount discount) {
            this.discount = discount;
            this.setPreferredSize(PosUIManager.getSize(120, 120));
            this.setLayout((LayoutManager)new MigLayout("fill", "", "[60%][40%]"));
            JLabel lblCoupon = new JLabel();
            lblCoupon.setOpaque(false);
            lblCoupon.setHorizontalAlignment(0);
            lblCoupon.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            lblCoupon.setText("<html><body><center><strong>" + discount.getName() + "</strong></center></body></html>");
            this.setBackground(Color.WHITE);
            this.setForeground(Color.BLACK);
            this.add((Component)lblCoupon, "grow,span,wrap");
            this.btnDiscount = new PosButton(POSConstants.APPLY);
            this.btnDiscount.addActionListener(this);
            this.add((Component)this.btnDiscount, "center");
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.setBorder(BorderFactory.createLineBorder(Color.red));
            super.paintComponent(g);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TicketDiscountSelectionDialog.this.doApplyDiscountOnTicket(this.discount);
        }

        public void setSelected(Boolean selected) {
            this.btnDiscount.setSelected(selected);
            if (selected.booleanValue()) {
                this.btnDiscount.setText(Messages.getString("TicketItemDiscountSelectionDialog.13"));
                this.btnDiscount.setBackground(Color.PINK);
            } else {
                this.btnDiscount.setText(POSConstants.APPLY);
                this.btnDiscount.setBackground(UIManager.getColor("control"));
            }
        }
    }
}

