/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Discount;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosOptionPane;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ScrollableFlowPanel;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class TicketItemDiscountSelectionDialog
extends OkCancelOptionDialog
implements ActionListener {
    private ScrollableFlowPanel itemDiscountButtonPanel;
    private HashMap<String, DiscountButton> buttonMap = new HashMap();
    private JPanel itemSearchPanel;
    private JTextField txtSearchItem;
    private TicketViewerTable ticketViewerTable;
    private JScrollPane ticketScrollPane;
    private Ticket ticket;

    public TicketItemDiscountSelectionDialog(Ticket ticket) {
        super(POSUtil.getFocusedWindow(), Messages.getString("DiscountSelectionDialog.0"));
        this.ticket = ticket;
        this.initComponent();
    }

    private void initComponent() {
        this.setOkButtonText(POSConstants.SAVE_BUTTON_TEXT);
        this.setCancelButtonVisible(false);
        this.getContentPanel().setBorder(new EmptyBorder(5, 5, 0, 5));
        this.createCouponSearchPanel();
        this.getContentPanel().add((Component)this.itemSearchPanel, "North");
        this.itemDiscountButtonPanel = new ScrollableFlowPanel(1);
        TitledBorder itemPanelBorder = BorderFactory.createTitledBorder(null, Messages.getString("TicketItemDiscountSelectionDialog.1"), 2, 0);
        this.itemDiscountButtonPanel.setBorder(itemPanelBorder);
        PosScrollPane scrollPane = new PosScrollPane(this.itemDiscountButtonPanel, 20, 31);
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(80, 0));
        this.ticketViewerTable = new TicketViewerTable(this.ticket);
        this.ticketViewerTable.setSelectionMode(2);
        this.ticketViewerTable.setVisibleDeleteButton(0);
        this.ticketScrollPane = new PosScrollPane(this.ticketViewerTable);
        JPanel mainPanel = new JPanel((LayoutManager)new MigLayout("fill,ins 5 5 0 5", "[40%][60%]", ""));
        mainPanel.add((Component)this.ticketScrollPane, "grow,gaptop 8,gapbottom 2");
        mainPanel.add((Component)this.itemDiscountButtonPanel, "grow");
        this.getContentPanel().add((Component)mainPanel, "Center");
        PosButton btnMerge = new PosButton("MERGE ITEMS");
        btnMerge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TicketItemDiscountSelectionDialog.this.ticket.consolidateTicketItems();
                TicketItemDiscountSelectionDialog.this.ticketViewerTable.updateView();
            }
        });
        this.getButtonPanel().add((Component)btnMerge, 0);
        this.rendererDiscounts();
        this.setSize(1024, 720);
    }

    private void createCouponSearchPanel() {
        this.itemSearchPanel = new JPanel(new BorderLayout(5, 5));
        this.itemSearchPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        PosButton btnSearch = new PosButton(IconFactory.getIcon("/ui_icons/", "search.png"));
        btnSearch.setPreferredSize(new Dimension(60, 40));
        JLabel lblCoupon = new JLabel(Messages.getString("DiscountSelectionDialog.4"));
        this.txtSearchItem = new JTextField();
        this.txtSearchItem.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                TicketItemDiscountSelectionDialog.this.txtSearchItem.setText(Messages.getString("DiscountSelectionDialog.5"));
                TicketItemDiscountSelectionDialog.this.txtSearchItem.setForeground(Color.gray);
            }

            @Override
            public void focusGained(FocusEvent e) {
                TicketItemDiscountSelectionDialog.this.txtSearchItem.setForeground(Color.black);
                TicketItemDiscountSelectionDialog.this.txtSearchItem.setText("");
            }
        });
        this.txtSearchItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TicketItemDiscountSelectionDialog.this.txtSearchItem.getText().equals("")) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DiscountSelectionDialog.8"));
                    return;
                }
                if (!TicketItemDiscountSelectionDialog.this.addCouponByBarcode(TicketItemDiscountSelectionDialog.this.txtSearchItem.getText()) && !TicketItemDiscountSelectionDialog.this.addCouponById(TicketItemDiscountSelectionDialog.this.txtSearchItem.getText())) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("DiscountSelectionDialog.11"));
                }
                TicketItemDiscountSelectionDialog.this.txtSearchItem.setText("");
            }
        });
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String value = PosOptionPane.showInputDialog(Messages.getString("DiscountSelectionDialog.10"));
                if (value == null || value.isEmpty()) {
                    return;
                }
                TicketItemDiscountSelectionDialog.this.txtSearchItem.requestFocus();
                if (!TicketItemDiscountSelectionDialog.this.addCouponByBarcode(value) && !TicketItemDiscountSelectionDialog.this.addCouponById(value)) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("DiscountSelectionDialog.11"));
                }
            }
        });
        this.itemSearchPanel.add((Component)lblCoupon, "West");
        this.itemSearchPanel.add(this.txtSearchItem);
        this.itemSearchPanel.add((Component)btnSearch, "East");
    }

    private boolean addCouponById(String id) {
        DiscountButton button;
        Discount discount = DiscountDAO.getInstance().get(id);
        if (discount == null) {
            return false;
        }
        if (discount.getQualificationType() == 0) {
            DiscountButton discountButton = this.buttonMap.get(discount.getId());
            this.applyDiscountToTicketItems(discountButton);
        }
        if ((button = this.buttonMap.get(discount.getId())) != null) {
            button.setSelected(true);
        }
        return true;
    }

    private boolean addCouponByBarcode(String barcode) {
        Discount discount = DiscountDAO.getInstance().getDiscountByBarcode(barcode, 0);
        if (discount == null) {
            return false;
        }
        DiscountButton discountButton = this.buttonMap.get(discount.getId());
        discountButton.setSelected(true);
        try {
            Thread.sleep(30L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.applyDiscountToTicketItems(discountButton);
        discountButton.setSelected(false);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.rendererDiscounts();
    }

    private void rendererDiscounts() {
        this.buttonMap.clear();
        this.itemDiscountButtonPanel.getContentPane().removeAll();
        List<Discount> discounts = DiscountDAO.getInstance().getValidItemCoupons();
        for (Discount discount : discounts) {
            DiscountButton btnDiscount = new DiscountButton(discount);
            this.itemDiscountButtonPanel.add(btnDiscount);
            this.buttonMap.put(discount.getId(), btnDiscount);
        }
        this.itemDiscountButtonPanel.repaint();
        this.itemDiscountButtonPanel.revalidate();
    }

    @Override
    public void doOk() {
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void doCancel() {
        this.buttonMap.clear();
        this.setCanceled(true);
        this.dispose();
    }

    /*
     * WARNING - void declaration
     */
    private void applyDiscountToTicketItems(DiscountButton discountButton) {
        void var6_11;
        boolean rePrice;
        int[] selectedRows = this.ticketViewerTable.getSelectedRows();
        Discount discount = discountButton.getDiscount();
        ArrayList<TicketItem> items = new ArrayList<TicketItem>();
        boolean bl = rePrice = discountButton.getDiscount().getType() == 2;
        if (rePrice) {
            if (selectedRows.length != 1) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TicketItemDiscountSelectionDialog.16"));
                return;
            }
            TicketItem ticketItem = (TicketItem)this.ticketViewerTable.get(selectedRows[0]);
            TicketItemDiscount ticketItemDiscount = null;
            List<TicketItemDiscount> discounts = ticketItem.getDiscounts();
            if (discounts != null) {
                for (TicketItemDiscount itemDiscount : discounts) {
                    if (!itemDiscount.getDiscountId().equals(discount.getId())) continue;
                    ticketItemDiscount = itemDiscount;
                    break;
                }
            }
            double initialAmount = ticketItem.getSubtotalAmount() - ticketItem.calculateDiscount(NumberUtil.convertToBigDecimal(ticketItem.getSubtotalAmount())).doubleValue();
            double value = NumberSelectionDialog2.takeDoubleInput(Messages.getString("TicketItemDiscountSelectionDialog.17"), initialAmount, true);
            if (value == -1.0) {
                return;
            }
            ticketItem.setUnitPrice(value);
            ticketItem.calculatePrice();
            if (ticketItemDiscount == null) {
                ticketItemDiscount = MenuItem.convertToTicketItemDiscount(discount, ticketItem);
                ticketItem.addTodiscounts(ticketItemDiscount);
            }
            ticketItemDiscount.setValue(value);
            ticketItemDiscount.setAmount(value);
            ticketItem.calculateDiscount(NumberUtil.convertToBigDecimal(ticketItem.getSubtotalAmount()));
            this.ticketViewerTable.updateView();
            return;
        }
        if (selectedRows.length == 0) {
            String string = Messages.getString("TicketItemDiscountSelectionDialog.19");
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), string, POSConstants.CONFIRM) == 1) {
                return;
            }
            for (int i = 0; i < this.ticketViewerTable.getRowCount(); ++i) {
                TicketItem ticketItem;
                ITicketItem item = this.ticketViewerTable.get(i);
                if (!(item instanceof TicketItem) || (ticketItem = (TicketItem)item).isHasModifiers().booleanValue()) continue;
                items.add((TicketItem)item);
            }
        } else {
            for (int i : selectedRows) {
                ITicketItem item = this.ticketViewerTable.get(i);
                if (!(item instanceof TicketItem)) continue;
                items.add((TicketItem)item);
            }
        }
        if (items.size() == 0) {
            return;
        }
        String string = "";
        boolean limitOver = false;
        for (TicketItem ticketItem : items) {
            List<TicketItemDiscount> discounts = ticketItem.getDiscounts();
            if (discounts == null) {
                discounts = new ArrayList<TicketItemDiscount>();
            }
            boolean exists = false;
            if (discount.getMenuItems() != null && !discount.getMenuItems().isEmpty() && !DiscountDAO.getInstance().isApplicable(ticketItem.getMenuItemId(), discount.getId())) {
                String string2 = (String)var6_11 + ticketItem.getName() + ",";
                continue;
            }
            for (TicketItemDiscount ticketItemDiscount : discounts) {
                if (discount.getMaximumOff() != 0.0 && ticketItemDiscount.getCouponQuantity() + 1.0 > discount.getMaximumOff()) {
                    exists = true;
                    String string3 = (String)var6_11 + ticketItem.getName();
                    limitOver = true;
                    break;
                }
                if (!ticketItemDiscount.getDiscountId().equals(discount.getId())) continue;
                ticketItemDiscount.setCouponQuantity(ticketItemDiscount.getCouponQuantity() + 1.0);
                exists = true;
                break;
            }
            if (!exists) {
                boolean isAmountDiscount;
                boolean bl2 = isAmountDiscount = discount.getType() == 0;
                if (isAmountDiscount && discount.isModifiable().booleanValue()) {
                    this.doSetModifiableAmount(discount, ticketItem);
                } else {
                    ticketItem.addTodiscounts(MenuItem.convertToTicketItemDiscount(discount, ticketItem));
                }
            }
            ticketItem.calculateDiscount(NumberUtil.convertToBigDecimal(ticketItem.getSubtotalAmount()));
        }
        if (!var6_11.isEmpty()) {
            if (limitOver) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TicketItemDiscountSelectionDialog.22") + " " + var6_11.substring(0, var6_11.length()));
            } else {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TicketItemDiscountSelectionDialog.23") + " " + var6_11.substring(0, var6_11.length()));
            }
        }
        this.ticket.calculatePrice();
        this.ticketViewerTable.updateView();
    }

    private void doSetModifiableAmount(Discount discount, TicketItem ticketItem) {
        double value = NumberSelectionDialog2.takeDoubleInput("Enter modifiable amount", ticketItem.getSubtotalAmount(), true);
        if (value == -1.0) {
            return;
        }
        TicketItemDiscount ticketItemDiscount = MenuItem.convertToTicketItemDiscount(discount, ticketItem);
        ticketItem.addTodiscounts(ticketItemDiscount);
        ticketItemDiscount.setValue(value);
        ticketItemDiscount.setAmount(value);
    }

    private class DiscountButton
    extends JPanel
    implements ActionListener {
        private Discount discount;
        private PosButton btnDiscount;

        DiscountButton(Discount discount) {
            this.discount = discount;
            this.setPreferredSize(PosUIManager.getSize(120, 120));
            this.setLayout((LayoutManager)new MigLayout("fill", "", "[60%][40%]"));
            JLabel lblCoupon = new JLabel();
            lblCoupon.setOpaque(false);
            lblCoupon.setHorizontalAlignment(0);
            lblCoupon.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            lblCoupon.setText("<html><body><center><strong>" + discount.getName() + "</strong></center></body></html>");
            this.setBackground(Color.WHITE);
            this.setForeground(Color.BLACK);
            this.add((Component)lblCoupon, "grow,span,wrap");
            this.btnDiscount = new PosButton(POSConstants.APPLY);
            this.btnDiscount.addActionListener(this);
            this.add((Component)this.btnDiscount, "center");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TicketItemDiscountSelectionDialog.this.applyDiscountToTicketItems(this);
        }

        public Discount getDiscount() {
            return this.discount;
        }

        public void setSelected(Boolean selected) {
            this.btnDiscount.setSelected(selected);
            if (selected.booleanValue()) {
                this.btnDiscount.setText(Messages.getString("TicketItemDiscountSelectionDialog.13"));
                this.btnDiscount.setBackground(Color.PINK);
            } else {
                this.btnDiscount.setText(POSConstants.APPLY);
                this.btnDiscount.setBackground(UIManager.getColor("control"));
            }
        }
    }
}

