/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.main.Application;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.Timer;
import net.miginfocom.swing.MigLayout;

public class UpdateNotificationDialog
extends POSDialog
implements ActionListener {
    private JProgressBar jProgressBar = new JProgressBar(0, 30);
    private JLabel lblMessage;
    private Timer updateTimer = new Timer(1000, this);
    private int count;
    private JLabel lblSoftwareUpdate;
    private static UpdateNotificationDialog instance;
    private JPanel buttonPanel;
    private boolean updateStart = false;
    private PosButton btnUpdate;
    private PosButton btnHide;
    private boolean updateAfterAlert;

    private UpdateNotificationDialog() {
        this.setIconImage(new ImageIcon(this.getClass().getResource("/icons/icon.png")).getImage());
        this.setModal(true);
        this.init();
        this.setDefaultCloseOperation(0);
    }

    public void setMessage(String msg) {
        this.lblMessage.setText(msg);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.updateTimer.start();
        }
        super.setVisible(b);
    }

    private void init() {
        this.setTitle("Update");
        this.setSize(600, 350);
        this.setLayout(new BorderLayout(10, 10));
        JPanel contentPanel = new JPanel(new BorderLayout(10, 10));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout("fillx,ins 0", "", "[50][1]"));
        this.lblSoftwareUpdate = new JLabel();
        this.lblSoftwareUpdate.setFont(this.lblSoftwareUpdate.getFont().deriveFont(0, 20.0f));
        this.lblSoftwareUpdate.setForeground(new Color(49, 106, 196));
        topPanel.add((Component)this.lblSoftwareUpdate, "gap 10");
        topPanel.add((Component)new JSeparator(), "grow,newline,span");
        this.add((Component)topPanel, "North");
        JPanel progressPanel = new JPanel((LayoutManager)new MigLayout("fillx,ins 20 20 5 20,center", "[250]", "[]"));
        this.lblMessage = new JLabel();
        progressPanel.add((Component)this.lblMessage, "wrap");
        progressPanel.add((Component)this.jProgressBar, "grow,span,wrap,h " + PosUIManager.getSize(50));
        contentPanel.add(progressPanel);
        this.add(contentPanel);
        this.buttonPanel = new JPanel(new FlowLayout());
        this.btnUpdate = new PosButton("Update Now");
        this.btnUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateNotificationDialog.this.startUpdating();
            }
        });
        this.btnHide = new PosButton("Hide");
        this.btnHide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateNotificationDialog.this.dispose();
            }
        });
        this.buttonPanel.add(this.btnUpdate);
        this.buttonPanel.add(this.btnHide);
        this.add((Component)this.buttonPanel, "South");
        this.setSize(PosUIManager.getSize(450, 250));
    }

    public void startUpdating() {
        if (this.updateStart) {
            return;
        }
        this.updateStart = true;
        this.updateTimer.stop();
        this.setCanceled(false);
        this.dispose();
        Application.getInstance().getUpdateManager().startDownload();
        this.updateStart = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.jProgressBar.setValue(++this.count);
        this.jProgressBar.setString(this.getName());
        if (this.count == 30) {
            this.updateTimer.stop();
            if (this.updateAfterAlert) {
                this.startUpdating();
            } else {
                this.setCanceled(false);
                this.dispose();
                UpdateNotificationDialog notificationDialog = UpdateNotificationDialog.getInstance("Software update", "Waiting for update notification", false);
                notificationDialog.jProgressBar.setValue(30);
                notificationDialog.setUpdateButtonVisible(false);
                notificationDialog.setHideButtonVisible(true);
                notificationDialog.setVisible(true);
            }
        }
    }

    public static boolean showMessage(String title, String message, boolean updateAfterAlert) {
        UpdateNotificationDialog dialog = UpdateNotificationDialog.getInstance(title, message, updateAfterAlert);
        dialog.setUpdateButtonVisible(false);
        dialog.open();
        return dialog.isCanceled();
    }

    public static boolean showUpdatePromptDialog(String title) {
        String message = "<html>Download complete. Software will restart in 30 sec. This delay is to prepare other terminals for updating. <b>If no other terminal is running, you can start update now.</b></html>";
        UpdateNotificationDialog dialog = UpdateNotificationDialog.getInstance(title, message, true);
        dialog.setHideButtonVisible(false);
        dialog.setUpdateButtonVisible(true);
        dialog.open();
        return dialog.isCanceled();
    }

    public static UpdateNotificationDialog getInstance(String title, String message, boolean updateAfterAlert) {
        if (instance == null) {
            instance = new UpdateNotificationDialog();
        }
        UpdateNotificationDialog.instance.updateAfterAlert = updateAfterAlert;
        instance.setTitleText(title);
        instance.setMessage(message);
        return instance;
    }

    private void setTitleText(String title) {
        this.lblSoftwareUpdate.setText(title);
    }

    public void setHideButtonVisible(boolean visible) {
        this.btnHide.setVisible(visible);
    }

    public void setUpdateButtonVisible(boolean visible) {
        this.btnUpdate.setVisible(visible);
    }
}

