/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.config.CardConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.VoidTransaction;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.util.CurrencyUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

public class VoidPaymentDialog
extends OkCancelOptionDialog {
    private Ticket ticket;
    private List<PosTransaction> selectedTransactions = new ArrayList<PosTransaction>();
    private Map<String, PosButton> buttonMap = new HashMap<String, PosButton>();
    private JPanel buttonsPanel;

    public VoidPaymentDialog(Window window, Ticket ticket) {
        this.ticket = ticket;
        this.initComponents();
        this.initialize();
        this.setDefaultCloseOperation(0);
    }

    private void initComponents() {
        this.setCaption("Void payment");
        this.setOkButtonText(POSConstants.SAVE_BUTTON_TEXT);
        this.setCancelButtonVisible(false);
        this.setDefaultCloseOperation(2);
        this.getContentPanel().add(this.createCenterPanel());
    }

    public void initialize() {
        try {
            this.rendererTransactions();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.CANNOT_LOAD_VOID_REASONS, e);
        }
    }

    private JPanel createCenterPanel() {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        this.buttonsPanel = new JPanel(new FlowLayout(1));
        contentPanel.add(this.buttonsPanel);
        return contentPanel;
    }

    private void rendererTransactions() {
        this.buttonsPanel.removeAll();
        if (this.ticket != null) {
            ActionListener l = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PosButton button = (PosButton)e.getSource();
                    PosTransaction transaction = (PosTransaction)button.getClientProperty("transaction");
                    int option = POSMessageDialog.showYesNoQuestionDialog(VoidPaymentDialog.this, "Are you sure to void this payment?", "Confirm");
                    if (option != 0) {
                        return;
                    }
                    if (transaction instanceof CreditCardTransaction) {
                        CardProcessor cardProcessor = CardConfig.getPaymentGateway().getProcessor();
                        try {
                            cardProcessor.voidTransaction(transaction);
                            if (!transaction.isVoided().booleanValue()) {
                                cardProcessor.refundTransaction(transaction, transaction.getAmount());
                                if (!transaction.isRefunded()) {
                                    POSMessageDialog.showError("Failed to reverse this payment.");
                                    return;
                                }
                            }
                        }
                        catch (Exception e2) {
                            try {
                                cardProcessor.refundTransaction(transaction, transaction.getAmount());
                                if (!transaction.isRefunded()) {
                                    POSMessageDialog.showError("Failed to reverse this payment.");
                                    return;
                                }
                            }
                            catch (Exception e3) {
                                POSMessageDialog.showError("Failed to reverse this payment.");
                                return;
                            }
                        }
                    }
                    transaction.setVoided(true);
                    VoidPaymentDialog.this.ticket.setPaidAmount(VoidPaymentDialog.this.ticket.getPaidAmount() - transaction.getAmount());
                    VoidPaymentDialog.this.ticket.setDueAmount(VoidPaymentDialog.this.ticket.getDueAmount() + transaction.getAmount());
                    VoidPaymentDialog.this.ticket.setClosed(false);
                    VoidPaymentDialog.this.ticket.setPaid(false);
                    VoidPaymentDialog.this.ticket.calculatePrice();
                    TicketDAO.getInstance().update(VoidPaymentDialog.this.ticket);
                    ActionHistory history = new ActionHistory();
                    history.setActionName("Trans reversal");
                    history.setDescription("Trans# " + transaction.getId());
                    ((PosButton)e.getSource()).setEnabled(false);
                }
            };
            for (PosTransaction t : this.ticket.getTransactions()) {
                if (t instanceof RefundTransaction || t instanceof VoidTransaction || t.isVoided().booleanValue()) continue;
                PosButton btnTransactionType = new PosButton();
                btnTransactionType.putClientProperty("transaction", t);
                btnTransactionType.addActionListener(l);
                btnTransactionType.setPreferredSize(PosUIManager.getSize(120, 110));
                this.updateView(t, btnTransactionType);
                this.buttonsPanel.add((Component)btnTransactionType, "aligny top");
                this.buttonMap.put(t.getId(), btnTransactionType);
            }
        }
        this.setCancelButtonVisible(false);
        this.buttonsPanel.revalidate();
        this.buttonsPanel.repaint();
    }

    private void updateView(PosTransaction t, PosButton btnTransactionType) {
        double refundedAmountForTransaction = 0.0;
        if (refundedAmountForTransaction > 0.0) {
            btnTransactionType.setText("<html><center>" + (Object)((Object)t.getPaymentType()) + "<br><h2>" + CurrencyUtil.getCurrencySymbol() + t.getAmount() + "</h2><h5>Refunded -" + CurrencyUtil.getCurrencySymbol() + refundedAmountForTransaction + "</h5></html>");
            btnTransactionType.setEnabled(t.getAmount() != refundedAmountForTransaction);
            if (t.getAmount() != refundedAmountForTransaction) {
                this.selectedTransactions.add(t);
                btnTransactionType.setSelected(true);
            }
        } else {
            this.selectedTransactions.add(t);
            btnTransactionType.setSelected(true);
            btnTransactionType.setText("<html><center>" + (Object)((Object)t.getPaymentType()) + "<br><h2>" + CurrencyUtil.getCurrencySymbol() + t.getAmount());
        }
    }

    @Override
    public void doOk() {
        try {
            this.canceled = false;
            this.dispose();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }
}

