/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.export_import;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.config.AppProperties;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import liquibase.util.file.FilenameUtils;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.hibernate.exception.ConstraintViolationException;

public class ExcelImportViewDialog
extends POSDialog {
    private TitlePanel titlePanel;
    private JPanel buttonPanel;
    private String filePath;
    private JTabbedPane mainTabbedPane;
    private ItemContainer menuItemPanel;
    private ItemContainer modifierPanel;
    private List<Object> objectList;

    public ExcelImportViewDialog(String filePath) throws Exception {
        this.filePath = filePath;
        this.initDialog();
        this.initReader();
    }

    private void initDialog() {
        this.setTitle(AppProperties.getAppName());
        this.setLayout(new BorderLayout(5, 5));
        this.titlePanel = new TitlePanel();
        this.mainTabbedPane = new JTabbedPane();
        this.menuItemPanel = new ItemContainer(this.doCreateMenuItemModel());
        this.modifierPanel = new ItemContainer(this.doCreateMenuModifierModel());
        this.mainTabbedPane.addTab("Menu Item", this.menuItemPanel);
        this.mainTabbedPane.addTab("Menu Modifier", this.modifierPanel);
        this.add((Component)this.titlePanel, "North");
        this.add((Component)this.mainTabbedPane, "Center");
        this.buttonPanel = this.createButtonPanel();
        this.add((Component)this.buttonPanel, "South");
    }

    private BeanTableModel doCreateMenuModifierModel() {
        BeanTableModel menuModifierTableModel = new BeanTableModel(MenuModifier.class);
        menuModifierTableModel.addColumn(POSConstants.NAME.toUpperCase(), MenuModifier.PROP_NAME);
        menuModifierTableModel.addColumn(POSConstants.PRICE.toUpperCase() + " (" + CurrencyUtil.getCurrencySymbol() + ")", MenuModifier.PROP_PRICE);
        menuModifierTableModel.addColumn(POSConstants.ACTIVE.toUpperCase(), MenuModifier.PROP_ENABLE);
        menuModifierTableModel.addColumn(POSConstants.PIZZA_MODIFIER.toUpperCase(), MenuModifier.PROP_PIZZA_MODIFIER);
        return menuModifierTableModel;
    }

    private BeanTableModel doCreateMenuItemModel() {
        BeanTableModel menuItemTableModel = new BeanTableModel(MenuItem.class);
        menuItemTableModel.addColumn(POSConstants.CATEGORY.toUpperCase(), MenuItem.PROP_MENU_CATEGORY_NAME);
        menuItemTableModel.addColumn(POSConstants.GROUP.toUpperCase(), MenuItem.PROP_MENU_GROUP_NAME);
        menuItemTableModel.addColumn(POSConstants.NAME.toUpperCase(), MenuItem.PROP_NAME);
        menuItemTableModel.addColumn(POSConstants.DESCRIPTION.toUpperCase(), MenuItem.PROP_DESCRIPTION);
        menuItemTableModel.addColumn(POSConstants.PRICE.toUpperCase() + " (" + CurrencyUtil.getCurrencySymbol() + ")", MenuItem.PROP_PRICE);
        menuItemTableModel.addColumn(POSConstants.COST.toUpperCase(), MenuItem.PROP_COST);
        menuItemTableModel.addColumn(POSConstants.SKU.toUpperCase(), MenuItem.PROP_SKU);
        menuItemTableModel.addColumn(POSConstants.BARCODE.toUpperCase(), MenuItem.PROP_BARCODE);
        menuItemTableModel.addColumn(POSConstants.ACTIVE.toUpperCase(), MenuItem.PROP_VISIBLE);
        menuItemTableModel.addColumn(POSConstants.FRACTIONAL_UNIT.toUpperCase(), MenuItem.PROP_FRACTIONAL_UNIT);
        menuItemTableModel.addColumn(POSConstants.INVENTORY_ITEM.toUpperCase(), MenuItem.PROP_INVENTORY_ITEM);
        menuItemTableModel.addColumn(POSConstants.ALLOW_PRICE_OVERRIDE.toUpperCase(), MenuItem.PROP_EDITABLE_PRICE);
        return menuItemTableModel;
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(90);
        columnWidth.add(90);
        columnWidth.add(130);
        columnWidth.add(130);
        columnWidth.add(90);
        columnWidth.add(80);
        columnWidth.add(110);
        columnWidth.add(80);
        columnWidth.add(80);
        columnWidth.add(100);
        columnWidth.add(105);
        columnWidth.add(95);
        return columnWidth;
    }

    private JPanel createButtonPanel() {
        JButton deleteButton = new JButton(POSConstants.DELETE.toUpperCase());
        deleteButton.setText(Messages.getString("MenuItemExplorer.19"));
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ExcelImportViewDialog.this.doDeleteItems();
                }
                catch (Exception exp) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exp.getMessage().toString());
                }
            }
        });
        JButton btnSave = new JButton(POSConstants.SAVE.toUpperCase());
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ExcelImportViewDialog.this.setCanceled(false);
                    ExcelImportViewDialog.this.dispose();
                }
                catch (Exception exp) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exp.getMessage().toString());
                }
            }
        });
        JButton btnCancel = new JButton(POSConstants.CANCEL.toUpperCase());
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ExcelImportViewDialog.this.dispose();
                }
                catch (Exception exp) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exp.getMessage().toString());
                }
            }
        });
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("center", ""));
        bottomPanel.add(btnSave);
        bottomPanel.add(deleteButton);
        bottomPanel.add(btnCancel);
        return bottomPanel;
    }

    private void doDeleteItems() {
        try {
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            int selectedIndex = this.mainTabbedPane.getSelectedIndex();
            ItemContainer itemContainer = (ItemContainer)this.mainTabbedPane.getComponentAt(selectedIndex);
            JTable table = itemContainer.itemTable;
            BeanTableModel tableModel = itemContainer.tableModel;
            int[] selectedRows = table.getSelectedRows();
            if (selectedRows.length <= 0) {
                return;
            }
            for (int i = 0; i < selectedRows.length; ++i) {
                tableModel.removeRow(selectedRows[i] - i);
            }
            this.updateTitle(tableModel.getRowCount());
        }
        catch (ConstraintViolationException ex) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "This menu item is in use and cannot be deleted.");
            return;
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void initReader() throws Exception {
        String fileExtension = FilenameUtils.getExtension((String)this.filePath);
        if (fileExtension.equals("xlsx")) {
            this.objectList = this.readXLSXFile();
            if (this.objectList == null) {
                return;
            }
            for (Object object : this.objectList) {
                if (object instanceof MenuItem) {
                    MenuItem menuItem = (MenuItem)object;
                    this.menuItemPanel.tableModel.addRow(menuItem);
                    continue;
                }
                if (!(object instanceof MenuModifier)) continue;
                MenuModifier menuModifier = (MenuModifier)object;
                this.modifierPanel.tableModel.addRow(menuModifier);
            }
            this.updateTitle(this.objectList.size());
        } else if (fileExtension.equals("xls")) {
            this.objectList = this.readXLSFile();
            if (this.objectList == null) {
                return;
            }
            for (Object object : this.objectList) {
                if (object instanceof MenuItem) {
                    MenuItem menuItem = (MenuItem)object;
                    this.menuItemPanel.tableModel.addRow(menuItem);
                    continue;
                }
                if (!(object instanceof MenuModifier)) continue;
                MenuModifier menuModifier = (MenuModifier)object;
                this.modifierPanel.tableModel.addRow(menuModifier);
            }
            this.updateTitle(this.objectList.size());
        } else {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectAnExcelFile"));
            return;
        }
    }

    private void updateTitle(int size) {
        this.titlePanel.setTitle("Imported " + size + " rows, Please review and then click save to make it permanent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> readXLSXFile() throws Exception {
        XSSFWorkbook wb = null;
        ArrayList<Object> objectList = new ArrayList<Object>();
        MenuCategory menuCategory = null;
        MenuGroup menuGroup = null;
        ModifierGroup modifierGroup = null;
        try {
            FileInputStream xlsxFileToRead = new FileInputStream(this.filePath);
            wb = new XSSFWorkbook((InputStream)xlsxFileToRead);
            this.doImportMenuItemFromXLSX(objectList, menuCategory, menuGroup, wb.getSheetAt(0));
            this.doImportMenuModifierFromXLSX(objectList, modifierGroup, wb.getSheetAt(1));
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("InvalidExcel"), e);
            List<Object> list = null;
            return list;
        }
        finally {
            if (wb != null) {
                wb.close();
            }
        }
        return objectList;
    }

    private void doImportMenuItemFromXLSX(List<Object> objectList, MenuCategory menuCategory, MenuGroup menuGroup, XSSFSheet menuItemSheet) throws Exception {
        Iterator rows = menuItemSheet.rowIterator();
        while (rows.hasNext()) {
            XSSFRow xlsxRow = (XSSFRow)rows.next();
            if (xlsxRow.getRowNum() == 0) continue;
            Iterator cellIterator = xlsxRow.cellIterator();
            MenuItem menuItem = null;
            while (cellIterator.hasNext()) {
                Cell xlsxCell = (Cell)cellIterator.next();
                String stringValue = "";
                double doubleValue = 0.0;
                switch (xlsxCell.getCellTypeEnum()) {
                    case STRING: {
                        stringValue = xlsxCell.getStringCellValue();
                        break;
                    }
                    case NUMERIC: {
                        doubleValue = xlsxCell.getNumericCellValue();
                    }
                }
                String colValue = menuItemSheet.getRow(0).getCell(xlsxCell.getColumnIndex()).getStringCellValue();
                if (colValue.equals("Product Category")) {
                    menuCategory = MenuCategoryDAO.getInstance().findCategoriesByName(stringValue);
                    if (menuCategory != null) continue;
                    menuCategory = new MenuCategory();
                    menuCategory.setName(stringValue);
                    menuCategory.setVisible(true);
                    MenuCategoryDAO.getInstance().save(menuCategory);
                    continue;
                }
                if (colValue.equals("Product Group")) {
                    menuGroup = MenuGroupDAO.getInstance().findMenuGroupByName(stringValue);
                    if (menuGroup != null) continue;
                    menuGroup = new MenuGroup();
                    menuGroup.setName(stringValue);
                    menuGroup.setVisible(true);
                    menuCategory = MenuCategoryDAO.getInstance().initialize(menuCategory);
                    menuGroup.setMenuCategoryId(menuCategory.getId());
                    MenuGroupDAO.getInstance().saveOrUpdate(menuGroup);
                    menuCategory.addTomenuGroups(menuGroup);
                    MenuCategoryDAO.getInstance().update(menuCategory);
                    continue;
                }
                if (colValue.equals("Product Name")) {
                    menuItem = MenuItemDAO.getInstance().findByName(stringValue);
                    if (menuItem == null) {
                        menuItem = new MenuItem();
                        menuItem.setName(stringValue);
                        menuItem.setMenuCategoryId(menuCategory.getId());
                        menuItem.setMenuGroupId(menuGroup.getId());
                        menuItem.setMenuGroupName(menuGroup.getName());
                        menuItem.setMenuCategoryName(menuCategory.getName());
                        continue;
                    }
                    menuItem.setDescription("");
                    menuItem.setPrice(0.0);
                    menuItem.setCost(0.0);
                    menuItem.setSku("");
                    menuItem.setBarcode("");
                    continue;
                }
                if (colValue.equals("Product Description")) {
                    menuItem.setDescription(stringValue);
                    continue;
                }
                if (colValue.equals("Price")) {
                    menuItem.setPrice(this.doubleValue(stringValue, doubleValue));
                    continue;
                }
                if (colValue.equals("Cost")) {
                    menuItem.setCost(this.doubleValue(stringValue, doubleValue));
                    continue;
                }
                if (colValue.equals("SKU")) {
                    menuItem.setSku(stringValue);
                    continue;
                }
                if (colValue.equals("Barcode")) {
                    menuItem.setBarcode(stringValue);
                    continue;
                }
                if (colValue.equals("Active")) {
                    menuItem.setVisible(this.booleanValue(stringValue));
                    continue;
                }
                if (colValue.equals("Fractional Unit")) {
                    menuItem.setFractionalUnit(this.booleanValue(stringValue));
                    continue;
                }
                if (colValue.equals("Inventory Item")) {
                    menuItem.setInventoryItem(this.booleanValue(stringValue));
                    continue;
                }
                if (!colValue.equals("Allow Price Override")) continue;
                menuItem.setEditablePrice(this.booleanValue(stringValue));
            }
            if (menuItem == null) continue;
            objectList.add(menuItem);
        }
    }

    private void doImportMenuModifierFromXLSX(List<Object> objectList, ModifierGroup menuModifierGroup, XSSFSheet menuModifierSheet) throws Exception {
        Iterator rows = menuModifierSheet.rowIterator();
        while (rows.hasNext()) {
            XSSFRow xlsxRow = (XSSFRow)rows.next();
            if (xlsxRow.getRowNum() == 0) continue;
            Iterator cellIterator = xlsxRow.cellIterator();
            MenuModifier menuModifier = null;
            while (cellIterator.hasNext()) {
                Cell xlsxCell = (Cell)cellIterator.next();
                String stringValue = "";
                double doubleValue = 0.0;
                switch (xlsxCell.getCellTypeEnum()) {
                    case STRING: {
                        stringValue = xlsxCell.getStringCellValue();
                        break;
                    }
                    case NUMERIC: {
                        doubleValue = xlsxCell.getNumericCellValue();
                    }
                }
                String colValue = menuModifierSheet.getRow(0).getCell(xlsxCell.getColumnIndex()).getStringCellValue();
                if (colValue.equals("Modifier Group")) {
                    menuModifierGroup = ModifierGroupDAO.getInstance().findModifierGroupByName(stringValue);
                    if (menuModifierGroup != null) continue;
                    menuModifierGroup = new ModifierGroup();
                    menuModifierGroup.setName(stringValue);
                    ModifierGroupDAO.getInstance().saveOrUpdate(menuModifierGroup);
                    continue;
                }
                if (colValue.equals("Modifiers Name")) {
                    menuModifier = MenuModifierDAO.getInstance().findName(stringValue);
                    if (menuModifier == null) {
                        menuModifier = new MenuModifier();
                        menuModifier.setName(stringValue);
                        menuModifierGroup.addTomodifiers(menuModifier);
                        continue;
                    }
                    menuModifier.setPrice(0.0);
                    continue;
                }
                if (colValue.equals("Price")) {
                    menuModifier.setPrice(this.doubleValue(stringValue, doubleValue));
                    continue;
                }
                if (colValue.equals("Active")) {
                    menuModifier.setEnable(this.booleanValue(stringValue));
                    continue;
                }
                if (!colValue.equals("Pizza Modifier")) continue;
                menuModifier.setPizzaModifier(this.booleanValue(stringValue));
            }
            if (menuModifier == null) continue;
            objectList.add(menuModifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> readXLSFile() throws Exception {
        HSSFWorkbook wb = null;
        ArrayList<Object> objectList = new ArrayList<Object>();
        MenuCategory menuCategory = null;
        MenuGroup menuGroup = null;
        ModifierGroup modifierGroup = null;
        try {
            FileInputStream xlsFileToRead = new FileInputStream(this.filePath);
            wb = new HSSFWorkbook((InputStream)xlsFileToRead);
            this.doImportMenuItemFromXLS(objectList, menuCategory, menuGroup, wb.getSheetAt(0));
            this.doImportMenuModifierFromXLS(objectList, modifierGroup, wb.getSheetAt(1));
        }
        catch (Exception exp) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("InvalidExcel"), exp);
            List<Object> list = null;
            return list;
        }
        finally {
            if (wb != null) {
                wb.close();
            }
        }
        return objectList;
    }

    private void doImportMenuItemFromXLS(List<Object> menuItemList, MenuCategory menuCategory, MenuGroup menuGroup, HSSFSheet menuItemSheet) throws Exception {
        Iterator rows = menuItemSheet.rowIterator();
        while (rows.hasNext()) {
            HSSFRow xlsRow = (HSSFRow)rows.next();
            if (xlsRow.getRowNum() == 0) continue;
            Iterator cellIterator = xlsRow.cellIterator();
            MenuItem menuItem = null;
            while (cellIterator.hasNext()) {
                Cell xlsCell = (Cell)cellIterator.next();
                String stringValue = "";
                double doubleValue = 0.0;
                switch (xlsCell.getCellTypeEnum()) {
                    case STRING: {
                        stringValue = xlsCell.getStringCellValue();
                        break;
                    }
                    case NUMERIC: {
                        doubleValue = xlsCell.getNumericCellValue();
                    }
                }
                String colValue = menuItemSheet.getRow(0).getCell(xlsCell.getColumnIndex()).getStringCellValue();
                if (colValue.equals("Product Category")) {
                    menuCategory = MenuCategoryDAO.getInstance().findCategoriesByName(stringValue);
                    if (menuCategory != null) continue;
                    menuCategory = new MenuCategory();
                    menuCategory.setName(stringValue);
                    menuCategory.setVisible(true);
                    continue;
                }
                if (colValue.equals("Product Group")) {
                    menuGroup = MenuGroupDAO.getInstance().findMenuGroupByName(stringValue);
                    if (menuGroup != null) continue;
                    menuGroup = new MenuGroup();
                    menuGroup.setName(stringValue);
                    menuGroup.setVisible(true);
                    menuCategory = MenuCategoryDAO.getInstance().initialize(menuCategory);
                    menuGroup.setMenuCategoryId(menuCategory.getId());
                    menuCategory.addTomenuGroups(menuGroup);
                    MenuCategoryDAO.getInstance().update(menuCategory);
                    continue;
                }
                if (colValue.equals("Product Name")) {
                    menuItem = MenuItemDAO.getInstance().findByName(stringValue);
                    if (menuItem == null) {
                        menuItem = new MenuItem();
                        menuItem.setName(stringValue);
                        menuItem.setMenuCategoryId(menuCategory.getId());
                        menuItem.setMenuGroupId(menuGroup.getId());
                        menuItem.setMenuGroupName(menuGroup.getName());
                        menuItem.setMenuCategoryName(menuCategory.getName());
                        continue;
                    }
                    menuItem.setDescription("");
                    menuItem.setPrice(0.0);
                    menuItem.setCost(0.0);
                    menuItem.setSku("");
                    menuItem.setBarcode("");
                    continue;
                }
                if (colValue.equals("Product Description")) {
                    menuItem.setDescription(stringValue);
                    continue;
                }
                if (colValue.equals("Price")) {
                    menuItem.setPrice(doubleValue);
                    continue;
                }
                if (colValue.equals("Cost")) {
                    menuItem.setCost(doubleValue);
                    continue;
                }
                if (colValue.equals("SKU")) {
                    menuItem.setSku(stringValue);
                    continue;
                }
                if (colValue.equals("Barcode")) {
                    menuItem.setBarcode(stringValue);
                    continue;
                }
                if (colValue.equals("Active")) {
                    menuItem.setVisible(this.booleanValue(stringValue));
                    continue;
                }
                if (colValue.equals("Fractional Unit")) {
                    menuItem.setFractionalUnit(this.booleanValue(stringValue));
                    continue;
                }
                if (colValue.equals("Inventory Item")) {
                    menuItem.setInventoryItem(this.booleanValue(stringValue));
                    continue;
                }
                if (!colValue.equals("Allow Price Override")) continue;
                menuItem.setEditablePrice(this.booleanValue(stringValue));
            }
            if (menuItem == null) continue;
            menuItemList.add(menuItem);
        }
    }

    private void doImportMenuModifierFromXLS(List<Object> objectList, ModifierGroup menuModifierGroup, HSSFSheet menuModifierSheet) throws Exception {
        Iterator rows = menuModifierSheet.rowIterator();
        while (rows.hasNext()) {
            HSSFRow xlsRow = (HSSFRow)rows.next();
            if (xlsRow.getRowNum() == 0) continue;
            Iterator cellIterator = xlsRow.cellIterator();
            MenuModifier menuModifier = null;
            while (cellIterator.hasNext()) {
                Cell xlsCell = (Cell)cellIterator.next();
                String stringValue = "";
                double doubleValue = 0.0;
                switch (xlsCell.getCellTypeEnum()) {
                    case STRING: {
                        stringValue = xlsCell.getStringCellValue();
                        break;
                    }
                    case NUMERIC: {
                        doubleValue = xlsCell.getNumericCellValue();
                    }
                }
                String colValue = menuModifierSheet.getRow(0).getCell(xlsCell.getColumnIndex()).getStringCellValue();
                if (colValue.equals("Modifier Group")) {
                    menuModifierGroup = ModifierGroupDAO.getInstance().findModifierGroupByName(stringValue);
                    if (menuModifierGroup != null) continue;
                    menuModifierGroup = new ModifierGroup();
                    menuModifierGroup.setName(stringValue);
                    ModifierGroupDAO.getInstance().saveOrUpdate(menuModifierGroup);
                    continue;
                }
                if (colValue.equals("Modifiers Name")) {
                    menuModifier = MenuModifierDAO.getInstance().findName(stringValue);
                    if (menuModifier == null) {
                        menuModifier = new MenuModifier();
                        menuModifier.setName(stringValue);
                        menuModifierGroup.addTomodifiers(menuModifier);
                        continue;
                    }
                    menuModifier.setPrice(0.0);
                    continue;
                }
                if (colValue.equals("Price")) {
                    menuModifier.setPrice(this.doubleValue(stringValue, doubleValue));
                    continue;
                }
                if (colValue.equals("Active")) {
                    menuModifier.setEnable(this.booleanValue(stringValue));
                    continue;
                }
                if (!colValue.equals("Pizza Modifier")) continue;
                menuModifier.setPizzaModifier(this.booleanValue(stringValue));
            }
            if (menuModifier == null) continue;
            objectList.add(menuModifier);
        }
    }

    private double doubleValue(String stringValue, double doubleValue) {
        double parseValue = 0.0;
        try {
            parseValue = Double.parseDouble(stringValue);
        }
        catch (Exception e) {
            parseValue = doubleValue;
        }
        return parseValue;
    }

    private boolean booleanValue(String stringValue) {
        if (StringUtils.isEmpty((String)stringValue)) {
            return false;
        }
        return stringValue.equalsIgnoreCase("yes");
    }

    public List<Object> getItemsList() {
        return this.objectList;
    }

    class ItemContainer
    extends JPanel {
        private BeanTableModel tableModel;
        private JTable itemTable;

        public ItemContainer(BeanTableModel tableModel) {
            this.tableModel = tableModel;
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.itemTable = new JTable(this.tableModel);
            this.itemTable.setDefaultRenderer(Object.class, new CustomCellRenderer());
            this.itemTable.setSelectionMode(2);
            this.itemTable.setRowHeight(PosUIManager.getSize(50));
            ExcelImportViewDialog.this.resizeColumnWidth(this.itemTable);
            this.add(new JScrollPane(this.itemTable));
        }
    }
}

