/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.forms;

import com.floreantpos.POSConstants;
import com.floreantpos.config.AppProperties;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class GeneratePasswordDialog
extends POSDialog {
    private String USE_PASS = "USE THIS PASSWORD";
    private String COPY = "COPY";
    private JPanel mainPanel;
    private JTextField tfGenPass;
    private IntegerTextField tfPassLength;
    private TitlePanel titlePanel;
    private String generatedPassword;

    public GeneratePasswordDialog() {
        super(POSUtil.getFocusedWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(2);
        this.setTitle(AppProperties.getAppName());
        this.initComponents();
    }

    private void initComponents() {
        this.titlePanel = new TitlePanel();
        this.titlePanel.setTitle("Generate Password");
        this.getContentPane().add((Component)this.titlePanel, "North");
        this.mainPanel = new JPanel((LayoutManager)new MigLayout("center", "[][grow][]", ""));
        JLabel passLengthLabel = new JLabel("PASSWORD LENGTH");
        this.tfPassLength = new IntegerTextField(10);
        this.tfPassLength.setText(String.valueOf(4));
        JButton btnGen = new JButton("GENERATE");
        btnGen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                GeneratePasswordDialog.this.doSetGeneratedPass();
            }
        });
        JLabel passLabel = new JLabel("GENERATED PASSWORD");
        this.tfGenPass = new JTextField(10);
        this.tfGenPass.setEditable(false);
        this.mainPanel.add(passLengthLabel);
        this.mainPanel.add((Component)this.tfPassLength, "growx");
        this.mainPanel.add((Component)btnGen, "wrap");
        this.mainPanel.add(passLabel);
        this.mainPanel.add((Component)this.tfGenPass, "growx");
        this.getContentPane().add((Component)this.mainPanel, "Center");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("center"));
        PosButton useThisPass = new PosButton(this.USE_PASS);
        PosButton btnCancel = new PosButton(POSConstants.CANCEL.toUpperCase());
        PosButton btnCopy = new PosButton(this.COPY);
        btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GeneratePasswordDialog.this.tfGenPass.getText().length() == 0) {
                    POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), "Please generate password!");
                } else {
                    StringSelection selection = new StringSelection(GeneratePasswordDialog.this.tfGenPass.getText());
                    Clipboard clipbord = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipbord.setContents(selection, null);
                    GeneratePasswordDialog.this.tfGenPass.copy();
                }
            }
        });
        useThisPass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneratePasswordDialog.this.doUseThisPass();
            }
        });
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneratePasswordDialog.this.performCancel();
            }
        });
        buttonPanel.add(btnCopy);
        buttonPanel.add(useThisPass);
        buttonPanel.add(btnCancel);
        this.getContentPane().add((Component)buttonPanel, "South");
    }

    private void performCancel() {
        this.setCanceled(true);
        this.dispose();
    }

    private String createRandPass() throws Exception {
        ArrayList<String> passList = new ArrayList<String>();
        List<String> passwords = UserDAO.getInstance().findUsersPasswords();
        Iterator<String> iterator = passwords.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (StringUtils.isEmpty((String)string)) {
                iterator.remove();
                continue;
            }
            String deCryptedPass = AESencrp.decrypt(string);
            passList.add(deCryptedPass);
        }
        String passWordLength = this.tfPassLength.getText();
        String rawString = "1234567890";
        StringBuilder stringBuilder = new StringBuilder();
        String password = this.genPassword(rawString, stringBuilder, passWordLength);
        while (passList.contains(password)) {
            stringBuilder.setLength(0);
            password = this.genPassword(rawString, stringBuilder, passWordLength);
        }
        return password;
    }

    private String genPassword(String rawString, StringBuilder stringBuilder, String passWordLength) {
        Random rand = new Random();
        String password = "";
        if (passWordLength.length() == 0) {
            while (stringBuilder.length() < 4) {
                int index = (int)(rand.nextFloat() * (float)rawString.length());
                stringBuilder.append(rawString.charAt(index));
            }
            password = stringBuilder.toString();
        } else {
            while (stringBuilder.length() < Integer.parseInt(passWordLength)) {
                int index = (int)(rand.nextFloat() * (float)rawString.length());
                stringBuilder.append(rawString.charAt(index));
            }
            password = stringBuilder.toString();
        }
        return password;
    }

    public String getGenPassword() {
        return this.generatedPassword;
    }

    private void doUseThisPass() {
        try {
            this.generatedPassword = this.tfGenPass.getText();
            if (StringUtils.isEmpty((String)this.generatedPassword)) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please generate password.");
                return;
            }
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void doSetGeneratedPass() {
        try {
            if (this.tfPassLength.getText().equals("0") || this.tfPassLength.getText().equals("1") || this.tfPassLength.getText().equals("2") || this.tfPassLength.getText().equals("3")) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Password length minimum 4");
            } else {
                this.tfGenPass.setText(this.createRandPass());
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }
}

