/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.inv;

import com.floreantpos.config.AppProperties;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class InventoryItemEntryDialog
extends OkCancelOptionDialog {
    private Component lblQuantity;
    private JLabel lblPurchaseOrderItemType;
    private JComboBox cbInventoryReasons;
    private JLabel lblUnitPrice;
    private DoubleTextField tfUnitPrice;
    private DoubleTextField tfQuantity;
    private JButton btnSearchItem;
    private POSTextField tfSearchString;
    private JComboBox<IUnit> cbUnits;
    private JLabel lblOrderId;
    private InventoryTransaction inventoryTransaction;
    private MenuItem menuItem;

    public InventoryItemEntryDialog() {
        this((InventoryTransaction)null);
    }

    public InventoryItemEntryDialog(InventoryTransaction inventoryTransaction) {
        this.inventoryTransaction = inventoryTransaction;
        this.initComponents();
        this.initData();
        this.updateView();
    }

    private void initData() {
        ComboBoxModel aModel = new ComboBoxModel();
        this.cbUnits.setModel(aModel);
        this.loadUnits();
    }

    private void updatePrice() {
        if (this.menuItem == null) {
            return;
        }
        IUnit selectedUnit = (IUnit)this.cbUnits.getSelectedItem();
        if (selectedUnit != null) {
            this.tfUnitPrice.setText(NumberUtil.formatNumber(this.menuItem.getCost(selectedUnit)));
        }
    }

    private void loadUnits() {
        if (this.menuItem == null) {
            return;
        }
        ComboBoxModel model = (ComboBoxModel)this.cbUnits.getModel();
        model.removeAllElements();
        model.setDataList(this.menuItem.getUnits());
    }

    private void initComponents() {
        this.setTitle(AppProperties.getAppName());
        this.setCaption("Select Item");
        JPanel itemInfoPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3", "[][grow][]", ""));
        this.lblOrderId = new JLabel("Barcode/SKU/Name");
        itemInfoPanel.add((Component)this.lblOrderId, "cell 0 2,alignx trailing");
        this.tfSearchString = new POSTextField();
        itemInfoPanel.add((Component)this.tfSearchString, "cell 1 2,growx");
        this.tfSearchString.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryItemEntryDialog.this.doSearchItem();
            }
        });
        this.btnSearchItem = new JButton("Search");
        itemInfoPanel.add((Component)this.btnSearchItem, "cell 2 2,growx");
        this.btnSearchItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryItemEntryDialog.this.doSearchItem();
            }
        });
        this.lblPurchaseOrderItemType = new JLabel("Reason Type");
        itemInfoPanel.add((Component)this.lblPurchaseOrderItemType, "cell 0 4, alignx trailing");
        this.lblPurchaseOrderItemType.setVisible(false);
        this.cbInventoryReasons = new JComboBox();
        itemInfoPanel.add((Component)this.cbInventoryReasons, "cell 1 4");
        this.cbInventoryReasons.setVisible(false);
        JLabel lblUnit = new JLabel("Unit");
        itemInfoPanel.add((Component)lblUnit, "cell 0 7,alignx trailing");
        this.cbUnits = new JComboBox();
        this.cbUnits.setMinimumSize(PosUIManager.getSize(100, 0));
        itemInfoPanel.add(this.cbUnits, "cell 1 7");
        this.lblUnitPrice = new JLabel("Unit Cost (" + CurrencyUtil.getCurrencySymbol() + ")");
        itemInfoPanel.add((Component)this.lblUnitPrice, "cell 0 8,alignx trailing");
        this.tfUnitPrice = new DoubleTextField();
        itemInfoPanel.add((Component)this.tfUnitPrice, "cell 1 8,growx");
        this.lblQuantity = new JLabel("Quantity");
        itemInfoPanel.add(this.lblQuantity, "cell 0 9,alignx trailing");
        this.tfQuantity = new DoubleTextField();
        itemInfoPanel.add((Component)this.tfQuantity, "cell 1 9,growx");
        this.getContentPanel().add(itemInfoPanel);
        this.cbUnits.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int stateChange = e.getStateChange();
                if (stateChange == 1) {
                    InventoryItemEntryDialog.this.updatePrice();
                }
            }
        });
    }

    private void doSearchItem() {
        MenuItemSelectionDialog dialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>(), true);
        dialog.setSelectionMode(0);
        dialog.setSize(PosUIManager.getSize(600, 515));
        dialog.doSearch(this.tfSearchString.getText());
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        this.menuItem = dialog.getSelectedRowData();
        if (this.menuItem != null) {
            this.tfSearchString.setText(this.menuItem.getName());
            this.setUnit(this.menuItem);
        }
        if (this.menuItem != null) {
            this.tfQuantity.setText(String.valueOf(this.menuItem.getReplenishLevel() == 0.0 ? 1.0 : this.menuItem.getReplenishLevel()));
            this.tfUnitPrice.setText(NumberUtil.formatNumber(this.menuItem.getCost()));
        }
    }

    private void setUnit(MenuItem menuItem) {
        ComboBoxModel aModel = (ComboBoxModel)this.cbUnits.getModel();
        if (menuItem != null) {
            MenuItemDAO.getInstance().initialize(menuItem);
            aModel.setDataList(menuItem.getUnits());
            InventoryUnit unit = menuItem.getUnit();
            if (unit != null) {
                for (IUnit iUnit : aModel.getDataList()) {
                    if (!iUnit.getUniqueCode().equals(unit.getUniqueCode())) continue;
                    this.cbUnits.setSelectedItem(iUnit);
                }
            } else if (aModel.getSize() > 0) {
                this.cbUnits.setSelectedIndex(0);
            }
        }
        this.updatePrice();
    }

    public void updateView() {
        InventoryTransaction inventoryTransaction = this.getInventoryTransaction();
        if (inventoryTransaction == null) {
            return;
        }
        this.menuItem = inventoryTransaction.getMenuItem();
        if (this.menuItem == null) {
            return;
        }
        this.setUnit(this.menuItem);
        ComboBoxModel aModel = (ComboBoxModel)this.cbUnits.getModel();
        if (inventoryTransaction.getUnit() != null) {
            for (IUnit iUnit : aModel.getDataList()) {
                if (iUnit.getUniqueCode() == null || !iUnit.getUniqueCode().equals(inventoryTransaction.getUnit())) continue;
                this.cbUnits.setSelectedItem(iUnit);
            }
        } else if (aModel.getSize() > 0) {
            this.cbUnits.setSelectedIndex(0);
        }
        this.tfSearchString.setText(this.menuItem.getName());
        this.tfQuantity.setText(String.valueOf(inventoryTransaction.getQuantity()));
        this.tfUnitPrice.setText(NumberUtil.formatNumber(inventoryTransaction.getUnitCost()));
    }

    @Override
    public void doOk() {
        if (this.menuItem == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select an item");
            return;
        }
        IUnit unit = (IUnit)this.cbUnits.getSelectedItem();
        if (unit == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select item unit");
            return;
        }
        double quantity = this.tfQuantity.getDoubleOrZero();
        if (quantity <= 0.0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select valid quantity");
            return;
        }
        double price = this.tfUnitPrice.getDoubleOrZero();
        double total = price * quantity;
        this.getInventoryTransaction().setMenuItem(this.menuItem);
        this.getInventoryTransaction().setUnit(unit.getUniqueCode());
        this.getInventoryTransaction().setQuantity(quantity);
        this.getInventoryTransaction().setUnitCost(price);
        this.getInventoryTransaction().setTotal(total);
        this.setCanceled(false);
        this.dispose();
    }

    public InventoryTransaction getInventoryTransaction() {
        return this.inventoryTransaction;
    }

    public void setInventoryTransaction(InventoryTransaction inventoryTransaction) {
        this.inventoryTransaction = inventoryTransaction;
    }
}

