/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.inv;

import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.InventoryStockDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.InventoryVendorDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.inv.InventoryLocationSelector;
import com.floreantpos.util.CopyUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class InventoryTransactionEntryForm
extends BeanEditor<InventoryTransaction> {
    private JButton btnInLoc;
    private POSTextField tfInLocation;
    private JLabel lblParentLoc;
    private POSTextField tfOrderId;
    private JLabel lblMenuItem;
    private JLabel lblVendor;
    private InventoryTransaction inventoryTransaction;
    private JComboBox<InventoryVendor> cbVendor;
    private JLabel lblInventoryTransactionType;
    private JComboBox cbTransactionType;
    private JLabel lblPurchaseUnitPrice;
    private DoubleTextField tfPurchaseUnitPrice;
    private JLabel lblPurchaseTotalPrice;
    private JLabel lblPurchaseQuantity;
    private DoubleTextField tfPurchaseTotalPrice;
    private POSTextField tfMenuItem;
    private DoubleTextField tfPurchaseQuantity;
    private POSTextField tfSku;
    private InventoryLocation selectedFromLocation;
    private InventoryLocation selectedToLocation;
    private JComboBox<IUnit> cbUnits;
    private POSTextField tfToLocation;
    private JButton btnToLoc;
    private JLabel lblToLocation;
    private JButton btnClearToLoc;
    private JComboBox cbInventoryReasons;
    private JLabel lblInventoryReasonType;
    private JLabel lblAvailableQuantity;

    public InventoryTransactionEntryForm() {
        this.setLayout(new BorderLayout());
        this.createUI();
    }

    public InventoryTransactionEntryForm(InventoryTransaction inventoryTransaction) {
        this.inventoryTransaction = inventoryTransaction;
        this.setLayout(new BorderLayout());
        this.createUI();
        this.initData();
        this.setBean(inventoryTransaction);
    }

    private void initData() {
        InventoryVendorDAO inventoryVendorDao = new InventoryVendorDAO();
        List<InventoryVendor> inventoryVendors = inventoryVendorDao.findAll();
        this.cbVendor.setModel(new ComboBoxModel(inventoryVendors));
        ArrayList<String> inventoryReasons = new ArrayList<String>();
        for (int i = 0; i < InventoryTransaction.REASON_OUT.length; ++i) {
            inventoryReasons.add(InventoryTransaction.REASON_OUT[i]);
        }
        this.cbInventoryReasons.setModel(new ComboBoxModel(inventoryReasons));
        this.cbTransactionType.setEnabled(false);
        this.cbUnits.setModel(new ComboBoxModel());
        List<InventoryLocation> inventoryLocationList = InventoryLocationDAO.getInstance().findAll();
        for (InventoryLocation inventoryLocation : inventoryLocationList) {
            if (inventoryLocation.isDefaultInLocation().booleanValue()) {
                this.selectedFromLocation = inventoryLocation;
                this.tfInLocation.setText(inventoryLocation.getName());
            }
            if (!inventoryLocation.isDefaultOutLocation().booleanValue()) continue;
            this.selectedToLocation = inventoryLocation;
            this.tfToLocation.setText(inventoryLocation.getName());
        }
        if (this.inventoryTransaction.getTransactionType().equals((Object)InventoryTransactionType.UNCHANGED)) {
            this.cbTransactionType.addItem(InventoryTransactionType.UNCHANGED);
            this.lblPurchaseUnitPrice.setVisible(false);
            this.lblPurchaseTotalPrice.setVisible(false);
            this.tfPurchaseUnitPrice.setVisible(false);
            this.tfPurchaseTotalPrice.setVisible(false);
            this.lblInventoryReasonType.setVisible(false);
            this.cbInventoryReasons.setVisible(false);
            this.lblParentLoc.setText("From Location");
        } else if (this.inventoryTransaction.getTransactionType().equals((Object)InventoryTransactionType.OUT)) {
            this.cbTransactionType.addItem(InventoryTransactionType.OUT);
            this.lblToLocation.setVisible(false);
            this.tfToLocation.setVisible(false);
            this.btnToLoc.setVisible(false);
            this.btnClearToLoc.setVisible(false);
        }
        this.btnInLoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryLocation selectedLocation = InventoryLocationSelector.openLocationSelector();
                if (selectedLocation == null) {
                    return;
                }
                InventoryTransactionEntryForm.this.selectedFromLocation = selectedLocation;
                InventoryTransactionEntryForm.this.tfInLocation.setText(selectedLocation.getName());
                InventoryTransactionEntryForm.this.findAvailableQuantity();
            }
        });
        this.btnToLoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryLocation selectedLocation = InventoryLocationSelector.openLocationSelector();
                if (selectedLocation == null) {
                    return;
                }
                InventoryTransactionEntryForm.this.selectedToLocation = selectedLocation;
                InventoryTransactionEntryForm.this.tfToLocation.setText(selectedLocation.getName());
            }
        });
        this.loadUnits();
    }

    private void loadUnits() {
        MenuItem menuItem = this.inventoryTransaction.getMenuItem();
        if (menuItem == null) {
            return;
        }
        ComboBoxModel model = (ComboBoxModel)this.cbUnits.getModel();
        model.removeAllElements();
        MenuItemDAO.getInstance().initializeUnits(menuItem);
        model.setDataList(menuItem.getUnits());
        if (model.getDataList() != null) {
            this.cbUnits.setSelectedIndex(0);
        }
    }

    private void createUI() {
        JPanel itemInfoPanel = new JPanel();
        this.add((Component)itemInfoPanel, "Center");
        itemInfoPanel.setLayout((LayoutManager)new MigLayout("hidemode 3", "[][grow][]", ""));
        JLabel lblOrderID = new JLabel("P.O. No");
        itemInfoPanel.add((Component)lblOrderID, "cell 0 0,alignx trailing");
        this.tfOrderId = new POSTextField();
        itemInfoPanel.add((Component)this.tfOrderId, "cell 1 0,growx");
        this.lblMenuItem = new JLabel("Inventory Item");
        itemInfoPanel.add((Component)this.lblMenuItem, "cell 0 1,alignx trailing ");
        this.tfMenuItem = new POSTextField();
        itemInfoPanel.add((Component)this.tfMenuItem, "cell 1 1,growx");
        this.tfMenuItem.setEditable(false);
        JLabel lblSku = new JLabel("SKU");
        itemInfoPanel.add((Component)lblSku, "cell 0 2,alignx trailing");
        this.tfSku = new POSTextField();
        itemInfoPanel.add((Component)this.tfSku, "cell 1 2,growx");
        this.tfSku.setEditable(false);
        this.lblVendor = new JLabel("Vendor");
        itemInfoPanel.add((Component)this.lblVendor, "cell 0 3, alignx trailing");
        this.cbVendor = new JComboBox();
        itemInfoPanel.add(this.cbVendor, "cell 1 3, growx");
        this.lblInventoryReasonType = new JLabel("Reason Type");
        itemInfoPanel.add((Component)this.lblInventoryReasonType, "cell 0 4, alignx trailing");
        this.cbInventoryReasons = new JComboBox();
        this.cbInventoryReasons.setMinimumSize(PosUIManager.getSize(100, 0));
        itemInfoPanel.add((Component)this.cbInventoryReasons, "cell 1 4, growx");
        this.lblInventoryTransactionType = new JLabel("Transaction Type");
        itemInfoPanel.add((Component)this.lblInventoryTransactionType, "cell 0 5, alignx trailing");
        this.cbTransactionType = new JComboBox();
        itemInfoPanel.add((Component)this.cbTransactionType, "cell 1 5, growx");
        this.lblParentLoc = new JLabel("Location");
        itemInfoPanel.add((Component)this.lblParentLoc, "cell 0 6, alignx trailing");
        this.tfInLocation = new POSTextField();
        itemInfoPanel.add((Component)this.tfInLocation, "cell 1 6,split 3, growx");
        this.tfInLocation.setEditable(false);
        this.btnInLoc = new JButton("Select");
        itemInfoPanel.add(this.btnInLoc);
        JButton btnClearOutLoc = new JButton("Clear");
        itemInfoPanel.add(btnClearOutLoc);
        btnClearOutLoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryTransactionEntryForm.this.tfInLocation.setText("");
                InventoryTransactionEntryForm.this.selectedToLocation = null;
                InventoryTransactionEntryForm.this.findAvailableQuantity();
            }
        });
        this.lblToLocation = new JLabel("To Location");
        itemInfoPanel.add((Component)this.lblToLocation, "cell 0 7, alignx trailing");
        this.tfToLocation = new POSTextField();
        itemInfoPanel.add((Component)this.tfToLocation, "cell 1 7,split 3, growx");
        this.tfToLocation.setEditable(false);
        this.btnToLoc = new JButton("Select");
        itemInfoPanel.add(this.btnToLoc);
        this.btnClearToLoc = new JButton("Clear");
        itemInfoPanel.add(this.btnClearToLoc);
        this.btnClearToLoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryTransactionEntryForm.this.tfToLocation.setText("");
                InventoryTransactionEntryForm.this.selectedFromLocation = null;
            }
        });
        JLabel lblUnit = new JLabel("Unit");
        itemInfoPanel.add((Component)lblUnit, "cell 0 8,alignx trailing");
        this.cbUnits = new JComboBox();
        this.cbUnits.setMinimumSize(PosUIManager.getSize(100, 0));
        itemInfoPanel.add(this.cbUnits, "cell 1 8");
        this.cbUnits.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InventoryTransactionEntryForm.this.findAvailableQuantity();
            }
        });
        this.lblPurchaseUnitPrice = new JLabel("Unit Cost (" + CurrencyUtil.getCurrencySymbol() + ")");
        itemInfoPanel.add((Component)this.lblPurchaseUnitPrice, "cell 0 9,alignx trailing");
        this.tfPurchaseUnitPrice = new DoubleTextField();
        itemInfoPanel.add((Component)this.tfPurchaseUnitPrice, "cell 1 9,growx");
        this.lblPurchaseQuantity = new JLabel("Quantity");
        itemInfoPanel.add((Component)this.lblPurchaseQuantity, "cell 0 10,alignx trailing");
        this.tfPurchaseQuantity = new DoubleTextField();
        this.tfPurchaseQuantity.setMinimumSize(PosUIManager.getSize(100, 0));
        itemInfoPanel.add((Component)this.tfPurchaseQuantity, "cell 1 10 , split 3");
        this.lblAvailableQuantity = new JLabel("(Available Quantity)");
        itemInfoPanel.add(this.lblAvailableQuantity);
        this.lblPurchaseTotalPrice = new JLabel("Total Price");
        this.tfPurchaseTotalPrice = new DoubleTextField();
    }

    @Override
    public boolean save() {
        Transaction tx = null;
        try (Session session = null;){
            if (!this.updateModel()) {
                boolean bl = false;
                return bl;
            }
            InventoryTransaction modelTransaction = (InventoryTransaction)this.getBean();
            String orderId = this.tfOrderId.getText();
            PurchaseOrder purchaseOrder = new PurchaseOrder();
            purchaseOrder.setOrderId(orderId);
            modelTransaction.setReferenceNo(purchaseOrder.getId());
            InventoryTransactionDAO inventoryTransactionDAO = InventoryTransactionDAO.getInstance();
            session = inventoryTransactionDAO.createNewSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)purchaseOrder);
            if (modelTransaction.getTransactionType() == InventoryTransactionType.UNCHANGED) {
                InventoryTransaction outTrans = (InventoryTransaction)CopyUtil.deepCopy(modelTransaction);
                InventoryTransaction inTrans = modelTransaction;
                outTrans.setTransactionType(InventoryTransactionType.OUT);
                inventoryTransactionDAO.adjustInventoryStock(outTrans, session);
                inTrans.setTransactionType(InventoryTransactionType.IN);
                inventoryTransactionDAO.adjustInventoryStock(inTrans, session);
            } else {
                inventoryTransactionDAO.adjustInventoryStock(modelTransaction, session);
            }
            tx.commit();
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public void updateView() {
        InventoryTransaction model = (InventoryTransaction)this.getBean();
        if (model == null) {
            return;
        }
        if (model.getReferenceNo() != null) {
            this.tfOrderId.setText(model.getReferenceNo());
        }
        this.tfMenuItem.setText(model.getMenuItem().getName());
        this.tfSku.setText(model.getMenuItem().getSku());
        PosGuiUtil.selectComboItemById(this.cbVendor, model.getVendorId());
        this.cbTransactionType.setSelectedItem(model.getType());
        InventoryLocation fromInventoryLocation = DataProvider.get().getInventoryLocationById(model.getFromLocationId());
        InventoryLocation toInventoryLocation = DataProvider.get().getInventoryLocationById(model.getToLocationId());
        if (fromInventoryLocation != null) {
            this.tfInLocation.setText(fromInventoryLocation.getName());
        }
        if (toInventoryLocation != null) {
            this.tfToLocation.setText(toInventoryLocation.getName());
        }
        this.tfPurchaseUnitPrice.setText(NumberUtil.formatNumber(model.getUnitPrice()));
        this.tfPurchaseQuantity.setText(String.valueOf(model.getQuantity()));
    }

    @Override
    public boolean updateModel() {
        InventoryTransaction invTran = (InventoryTransaction)this.getBean();
        MenuItem inventoryItem = invTran.getMenuItem();
        if (inventoryItem == null) {
            POSMessageDialog.showMessage(this.getParent(), "Please select inventory item");
            return false;
        }
        invTran.setMenuItem(inventoryItem);
        IUnit selectedUnit = (IUnit)this.cbUnits.getSelectedItem();
        if (selectedUnit == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select item unit.");
            return false;
        }
        invTran.setUnit(selectedUnit.getUniqueCode());
        if (invTran.getTransactionType() == InventoryTransactionType.UNCHANGED) {
            if (this.selectedFromLocation == null) {
                POSMessageDialog.showMessage(this.getParent(), "Please select from location.");
                return false;
            }
            invTran.setFromLocationId(this.selectedFromLocation.getId());
            if (this.selectedToLocation == null) {
                POSMessageDialog.showMessage(this.getParent(), "Please select to location.");
                return false;
            }
            invTran.setToLocationId(this.selectedToLocation.getId());
            if (this.selectedFromLocation.equals(this.selectedToLocation)) {
                POSMessageDialog.showMessage(this.getParent(), "Please choose a different from and to location.");
                return false;
            }
        } else if (invTran.getTransactionType() == InventoryTransactionType.OUT) {
            String inventoryReasons = (String)this.cbInventoryReasons.getSelectedItem();
            invTran.setReason(inventoryReasons);
            if (this.selectedToLocation == null) {
                POSMessageDialog.showMessage(this.getParent(), "Please select to location");
                return false;
            }
            invTran.setFromLocationId(this.selectedFromLocation.getId());
        }
        InventoryStockDAO stockDAO = InventoryStockDAO.getInstance();
        InventoryStock inventoryStock = stockDAO.getInventoryStock(invTran.getMenuItem(), this.selectedFromLocation.getId(), invTran.getUnit());
        double quantity = this.tfPurchaseQuantity.getDouble();
        if (quantity == 0.0) {
            POSMessageDialog.showMessage(this.getParent(), "Quantity must be greater than zero");
            return false;
        }
        if (inventoryStock == null || inventoryStock.getQuantityInHand() <= 0.0 || quantity > inventoryStock.getQuantityInHand()) {
            POSMessageDialog.showMessage(this.getParent(), "Selected location does not contain enough items for out transaction!");
            return false;
        }
        Object selectedItem = this.cbVendor.getSelectedItem();
        if (selectedItem instanceof InventoryVendor) {
            invTran.setVendorId(((InventoryVendor)selectedItem).getId());
        }
        invTran.setTransactionDate(new Date());
        invTran.setQuantity(quantity);
        double cost = inventoryItem.getCost(selectedUnit.getUniqueCode());
        invTran.setUnitCost(cost);
        invTran.setUnit(selectedUnit.getUniqueCode());
        invTran.setTotal(quantity * cost);
        return true;
    }

    @Override
    public String getDisplayText() {
        if (this.inventoryTransaction.getTransactionType().equals((Object)InventoryTransactionType.UNCHANGED)) {
            return "Inventory Transfer";
        }
        if (this.inventoryTransaction.getTransactionType().equals((Object)InventoryTransactionType.OUT)) {
            return "Inventory Out";
        }
        return "";
    }

    private void findAvailableQuantity() {
        MenuItem menuItem = this.inventoryTransaction.getMenuItem();
        if (this.selectedFromLocation == null) {
            return;
        }
        String locationId = this.selectedFromLocation.getId();
        String selectedUnits = String.valueOf(this.cbUnits.getSelectedItem());
        InventoryStockDAO stockDAO = InventoryStockDAO.getInstance();
        InventoryStock inventoryStock = stockDAO.getInventoryStock(menuItem, locationId, selectedUnits);
        if (inventoryStock != null) {
            this.lblAvailableQuantity.setText("(Available Quantity : " + inventoryStock.getQuantityInHand() + " " + selectedUnits + ")");
        } else {
            this.lblAvailableQuantity.setText("(Available Quantity : 0 " + (selectedUnits.equals("null") ? "" : selectedUnits + ")"));
        }
    }
}

