/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.kitchendisplay;

import com.floreantpos.swing.PosButton;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class KitchenActionButton
extends PosButton
implements MouseListener,
MouseMotionListener {
    public static final int TYPE_ROUNDED_RECTANGLE = 1;
    public static final int RECTANGLE = 2;
    private int shape;
    private boolean buttonSelected;
    private Color selectedBackgoundColor;
    private Color originalBackground;
    private Color originalForeground;
    private Color selectedBorderColor;
    private int gapTop = 2;
    private int gapLeft = 5;
    private int arcWidth = 10;
    private int arcHeight = 10;
    private boolean cellButton = true;
    private boolean btnToogle;

    public KitchenActionButton(String text) {
        this(text, 1, Color.black, Color.white);
        this.selectedBackgoundColor = new Color(203, 33, 55);
        this.setCellButton(false);
        this.setGap(2, 2);
    }

    public KitchenActionButton(String text, Color bg) {
        this(text, bg, Color.black);
    }

    public KitchenActionButton(String text, Color bg, Color fg) {
        this(text, 2, bg, fg);
        this.selectedBackgoundColor = new Color(203, 33, 55);
        this.setFont(this.getFont().deriveFont(1));
        this.setCellButton(false);
        this.setGap(0, 0);
    }

    public KitchenActionButton(String text, int shape, Color bg, Color fg) {
        super(text);
        this.shape = shape;
        this.originalBackground = bg;
        this.originalForeground = fg;
        this.setOpaque(false);
        this.setFocusPainted(false);
        this.setContentAreaFilled(false);
        this.setFocusable(false);
        this.setBackground(bg);
        this.setForeground(fg);
        this.setBorderPainted(false);
        this.addMouseListener(this);
    }

    public void setCellButton(boolean b) {
        this.cellButton = b;
    }

    public void setBtnToogle(boolean btnToogle) {
        this.btnToogle = btnToogle;
    }

    public void setGap(int gapTop, int gapLeft) {
        this.gapTop = gapTop;
        this.gapLeft = gapLeft;
    }

    public void setRoundCorner(int arcWidth, int arcHeight) {
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
    }

    public void setSelectedBackground(Color selectedBackground) {
        this.selectedBackgoundColor = selectedBackground;
    }

    public KitchenActionButton() {
    }

    @Override
    public void setSelected(boolean b) {
        this.buttonSelected = b;
    }

    @Override
    public boolean isSelected() {
        return this.buttonSelected;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.selectedBorderColor != null) {
            g.setColor(this.selectedBorderColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.buttonSelected) {
            g.setColor(this.selectedBackgoundColor);
            if (this.shape == 1) {
                g.fillRoundRect(this.gapLeft, this.gapTop, this.getWidth() - this.gapLeft * 2, this.getHeight() - this.gapTop * 2, this.arcWidth, this.arcHeight);
            } else {
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            this.setForeground(Color.WHITE);
        } else {
            g.setColor(this.originalBackground);
            if (this.shape == 1) {
                g.fillRoundRect(this.gapLeft, this.gapTop, this.getWidth() - this.gapLeft * 2, this.getHeight() - this.gapTop * 2, this.arcWidth, this.arcHeight);
            } else {
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.drawLine(this.getX(), this.getY(), 1, this.getHeight());
            }
            this.setForeground(this.originalForeground);
        }
        super.paintComponent(g);
    }

    public void setSelectedBorderColor(Color color) {
        this.selectedBorderColor = color;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.btnToogle) {
            return;
        }
        if (!this.cellButton) {
            this.setSelected(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.btnToogle) {
            return;
        }
        if (!this.cellButton) {
            this.setSelected(false);
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

