/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.kitchendisplay;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.NumericKeypad;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class KitchenDisplayConfigDialog
extends OkCancelOptionDialog {
    private IntegerTextField tfTicketsPerPage = new IntegerTextField(25);
    private IntegerTextField tfWarningTimout = new IntegerTextField(8);
    private IntegerTextField tfOverTimout = new IntegerTextField(8);
    private JButton btnContainerBgColor = new JButton(POSConstants.BACKGROUND);
    private JButton btnInitialBgColor = new JButton(POSConstants.BACKGROUND);
    private JButton btnWarningBgColor = new JButton(POSConstants.BACKGROUND);
    private JButton btnOverBgColor = new JButton(POSConstants.BACKGROUND);
    private JButton btnContainerFgColor = new JButton(POSConstants.TEXT_COLOR);
    private JButton btnInitialFgColor = new JButton(POSConstants.TEXT_COLOR);
    private JButton btnWarningFgColor = new JButton(POSConstants.TEXT_COLOR);
    private JButton btnOverFgColor = new JButton(POSConstants.TEXT_COLOR);
    private JCheckBox chkHideItemBumpButton = new JCheckBox(Messages.getString("KitchenDisplayConfigDialog.0"));
    private String[] labels = new String[]{Messages.getString("KitchenDisplayConfigDialog.2"), Messages.getString("KitchenDisplayConfigDialog.3")};
    private JComboBox cbInitialColorComponent = new JComboBox<String>(this.labels);
    private JComboBox cbWarningColorComponent = new JComboBox<String>(this.labels);
    private JComboBox cbOverColorComponent = new JComboBox<String>(this.labels);
    private JCheckBox chkShowBorder = new JCheckBox(Messages.getString("KitchenDisplayConfigDialog.4"));
    private JCheckBox chkShowHorizontalLines = new JCheckBox(Messages.getString("KitchenDisplayConfigDialog.6"));

    public KitchenDisplayConfigDialog() {
        String title = Messages.getString("KitchenDisplayConfigDialog.1");
        this.setTitle(title);
        this.setCaption(title);
        this.initComponents();
        this.updateView();
    }

    private void initComponents() {
        JPanel contentPanel = this.getContentPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("wrap 2,ins 0 10 0 10", "[][grow]", ""));
        contentPanel.add(this.createLabel(Messages.getString("KitchenDisplayConfigDialog.5")));
        contentPanel.add((Component)this.tfTicketsPerPage, "growx");
        contentPanel.add(this.createLabel(Messages.getString("KitchenDisplayConfigDialog.7")));
        contentPanel.add((Component)this.tfWarningTimout, "split 4");
        contentPanel.add(this.createLabel(Messages.getString("KitchenDisplayConfigDialog.10")));
        contentPanel.add(this.tfOverTimout);
        contentPanel.add(this.createLabel("sec"));
        this.addButtonRow(contentPanel, "Kitchen Display", this.btnContainerBgColor, this.btnContainerFgColor, null);
        this.addButtonRow(contentPanel, Messages.getString("KitchenDisplayConfigDialog.13"), this.btnInitialBgColor, this.btnInitialFgColor, this.cbInitialColorComponent);
        this.addButtonRow(contentPanel, Messages.getString("KitchenDisplayConfigDialog.14"), this.btnWarningBgColor, this.btnWarningFgColor, this.cbWarningColorComponent);
        this.addButtonRow(contentPanel, Messages.getString("KitchenDisplayConfigDialog.15"), this.btnOverBgColor, this.btnOverFgColor, this.cbOverColorComponent);
        contentPanel.add((Component)this.chkHideItemBumpButton, "skip 1");
        contentPanel.add((Component)this.chkShowBorder, "skip 1,split 2");
        contentPanel.add(this.chkShowHorizontalLines);
        NumericKeypad keypad = new NumericKeypad();
        contentPanel.add((Component)keypad, "span 2,gaptop 10,grow");
    }

    private void addButtonRow(JPanel contentPanel, String caption, JButton btnBg, JButton btnTextColor, JComboBox cbColorComponent) {
        contentPanel.add(this.createLabel(caption));
        contentPanel.add((Component)btnBg, "grow,split " + (cbColorComponent == null ? 2 : 3) + ",h " + PosUIManager.getSize(30));
        contentPanel.add((Component)btnTextColor, "grow");
        if (cbColorComponent != null) {
            contentPanel.add((Component)cbColorComponent, "grow");
        }
        ActionListener buttonbackgroundColorActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton btnButtonColor = (JButton)e.getSource();
                Color color = JColorChooser.showDialog(POSUtil.getBackOfficeWindow(), "", btnButtonColor.getBackground());
                if (color == null) {
                    return;
                }
                btnButtonColor.setBackground(color);
                JButton btnTextColor = (JButton)btnButtonColor.getClientProperty(POSConstants.TEXT_COLOR);
                btnTextColor.setBackground(color);
            }
        };
        btnBg.putClientProperty(POSConstants.TEXT_COLOR, btnTextColor);
        btnBg.addActionListener(buttonbackgroundColorActionListener);
        btnTextColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton btnTextColor = (JButton)e.getSource();
                Color color = JColorChooser.showDialog(POSUtil.getBackOfficeWindow(), "", btnTextColor.getForeground());
                if (color == null) {
                    return;
                }
                btnTextColor.setForeground(color);
            }
        });
    }

    private Component createLabel(String text) {
        return new JLabel(text);
    }

    private void updateView() {
        String yellowTimeOut = AppConfig.getString("YellowTimeOut");
        String redTimeOut = AppConfig.getString("RedTimeOut");
        if (yellowTimeOut != null) {
            this.tfWarningTimout.setText(yellowTimeOut);
        }
        if (redTimeOut != null) {
            this.tfOverTimout.setText(redTimeOut);
        }
        this.tfTicketsPerPage.setText(String.valueOf(TerminalConfig.getKDSTicketsPerPage()));
        this.chkHideItemBumpButton.setSelected(AppConfig.getBoolean("kds.hide_item_bump", false));
        this.chkShowBorder.setSelected(AppConfig.getBoolean("kds.border", false));
        this.chkShowHorizontalLines.setSelected(AppConfig.getBoolean("kds.sep", true));
        Color containerBgColor = TerminalConfig.getColor("kds.background", Color.black);
        Color containerFgColor = TerminalConfig.getColor("kds.textcolor", Color.white);
        Color initialBgColor = TerminalConfig.getColor("kds.initial.bg", new Color(0, 135, 67));
        Color initialFgColor = TerminalConfig.getColor("kds.initial.fg", Color.white);
        Color warningBgColor = TerminalConfig.getColor("kds.warning.bg", new Color(247, 177, 55));
        Color warningFgColor = TerminalConfig.getColor("kds.warning.fg", Color.white);
        Color overBgColor = TerminalConfig.getColor("kds.over.bd", new Color(204, 0, 0));
        Color overFgColor = TerminalConfig.getColor("kds.over.fg", Color.white);
        this.updateColorApplicableCompoment(this.cbInitialColorComponent, "kds.initial.component");
        this.updateColorApplicableCompoment(this.cbWarningColorComponent, "kds.warning.component");
        this.updateColorApplicableCompoment(this.cbOverColorComponent, "kds.over.component");
        this.updateButtonColor(this.btnContainerBgColor, this.btnContainerFgColor, containerBgColor, containerFgColor);
        this.updateButtonColor(this.btnInitialBgColor, this.btnInitialFgColor, initialBgColor, initialFgColor);
        this.updateButtonColor(this.btnWarningBgColor, this.btnWarningFgColor, warningBgColor, warningFgColor);
        this.updateButtonColor(this.btnOverBgColor, this.btnOverFgColor, overBgColor, overFgColor);
    }

    private void updateColorApplicableCompoment(JComboBox cbOverColorComponent, String prop) {
        int componentIndex = AppConfig.getInt(prop, 0);
        cbOverColorComponent.setSelectedIndex(componentIndex);
    }

    @Override
    public void doOk() {
        int ticketsPerPage = this.tfTicketsPerPage.getInteger();
        if (ticketsPerPage <= 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("KitchenDisplayConfigDialog.20"));
            return;
        }
        TerminalConfig.setKDSTicketsPerPage(ticketsPerPage);
        AppConfig.put("YellowTimeOut", this.tfWarningTimout.getText());
        AppConfig.put("RedTimeOut", this.tfOverTimout.getText());
        AppConfig.put("kds.hide_item_bump", this.chkHideItemBumpButton.isSelected());
        AppConfig.put("kds.border", this.chkShowBorder.isSelected());
        AppConfig.put("kds.sep", this.chkShowHorizontalLines.isSelected());
        AppConfig.putInt("kds.initial.component", this.cbInitialColorComponent.getSelectedIndex());
        AppConfig.putInt("kds.warning.component", this.cbWarningColorComponent.getSelectedIndex());
        AppConfig.putInt("kds.over.component", this.cbOverColorComponent.getSelectedIndex());
        this.updateButtonColorCode(this.btnContainerBgColor, this.btnContainerFgColor, "kds.background", "kds.textcolor");
        this.updateButtonColorCode(this.btnInitialBgColor, this.btnInitialFgColor, "kds.initial.bg", "kds.initial.fg");
        this.updateButtonColorCode(this.btnWarningBgColor, this.btnWarningFgColor, "kds.warning.bg", "kds.warning.fg");
        this.updateButtonColorCode(this.btnOverBgColor, this.btnOverFgColor, "kds.over.bd", "kds.over.fg");
        this.setCanceled(false);
        this.dispose();
    }

    private void updateButtonColorCode(JButton btnButtonColor, JButton btnTextColor, String bgProp, String fgProp) {
        AppConfig.put(bgProp, String.valueOf(btnButtonColor.getBackground().getRGB()));
        AppConfig.put(fgProp, String.valueOf(btnTextColor.getForeground().getRGB()));
    }

    private void updateButtonColor(JButton btnButtonColor, JButton btnTextColor, Color bgColor, Color fgColor) {
        btnButtonColor.setBackground(bgColor);
        btnTextColor.setBackground(bgColor);
        btnTextColor.setForeground(fgColor);
    }
}

