/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.kitchendisplay;

import com.floreantpos.config.TerminalConfig;
import com.floreantpos.ui.kitchendisplay.KitchenTicketListPanel;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.ViewPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import javax.swing.border.EmptyBorder;

public class KitchenDisplayView
extends ViewPanel {
    public static final String VIEW_NAME = "KD";
    private KeyboardDispatcher dispatcher;
    private KitchenTicketListPanel ticketPanel;
    private static KitchenDisplayView instance;

    public KitchenDisplayView() {
        this.setLayout(new BorderLayout(5, 5));
        this.ticketPanel = new KitchenTicketListPanel();
        this.ticketPanel.setOpaque(false);
        this.ticketPanel.setBorder(new EmptyBorder(5, 0, 5, 0));
        this.add(this.ticketPanel);
        this.dispatcher = new KeyboardDispatcher();
    }

    @Override
    public Color getBackground() {
        return TerminalConfig.getColor("kds.background", Color.black);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            RootView.getInstance().getHeaderPanel().setVisible(false);
            String currentView = TerminalConfig.getDefaultView();
            this.ticketPanel.setBackButtonVisible(currentView != null && !currentView.equals(VIEW_NAME));
            this.ticketPanel.updateKDSView();
            KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            manager.addKeyEventDispatcher(this.dispatcher);
        } else {
            KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            manager.removeKeyEventDispatcher(this.dispatcher);
            this.cleanup();
        }
    }

    public synchronized void cleanup() {
        this.ticketPanel.stopTimer();
        this.ticketPanel.reset();
    }

    public void updateView() {
        this.revalidate();
        this.repaint();
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    public static synchronized KitchenDisplayView getInstance() {
        if (instance == null) {
            instance = new KitchenDisplayView();
        }
        return instance;
    }

    private class KeyboardDispatcher
    implements KeyEventDispatcher {
        private KeyboardDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getID() == 402) {
                KitchenDisplayView.this.ticketPanel.setSelectedKey(e.getKeyCode());
            }
            return false;
        }
    }
}

