/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.kitchendisplay;

import com.floreantpos.Messages;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Printer;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ScrollableFlowPanel;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.plaf.metal.MetalToggleButtonUI;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class KitchenFilterDialog
extends OkCancelOptionDialog {
    private JPanel filterPanel;
    private Terminal terminal = Application.getInstance().getTerminal();
    private List<Printer> printerList = new ArrayList<Printer>();
    private List<OrderType> orderTypeList = new ArrayList<OrderType>();
    private static final String ORDER_TYPE_ID = "KDS.ORDER.TYPE.ID";
    private static final String PRINTER_NAME = "KDS.PRINTER_ID";

    public KitchenFilterDialog() {
        this.initializeComponent();
        this.setResizable(true);
    }

    private void initializeComponent() {
        String title = Messages.getString("KitchenFilterDialog.0");
        this.setTitle(title);
        this.setCaption(title);
        this.filterPanel = new JPanel();
        List<Printer> kitchenPrinters = DataProvider.get().getPrinters().getKitchenPrinters();
        List<OrderType> orderType = Application.getInstance().getOrderTypes();
        this.getContentPanel().setLayout(new BorderLayout());
        this.filterPanel.setLayout((LayoutManager)new MigLayout("fill, ins 0", "[225][225]"));
        JPanel leftPanel = new JPanel((LayoutManager)new MigLayout("center center, wrap, gapy 20"));
        leftPanel.setBorder(BorderFactory.createTitledBorder(null, "Printers", 2, 0));
        String printerIds = "";
        List<Object> printerIdsInList = new ArrayList();
        if (StringUtils.isNotBlank((String)this.terminal.getProperty(PRINTER_NAME))) {
            printerIds = this.terminal.getProperty(PRINTER_NAME);
            printerIdsInList = Arrays.asList(printerIds.split(","));
        }
        for (final Printer printer : kitchenPrinters) {
            POSToggleButton button = new POSToggleButton(printer.getVirtualPrinter().getName());
            button.setPreferredSize(PosUIManager.getSize(120, 50));
            button.setBackground(Color.WHITE);
            button.setUI(new MetalToggleButtonUI(){

                @Override
                protected Color getSelectColor() {
                    return Color.RED;
                }
            });
            if (printerIdsInList != null && printerIdsInList.contains(printer.getVirtualPrinter().getId())) {
                button.setSelected(true);
                if (this.printerList.contains(printer)) {
                    return;
                }
                this.printerList.add(printer);
            }
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.addOrRemovePrinter(printer, e);
                }

                private void addOrRemovePrinter(Printer printer2, ActionEvent e) {
                    JToggleButton tb = (JToggleButton)e.getSource();
                    if (tb.isSelected()) {
                        if (!KitchenFilterDialog.this.printerList.contains(printer2)) {
                            KitchenFilterDialog.this.printerList.add(printer2);
                        }
                    } else {
                        KitchenFilterDialog.this.printerList.remove(printer2);
                    }
                }
            });
            leftPanel.add(button);
        }
        JPanel rightPanel = new JPanel(new BorderLayout());
        ScrollableFlowPanel contentPanel = new ScrollableFlowPanel(1);
        contentPanel.setBorder(BorderFactory.createTitledBorder(null, "Order Types", 2, 0));
        String orderTypeID = "";
        List<Object> orderTypeIdInList = new ArrayList();
        if (StringUtils.isNotBlank((String)this.terminal.getProperty(ORDER_TYPE_ID))) {
            orderTypeID = this.terminal.getProperty(ORDER_TYPE_ID);
            orderTypeIdInList = Arrays.asList(orderTypeID.split(","));
        }
        for (final OrderType order : orderType) {
            POSToggleButton btnOrdertype = new POSToggleButton(order.getName());
            btnOrdertype.setPreferredSize(PosUIManager.getSize(120, 50));
            btnOrdertype.setBackground(Color.WHITE);
            btnOrdertype.setUI(new MetalToggleButtonUI(){

                @Override
                protected Color getSelectColor() {
                    return Color.RED;
                }
            });
            if (orderTypeIdInList != null && orderTypeIdInList.contains(order.getId())) {
                btnOrdertype.setSelected(true);
                if (this.orderTypeList.contains(order)) {
                    return;
                }
                this.orderTypeList.add(order);
            }
            btnOrdertype.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.addOrRemoveOrder(order, e);
                }

                private void addOrRemoveOrder(OrderType order2, ActionEvent e) {
                    JToggleButton tb = (JToggleButton)e.getSource();
                    if (tb.isSelected()) {
                        if (!KitchenFilterDialog.this.orderTypeList.contains(order2)) {
                            KitchenFilterDialog.this.orderTypeList.add(order2);
                        }
                    } else {
                        KitchenFilterDialog.this.orderTypeList.remove(order2);
                    }
                }
            });
            contentPanel.add(btnOrdertype);
        }
        contentPanel.getContentPane().setPreferredSize(PosUIManager.getSize(0, 500));
        rightPanel.add(contentPanel);
        JScrollPane comp = new JScrollPane(leftPanel);
        comp.setBorder(null);
        this.filterPanel.add((Component)comp, "grow");
        JScrollPane comp2 = new JScrollPane(rightPanel);
        comp2.setBorder(null);
        this.filterPanel.add((Component)comp2, " grow");
        this.filterPanel.setOpaque(true);
        this.getContentPanel().add(this.filterPanel);
        this.setSize(550, 450);
    }

    @Override
    public void doOk() {
        String printerIds = "";
        String orderTypeIds = "";
        Iterator<Serializable> iterator = this.orderTypeList.iterator();
        while (iterator.hasNext()) {
            OrderType orderType = iterator.next();
            orderTypeIds = orderTypeIds + orderType.getId();
            if (!iterator.hasNext()) continue;
            orderTypeIds = orderTypeIds + ",";
        }
        iterator = this.printerList.iterator();
        while (iterator.hasNext()) {
            Printer printer = (Printer)iterator.next();
            printerIds = printerIds + printer.getVirtualPrinter().getId();
            if (!iterator.hasNext()) continue;
            printerIds = printerIds + ",";
        }
        this.terminal.addProperty(PRINTER_NAME, printerIds);
        this.terminal.addProperty(ORDER_TYPE_ID, orderTypeIds);
        TerminalDAO.getInstance().update(this.terminal);
        this.setCanceled(false);
        this.dispose();
    }

    public List getPrinter() {
        if (this.printerList.isEmpty()) {
            return null;
        }
        return this.printerList;
    }

    public List getOrderType() {
        if (this.orderTypeList.isEmpty()) {
            return null;
        }
        return this.orderTypeList;
    }
}

