/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.kitchendisplay;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.LogoutAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Printer;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.KitchenTicketDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosBlinkButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.kitchendisplay.KitchenActionButton;
import com.floreantpos.ui.kitchendisplay.KitchenDisplayConfigDialog;
import com.floreantpos.ui.kitchendisplay.KitchenDisplayView;
import com.floreantpos.ui.kitchendisplay.KitchenFilterDialog;
import com.floreantpos.ui.kitchendisplay.KitchenTicketActionListener;
import com.floreantpos.ui.kitchendisplay.KitchenTicketView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import jiconfont.IconCode;
import jiconfont.icons.FontAwesome;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;

public class KitchenTicketListPanel
extends JPanel
implements ActionListener,
KitchenTicketActionListener {
    private static final int HORIZONTAL_GAP = 0;
    private static final int VERTICAL_GAP = 0;
    private PaginatedListModel dataModel = new PaginatedListModel();
    private JPanel selectionTicketViewsPanel;
    private TitledBorder border;
    private KitchenActionButton btnLogout;
    private KitchenActionButton btnFilter;
    private KitchenActionButton btnKitchenDispatch;
    private KitchenActionButton btnBack;
    private KitchenActionButton btnNext;
    private KitchenActionButton btnPrev;
    private KitchenActionButton btnBumpAll;
    private int wrapCount = 4;
    private List<Printer> selectedPrinter;
    private List<OrderType> selectedTicketType;
    private PosBlinkButton btnRefresh;
    private KitchenActionButton btnUndo;
    private Stack<KitchenTicket> stack = new Stack();
    private Timer viewUpdateTimer;
    private Date lastUpdateTime;
    private static final Color defaultButtonBg = Color.white;
    private static final Color defaultButtonTextColor = Color.black;
    private KitchenActionButton btnOption;

    public KitchenTicketListPanel() {
        this.border = new TitledBorder("");
        this.border.setTitleJustification(2);
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(new CompoundBorder(this.border, new EmptyBorder(0, 0, 0, 0)));
        this.selectionTicketViewsPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.selectionTicketViewsPanel.setOpaque(false);
        this.add(this.selectionTicketViewsPanel);
        Dimension size = PosUIManager.getSize(90, 40);
        Color undoBtnColor = Color.white;
        Color optionBtnColor = Color.white;
        Color filterBtnColor = Color.white;
        this.btnLogout = new KitchenActionButton("", defaultButtonBg, defaultButtonTextColor);
        this.btnBack = new KitchenActionButton(POSConstants.CLOSE.toUpperCase(), defaultButtonBg, defaultButtonTextColor);
        this.btnKitchenDispatch = new KitchenActionButton(Messages.getString("KitchenTicketListPanel.2").toUpperCase(), defaultButtonBg, defaultButtonTextColor);
        this.btnFilter = new KitchenActionButton(POSConstants.FILTER.toUpperCase(), filterBtnColor);
        this.btnOption = new KitchenActionButton(Messages.getString("OPTION").toUpperCase(), optionBtnColor);
        this.btnUndo = new KitchenActionButton(Messages.getString("KitchenTicketListPanel.1").toUpperCase(), undoBtnColor);
        this.btnPrev = new KitchenActionButton(POSConstants.CAPITAL_PREV, defaultButtonBg, defaultButtonTextColor);
        this.btnNext = new KitchenActionButton(POSConstants.CAPITAL_NEXT, defaultButtonBg, defaultButtonTextColor);
        this.btnBumpAll = new KitchenActionButton(Messages.getString("BUMP_ALL"), defaultButtonBg, defaultButtonTextColor);
        this.btnRefresh = new PosBlinkButton(){

            @Override
            public Color getBackground() {
                if (KitchenTicketListPanel.this.btnRefresh == null) {
                    return Color.white;
                }
                return super.getBackground();
            }

            @Override
            public Color getForeground() {
                if (KitchenTicketListPanel.this.btnRefresh == null || !KitchenTicketListPanel.this.btnRefresh.isBlinking()) {
                    return Color.black;
                }
                return Color.white;
            }
        };
        this.btnRefresh.setFont(this.btnRefresh.getFont().deriveFont(1));
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KitchenTicketListPanel.this.close();
            }
        });
        this.btnKitchenDispatch.setBtnToogle(true);
        this.btnKitchenDispatch.setCellButton(false);
        this.btnKitchenDispatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KitchenTicketListPanel.this.btnKitchenDispatch.setSelected(!KitchenTicketListPanel.this.btnKitchenDispatch.isSelected());
                KitchenTicketListPanel.this.getDataModel().setCurrentRowIndex(0);
                if (KitchenTicketListPanel.this.btnKitchenDispatch.isSelected()) {
                    KitchenTicketListPanel.this.btnBumpAll.setText(Messages.getString("DISPATCH_ALL"));
                } else {
                    KitchenTicketListPanel.this.btnBumpAll.setText(Messages.getString("BUMP_ALL"));
                }
                KitchenTicketListPanel.this.updateKDSView();
            }
        });
        this.btnOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KitchenDisplayConfigDialog dialog = new KitchenDisplayConfigDialog();
                dialog.pack();
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
                KitchenTicketListPanel.this.dataModel.setCurrentRowIndex(0);
                KitchenTicketListPanel.this.updateKDSView();
                KitchenDisplayView.getInstance().updateView();
            }
        });
        this.btnBumpAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KitchenTicketListPanel.this.bumpOrDispatchAll();
            }
        });
        this.btnLogout.setAction(new LogoutAction(true, false));
        this.btnLogout.setText(POSConstants.LOGOUT.toUpperCase());
        this.btnUndo.setEnabled(false);
        this.btnUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KitchenTicketListPanel.this.unbump();
            }
        });
        this.btnRefresh.setText(POSConstants.REFRESH.toUpperCase());
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KitchenTicketListPanel.this.dataModel.setCurrentRowIndex(0);
                KitchenTicketListPanel.this.updateKDSView();
            }
        });
        this.btnRefresh.setBorder(null);
        this.btnRefresh.setOpaque(true);
        ScrollAction action = new ScrollAction();
        this.btnPrev.addActionListener(action);
        this.btnNext.addActionListener(action);
        this.btnNext.setEnabled(false);
        this.btnPrev.setEnabled(false);
        this.btnFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KitchenTicketListPanel.this.doFilter();
            }
        });
        int iconSize = PosUIManager.getSize(16);
        this.btnPrev.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.BACKWARD, (float)iconSize));
        this.btnNext.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.FORWARD, (float)iconSize));
        this.btnNext.setHorizontalTextPosition(2);
        this.btnRefresh.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.REFRESH, (float)iconSize));
        this.btnFilter.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.FILTER, (float)iconSize));
        this.btnUndo.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.UNDO, (float)iconSize));
        this.btnBack.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.WINDOW_CLOSE, (float)iconSize));
        this.btnLogout.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.ARROW_CIRCLE_O_LEFT, (float)iconSize));
        JPanel optionPanel = new JPanel((LayoutManager)new MigLayout("ins 0,hidemode 3", "[]2px[]", ""));
        optionPanel.setOpaque(false);
        String constraints = "w " + (size.width + 7) + "!, growy,gap 1";
        optionPanel.add((Component)this.btnLogout, constraints);
        optionPanel.add((Component)this.btnBack, constraints);
        JPanel actionButtonPanel = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3, ins 0 2 3 2", "[][grow][]", "[]"));
        JSeparator sep = new JSeparator();
        sep.setBackground(Color.white);
        sep.setForeground(Color.white);
        sep.setPreferredSize(PosUIManager.getSize(0, 5));
        actionButtonPanel.add((Component)sep, "growx,span");
        actionButtonPanel.add((Component)optionPanel, "growy");
        actionButtonPanel.add((Component)this.btnBumpAll, "split 6,center," + constraints);
        actionButtonPanel.add((Component)this.btnKitchenDispatch, constraints);
        actionButtonPanel.add((Component)this.btnFilter, constraints);
        actionButtonPanel.add((Component)this.btnOption, constraints);
        actionButtonPanel.add((Component)this.btnUndo, constraints);
        actionButtonPanel.add((Component)this.btnRefresh, String.valueOf(constraints));
        actionButtonPanel.add((Component)this.btnPrev, "split 3,right," + constraints);
        actionButtonPanel.add((Component)this.btnNext, String.valueOf(constraints) + ",gapleft 1");
        this.add((Component)actionButtonPanel, "South");
        actionButtonPanel.setBackground(Color.black);
        this.viewUpdateTimer = new Timer(5000, this);
        this.viewUpdateTimer.setRepeats(true);
    }

    public void setBackButtonVisible(boolean b) {
        this.btnBack.setVisible(b);
        this.btnLogout.setVisible(!b);
    }

    private void doFilter() {
        KitchenFilterDialog dialog = new KitchenFilterDialog();
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        this.selectedPrinter = dialog.getPrinter();
        this.selectedTicketType = dialog.getOrderType();
        this.getDataModel().setCurrentRowIndex(0);
        this.updateKDSView();
    }

    public void updateKDSView() {
        this.stopTimer();
        this.reset();
        try {
            try {
                Terminal terminal = Application.getInstance().getTerminal();
                int pageSize = TerminalConfig.getKDSTicketsPerPage();
                this.wrapCount = (int)Math.round((double)pageSize / 2.0);
                this.dataModel.setPageSize(pageSize);
                KitchenTicketDAO.getInstance().loadItems(terminal, this.selectedPrinter, this.selectedTicketType, this.btnKitchenDispatch.isSelected(), this.dataModel);
                this.btnRefresh.setBlinking(false);
                Date dbLastUpdateTime = KitchenTicketDAO.getInstance().getLastUpdateDate();
                if (dbLastUpdateTime != null) {
                    this.lastUpdateTime = new Date(dbLastUpdateTime.getTime());
                }
                this.setDataModel(this.dataModel);
                this.stack.clear();
                this.refreshUndoRedo();
            }
            catch (Exception e) {
                POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
                this.restartTimer();
            }
        }
        finally {
            this.restartTimer();
        }
    }

    protected void setDataModel(PaginatedListModel listModel) {
        this.dataModel = listModel;
        this.renderItems();
    }

    protected void updateButton() {
        boolean hasNext = this.dataModel.hasNext();
        boolean hasPrevious = this.dataModel.hasPrevious();
        this.btnNext.setVisible(hasNext || hasPrevious);
        this.btnPrev.setVisible(hasNext || hasPrevious);
        this.btnPrev.setEnabled(hasPrevious);
        this.btnNext.setEnabled(hasNext);
    }

    public PaginatedListModel getDataModel() {
        return this.dataModel;
    }

    public void reset() {
        Component[] components;
        Component[] componentArray = components = this.selectionTicketViewsPanel.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof KitchenTicketView) {
                KitchenTicketView kitchenTicketView = (KitchenTicketView)component;
                kitchenTicketView.stopTimer();
            }
            ++n2;
        }
        this.selectionTicketViewsPanel.removeAll();
        this.selectionTicketViewsPanel.repaint();
        this.btnNext.setEnabled(false);
        this.btnPrev.setEnabled(false);
    }

    protected void renderItems() {
        try {
            this.reset();
            if (this.dataModel == null || this.dataModel.getSize() == 0) {
                this.btnNext.setEnabled(this.dataModel.hasNext());
                this.btnPrev.setEnabled(this.dataModel.hasPrevious());
                return;
            }
            int numOfTickets = TerminalConfig.getKDSTicketsPerPage();
            if (numOfTickets <= 5) {
                this.selectionTicketViewsPanel.setLayout(new GridLayout(1, numOfTickets, 5, 5));
            } else {
                int colCount = (int)Math.ceil((double)numOfTickets / 2.0);
                this.selectionTicketViewsPanel.setLayout(new GridLayout(2, colCount, 5, 5));
            }
            this.selectionTicketViewsPanel.setOpaque(false);
            int i = 0;
            while (i < numOfTickets) {
                if (i >= this.dataModel.getSize()) {
                    TransparentPanel transparentPanel = new TransparentPanel();
                    this.selectionTicketViewsPanel.add(transparentPanel);
                } else {
                    Object item = this.dataModel.getElementAt(i);
                    JPanel itemPanel = this.createKitchenTicket(item, i);
                    if (itemPanel != null) {
                        this.selectionTicketViewsPanel.add(itemPanel);
                    }
                }
                ++i;
            }
            this.btnNext.setEnabled(this.dataModel.hasNext());
            this.btnPrev.setEnabled(this.dataModel.hasPrevious());
            this.refreshUndoRedo();
            this.revalidate();
            this.repaint();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    protected void scrollDown() {
        if (!this.dataModel.hasNext()) {
            return;
        }
        this.stack.clear();
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        this.updateKDSView();
    }

    protected void scrollUp() {
        if (!this.dataModel.hasPrevious()) {
            return;
        }
        this.stack.clear();
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        this.updateKDSView();
    }

    protected JPanel createKitchenTicket(Object item, int index) {
        KitchenTicket kitchenTicket = (KitchenTicket)item;
        kitchenTicket.setSortOrder(index);
        if (kitchenTicket.getId() == null) {
            JPanel panel = new JPanel();
            panel.setOpaque(false);
            return panel;
        }
        KitchenTicketView kitchenTicketView = new KitchenTicketView(kitchenTicket, this);
        kitchenTicketView.putClientProperty("key", index + 1);
        return kitchenTicketView;
    }

    public void setSelectedKey(int key) {
        if (PosGuiUtil.isModalDialogShowing()) {
            return;
        }
        if (key == 10) {
            this.updateKDSView();
            return;
        }
        if (key == 81) {
            Application.getInstance().doLogout();
            return;
        }
        if (key == 85 && !this.btnKitchenDispatch.isSelected()) {
            this.unbump();
            return;
        }
        Component[] components = this.selectionTicketViewsPanel.getComponents();
        if (components.length == 0) {
            return;
        }
        if (key == 78) {
            this.scrollDown();
            return;
        }
        if (key == 80) {
            this.scrollUp();
            return;
        }
        int previousSelectedIndex = 0;
        int selectedIndex = 0;
        int count = 0;
        boolean active = false;
        boolean numberSelected = false;
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof KitchenTicketView) {
                boolean selected;
                KitchenTicketView kitchenTicketView = (KitchenTicketView)component;
                if (kitchenTicketView.isKeySelected() && (key == 66 || key == 32)) {
                    kitchenTicketView.fireBumpSelected();
                    return;
                }
                if (key != 37 && key != 39 && key != 40 && key != 38 && (selected = kitchenTicketView.keySelected(key))) {
                    numberSelected = true;
                }
                if (kitchenTicketView.isKeySelected()) {
                    active = true;
                    selectedIndex = count;
                    previousSelectedIndex = count;
                }
            }
            ++count;
            ++n2;
        }
        if (numberSelected) {
            return;
        }
        boolean scrollSelected = true;
        if (active && key != 32) {
            switch (key) {
                case 39: {
                    if (++selectedIndex < this.wrapCount * 2) break;
                    selectedIndex = 0;
                    break;
                }
                case 37: {
                    if (--selectedIndex >= 0) break;
                    return;
                }
                case 40: {
                    if ((selectedIndex += this.wrapCount) < this.wrapCount * 2) break;
                    return;
                }
                case 38: {
                    if ((selectedIndex -= this.wrapCount) < this.wrapCount * 2) break;
                    return;
                }
                default: {
                    scrollSelected = false;
                }
            }
        }
        if (scrollSelected) {
            if (selectedIndex < 0 || components.length < selectedIndex + 1) {
                return;
            }
            Component component = components[selectedIndex];
            if (component == null || !(component instanceof KitchenTicketView)) {
                return;
            }
            KitchenTicketView kitchenTicketView = (KitchenTicketView)component;
            kitchenTicketView.setSelected(true);
            if (selectedIndex != previousSelectedIndex) {
                KitchenTicketView previousTicketView = (KitchenTicketView)components[previousSelectedIndex];
                if (previousTicketView == null) {
                    return;
                }
                previousTicketView.setSelected(false);
            }
        }
    }

    public PaginatedListModel getModel() {
        return this.dataModel;
    }

    public void refreshUndoRedo() {
        this.btnUndo.setEnabled(!this.stack.isEmpty());
    }

    @Override
    public boolean isDispatchMode() {
        if (this.btnKitchenDispatch != null) {
            return this.btnKitchenDispatch.isSelected();
        }
        return false;
    }

    @Override
    public void dispatch(KitchenTicketView view) {
        KitchenTicket kitchenTicket = view.getTicket();
        KitchenTicketDAO.getInstance().bumpOrUnbump(kitchenTicket, KitchenStatus.DISPATCHED, KitchenStatus.DISPATCHED, false);
        KitchenTicketDAO.getInstance().delete(kitchenTicket);
        this.updateKDSView();
    }

    @Override
    public void bump(KitchenTicketView view) {
        try {
            KitchenTicket kitchenTicket = view.getTicket();
            KitchenTicketDAO.getInstance().bumpOrUnbump(kitchenTicket, KitchenStatus.BUMP, KitchenStatus.BUMP, true);
            this.lastUpdateTime = kitchenTicket.getLastUpdateTime();
            this.stack.push(kitchenTicket);
            this.dataModel.getDataList().set(kitchenTicket.getSortOrder(), new KitchenTicket());
            this.renderItems();
            this.refreshUndoRedo();
        }
        catch (StaleStateException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("KitchenTicketListPanel.0"), e);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    public void bumpAll() {
        try {
            List<KitchenTicket> findAllOpen = KitchenTicketDAO.getInstance().findAllOpen();
            if (findAllOpen.isEmpty()) {
                POSMessageDialog.showError(this, "No data to bump");
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Do you want to bump all tickets?", "Confirm");
            if (option != 0) {
                return;
            }
            for (KitchenTicket kitchenTicket : findAllOpen) {
                KitchenTicketDAO.getInstance().bumpOrUnbump(kitchenTicket, KitchenStatus.BUMP, KitchenStatus.BUMP, true);
            }
            this.dataModel.getDataList().clear();
            this.lastUpdateTime = new Date();
            this.renderItems();
            this.refreshUndoRedo();
            this.dataModel.getDataList().clear();
            this.lastUpdateTime = new Date();
            this.renderItems();
            this.refreshUndoRedo();
        }
        catch (StaleStateException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("KitchenTicketListPanel.0"), e);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void bumpOrDispatchAll() {
        try {
            if (this.btnKitchenDispatch.isSelected()) {
                int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Do you want to dispatch all tickets?", "Confirm");
                if (option != 0) {
                    return;
                }
                KitchenTicketDAO.getInstance().dispatchAll();
                this.updateKDSView();
            } else {
                this.bumpAll();
                this.updateKDSView();
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    public void unbump() {
        if (this.stack.isEmpty()) {
            return;
        }
        KitchenTicket kitchenTicket = this.stack.pop();
        try {
            KitchenTicketDAO.getInstance().bumpOrUnbump(kitchenTicket, KitchenStatus.WAITING, KitchenStatus.WAITING, false);
            this.lastUpdateTime = kitchenTicket.getLastUpdateTime();
            this.dataModel.getDataList().set(kitchenTicket.getSortOrder(), kitchenTicket);
            this.renderItems();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    public boolean isBlinkingRefreshButton() {
        return this.btnRefresh.isBlinking();
    }

    public void setBlinkingRefreshButton(boolean b) {
        this.btnRefresh.setBlinking(b);
        Window windowAncestor = SwingUtilities.getWindowAncestor(this);
        windowAncestor.toFront();
    }

    private void close() {
        Window window = this.getWindow();
        if (window == null) {
            RootView.getInstance().showDefaultView();
        } else {
            window.dispose();
        }
    }

    private Window getWindow() {
        Window windowAncestor = SwingUtilities.getWindowAncestor(this);
        if (windowAncestor instanceof JFrame) {
            return windowAncestor;
        }
        return null;
    }

    public void startTimer() {
        if (!this.viewUpdateTimer.isRunning()) {
            this.viewUpdateTimer.start();
        }
    }

    public void stopTimer() {
        if (this.viewUpdateTimer.isRunning()) {
            this.viewUpdateTimer.stop();
        }
    }

    public void restartTimer() {
        this.viewUpdateTimer.restart();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (PosGuiUtil.isModalDialogShowing()) {
                return;
            }
            this.viewUpdateTimer.stop();
            this.selectionTicketViewsPanel.repaint();
            if (this.isBlinkingRefreshButton()) {
                return;
            }
            Date dbLastUpdatedTime = KitchenTicketDAO.getInstance().getLastUpdateDate();
            if (dbLastUpdatedTime == null) {
                return;
            }
            if (this.lastUpdateTime != null && new Date(dbLastUpdatedTime.getTime()).after(this.lastUpdateTime)) {
                this.setBlinkingRefreshButton(true);
            }
        }
        finally {
            this.viewUpdateTimer.restart();
        }
    }

    private class ScrollAction
    implements ActionListener {
        private ScrollAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Object source = e.getSource();
                if (source == KitchenTicketListPanel.this.btnPrev) {
                    KitchenTicketListPanel.this.scrollUp();
                } else if (source == KitchenTicketListPanel.this.btnNext) {
                    KitchenTicketListPanel.this.scrollDown();
                }
            }
            catch (Exception e2) {
                POSMessageDialog.showError(Application.getPosWindow(), e2.getMessage(), e2);
            }
        }
    }
}

