/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.kitchendisplay;

import com.floreantpos.Messages;
import com.floreantpos.main.Application;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.dao.KitchenTicketItemDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class KitchenTicketStatusSelector
extends POSDialog
implements ActionListener {
    private PosButton btnVoid = new PosButton(KitchenStatus.VOID.name());
    private PosButton btnReady = new PosButton(Messages.getString("KitchenTicketView.11"));
    private KitchenTicket kitchenTicket;
    private KitchenTicketItem ticketItem;

    public KitchenTicketStatusSelector(Frame parent) {
        super(parent, true);
        this.initComponent();
    }

    public KitchenTicketStatusSelector(Frame parent, KitchenTicket kitchenTicket) {
        super(parent, true);
        this.kitchenTicket = kitchenTicket;
        this.initComponent();
    }

    private void initComponent() {
        this.setTitle(Messages.getString("KitchenTicketStatusSelector.0"));
        this.setIconImage(Application.getApplicationIcon().getImage());
        this.setDefaultCloseOperation(2);
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("KitchenTicketStatusSelector.1"));
        this.add((Component)titlePanel, "North");
        JPanel panel = new JPanel(new GridLayout(1, 0, 10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add(this.btnReady);
        this.add(panel);
        this.btnVoid.setActionCommand(KitchenStatus.BUMP.name());
        this.btnReady.setActionCommand(KitchenStatus.BUMP.name());
        this.btnVoid.addActionListener(this);
        this.btnReady.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            KitchenTicketItemDAO.getInstance().bumpTicketItem(this.ticketItem);
            this.dispose();
        }
        catch (Exception e2) {
            POSMessageDialog.showError(this, e2.getMessage(), e2);
        }
    }

    public KitchenTicketItem getTicketItem() {
        return this.ticketItem;
    }

    public void setTicketItem(KitchenTicketItem ticketItem) {
        this.ticketItem = ticketItem;
    }
}

