/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.dao.AttributeDAO;
import com.floreantpos.model.dao.AttributeGroupDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class AttributeEntryForm
extends BeanEditor<Attribute> {
    private FixedLengthTextField tfName = new FixedLengthTextField(30);
    private IntegerTextField tfFactor = new IntegerTextField(10);
    private JComboBox<AttributeGroup> cbGroups = new JComboBox();
    private List<AttributeGroup> groups;
    private JButton btnAddNew;
    private JCheckBox chkDefaultAttribute;

    public AttributeEntryForm() {
        this(new Attribute());
    }

    public AttributeEntryForm(Attribute unit) {
        this.createUI();
        this.groups = AttributeGroupDAO.getInstance().findAll();
        if (this.groups != null) {
            this.cbGroups.setModel(new ComboBoxModel(this.groups));
        }
        this.setBean(unit);
    }

    private void createUI() {
        this.setLayout((LayoutManager)new MigLayout("fillx"));
        this.add(new JLabel("Name"));
        this.add((Component)this.tfName, "grow, wrap");
        this.add(new JLabel("Sort Order"));
        this.add((Component)this.tfFactor, "wrap,grow");
        this.add(new JLabel("Attribute Group"));
        this.add(this.cbGroups, "split 2,grow");
        this.btnAddNew = new JButton("New");
        this.btnAddNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String groupName = JOptionPane.showInputDialog(POSUtil.getFocusedWindow(), (Object)"Enter group name");
                if (groupName == null) {
                    return;
                }
                if (groupName.equals("")) {
                    BOMessageDialog.showError(POSUtil.getFocusedWindow(), "Group name cannot be empty.");
                    return;
                }
                if (groupName.length() > 30) {
                    BOMessageDialog.showError(POSUtil.getFocusedWindow(), "Group name too long.");
                    return;
                }
                for (AttributeGroup group : AttributeEntryForm.this.groups) {
                    if (!group.getName().equals(groupName)) continue;
                    BOMessageDialog.showError(POSUtil.getFocusedWindow(), "Group name already exists.");
                    return;
                }
                AttributeGroup group = new AttributeGroup();
                group.setName(groupName);
                AttributeGroupDAO.getInstance().saveOrUpdate(group);
                AttributeEntryForm.this.groups.add(group);
                AttributeEntryForm.this.cbGroups.setModel(new ComboBoxModel(AttributeEntryForm.this.groups));
                AttributeEntryForm.this.cbGroups.setSelectedItem(group);
            }
        });
        this.add((Component)this.btnAddNew, "wrap");
        this.chkDefaultAttribute = new JCheckBox("Default");
        this.add((Component)this.chkDefaultAttribute, "skip 1,wrap");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Attribute selectedUnit = (Attribute)this.getBean();
            boolean baseUnit = selectedUnit.isDefaultAttribute();
            AttributeGroup unitGroup = selectedUnit.getGroup();
            if (baseUnit) {
                if (unitGroup.getAttributes() != null) {
                    for (Attribute unit : unitGroup.getAttributes()) {
                        unit.setDefaultAttribute(false);
                    }
                }
                selectedUnit.setDefaultAttribute(true);
            }
            ArrayList<Attribute> newAttributes = new ArrayList<Attribute>();
            List<Attribute> units = unitGroup.getAttributes();
            if (units != null) {
                if (units.contains(selectedUnit)) {
                    for (Attribute attribute : units) {
                        if (attribute.getId().equals(selectedUnit.getId())) {
                            attribute = selectedUnit;
                        }
                        newAttributes.add(attribute);
                    }
                    unitGroup.setAttributes(newAttributes);
                } else {
                    unitGroup.addToattributes(selectedUnit);
                }
            } else {
                unitGroup.addToattributes(selectedUnit);
            }
            AttributeGroupDAO.getInstance().saveOrUpdate(unitGroup);
            return true;
        }
        catch (IllegalModelStateException e) {
            POSMessageDialog.showError(this, e.getMessage());
            return false;
        }
    }

    @Override
    public void createNew() {
        this.setBean(new Attribute());
        this.clearFields();
    }

    @Override
    public void setFieldsEnable(boolean enable) {
        this.tfName.setEnabled(enable);
        this.tfFactor.setEnabled(enable);
        this.cbGroups.setEnabled(enable);
        this.btnAddNew.setEnabled(enable);
        this.chkDefaultAttribute.setEnabled(enable);
    }

    @Override
    public void clearFields() {
        this.tfName.setText("");
        this.tfFactor.setText("");
    }

    @Override
    protected void updateView() {
        Attribute attribute = (Attribute)this.getBean();
        if (attribute == null) {
            return;
        }
        this.tfName.setText(attribute.getName());
        this.tfFactor.setText(attribute.getSortOrder() + "");
        this.cbGroups.setSelectedItem(attribute.getGroup());
        this.chkDefaultAttribute.setSelected(attribute.isDefaultAttribute());
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        Attribute attribute = (Attribute)this.getBean();
        String name = this.tfName.getText();
        Integer conversionRate = this.tfFactor.getInteger();
        AttributeGroup group = (AttributeGroup)this.cbGroups.getSelectedItem();
        if (AttributeDAO.getInstance().nameExists(attribute, name)) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), "An attribute with that name already exists");
            return false;
        }
        if (StringUtils.isEmpty((String)name)) {
            POSMessageDialog.showError(this, "Please enter attribute name!");
            return false;
        }
        if (group == null) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), "Please select a group");
            return false;
        }
        attribute.setName(name);
        attribute.setSortOrder(conversionRate);
        attribute.setGroup(group);
        attribute.setDefaultAttribute(this.chkDefaultAttribute.isSelected());
        return true;
    }

    @Override
    public boolean delete() {
        try {
            Attribute attribute = (Attribute)this.getBean();
            if (attribute == null) {
                return false;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), "Are you sure to delete selected item ?", "Confirm");
            if (option != 0) {
                return false;
            }
            AttributeDAO.getInstance().delete(attribute);
            this.clearFields();
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e.getMessage(), e);
            return false;
        }
    }

    @Override
    public String getDisplayText() {
        return "Add/Edit Attribute";
    }
}

