/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Course;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.dao.CourseDAO;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class CourseForm
extends BeanEditor {
    private FixedLengthTextField tfName;
    private FixedLengthTextField tfShortName;
    private IntegerTextField tfSortOrder;
    private JLabel lblImagePreview;
    private ImageResource imageResource;
    private List<Course> existingCourses;

    public CourseForm() {
        this(new Course());
    }

    public CourseForm(Course course) {
        this.initComponents();
        this.setBean(course);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 3,wrap 2", "[134px][204px,grow]", ""));
        this.tfSortOrder = new IntegerTextField();
        this.tfName = new FixedLengthTextField();
        this.tfName.setLength(128);
        this.tfShortName = new FixedLengthTextField();
        this.tfShortName.setLength(3);
        this.lblImagePreview = new JLabel("");
        this.lblImagePreview.setText("Icon");
        this.lblImagePreview.setForeground(Color.gray);
        this.add((Component)new JLabel("Name"), "alignx trailing,aligny center");
        this.add((Component)this.tfName, "growx,aligny center");
        this.add((Component)new JLabel("Short Name"), "alignx trailing,aligny center");
        this.add((Component)this.tfShortName, "growx,aligny center");
        this.add((Component)new JLabel("Sort Order"), "alignx trailing,aligny center");
        this.add((Component)this.tfSortOrder, "w 100!,aligny center");
        JPanel imagePanel = new JPanel((LayoutManager)new MigLayout("center", "", ""));
        JPanel imgPreviewPanel = new JPanel((LayoutManager)new MigLayout("center"));
        this.lblImagePreview.setHorizontalAlignment(0);
        imgPreviewPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, "", 2, 2), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        imgPreviewPanel.setPreferredSize(new Dimension(70, 50));
        imgPreviewPanel.add((Component)this.lblImagePreview, "w 24!,h 24!,aligny center");
        this.add((Component)imagePanel, "skip 1");
    }

    @Override
    public String getDisplayText() {
        if (((Course)this.getBean()).getId() == null) {
            return "New Course";
        }
        return "Edit Course";
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Course course = (Course)this.getBean();
            CourseDAO courseDAO = CourseDAO.getInstance();
            courseDAO.saveOrUpdate(course);
        }
        catch (PosException x) {
            POSMessageDialog.showError(this, x.getMessage(), x);
            PosLog.error(this.getClass(), x);
            return false;
        }
        catch (Exception x) {
            POSMessageDialog.showError(this, "Error", x);
            PosLog.error(this.getClass(), x);
            return false;
        }
        return true;
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        String courseName = this.tfName.getText();
        String shortName = this.tfShortName.getText();
        int sortOrder = this.tfSortOrder.getInteger();
        if (StringUtils.isEmpty((String)courseName)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please enter course name.");
            return false;
        }
        if (StringUtils.isEmpty((String)shortName)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please enter short name.");
            return false;
        }
        if (sortOrder <= 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please enter sort order.");
            return false;
        }
        if (this.existingCourses != null) {
            for (Course course : this.existingCourses) {
                if (course.getSortOrder() != sortOrder) continue;
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Duplicate sort order cannot be allowed.");
                return false;
            }
        }
        Course course = (Course)this.getBean();
        course.setName(courseName);
        course.setShortName(shortName);
        course.setSortOrder(sortOrder);
        return true;
    }

    @Override
    protected void updateView() {
        if (!(this.getBean() instanceof Course)) {
            return;
        }
        Course course = (Course)this.getBean();
        this.setData(course);
    }

    private void setData(Course course) {
        this.tfSortOrder.setText(String.valueOf(course.getSortOrder()));
        this.tfName.setText(course.getName());
        this.tfShortName.setText(course.getShortName());
        this.imageResource = ImageResourceDAO.getInstance().findById(course.getIconId());
        if (this.imageResource != null) {
            this.lblImagePreview.setIcon(this.imageResource.getScaledImage(16, 16));
            this.lblImagePreview.setText("");
        } else {
            this.lblImagePreview.setText("Icon");
        }
    }

    protected void doSelectImageFile() {
        ImageGalleryDialog dialog = ImageGalleryDialog.getInstance();
        dialog.setSelectBtnVisible(true);
        dialog.setTitle("Image Gallery");
        dialog.setSize(PosUIManager.getSize(650, 600));
        dialog.setResizable(false);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        this.imageResource = dialog.getImageResource();
        if (this.imageResource != null) {
            this.lblImagePreview.setIcon(this.imageResource.getScaledImage(16, 16));
            this.lblImagePreview.setText("");
        } else {
            this.lblImagePreview.setText("Icon");
        }
    }

    protected void doClearImage() {
        this.lblImagePreview.setIcon(null);
        this.imageResource = null;
    }

    public List<Course> getExistingCourses() {
        return this.existingCourses;
    }

    public void setExistingCourses(List<Course> courses) {
        this.existingCourses = new ArrayList<Course>();
        Course course = (Course)this.getBean();
        int nextSortOrder = 1;
        for (Course c : courses) {
            if (course.getId() != null && c.getId().equals(course.getId())) continue;
            if (c.getSortOrder() > nextSortOrder) {
                nextSortOrder = c.getSortOrder();
            }
            this.existingCourses.add(c);
        }
        if (this.tfSortOrder.getInteger() == 0) {
            this.tfSortOrder.setText(String.valueOf(nextSortOrder + 1));
        }
    }
}

