/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.explorer.ComboItemExplorer;
import com.floreantpos.bo.ui.explorer.MenuItemVariantExplorer;
import com.floreantpos.bo.ui.modifierdesigner.ModifierPageDesigner;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.InventoryPlugin;
import com.floreantpos.model.Course;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuItemShift;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.CourseDAO;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.InventoryVendorItemsDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.model.dao.ReportGroupDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthDocument;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IUpdatebleView;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.menuitem.ButtonStylePanel;
import com.floreantpos.ui.menuitem.InventoryPanel;
import com.floreantpos.ui.model.MenuGroupForm;
import com.floreantpos.ui.model.MenuItemModifierSpecForm;
import com.floreantpos.ui.model.ReportGroupForm;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import com.floreantpos.util.ShiftUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.hibernate.Hibernate;
import org.hibernate.Session;

public class MenuItemForm
extends BeanEditor<MenuItem>
implements ActionListener,
ChangeListener {
    private MenuItem menuItem;
    private JButton btnDeleteModifierGroup = new JButton();
    private JButton btnEditModifierGroup = new JButton();
    private JButton btnNewModifierGroup = new JButton();
    private JComboBox cbReportGroup = new JComboBox();
    private JComboBox cbTaxGroup = new JComboBox();
    private JCheckBox chkVisible = new JCheckBox();
    private JLabel lfname = new JLabel();
    private JLabel lblPrice = new JLabel();
    private JLabel lTax = new JLabel();
    private JPanel tabGeneral = new JPanel();
    private JPanel tabModifier = new JPanel();
    private JScrollPane modifiertabScrollpane = new JScrollPane();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JTable modifierSpecTable = new JTable();
    private DoubleTextField tfDiscountRate = new DoubleTextField(18);
    private FixedLengthTextField tfName = new FixedLengthTextField(20, 255);
    private FixedLengthTextField tfTranslatedName = new FixedLengthTextField(20, 255);
    private DoubleTextField tfPrice = new DoubleTextField(10);
    private DoubleTextField tfCost = new DoubleTextField(10);
    private JTextArea tfDescription = new JTextArea(new FixedLengthDocument(512));
    private List<MenuItemModifierSpec> menuItemModifierSpecList;
    private MenuItemMGListModel menuItemMGListModel = new MenuItemMGListModel();
    private JLabel lblKitchenPrinter = new JLabel(Messages.getString("MenuItemForm.27"));
    private JComboBox<PrinterGroup> cbPrinterGroup = new JComboBox();
    private JLabel lblBarcode = new JLabel(Messages.getString("MenuItemForm.lblBarcode.text"));
    private FixedLengthTextField tfBarcode = new FixedLengthTextField(25, 128);
    private JLabel lblUnitName = new JLabel(Messages.getString("MenuItemForm.23"));
    private JLabel lblTranslatedName = new JLabel(Messages.getString("MenuItemForm.lblTranslatedName.text"));
    private FixedLengthTextField tfUnitName = new FixedLengthTextField(10, 20);
    private JCheckBox cbFractionalUnit = new JCheckBox(Messages.getString("MenuItemForm.24"));
    private DoubleTextField tfStockCount = new DoubleTextField(1);
    private JCheckBox cbRawMaterial = new JCheckBox(Messages.getString("MenuItemForm.31"));
    private JCheckBox cbIsInventory = new JCheckBox(Messages.getString("MenuItemForm.44"));
    private JLabel lblReportGroup = new JLabel();
    private JButton btnNewReportGroup = new JButton();
    private JButton btnNewMenuGroup = new JButton("+");
    private boolean inventoryItemMode = false;
    private ModifierPageDesigner modifierDesigner;
    private JCheckBox chkComboItem;
    private JCheckBox chkHasVariant = new JCheckBox("Has variant");
    private MenuItemVariantExplorer variantTab;
    private ComboItemExplorer tabComboItems;
    private JComboBox cbUnits = new JComboBox();
    private JComboBox<MenuGroup> cbMenuGroup = new JComboBox();
    private JComboBox<Course> cbCourse = new JComboBox();
    private JComboBox<Recepie> cbRecipe = new JComboBox();
    private InventoryPanel inventoryPanel;
    private ButtonStylePanel buttonStylePanel;
    private JCheckBox chkPrintToKitchen;
    private JCheckBox chkPrintKitchenSticker;
    private JCheckBox chkEditablePrice;

    public MenuItemForm() throws Exception {
        this(new MenuItem(), false);
    }

    public MenuItemForm(MenuItem menuItem) throws Exception {
        this(menuItem, false);
    }

    public MenuItemForm(MenuItem menuItem, boolean inventoryMode) throws Exception {
        this.menuItem = menuItem;
        this.inventoryItemMode = inventoryMode;
        this.initComponents();
        this.initData();
        this.setBean(menuItem);
    }

    public void initData() {
        MenuGroupDAO foodGroupDAO = new MenuGroupDAO();
        ArrayList<MenuGroup> foodGroups = new ArrayList<MenuGroup>();
        foodGroups.add(null);
        if (foodGroupDAO.findAll() != null) {
            foodGroups.addAll(foodGroupDAO.findAll());
        }
        this.cbMenuGroup.setModel(new ComboBoxModel(foodGroups));
        CourseDAO courseDAO = new CourseDAO();
        ArrayList<Course> courses = new ArrayList<Course>();
        courses.add(null);
        List<Course> courseList = courseDAO.findAll();
        if (courseList != null && courseList.size() > 0) {
            courses.addAll(courseList);
        }
        ComboBoxModel aModel = new ComboBoxModel(courses);
        this.cbCourse.setModel(aModel);
        this.cbCourse.setSelectedItem(null);
        PrinterGroupDAO printerDao = new PrinterGroupDAO();
        ArrayList<PrinterGroup> printerList = new ArrayList<PrinterGroup>();
        printerList.add(null);
        List<PrinterGroup> printerGroupList = printerDao.findAll();
        if (printerGroupList != null && printerGroupList.size() > 0) {
            printerList.addAll(printerGroupList);
        }
        ComboBoxModel defaultComboxModel = new ComboBoxModel(printerList);
        this.cbPrinterGroup.setModel(defaultComboxModel);
        this.cbPrinterGroup.setSelectedItem(null);
        ComboBoxModel recipeModel = new ComboBoxModel();
        recipeModel.addElement((Object)null);
        for (Recepie recipe : RecepieDAO.getInstance().findAll()) {
            recipeModel.addElement(recipe);
        }
        this.cbRecipe.setModel(recipeModel);
        this.cbRecipe.setSelectedItem(null);
        List<ReportGroup> reportGroups = ReportGroupDAO.getInstance().findAll();
        ComboBoxModel reportGroupModel = new ComboBoxModel();
        reportGroupModel.addElement((Object)null);
        for (ReportGroup reportGroup : reportGroups) {
            reportGroupModel.addElement(reportGroup);
        }
        this.cbReportGroup.setModel(reportGroupModel);
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        comboBoxModel.addElement((Object)null);
        List<TaxGroup> taxGroups = TaxGroupDAO.getInstance().findAll();
        for (TaxGroup taxGroup : taxGroups) {
            comboBoxModel.addElement(taxGroup);
        }
        this.cbTaxGroup.setModel(comboBoxModel);
        this.menuItemModifierSpecList = this.menuItem.getMenuItemModiferSpecs();
        this.tabComboItems.setMenuItem(this.menuItem);
        this.variantTab.setParentMenuItem(this.menuItem);
    }

    public void addRecepieExtension() {
        InventoryPlugin plugin = (InventoryPlugin)ExtensionManager.getPlugin(InventoryPlugin.class);
        if (plugin == null) {
            return;
        }
        plugin.addRecepieView(this.tabbedPane);
        if (this.cbUnits.isVisible()) {
            plugin.addStockUnitView(this.tabbedPane, this.menuItem);
            this.cbUnits.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MenuItemForm.this.menuItem.setUnit((InventoryUnit)MenuItemForm.this.cbUnits.getSelectedItem());
                }
            });
        }
    }

    private Component getUnitField() {
        InventoryPlugin plugin = (InventoryPlugin)ExtensionManager.getPlugin(InventoryPlugin.class);
        if (plugin == null) {
            this.cbUnits.setVisible(false);
            return this.tfUnitName;
        }
        this.lblUnitName.setText("Unit");
        ComboBoxModel model = new ComboBoxModel();
        model.addElement((Object)null);
        for (InventoryUnit inventoryUnit : InventoryUnitDAO.getInstance().findAll()) {
            model.addElement(inventoryUnit);
        }
        this.cbUnits.setModel(model);
        return this.cbUnits;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.initGeneralTab();
        this.initModifierGroupTab();
        this.addRecepieExtension();
        this.initComboTab();
        this.initAttributeTab();
        this.initBtnstyleTab();
        this.initInverntoryTab();
    }

    private void initComboTab() {
        this.tabComboItems = new ComboItemExplorer();
    }

    private void initAttributeTab() {
        this.variantTab = new MenuItemVariantExplorer();
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(200);
        columnWidth.add(50);
        columnWidth.add(50);
        return columnWidth;
    }

    private void btnNewModifierGroupActionPerformed(ActionEvent evt) {
    }

    private void addMenuItemModifierGroup() {
        try {
            MenuItemModifierSpec modifierSpec = new MenuItemModifierSpec();
            MenuItemModifierSpecForm form = new MenuItemModifierSpecForm(modifierSpec, this.menuItem, false);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)form);
            dialog.getButtonPanel().add((Component)form.getAutoBuildButton(), 0);
            dialog.openWithScale(500, 500);
            if (dialog.isCanceled()) {
                return;
            }
            this.menuItemMGListModel.add(form.getBean());
            this.modifierSpecTable.getSelectionModel().setSelectionInterval(this.menuItemMGListModel.getRowCount() - 1, this.menuItemMGListModel.getRowCount() - 1);
            if (form.isAutoBuildSelected()) {
                this.modifierDesigner.doGenenateMenuItemModifierPageItems();
            }
        }
        catch (Exception x) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void editMenuItemModifierGroup() {
        this.editSelectedRow();
    }

    private void editSelectedRow() {
        try {
            int index = this.modifierSpecTable.getSelectedRow();
            if (index < 0) {
                return;
            }
            MenuItemModifierSpec menuItemModifierGroup = this.menuItemMGListModel.get(index);
            MenuItemModifierSpecForm form = new MenuItemModifierSpecForm(menuItemModifierGroup, this.menuItem, true);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)form);
            dialog.openWithScale(500, 500);
            if (!dialog.isCanceled()) {
                this.menuItemMGListModel.fireTableRowsUpdated(index, index);
            }
        }
        catch (Exception x) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void deleteMenuItemModifierGroup() {
        try {
            int index = this.modifierSpecTable.getSelectedRow();
            if (index < 0) {
                return;
            }
            if (ConfirmDeleteDialog.showMessage(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.CONFIRM) == 0) {
                this.menuItemMGListModel.remove(index);
                if (this.menuItemMGListModel.getRowCount() > 0) {
                    this.modifierSpecTable.getSelectionModel().setSelectionInterval(this.menuItemMGListModel.getRowCount() - 1, this.menuItemMGListModel.getRowCount() - 1);
                } else {
                    this.modifierDesigner.reset();
                }
            }
        }
        catch (Exception x) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            MenuItem menuItem = (MenuItem)this.getBean();
            MenuItemDAO.getInstance().saveOrUpdate(menuItem);
            List<InventoryVendorItems> vendorItems = this.inventoryPanel.getVendorItems();
            for (InventoryVendorItems inventoryVendorItems : vendorItems) {
                InventoryVendorItemsDAO.getInstance().saveOrUpdate(inventoryVendorItems);
            }
        }
        catch (Exception e) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, e);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        MenuItem menuItem = (MenuItem)this.getBean();
        if (menuItem.getId() != null && !Hibernate.isInitialized(menuItem.getMenuItemModiferSpecs())) {
            MenuItemDAO dao = new MenuItemDAO();
            Session session = dao.getSession();
            menuItem = (MenuItem)session.merge((Object)menuItem);
            Hibernate.initialize(menuItem.getMenuItemModiferSpecs());
            session.close();
        }
        this.tfName.setText(menuItem.getName());
        this.tfDescription.setText(menuItem.getDescription());
        this.tfTranslatedName.setText(menuItem.getTranslatedName());
        this.tfBarcode.setText(menuItem.getBarcode());
        this.tfCost.setText(NumberUtil.trimDecilamIfNotNeeded(menuItem.getCost()));
        this.tfPrice.setText(NumberUtil.formatNumber(menuItem.getPrice()));
        if (menuItem.getUnit() != null) {
            this.cbUnits.setSelectedItem(menuItem.getUnit());
            this.tfUnitName.setText(menuItem.getUnit().getCode());
        }
        this.tfDiscountRate.setText(String.valueOf(menuItem.getDiscountRate()));
        this.tfStockCount.setText(String.valueOf(menuItem.getAvailableUnit()));
        this.chkVisible.setSelected(menuItem.isVisible());
        this.buttonStylePanel.setShowTextWithImage(menuItem.isShowImageOnly());
        this.cbRawMaterial.setSelected(menuItem.isRawMaterial());
        this.cbIsInventory.setSelected(menuItem.isInventoryItem());
        if (!menuItem.isInventoryItem().booleanValue()) {
            this.tabbedPane.remove(this.inventoryPanel);
        }
        this.tabbedPane.addChangeListener(this);
        ImageResource imageResource = ImageResourceDAO.getInstance().findById(menuItem.getImageId());
        if (imageResource != null) {
            this.buttonStylePanel.setImageResource(imageResource);
        }
        this.cbTaxGroup.setSelectedItem(menuItem.getTaxGroup());
        if (menuItem.getMenuGroupId() != null) {
            PosGuiUtil.selectComboItemById(this.cbMenuGroup, menuItem.getMenuGroupId());
        }
        if (menuItem.getCourseId() != null) {
            PosGuiUtil.selectComboItemById(this.cbCourse, menuItem.getCourseId());
        }
        if (menuItem.getDefaultRecipeId() != null) {
            PosGuiUtil.selectComboItemById(this.cbRecipe, menuItem.getDefaultRecipeId());
        }
        if (menuItem.getPrinterGroupId() != null) {
            this.cbPrinterGroup.setSelectedItem(PrinterGroupDAO.getInstance().get(menuItem.getPrinterGroupId()));
        }
        this.buttonStylePanel.setSortOrder(menuItem.getSortOrder());
        Color buttonColor = menuItem.getButtonColor();
        if (buttonColor != null) {
            this.buttonStylePanel.setButtonColor(buttonColor);
            this.buttonStylePanel.setTextColor(buttonColor);
        }
        if (menuItem.getTextColor() != null) {
            this.buttonStylePanel.setTextForegroundColor(menuItem.getTextColor());
        }
        this.cbFractionalUnit.setSelected(menuItem.isFractionalUnit());
        this.chkComboItem.setSelected(menuItem.isComboItem());
        this.chkHasVariant.setSelected(menuItem.isHasVariant());
        this.inventoryPanel.setSku(menuItem.getSku());
        this.inventoryPanel.setReOrderLevel(menuItem.getReorderLevel());
        this.inventoryPanel.setReplenishLevel(menuItem.getReplenishLevel());
        this.inventoryPanel.setCbDisableStockCount(menuItem.isDisableWhenStockAmountIsZero());
        this.menuItemModifierSpecList = menuItem.getMenuItemModiferSpecs();
        this.chkPrintToKitchen.setSelected(menuItem.isShouldPrintToKitchen());
        this.chkPrintKitchenSticker.setSelected(menuItem.isPrintKitchenSticker());
        this.chkEditablePrice.setSelected(menuItem.isEditablePrice());
    }

    @Override
    public boolean updateModel() {
        String itemName = this.tfName.getText();
        if (POSUtil.isBlankOrNull(itemName)) {
            MessageDialog.showError(POSConstants.NAME_REQUIRED);
            return false;
        }
        MenuItem menuItem = (MenuItem)this.getBean();
        menuItem.setName(itemName);
        menuItem.setDescription(this.tfDescription.getText());
        menuItem.setBarcode(this.tfBarcode.getText());
        menuItem.setCost(this.tfCost.getDoubleOrZero());
        menuItem.setPrice(Double.valueOf(this.tfPrice.getText()));
        if (this.cbUnits.isVisible()) {
            InventoryUnit unit = (InventoryUnit)this.cbUnits.getSelectedItem();
            if (unit == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select unit!");
                return false;
            }
            menuItem.setUnit(unit);
            menuItem.setUnitName(unit.getCode());
        } else {
            menuItem.setUnitName(this.tfUnitName.getText());
        }
        menuItem.setTaxGroup((TaxGroup)this.cbTaxGroup.getSelectedItem());
        menuItem.setAvailableUnit(Double.parseDouble(this.tfStockCount.getText()));
        menuItem.setVisible(this.chkVisible.isSelected());
        menuItem.setShowImageOnly(this.buttonStylePanel.isShowTextWithImage());
        menuItem.setFractionalUnit(this.cbFractionalUnit.isSelected());
        menuItem.setRawMaterial(this.cbRawMaterial.isSelected());
        menuItem.setInventoryItem(this.cbIsInventory.isSelected());
        menuItem.setTranslatedName(this.tfTranslatedName.getText());
        menuItem.setSortOrder(this.buttonStylePanel.getSortOrder());
        menuItem.setButtonColorCode(this.buttonStylePanel.getButtonColorCode());
        menuItem.setTextColorCode(this.buttonStylePanel.getTextColorCode());
        menuItem.setEditablePrice(this.chkEditablePrice.isSelected());
        try {
            menuItem.setDiscountRate(Double.parseDouble(this.tfDiscountRate.getText()));
        }
        catch (Exception unit) {
            // empty catch block
        }
        if (this.menuItemModifierSpecList != null && this.menuItemModifierSpecList.size() > 0) {
            for (MenuItemModifierSpec menuItemModifierSpec : this.menuItemModifierSpecList) {
                int minQuantity = menuItemModifierSpec.getMinQuantity();
                int itemCount = 0;
                for (MenuItemModifierPage itemModifierPage : menuItemModifierSpec.getModifierPages()) {
                    List<MenuItemModifierPageItem> pageItems;
                    if (menuItemModifierSpec.getId() != null) {
                        itemModifierPage.setModifierSpecId(menuItemModifierSpec.getId());
                    }
                    if ((pageItems = itemModifierPage.getPageItems()) == null) continue;
                    itemCount += pageItems.size();
                    for (MenuItemModifierPageItem menuItemModifierPageItem : pageItems) {
                        if (itemModifierPage.getId() == null) continue;
                        menuItemModifierPageItem.setParentPage(itemModifierPage);
                    }
                }
                if (itemCount >= minQuantity) continue;
                Component componentAt = this.tabbedPane.getSelectedComponent();
                if (componentAt != this.tabModifier) {
                    this.tabbedPane.setSelectedComponent(this.tabModifier);
                }
                int quaDiff = minQuantity - itemCount;
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), " Please add " + quaDiff + " more " + (quaDiff > 1 ? "items" : "item") + " in " + menuItemModifierSpec.getName() + " group \n Minimum quantity required " + minQuantity + ".");
                return false;
            }
        }
        menuItem.setMenuItemModiferSpecs(this.menuItemModifierSpecList);
        menuItem.setHasModifiers(this.menuItemModifierSpecList != null && this.menuItemModifierSpecList.size() > 0);
        menuItem.setHasMandatoryModifiers(false);
        if (menuItem.hasModifiers()) {
            for (MenuItemModifierSpec menuItemModifierGroup : this.menuItemModifierSpecList) {
                if (menuItemModifierGroup.getMinQuantity() <= 0 && !menuItemModifierGroup.isAutoShow().booleanValue()) continue;
                menuItem.setHasMandatoryModifiers(true);
                break;
            }
        }
        int tabCount = this.tabbedPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            IUpdatebleView view;
            Component componentAt = this.tabbedPane.getComponent(i);
            if (!(componentAt instanceof IUpdatebleView) || (view = (IUpdatebleView)((Object)componentAt)).updateModel(menuItem)) continue;
            return false;
        }
        MenuGroup selectedGroup = (MenuGroup)this.cbMenuGroup.getSelectedItem();
        menuItem.setMenuGroup(selectedGroup);
        menuItem.setCourse((Course)this.cbCourse.getSelectedItem());
        menuItem.setDefaultRecipeId(null);
        if (this.cbRecipe.getSelectedItem() instanceof Recepie) {
            String defaultRecipeId = ((Recepie)this.cbRecipe.getSelectedItem()).getId();
            menuItem.setDefaultRecipeId(defaultRecipeId);
        }
        menuItem.setPrinterGroup((PrinterGroup)this.cbPrinterGroup.getSelectedItem());
        menuItem.setComboItem(this.chkComboItem.isSelected());
        menuItem.setHasVariant(this.chkHasVariant.isSelected());
        if (menuItem.isComboItem().booleanValue()) {
            menuItem.setComboItems(this.tabComboItems.getSelectedComboItems());
            menuItem.setComboGroups(this.tabComboItems.getSelectedComboGroups());
        }
        if (menuItem.isHasVariant().booleanValue()) {
            List<MenuItem> newVariants = this.variantTab.getVariants();
            if (newVariants != null) {
                for (MenuItem menuItem2 : newVariants) {
                    menuItem2.setInventoryItem(this.cbIsInventory.isSelected());
                    menuItem2.setParentMenuItem(menuItem);
                    menuItem2.setMenuGroup(selectedGroup);
                }
            }
            menuItem.setVariants(POSUtil.copySelectedValues(menuItem.getVariants(), newVariants));
        }
        menuItem.setSku(this.inventoryPanel.getSku());
        menuItem.setReorderLevel(this.inventoryPanel.getReOrderLevel());
        menuItem.setReplenishLevel(this.inventoryPanel.getReplenishLevel());
        menuItem.setDisableWhenStockAmountIsZero(this.inventoryPanel.isCbDisableStockCount());
        menuItem.setImageId(this.buttonStylePanel.getImageResourceId());
        menuItem.setShouldPrintToKitchen(this.chkPrintToKitchen.isSelected());
        menuItem.setPrintKitchenSticker(this.chkPrintKitchenSticker.isSelected());
        return true;
    }

    @Override
    public String getDisplayText() {
        MenuItem foodItem = (MenuItem)this.getBean();
        if (foodItem.getId() == null) {
            return POSConstants.NEW_MENU_ITEM;
        }
        return POSConstants.EDIT_MENU_ITEM;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("AddModifierGroup")) {
            this.addMenuItemModifierGroup();
        } else if (actionCommand.equals("EditModifierGroup")) {
            this.editMenuItemModifierGroup();
        } else if (actionCommand.equals("DeleteModifierGroup")) {
            this.deleteMenuItemModifierGroup();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Component selectedComponent = this.tabbedPane.getSelectedComponent();
        if (!(selectedComponent instanceof IUpdatebleView)) {
            return;
        }
        IUpdatebleView view = (IUpdatebleView)((Object)selectedComponent);
        MenuItem menuItem = (MenuItem)this.getBean();
        view.initView(menuItem);
    }

    private void doCreateNewGroup() {
        MenuGroupForm editor = new MenuGroupForm();
        BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
        dialog.open();
        if (!dialog.isCanceled()) {
            MenuGroup foodGroup = (MenuGroup)editor.getBean();
            ComboBoxModel model = (ComboBoxModel)this.cbMenuGroup.getModel();
            model.addElement(foodGroup);
            model.setSelectedItem(foodGroup);
        }
    }

    private void doCreateReportGroup(ActionEvent evt) {
        ReportGroupForm editor = new ReportGroupForm();
        BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
        dialog.open();
        if (!dialog.isCanceled()) {
            ReportGroup reportGroup = (ReportGroup)editor.getBean();
            ComboBoxModel model = (ComboBoxModel)this.cbReportGroup.getModel();
            model.addElement(reportGroup);
            model.setSelectedItem(reportGroup);
        }
    }

    public void initModifierGroupTab() {
        this.modifierDesigner = new ModifierPageDesigner(this.menuItem);
        this.btnDeleteModifierGroup.setText(POSConstants.DELETE);
        this.btnEditModifierGroup.setText(POSConstants.EDIT);
        this.btnNewModifierGroup.setText(POSConstants.ADD);
        this.btnDeleteModifierGroup.setActionCommand("DeleteModifierGroup");
        this.btnEditModifierGroup.setActionCommand("EditModifierGroup");
        this.modifierSpecTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int index = MenuItemForm.this.modifierSpecTable.getSelectedRow();
                if (index < 0) {
                    return;
                }
                MenuItemModifierSpec menuItemModifierSpec = MenuItemForm.this.menuItemMGListModel.get(index);
                MenuItemForm.this.modifierDesigner.setMenuItemModifierSpec(menuItemModifierSpec);
            }
        });
        this.modifierSpecTable.setModel(this.menuItemMGListModel);
        this.modifierSpecTable.setRowHeight(PosUIManager.getSize(30));
        this.modifierSpecTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    MenuItemForm.this.editSelectedRow();
                }
            }
        });
        this.btnNewModifierGroup.addActionListener(this);
        this.btnEditModifierGroup.addActionListener(this);
        this.btnDeleteModifierGroup.addActionListener(this);
        this.btnNewModifierGroup.setActionCommand("AddModifierGroup");
        this.btnNewModifierGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuItemForm.this.btnNewModifierGroupActionPerformed(evt);
            }
        });
        this.tabModifier.setLayout(new BorderLayout(10, 10));
        JPanel groupsPanel = new JPanel(new BorderLayout());
        TitledBorder groupsPanelBorder = BorderFactory.createTitledBorder(new EmptyBorder(5, 5, 0, 5), "Groups", 2, 2);
        groupsPanelBorder.setTitleJustification(2);
        groupsPanel.setBorder(groupsPanelBorder);
        groupsPanel.add(this.modifiertabScrollpane);
        JPanel btmpanel = new JPanel();
        btmpanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        groupsPanel.add((Component)btmpanel, "South");
        btmpanel.add(this.btnNewModifierGroup);
        btmpanel.add(this.btnEditModifierGroup);
        btmpanel.add(this.btnDeleteModifierGroup);
        this.tabModifier.add((Component)groupsPanel, "West");
        this.tabModifier.add(this.modifierDesigner);
        this.tabbedPane.addTab(POSConstants.MODIFIER_GROUPS, this.tabModifier);
        this.modifiertabScrollpane.setViewportView(this.modifierSpecTable);
        this.modifierSpecTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.modifierSpecTable.getColumnModel().getColumn(1).setPreferredWidth(45);
        this.modifierSpecTable.getColumnModel().getColumn(2).setPreferredWidth(45);
        this.modifierSpecTable.setAutoResizeMode(3);
    }

    public void initGeneralTab() {
        int comboWidth = PosUIManager.getSize(200);
        this.chkComboItem = new JCheckBox("Combo Item");
        this.lfname.setText(Messages.getString("LABEL_NAME"));
        this.lfname.setHorizontalAlignment(11);
        this.lblPrice.setHorizontalAlignment(11);
        this.lblPrice.setText("Sales Price (" + CurrencyUtil.getCurrencySymbol() + ")");
        this.lTax.setHorizontalAlignment(11);
        this.lTax.setText("Tax Group");
        this.tfPrice.setHorizontalAlignment(4);
        this.tfCost.setHorizontalAlignment(4);
        this.lblReportGroup.setHorizontalAlignment(11);
        this.lblReportGroup.setText(Messages.getString("MenuItemForm.45"));
        this.btnNewReportGroup.setText("+");
        JPanel column1 = new JPanel((LayoutManager)new MigLayout("fillx", "[][grow]", ""));
        JPanel column2 = new JPanel((LayoutManager)new MigLayout("fillx", "[][grow]", ""));
        Dimension preferredSize = PosUIManager.getSize(280, 450);
        column1.setPreferredSize(preferredSize);
        column2.setPreferredSize(preferredSize);
        this.tabGeneral.setLayout(new GridLayout(1, 2, 40, 5));
        this.chkPrintToKitchen = new JCheckBox("Print to kitchen");
        this.chkPrintKitchenSticker = new JCheckBox("Print kitchen sticker");
        this.chkEditablePrice = new JCheckBox("Editable price");
        column1.add((Component)this.lfname, "right");
        column1.add((Component)this.tfName, "grow, wrap");
        column1.add((Component)this.lblTranslatedName, "right");
        column1.add((Component)this.tfTranslatedName, "grow, wrap");
        column1.add((Component)this.lblUnitName, "right");
        column1.add(this.getUnitField(), "width 150!, wrap");
        column1.add((Component)this.lblPrice, "right");
        column1.add((Component)this.tfPrice, "wrap");
        column1.add((Component)new JLabel("Cost (" + CurrencyUtil.getCurrencySymbol() + ")"), "right");
        column1.add((Component)this.tfCost, "wrap");
        column1.add((Component)new JLabel("Group"), "right");
        column1.add(this.cbMenuGroup, "split 2, w " + comboWidth);
        column1.add((Component)this.btnNewMenuGroup, "wrap");
        column1.add((Component)this.lblReportGroup, "right");
        column1.add((Component)this.cbReportGroup, "split 2, w " + comboWidth);
        column1.add((Component)this.btnNewReportGroup, "wrap");
        column1.add((Component)this.lblBarcode, "right");
        column1.add((Component)this.tfBarcode, "wrap");
        column1.add((Component)this.chkVisible, "skip 1,wrap");
        column1.add((Component)this.cbFractionalUnit, "growx 8,skip 1,wrap");
        column1.add((Component)this.cbRawMaterial, "skip 1,wrap");
        column1.add((Component)this.cbIsInventory, "skip 1,wrap");
        column1.add((Component)this.chkComboItem, "skip 1,wrap");
        column1.add((Component)this.chkHasVariant, "skip 1,wrap");
        column1.add((Component)this.chkPrintToKitchen, "skip 1,wrap");
        column1.add((Component)this.chkPrintKitchenSticker, "skip 1,wrap");
        column1.add((Component)this.chkEditablePrice, "skip 1,wrap");
        this.chkVisible.setText(POSConstants.VISIBLE);
        this.chkVisible.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkVisible.setMargin(new Insets(0, 0, 0, 0));
        column2.add((Component)this.lblKitchenPrinter, "right");
        column2.add(this.cbPrinterGroup, "wrap, w " + comboWidth + "!");
        column2.add((Component)this.lTax, "right");
        column2.add((Component)this.cbTaxGroup, "wrap, w " + comboWidth + "!");
        column2.add((Component)new JLabel("Course"), "right");
        column2.add(this.cbCourse, "wrap, w " + comboWidth + "!");
        column2.add((Component)new JLabel("Default recipe"), "right");
        column2.add(this.cbRecipe, "wrap, w " + comboWidth + "!");
        JLabel descLabel = new JLabel("Description");
        descLabel.setVerticalAlignment(1);
        descLabel.setHorizontalAlignment(11);
        this.tfDescription.setLineWrap(true);
        JScrollPane scrlDescription = new JScrollPane(this.tfDescription, 20, 30);
        column2.add((Component)descLabel, "align right, grow");
        column2.add((Component)scrlDescription, "h 50%,grow,wrap");
        this.tabGeneral.add((Component)column1, "grow,wrap");
        this.tabGeneral.add((Component)column2, "grow,wrap");
        JScrollPane scrlMainPanel = new JScrollPane(this.tabGeneral, 20, 30);
        scrlMainPanel.setBorder(null);
        this.tabbedPane.addTab(POSConstants.GENERAL, scrlMainPanel);
        Dimension mainPanelSize = PosUIManager.getSize(700, 470);
        this.tabbedPane.setPreferredSize(mainPanelSize);
        this.add(this.tabbedPane);
        this.chkComboItem.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkComboItem.setMargin(new Insets(0, 0, 0, 0));
        this.chkComboItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    MenuItemForm.this.tabbedPane.addTab("Combo Items", MenuItemForm.this.tabComboItems);
                } else {
                    MenuItemForm.this.tabbedPane.remove(MenuItemForm.this.tabComboItems);
                }
            }
        });
        this.chkHasVariant.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkHasVariant.setMargin(new Insets(0, 0, 0, 0));
        this.chkHasVariant.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (MenuItemForm.this.tfName.getText().isEmpty()) {
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please enter item name.");
                        MenuItemForm.this.chkHasVariant.setSelected(false);
                        return;
                    }
                    if (MenuItemForm.this.cbMenuGroup.getSelectedItem() == null) {
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select group.");
                        MenuItemForm.this.chkHasVariant.setSelected(false);
                        return;
                    }
                    MenuItemForm.this.tabbedPane.addTab("Variant", MenuItemForm.this.variantTab);
                } else {
                    MenuItemForm.this.tabbedPane.remove(MenuItemForm.this.variantTab);
                }
            }
        });
        this.btnNewMenuGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuItemForm.this.doCreateNewGroup();
            }
        });
        this.btnNewReportGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuItemForm.this.doCreateReportGroup(evt);
            }
        });
        this.tfName.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                MenuItemForm.this.menuItem.setName(MenuItemForm.this.tfName.getText());
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
    }

    public void initBtnstyleTab() {
        this.buttonStylePanel = new ButtonStylePanel();
        this.tabbedPane.addTab(Messages.getString("MenuItemForm.26"), this.buttonStylePanel);
    }

    public void initInverntoryTab() {
        this.inventoryPanel = new InventoryPanel(this.menuItem);
        this.tabbedPane.addTab(Messages.getString("MenuItemForm.64"), this.inventoryPanel);
        if (this.inventoryItemMode) {
            this.cbIsInventory.setVisible(false);
            this.inventoryPanel.setVisible(true);
        }
    }

    class ShiftTableModel
    extends AbstractTableModel {
        List<MenuItemShift> shifts;
        String[] cn = new String[]{POSConstants.START_TIME, POSConstants.END_TIME, POSConstants.PRICE};
        Calendar calendar = Calendar.getInstance();

        ShiftTableModel(List<MenuItemShift> shifts) {
            this.shifts = shifts == null ? new ArrayList<MenuItemShift>() : new ArrayList<MenuItemShift>(shifts);
        }

        public MenuItemShift get(int index) {
            return this.shifts.get(index);
        }

        public void add(MenuItemShift group) {
            if (this.shifts == null) {
                this.shifts = new ArrayList<MenuItemShift>();
            }
            this.shifts.add(group);
            this.fireTableDataChanged();
        }

        public void remove(int index) {
            if (this.shifts == null) {
                return;
            }
            this.shifts.remove(index);
            this.fireTableDataChanged();
        }

        public void remove(MenuItemShift group) {
            if (this.shifts == null) {
                return;
            }
            this.shifts.remove(group);
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            if (this.shifts == null) {
                return 0;
            }
            return this.shifts.size();
        }

        @Override
        public int getColumnCount() {
            return this.cn.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.cn[column];
        }

        public List<MenuItemShift> getShifts() {
            return this.shifts;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MenuItemShift shift = this.shifts.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return ShiftUtil.buildShiftTimeRepresentation(shift.getShift().getStartTime());
                }
                case 1: {
                    return ShiftUtil.buildShiftTimeRepresentation(shift.getShift().getEndTime());
                }
                case 2: {
                    return String.valueOf(shift.getShiftPrice());
                }
            }
            return null;
        }
    }

    class MenuItemMGListModel
    extends AbstractTableModel {
        String[] cn = new String[]{POSConstants.GROUP_NAME, "MIN", "MAX"};

        MenuItemMGListModel() {
        }

        public MenuItemModifierSpec get(int index) {
            return (MenuItemModifierSpec)MenuItemForm.this.menuItemModifierSpecList.get(index);
        }

        public void add(MenuItemModifierSpec group) {
            if (MenuItemForm.this.menuItemModifierSpecList == null) {
                MenuItemForm.this.menuItemModifierSpecList = new ArrayList();
            }
            MenuItemForm.this.menuItemModifierSpecList.add(group);
            this.fireTableDataChanged();
        }

        public void remove(int index) {
            if (MenuItemForm.this.menuItemModifierSpecList == null) {
                return;
            }
            MenuItemForm.this.menuItemModifierSpecList.remove(index);
            this.fireTableDataChanged();
        }

        public List<MenuItemModifierSpec> getItems() {
            return MenuItemForm.this.menuItemModifierSpecList;
        }

        public void remove(MenuItemModifierSpec group) {
            if (MenuItemForm.this.menuItemModifierSpecList == null) {
                return;
            }
            MenuItemForm.this.menuItemModifierSpecList.remove(group);
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            if (MenuItemForm.this.menuItemModifierSpecList == null) {
                return 0;
            }
            return MenuItemForm.this.menuItemModifierSpecList.size();
        }

        @Override
        public int getColumnCount() {
            return this.cn.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.cn[column];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MenuItemModifierSpec menuItemModifierGroup = (MenuItemModifierSpec)MenuItemForm.this.menuItemModifierSpecList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return menuItemModifierGroup.getName();
                }
                case 1: {
                    return (int)menuItemModifierGroup.getMinQuantity();
                }
                case 2: {
                    return (int)menuItemModifierGroup.getMaxQuantity();
                }
            }
            return null;
        }
    }
}

