/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.modifierdesigner.ModifierSelectionDialog;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.ModifierDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.hibernate.Hibernate;
import org.hibernate.Session;

public class ModifierGroupForm
extends BeanEditor {
    private JLabel jLabel1;
    private FixedLengthTextField tfName;
    private FixedLengthTextField tfTranslatedName;
    private JList listModifiers;
    private ComboBoxModel modifierListModel;
    private Boolean pizzaModifierGroup;

    public ModifierGroupForm() throws Exception {
        this(new ModifierGroup());
    }

    public ModifierGroupForm(ModifierGroup group) throws Exception {
        this(group, (Boolean)false);
    }

    public ModifierGroupForm(ModifierGroup group, Boolean pizzaModifierGroup) throws Exception {
        this.initComponents();
        this.setBean(group);
        this.pizzaModifierGroup = pizzaModifierGroup;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        JPanel formPanel = new JPanel();
        formPanel.setLayout((LayoutManager)new MigLayout("", "[45px][369px,grow]", "[19px][]"));
        this.jLabel1 = new JLabel();
        this.tfName = new FixedLengthTextField();
        this.tfName.setLength(60);
        this.jLabel1.setText(POSConstants.NAME);
        formPanel.add((Component)this.jLabel1, "cell 0 0,alignx left,aligny center");
        formPanel.add((Component)this.tfName, "cell 1 0,growx,aligny top");
        JLabel lblTranslatedName = new JLabel(POSConstants.TRANSLATED_NAME);
        formPanel.add((Component)lblTranslatedName, "cell 0 1,alignx trailing");
        this.tfTranslatedName = new FixedLengthTextField();
        this.tfTranslatedName.setLength(60);
        formPanel.add((Component)this.tfTranslatedName, "cell 1 1,growx");
        this.add((Component)formPanel, "North");
        JPanel modifierPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        JPanel listPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout());
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        TitledBorder title = BorderFactory.createTitledBorder(loweredetched, "Modifier List");
        title.setTitleJustification(1);
        JButton btnAddModifier = new JButton("Add Modifier");
        btnAddModifier.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifierGroupForm.this.doAddModifiers();
            }
        });
        JButton btnRemoveModifier = new JButton("Remove");
        btnRemoveModifier.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuModifier modifier = (MenuModifier)ModifierGroupForm.this.listModifiers.getSelectedValue();
                if (modifier == null) {
                    return;
                }
                ModifierGroupForm.this.modifierListModel.removeElement(modifier);
            }
        });
        this.listModifiers = new JList();
        JScrollPane scrollPane = new JScrollPane(this.listModifiers);
        listPanel.setBorder(title);
        listPanel.add((Component)scrollPane, "grow");
        buttonPanel.add(btnAddModifier);
        buttonPanel.add(btnRemoveModifier);
        modifierPanel.add((Component)listPanel, "grow");
        modifierPanel.add((Component)buttonPanel, "South");
        this.add(modifierPanel);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            ModifierGroup group = (ModifierGroup)this.getBean();
            ModifierGroupDAO dao = new ModifierGroupDAO();
            dao.saveOrUpdate(group);
        }
        catch (Exception e) {
            MessageDialog.showError(e);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        ModifierGroup group = (ModifierGroup)this.getBean();
        if (group.getId() != null && !Hibernate.isInitialized(group.getModifiers())) {
            ModifierDAO dao = new ModifierDAO();
            Session session = dao.getSession();
            group = (ModifierGroup)session.merge((Object)group);
            Hibernate.initialize(group.getModifiers());
            session.close();
        }
        this.tfName.setText(group.getName());
        this.tfTranslatedName.setText(group.getTranslatedName());
        this.modifierListModel = new ComboBoxModel();
        if (group.getModifiers() != null) {
            this.modifierListModel.setDataList(group.getModifiers());
        } else {
            this.modifierListModel.setDataList(new ArrayList());
        }
        this.listModifiers.setModel(this.modifierListModel);
    }

    @Override
    protected boolean updateModel() {
        ModifierGroup group = (ModifierGroup)this.getBean();
        String name = this.tfName.getText();
        if (POSUtil.isBlankOrNull(name)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.NAME_REQUIRED);
            return false;
        }
        group.setName(name);
        group.setTranslatedName(this.tfTranslatedName.getText());
        group.setModifiers(this.modifierListModel.getDataList());
        group.setPizzaModifierGroup(this.pizzaModifierGroup);
        return true;
    }

    @Override
    public String getDisplayText() {
        ModifierGroup modifierGroup = (ModifierGroup)this.getBean();
        if (modifierGroup.getId() == null) {
            return POSConstants.NEW_MODIFIER_GROUP;
        }
        return POSConstants.EDIT_MODIFIER_GROUP;
    }

    private void doAddModifiers() {
        ModifierSelectionDialog modifierSelectionDialog = new ModifierSelectionDialog(this.modifierListModel.getDataList(), (boolean)this.pizzaModifierGroup);
        modifierSelectionDialog.setSize(PosUIManager.getSize(600, 500));
        modifierSelectionDialog.open();
        if (modifierSelectionDialog.isCanceled()) {
            return;
        }
        List<MenuModifier> selectedMenuModifierList = modifierSelectionDialog.getSelectedMenuModifierList();
        this.modifierListModel.removeAllElements();
        for (MenuModifier menuModifier : selectedMenuModifierList) {
            this.modifierListModel.addElement(menuModifier);
        }
    }
}

