/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.model.Department;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.dao.TerminalTypeDAO;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.exception.ConstraintViolationException;

public class OrderTypeForm
extends BeanEditor
implements ItemListener {
    private FixedLengthTextField tfName;
    private JCheckBox chkEnabled;
    private JCheckBox chkShowTableSelection;
    private JCheckBox chkShowGuestSelection;
    private JCheckBox chkShouldPrintToKitchen;
    private JCheckBox chkCloseOnPaid;
    private JCheckBox chkPrepaid;
    private JCheckBox chkRequiredCustomerData;
    private JCheckBox chkShowInLoginScreen;
    private JCheckBox chkConsolidateItemsInReceipt;
    private JCheckBox chkAllowSeatBasedOrder;
    private JCheckBox chkHideItemWithEmptyInventory;
    private JCheckBox chkHasForHereAndToGo;
    private JCheckBox chkPreAuthCreditCard;
    private JCheckBox chkRequiredDeliveryData;
    private JCheckBox chkAssignDriver;
    private IntegerTextField tfSortOrder;
    private JLabel lblImagePreview;
    private JButton btnTextColorChooser = new JButton(Messages.getString("OrderTypeForm.15"));
    private JButton btnColorChooser = new JButton(Messages.getString("OrderTypeForm.16"));
    private JCheckBox showImageOnly;
    private Log logger = LogFactory.getLog(OrderTypeForm.class);
    JList<String> list;
    DefaultListModel<String> listModel;
    private JCheckBox chkEnableReorder;
    private JCheckBox chkEnableCourse;
    private CheckBoxList<Department> chkbDeptList = new CheckBoxList();
    private CheckBoxList<TerminalType> chkbTerminalTypeList = new CheckBoxList();
    private CheckBoxList<MenuCategory> chkbCategoryList = new CheckBoxList();
    private ArrayList<Department> selectedDeptList;
    private List<Department> deptList;
    private JTabbedPane tabbedPane;
    private JComboBox cbForHereTG;
    private JComboBox cbToGoTG;
    private JLabel lblForHereTG;
    private JLabel lblToGoTG;
    private JComboBox cbDefaultTG;
    private List<TerminalType> terminalTypeList;
    private List<MenuCategory> categoryList;
    private ArrayList<TerminalType> selectedTerminalTypes;
    private ArrayList<MenuCategory> selectedCategories;
    private ButtonGroup rbButtonGroup;
    private JRadioButton rbtnBarTab;
    private JRadioButton rbtnDelivery;
    private JRadioButton rbtnPickup;
    private JRadioButton rbtnRetail;
    private JRadioButton rbtnNone;

    public OrderTypeForm() throws Exception {
        this(new OrderType());
        this.initHandler();
    }

    public OrderTypeForm(OrderType orderType) throws Exception {
        this.initComponents();
        this.setBean(orderType);
        this.initHandler();
    }

    @Override
    public String getDisplayText() {
        OrderType orderType = (OrderType)this.getBean();
        if (orderType.getId() == null) {
            return POSConstants.ORDER_TYPE;
        }
        return POSConstants.ORDER_TYPE;
    }

    private void initHandler() {
        this.rbtnDelivery.addItemListener(this);
        this.rbtnPickup.addItemListener(this);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setPreferredSize(new Dimension(750, 470));
        this.initGeneralTab();
        this.initGeneralData();
        this.initStyleTab();
        this.add(this.tabbedPane);
    }

    private void initGeneralTab() {
        TransparentPanel generalPanel = new TransparentPanel();
        JLabel lblName = new JLabel(POSConstants.NAME + ":");
        this.tfName = new FixedLengthTextField();
        this.tfName.setLength(120);
        JLabel lblSortOrder = new JLabel("Sort Order:");
        this.tfSortOrder = new IntegerTextField();
        JLabel lblTaxGroup = new JLabel("Tax Group:");
        this.cbDefaultTG = new JComboBox();
        this.rbtnDelivery = new JRadioButton("Home delivery");
        this.rbtnRetail = new JRadioButton("Retail");
        this.rbtnPickup = new JRadioButton("Pickup");
        this.rbtnBarTab = new JRadioButton("Bar tab");
        this.rbtnBarTab.addItemListener(this);
        this.rbtnNone = new JRadioButton("None");
        this.rbtnNone.setSelected(true);
        this.rbButtonGroup = new ButtonGroup();
        this.rbButtonGroup.add(this.rbtnDelivery);
        this.rbButtonGroup.add(this.rbtnRetail);
        this.rbButtonGroup.add(this.rbtnPickup);
        this.rbButtonGroup.add(this.rbtnBarTab);
        this.rbButtonGroup.add(this.rbtnNone);
        this.chkEnabled = new JCheckBox(POSConstants.ENABLED);
        this.chkShowTableSelection = new JCheckBox(Messages.getString("OrderTypeForm.1"));
        this.chkShowGuestSelection = new JCheckBox(Messages.getString("OrderTypeForm.2"));
        this.chkShouldPrintToKitchen = new JCheckBox(Messages.getString("OrderTypeForm.3"));
        this.chkCloseOnPaid = new JCheckBox(Messages.getString("OrderTypeForm.4"));
        this.chkPrepaid = new JCheckBox(Messages.getString("OrderTypeForm.5"));
        this.chkRequiredCustomerData = new JCheckBox(Messages.getString("OrderTypeForm.6"));
        this.chkShowInLoginScreen = new JCheckBox(Messages.getString("OrderTypeForm.10"));
        this.chkConsolidateItemsInReceipt = new JCheckBox(Messages.getString("OrderTypeForm.11"));
        this.chkAllowSeatBasedOrder = new JCheckBox(Messages.getString("ENABLE_SEAT"));
        this.chkHideItemWithEmptyInventory = new JCheckBox(Messages.getString("OrderTypeForm.12"));
        this.chkHasForHereAndToGo = new JCheckBox(Messages.getString("OrderTypeForm.13"));
        this.chkPreAuthCreditCard = new JCheckBox(Messages.getString("OrderTypeForm.0"));
        this.chkRequiredDeliveryData = new JCheckBox(Messages.getString("OrderTypeForm.17"));
        this.chkAssignDriver = new JCheckBox(Messages.getString("OrderTypeForm.18"));
        this.chkEnableReorder = new JCheckBox(Messages.getString("ENABLE_REORDER"));
        this.chkEnableCourse = new JCheckBox(Messages.getString("ENABLE_COURSE"));
        this.chkShowTableSelection.addItemListener(this);
        this.lblForHereTG = new JLabel("For Here tax group");
        this.lblToGoTG = new JLabel("To Go tax group");
        this.cbForHereTG = new JComboBox();
        this.cbToGoTG = new JComboBox();
        generalPanel.setLayout((LayoutManager)new MigLayout("hidemode 3", "[][grow][grow]", ""));
        generalPanel.add((Component)lblName, "align trailing,gaptop 9");
        generalPanel.add((Component)this.tfName, "growx,wrap");
        JPanel rightPanel = new JPanel((LayoutManager)new MigLayout("ins 0"));
        TitledBorder titledBorderOrderTypes = new TitledBorder("Departments");
        JScrollPane deptScrollPanel = new JScrollPane(this.chkbDeptList);
        deptScrollPanel.setBorder(titledBorderOrderTypes);
        rightPanel.add((Component)deptScrollPanel, "w 200!,h 150!, wrap,growx,gapright 30");
        generalPanel.add((Component)lblSortOrder, "trailing");
        generalPanel.add((Component)this.tfSortOrder, "growx, wrap");
        generalPanel.add((Component)lblTaxGroup, "trailing");
        generalPanel.add((Component)this.cbDefaultTG, "growx, wrap");
        JPanel rbButtonPanel = new JPanel((LayoutManager)new MigLayout("ins 0"));
        rbButtonPanel.add(this.rbtnDelivery);
        rbButtonPanel.add(this.rbtnRetail);
        rbButtonPanel.add(this.rbtnPickup);
        rbButtonPanel.add(this.rbtnBarTab);
        rbButtonPanel.add(this.rbtnNone);
        generalPanel.add((Component)rbButtonPanel, "skip 1, growx,wrap");
        generalPanel.add((Component)this.chkEnabled, "skip 1, wrap");
        generalPanel.add((Component)this.chkShowTableSelection, "skip 1, wrap");
        generalPanel.add((Component)this.chkShowGuestSelection, "skip 1, wrap");
        generalPanel.add((Component)this.chkShouldPrintToKitchen, "skip 1,wrap");
        TitledBorder titledBorderTerminalTypes = new TitledBorder("Terminal types");
        JScrollPane terminalTypesScrollPanel = new JScrollPane(this.chkbTerminalTypeList);
        terminalTypesScrollPanel.setBorder(titledBorderTerminalTypes);
        rightPanel.add((Component)terminalTypesScrollPanel, "w 200!,h 150!, wrap,growx,gapright 30");
        generalPanel.add((Component)this.chkPrepaid, "skip 1, wrap");
        generalPanel.add((Component)this.chkCloseOnPaid, "skip 1, wrap");
        OrderServiceExtension orderServiceExtension = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
        generalPanel.add((Component)this.chkRequiredCustomerData, "skip 1, wrap");
        if (orderServiceExtension != null) {
            generalPanel.add((Component)this.chkRequiredDeliveryData, "skip 1, wrap");
            generalPanel.add((Component)this.chkAssignDriver, "skip 1, wrap");
        }
        generalPanel.add((Component)this.chkShowInLoginScreen, "skip 1,wrap");
        generalPanel.add((Component)this.chkConsolidateItemsInReceipt, "skip 1, wrap");
        generalPanel.add((Component)this.chkEnableCourse, "skip 1, wrap");
        generalPanel.add((Component)this.chkAllowSeatBasedOrder, "skip 1,wrap");
        TitledBorder titledBorderCategories = new TitledBorder("Categories");
        JScrollPane categoriesScrollPanel = new JScrollPane(this.chkbCategoryList);
        categoriesScrollPanel.setBorder(titledBorderCategories);
        rightPanel.add((Component)categoriesScrollPanel, "w 200!,h 150!,growx,gapright 30");
        generalPanel.add((Component)rightPanel, "east");
        generalPanel.add((Component)this.chkHideItemWithEmptyInventory, "skip 1,wrap");
        generalPanel.add((Component)this.chkHasForHereAndToGo, "skip 1, wrap");
        generalPanel.add((Component)this.lblForHereTG, "gapleft 20, skip 1, split 2");
        generalPanel.add((Component)this.cbForHereTG, "gapleft 20, wrap");
        generalPanel.add((Component)this.lblToGoTG, "gapleft 20, skip 1, split 2");
        generalPanel.add((Component)this.cbToGoTG, "gapleft 35, skip 1, wrap");
        generalPanel.add((Component)this.chkPreAuthCreditCard, "skip 1, wrap");
        generalPanel.add((Component)this.chkEnableReorder, "skip 1, wrap");
        this.chkHasForHereAndToGo.addItemListener(this);
        this.lblForHereTG.setVisible(false);
        this.lblToGoTG.setVisible(false);
        this.cbForHereTG.setVisible(false);
        this.cbToGoTG.setVisible(false);
        generalPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane generalTabScrollpane = new JScrollPane(generalPanel);
        generalTabScrollpane.getVerticalScrollBar().setUnitIncrement(10);
        generalTabScrollpane.setBorder(null);
        this.tabbedPane.add(Messages.getString("OrderTypeForm.32"), generalTabScrollpane);
    }

    private void initGeneralData() {
        this.deptList = DepartmentDAO.getInstance().findAll();
        if (this.deptList == null) {
            this.deptList = new ArrayList<Department>();
        }
        this.chkbDeptList.setModel(this.deptList);
        this.terminalTypeList = TerminalTypeDAO.getInstance().findAll();
        if (this.terminalTypeList == null) {
            this.terminalTypeList = new ArrayList<TerminalType>();
        }
        this.chkbTerminalTypeList.setModel(this.terminalTypeList);
        this.categoryList = MenuCategoryDAO.getInstance().findAll();
        if (this.categoryList == null) {
            this.categoryList = new ArrayList<MenuCategory>();
        }
        this.chkbCategoryList.setModel(this.categoryList);
        ArrayList<TaxGroup> taxGroups = new ArrayList<TaxGroup>();
        taxGroups.add(null);
        taxGroups.addAll(TaxGroupDAO.getInstance().findAll());
        this.cbDefaultTG.setModel(new ComboBoxModel(taxGroups));
        this.cbForHereTG.setModel(new ComboBoxModel(taxGroups));
        this.cbToGoTG.setModel(new ComboBoxModel(taxGroups));
    }

    private void initStyleTab() {
        JPanel btnPanel = new JPanel((LayoutManager)new MigLayout("insets 10", "[][]100[][][][]", "[][][center][][][]"));
        JLabel lblImage = new JLabel(Messages.getString("MenuItemForm.28"));
        lblImage.setHorizontalAlignment(11);
        btnPanel.add((Component)lblImage, "cell 0 0,right");
        this.lblImagePreview = new JLabel("");
        this.lblImagePreview.setHorizontalAlignment(0);
        this.lblImagePreview.setBorder(new EtchedBorder(1, null, null));
        this.lblImagePreview.setPreferredSize(new Dimension(100, 100));
        btnPanel.add((Component)this.lblImagePreview, "cell 1 0");
        JButton btnSelectImage = new JButton("...");
        btnSelectImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderTypeForm.this.doSelectImageFile();
            }
        });
        JButton btnClearImage = new JButton(Messages.getString("MenuItemForm.34"));
        btnClearImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderTypeForm.this.doClearImage();
            }
        });
        btnPanel.add((Component)btnSelectImage, "cell 1 0");
        btnPanel.add((Component)btnClearImage, "cell  1 0");
        JLabel lblButtonColor = new JLabel(Messages.getString("OrderTypeForm.22"));
        this.btnColorChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(POSUtil.getBackOfficeWindow(), Messages.getString("OrderTypeForm.23"), Color.WHITE);
                OrderTypeForm.this.btnColorChooser.setBackground(color);
                OrderTypeForm.this.btnTextColorChooser.setBackground(color);
            }
        });
        this.btnColorChooser.setPreferredSize(new Dimension(228, 40));
        btnPanel.add((Component)lblButtonColor, "cell 0 2");
        btnPanel.add((Component)this.btnColorChooser, "cell 1 2 ,grow");
        JLabel lblTxtColor = new JLabel(Messages.getString("OrderTypeForm.26"));
        this.btnTextColorChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(POSUtil.getBackOfficeWindow(), Messages.getString("OrderTypeForm.27"), Color.WHITE);
                OrderTypeForm.this.btnTextColorChooser.setForeground(color);
            }
        });
        this.btnTextColorChooser.setPreferredSize(new Dimension(228, 40));
        btnPanel.add((Component)lblTxtColor, "cell 0 3");
        btnPanel.add((Component)this.btnTextColorChooser, "cell 1 3 ,grow");
        this.showImageOnly = new JCheckBox(Messages.getString("OrderTypeForm.30"));
        btnPanel.add((Component)this.showImageOnly, "cell 1 4");
        this.tabbedPane.add(Messages.getString("OrderTypeForm.33"), btnPanel);
    }

    protected void doClearImage() {
        this.lblImagePreview.setIcon(null);
        this.lblImagePreview.putClientProperty("image", null);
    }

    @Override
    protected void updateView() {
        OrderType ordersType = (OrderType)this.getBean();
        if (ordersType == null) {
            this.tfName.setText("");
            this.chkEnabled.setSelected(false);
            return;
        }
        this.tfName.setText(ordersType.getName());
        if (ordersType.getId() == null) {
            this.chkEnabled.setSelected(true);
        } else {
            OrderTypeDAO.getInstance().initialize(ordersType);
            this.chkEnabled.setSelected(ordersType.isEnabled());
            this.chkShowTableSelection.setSelected(ordersType.isShowTableSelection());
            this.chkShowGuestSelection.setSelected(ordersType.isShowGuestSelection());
            this.chkShouldPrintToKitchen.setSelected(ordersType.isShouldPrintToKitchen());
            this.chkPrepaid.setSelected(ordersType.isPrepaid());
            this.chkCloseOnPaid.setSelected(ordersType.isCloseOnPaid());
            this.chkRequiredCustomerData.setSelected(ordersType.isRequiredCustomerData());
            this.chkShowInLoginScreen.setSelected(ordersType.isShowInLoginScreen());
            this.chkConsolidateItemsInReceipt.setSelected(ordersType.isConsolidateItemsInReceipt());
            this.chkAllowSeatBasedOrder.setSelected(ordersType.isAllowSeatBasedOrder());
            this.chkHideItemWithEmptyInventory.setSelected(ordersType.isHideItemWithEmptyInventory());
            this.chkHasForHereAndToGo.setSelected(ordersType.isHasForHereAndToGo());
            this.chkPreAuthCreditCard.setSelected(ordersType.isPreAuthCreditCard());
            this.chkEnableReorder.setSelected(ordersType.isEnableReorder());
            this.chkEnableCourse.setSelected(ordersType.isEnableCourse());
            this.btnTextColorChooser.setForeground(ordersType.getTextColor());
            this.btnColorChooser.setBackground(ordersType.getButtonColor());
            this.showImageOnly.setSelected(ordersType.isShowImageOnly());
            this.rbtnDelivery.setSelected(ordersType.isDelivery());
            this.rbtnPickup.setSelected(ordersType.isPickup());
            this.rbtnRetail.setSelected(ordersType.isRetailOrder());
            this.rbtnBarTab.setSelected(ordersType.isBarTab());
            this.chkRequiredDeliveryData.setSelected(ordersType.isRequiredDeliveryData());
            this.chkAssignDriver.setSelected(ordersType.isAssignDriver());
            ImageIcon orderTypeImage = ordersType.getScaledImage(80, 60);
            if (orderTypeImage != null) {
                this.lblImagePreview.setIcon(orderTypeImage);
                this.lblImagePreview.putClientProperty("image", this.convertImageAsFile(orderTypeImage));
            }
            this.selectedDeptList = new ArrayList<Department>(ordersType.getDepartments());
            this.chkbDeptList.selectItems(this.selectedDeptList);
            this.selectedTerminalTypes = new ArrayList<TerminalType>(ordersType.getTerminalTypes());
            this.chkbTerminalTypeList.selectItems(this.selectedTerminalTypes);
            this.selectedCategories = new ArrayList<MenuCategory>(ordersType.getCategories());
            this.chkbCategoryList.selectItems(this.selectedCategories);
            this.cbDefaultTG.setSelectedItem(ordersType.getDefaultTaxGroup());
            this.cbForHereTG.setSelectedItem(ordersType.getForHereTaxGroup());
            this.cbToGoTG.setSelectedItem(ordersType.getToGoTaxGroup());
        }
    }

    private File convertImageAsFile(ImageIcon orderTypeImage) {
        Image rImage = orderTypeImage.getImage();
        BufferedImage bufferedImage = new BufferedImage(rImage.getWidth(null), rImage.getHeight(null), 2);
        Graphics2D bGr = bufferedImage.createGraphics();
        bGr.drawImage(rImage, 0, 0, null);
        bGr.dispose();
        File outputfile = new File("saved.png");
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", outputfile);
        }
        catch (IOException e) {
            PosLog.error(this.getClass(), e);
        }
        return outputfile;
    }

    @Override
    protected boolean updateModel() {
        try {
            OrderType ordersType = (OrderType)this.getBean();
            if (ordersType == null) {
                return false;
            }
            String categoryName = this.tfName.getText();
            if (POSUtil.isBlankOrNull(categoryName)) {
                MessageDialog.showError(Messages.getString("MenuCategoryForm.26"));
                return false;
            }
            ordersType.setName(categoryName);
            ordersType.setEnabled(this.chkEnabled.isSelected());
            ordersType.setShowTableSelection(this.chkShowTableSelection.isSelected());
            ordersType.setShowGuestSelection(this.chkShowGuestSelection.isSelected());
            ordersType.setShouldPrintToKitchen(this.chkShouldPrintToKitchen.isSelected());
            ordersType.setPrepaid(this.chkPrepaid.isSelected());
            ordersType.setCloseOnPaid(this.chkCloseOnPaid.isSelected());
            ordersType.setDelivery(this.rbtnDelivery.isSelected());
            ordersType.setPickup(this.rbtnPickup.isSelected());
            ordersType.setRetailOrder(this.rbtnRetail.isSelected());
            ordersType.setBarTab(this.rbtnBarTab.isSelected());
            ordersType.setRequiredCustomerData(this.chkRequiredCustomerData.isSelected());
            ordersType.setRequiredDeliveryData(this.chkRequiredDeliveryData.isSelected());
            ordersType.setAssignDriver(this.chkAssignDriver.isSelected());
            ordersType.setShowInLoginScreen(this.chkShowInLoginScreen.isSelected());
            ordersType.setConsolidateItemsInReceipt(this.chkConsolidateItemsInReceipt.isSelected());
            ordersType.setAllowSeatBasedOrder(this.chkAllowSeatBasedOrder.isSelected());
            ordersType.setHideItemWithEmptyInventory(this.chkHideItemWithEmptyInventory.isSelected());
            ordersType.setHasForHereAndToGo(this.chkHasForHereAndToGo.isSelected());
            ordersType.setPreAuthCreditCard(this.chkPreAuthCreditCard.isSelected());
            ordersType.setSortOrder(this.tfSortOrder.getInteger());
            ordersType.setTextColorCode(this.btnTextColorChooser.getForeground().getRGB());
            ordersType.setButtonColorCode(this.btnColorChooser.getBackground().getRGB());
            ordersType.setShowImageOnly(this.showImageOnly.isSelected());
            ordersType.setEnableReorder(this.chkEnableReorder.isSelected());
            ordersType.setEnableCourse(this.chkEnableCourse.isSelected());
            File imageFile = (File)this.lblImagePreview.getClientProperty("image");
            if (imageFile != null) {
                ordersType.setImageData(POSUtil.convertImageToBlob(imageFile));
            } else {
                ordersType.setImageData(null);
            }
            ordersType.setDefaultTaxGroup((TaxGroup)this.cbDefaultTG.getSelectedItem());
            if (this.chkHasForHereAndToGo.isSelected()) {
                ordersType.setForHereTaxGroup((TaxGroup)this.cbForHereTG.getSelectedItem());
                ordersType.setToGoTaxGroup((TaxGroup)this.cbToGoTG.getSelectedItem());
            } else {
                ordersType.setForHereTaxGroup(null);
                ordersType.setToGoTaxGroup(null);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean save() {
        OrderType ordersType = null;
        try {
            if (!this.updateModel()) {
                return false;
            }
            ordersType = (OrderType)this.getBean();
            ordersType.setDepartments(POSUtil.copySelectedValues(ordersType.getDepartments(), this.chkbDeptList.getCheckedValuesAsSet()));
            ordersType.setTerminalTypes(POSUtil.copySelectedValues(ordersType.getTerminalTypes(), this.chkbTerminalTypeList.getCheckedValuesAsSet()));
            ordersType.setCategories(POSUtil.copySelectedValues(ordersType.getCategories(), this.chkbCategoryList.getCheckedValuesAsSet()));
            OrderTypeDAO.getInstance().saveOrUpdate(ordersType);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TerminalConfigurationView.40"));
            return true;
        }
        catch (ConstraintViolationException e) {
            MessageDialog.showError("Order type with same name already exists.");
            ordersType.setId(null);
            return false;
        }
        catch (Exception x) {
            MessageDialog.showError(x);
            return false;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JToggleButton source = (JToggleButton)e.getSource();
        if (source == this.rbtnDelivery) {
            if (this.rbtnDelivery.isSelected()) {
                this.chkRequiredCustomerData.setSelected(true);
                this.chkRequiredDeliveryData.setSelected(true);
                this.chkAssignDriver.setSelected(true);
            }
        } else if (source == this.rbtnPickup) {
            if (this.rbtnPickup.isSelected()) {
                this.chkRequiredCustomerData.setSelected(true);
            }
        } else if (source == this.chkHasForHereAndToGo) {
            if (this.chkHasForHereAndToGo.isSelected()) {
                this.lblForHereTG.setVisible(true);
                this.lblToGoTG.setVisible(true);
                this.cbForHereTG.setVisible(true);
                this.cbToGoTG.setVisible(true);
            } else {
                this.lblForHereTG.setVisible(false);
                this.lblToGoTG.setVisible(false);
                this.cbForHereTG.setVisible(false);
                this.cbToGoTG.setVisible(false);
            }
        } else if (source == this.rbtnBarTab) {
            if (this.rbtnBarTab.isSelected() && !this.chkShowTableSelection.isSelected()) {
                this.chkShowTableSelection.setSelected(this.rbtnBarTab.isSelected());
            }
        } else if (source == this.chkShowTableSelection && this.rbtnBarTab.isSelected() && !this.chkShowTableSelection.isSelected()) {
            this.rbButtonGroup.clearSelection();
        }
    }

    protected void doSelectImageFile() {
        FileNameExtensionFilter filter = new FileNameExtensionFilter("*.jpg , *.png , *.gif , *.jpeg", "jpg", "png", "gif", "jpeg");
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(filter);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileFilter(filter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileSelectionMode(0);
        int option = fileChooser.showOpenDialog(POSUtil.getBackOfficeWindow());
        if (option == 0) {
            File imageFile = fileChooser.getSelectedFile();
            long imageSizeChk = imageFile.length();
            if (imageSizeChk >= 0xA00000L) {
                POSMessageDialog.showError(Messages.getString("OrderTypeForm.40"));
                this.doSelectImageFile();
            }
            try {
                BufferedImage resizedImg = ImageIO.read(imageFile);
                Image scaledImage = POSUtil.getScaledImage(resizedImg, 100, 100);
                this.lblImagePreview.putClientProperty("image", imageFile);
                this.lblImagePreview.setIcon(new ImageIcon(scaledImage));
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        }
    }
}

