/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.Department;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.dao.CustomerGroupDAO;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.PriceRuleDAO;
import com.floreantpos.model.dao.PriceShiftDAO;
import com.floreantpos.model.dao.PriceTableDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.PriceShiftEntryDialog;
import com.floreantpos.ui.model.PriceTableForm;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class PriceRuleForm
extends BeanEditor<PriceRule> {
    private FixedLengthTextField tfName = new FixedLengthTextField();
    private FixedLengthTextField tfDescription = new FixedLengthTextField();
    private FixedLengthTextField tfCode = new FixedLengthTextField();
    private JComboBox cbOutlet = new JComboBox();
    private JComboBox cbDepartment = new JComboBox();
    private JComboBox cbSalesArea = new JComboBox();
    private JComboBox cbOrderType = new JComboBox();
    private JComboBox cbCustomerGroup = new JComboBox();
    private JComboBox cbPriceShift = new JComboBox();
    private JComboBox cbPriceList = new JComboBox();
    private JCheckBox chkActive = new JCheckBox("Active");

    public PriceRuleForm(PriceRule priceTable) {
        this.initComponents();
        this.initData();
        this.setBean(priceTable);
    }

    private void initData() {
        this.cbOutlet.setModel(this.getComboModel(OutletDAO.getInstance().findAll()));
        this.cbDepartment.setModel(this.getComboModel(DepartmentDAO.getInstance().findAll()));
        this.cbSalesArea.setModel(this.getComboModel(SalesAreaDAO.getInstance().findAll()));
        this.cbOrderType.setModel(this.getComboModel(OrderTypeDAO.getInstance().findAll()));
        this.cbCustomerGroup.setModel(this.getComboModel(CustomerGroupDAO.getInstance().findAll()));
        this.cbPriceShift.setModel(this.getComboModel(PriceShiftDAO.getInstance().findAll()));
        this.cbPriceList.setModel(new ComboBoxModel(PriceTableDAO.getInstance().findAll()));
        this.cbOutlet.setSelectedIndex(0);
        this.cbDepartment.setSelectedIndex(0);
        this.cbSalesArea.setSelectedIndex(0);
        this.cbOrderType.setSelectedIndex(0);
        this.cbCustomerGroup.setSelectedIndex(0);
        this.cbPriceShift.setSelectedIndex(0);
        if (this.cbPriceList.getModel().getSize() > 0) {
            this.cbPriceList.setSelectedIndex(0);
        }
    }

    private ComboBoxModel getComboModel(List items) {
        ArrayList<String> dataList = new ArrayList<String>();
        dataList.add("<All>");
        dataList.addAll(items);
        return new ComboBoxModel(dataList);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("fillx"));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JButton btnNewPriceShift = new JButton("...");
        JButton btnNewPriceList = new JButton("...");
        btnNewPriceShift.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PriceShiftEntryDialog dialog = new PriceShiftEntryDialog();
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    PriceShift shift = dialog.getPriceShift();
                    PriceRuleForm.this.cbPriceShift.addItem(shift);
                    PriceRuleForm.this.cbPriceShift.setSelectedItem(shift);
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        btnNewPriceList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PriceTableForm editor = new PriceTableForm(new PriceTable());
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.openWithScale(650, 600);
                    if (dialog.isCanceled()) {
                        return;
                    }
                    PriceTable priceTable = (PriceTable)editor.getBean();
                    PriceRuleForm.this.cbPriceList.addItem(priceTable);
                    PriceRuleForm.this.cbPriceList.setSelectedItem(priceTable);
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        this.tfName.setLength(30);
        this.tfDescription.setLength(255);
        this.tfCode.setLength(6);
        this.add(new JLabel("Name"));
        this.add((Component)this.tfName, "grow,wrap");
        this.add(new JLabel("Description"));
        this.add((Component)this.tfDescription, "grow,wrap");
        this.add(new JLabel("Code"));
        this.add((Component)this.tfCode, "grow,wrap");
        this.add(new JLabel("Outlet"));
        this.add((Component)this.cbOutlet, "grow,wrap");
        this.add(new JLabel("Department"));
        this.add((Component)this.cbDepartment, "grow,wrap");
        this.add(new JLabel("Sales Area"));
        this.add((Component)this.cbSalesArea, "grow,wrap");
        this.add(new JLabel("Order Type"));
        this.add((Component)this.cbOrderType, "grow,wrap");
        this.add(new JLabel("Customer Group"));
        this.add((Component)this.cbCustomerGroup, "grow,wrap");
        this.add(new JLabel("Price Shift"));
        this.add((Component)this.cbPriceShift, "grow,split 2");
        this.add((Component)btnNewPriceShift, "wrap");
        this.add(new JLabel("Price List"));
        this.add((Component)this.cbPriceList, "grow,split 2");
        this.add((Component)btnNewPriceList, "wrap");
        this.add((Component)this.chkActive, "skip 1,grow,wrap");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            PriceRule priceTable = (PriceRule)this.getBean();
            PriceRuleDAO.getInstance().saveOrUpdate(priceTable);
            return true;
        }
        catch (IllegalModelStateException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected void updateView() {
        PriceRule priceTable = (PriceRule)this.getBean();
        this.tfName.setText(priceTable.getName());
        this.tfDescription.setText(priceTable.getDescription());
        this.tfCode.setText(priceTable.getCode());
        this.chkActive.setSelected(priceTable.getId() == null ? true : priceTable.isActive());
        String all = "<All>";
        this.cbOutlet.setSelectedItem(priceTable.getOutlet() == null ? all : priceTable.getOutlet());
        this.cbDepartment.setSelectedItem(priceTable.getDepartment() == null ? all : priceTable.getDepartment());
        this.cbSalesArea.setSelectedItem(priceTable.getSalesArea() == null ? all : priceTable.getSalesArea());
        this.cbOrderType.setSelectedItem(priceTable.getOrderType() == null ? all : priceTable.getOrderType());
        this.cbCustomerGroup.setSelectedItem(priceTable.getCustomerGroup() == null ? all : priceTable.getCustomerGroup());
        this.cbPriceShift.setSelectedItem(priceTable.getPriceShift() == null ? all : priceTable.getPriceShift());
        this.cbPriceList.setSelectedItem(priceTable.getPriceTable());
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        PriceRule priceTable = (PriceRule)this.getBean();
        String name = this.tfName.getText();
        if (StringUtils.isEmpty((String)name)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Name cannot be empty.");
            return false;
        }
        Object selectedPriceList = this.cbPriceList.getSelectedItem();
        if (selectedPriceList == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select price list.");
            return false;
        }
        priceTable.setName(name);
        priceTable.setDescription(this.tfDescription.getText());
        priceTable.setCode(this.tfCode.getText());
        priceTable.setActive(this.chkActive.isSelected());
        priceTable.setOutlet((Outlet)this.getValue(this.cbOutlet.getSelectedItem()));
        priceTable.setDepartment((Department)this.getValue(this.cbDepartment.getSelectedItem()));
        priceTable.setSalesArea((SalesArea)this.getValue(this.cbSalesArea.getSelectedItem()));
        priceTable.setCustomerGroup((CustomerGroup)this.getValue(this.cbCustomerGroup.getSelectedItem()));
        priceTable.setPriceShift((PriceShift)this.getValue(this.cbPriceShift.getSelectedItem()));
        priceTable.setOrderType((OrderType)this.getValue(this.cbOrderType.getSelectedItem()));
        priceTable.setPriceTable((PriceTable)selectedPriceList);
        return true;
    }

    private Object getValue(Object selectedItem) {
        if (selectedItem instanceof String) {
            return null;
        }
        return selectedItem;
    }

    @Override
    public String getDisplayText() {
        if (((PriceRule)this.getBean()).getId() == null) {
            return "New Price Rule";
        }
        return "Edit Price Rule";
    }
}

