/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.order;

import com.floreantpos.Messages;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.swing.ListTableModel;
import java.util.List;

public class CourseOrganizeTableModel
extends ListTableModel<ITicketItem> {
    protected String[] columnNames = new String[]{Messages.getString("TicketViewerTableModel.0")};

    public void setItems(List<ITicketItem> items) {
        if (items == null) {
            super.setRows(null);
            return;
        }
        this.setRows(items);
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ITicketItem ticketItem = (ITicketItem)this.getRowData(rowIndex);
        if (ticketItem == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return ticketItem.getNameDisplay();
            }
            case 1: {
                return ticketItem.getSubTotalAmountDisplay();
            }
        }
        return null;
    }

    public Object delete(int index) {
        if (index < 0 || index >= this.getRowCount()) {
            return null;
        }
        Object object = this.getRowData(index);
        super.deleteItem(index);
        this.fireTableRowsDeleted(index, index);
        return object;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void update() {
        this.fireTableDataChanged();
    }

    public void insertRow(int idx, Object value) {
        ITicketItem item = (ITicketItem)value;
        this.getRows().add(idx, item);
        this.fireTableDataChanged();
    }
}

