/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.tableselection;

import com.floreantpos.Messages;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.ShopTableStatusDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.tableselection.TableSelectionListener;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import org.apache.commons.lang.StringUtils;

public class DefaultShopTableButton
extends PosButton
implements ActionListener {
    private ShopTable shopTable;
    private User user;
    private Ticket ticket;
    private TableSelectionListener listener;
    public List<Integer> removeTableListModel = new ArrayList<Integer>();

    public DefaultShopTableButton(ShopTable shopTable) {
        this.shopTable = shopTable;
        this.setPreferredSize(PosUIManager.getSize(157, 138));
        this.setBorder(null);
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ShopTableStatus shopTaleStatus = this.shopTable.getStatus();
        if (!TerminalDAO.getInstance().isVersionEqual(ShopTableStatus.class, shopTaleStatus.getId(), shopTaleStatus.getVersion())) {
            POSMessageDialog.showMessage("Table has been changed in other terminal. Please reload this window and try again.");
            return;
        }
        if (this.listener == null) {
            return;
        }
        AbstractButton selectedActionButton = this.listener.getTableActionButton();
        if (selectedActionButton == null) {
            shopTaleStatus = ShopTableStatusDAO.getInstance().get(shopTaleStatus.getId());
            this.listener.tableSelected(this.shopTable);
        } else {
            POSToggleButton toggleActionButton = (POSToggleButton)selectedActionButton;
            Object ticketAction = toggleActionButton.getClientProperty("ticketAction");
            if (ticketAction == null) {
                this.doGroupOrUngroupTable(toggleActionButton);
            } else {
                PosAction action = (PosAction)toggleActionButton.getClientProperty("ticketAction");
                if (shopTaleStatus.getTicketId() == null) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DefaultTableSelectionView.2"));
                } else {
                    this.listener.tableActionSelected(this.shopTable, action, this.initializeTicket());
                }
            }
        }
        this.updateView();
        this.listener.clearSelection();
    }

    private void doGroupOrUngroupTable(POSToggleButton toggleActionButton) {
        ShopTableStatus shopTaleStatus = this.shopTable.getStatus();
        String buttonAction = (String)toggleActionButton.getClientProperty("buttonAction");
        if (buttonAction.equals("GROUP")) {
            if (shopTaleStatus.getTicketId() != null) {
                return;
            }
            List list = this.listener.getAddedTableList();
            if (list.contains(shopTaleStatus.getId())) {
                return;
            }
            list.add(shopTaleStatus.getId());
        } else if (buttonAction.equals("UNGROUP")) {
            if (shopTaleStatus.getTicketId() == null) {
                return;
            }
            List list = this.listener.getReleasesTableList();
            for (Integer tableId : list) {
                Ticket ticket = this.listener.getTicket(tableId);
                if (shopTaleStatus.getTicketId().equals(ticket.getId())) continue;
                return;
            }
            if (list.size() >= this.getTicket().getTableNumbers().size() - 1) {
                return;
            }
            list.add(shopTaleStatus.getId());
        } else if (buttonAction.equals("RELEASE")) {
            if (shopTaleStatus.getTicketId() == null) {
                POSMessageDialog.showMessage("No Order has been submitted yet");
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Are you sure to release table?", "Release table:");
            if (0 != option) {
                return;
            }
            ShopTable shopTable = this.getShopTable();
            shopTable.setTableStatus(TableStatus.Available);
            this.removeTableListModel.add(shopTable.getId());
            ShopTableDAO.getInstance().updateTableStatus(this.removeTableListModel, null, null, false);
            this.setTicket(null);
        }
    }

    public void setTableSelectionListener(TableSelectionListener listener) {
        this.listener = listener;
    }

    public int getId() {
        return this.shopTable.getId();
    }

    public void setShopTable(ShopTable shopTable) {
        this.shopTable = shopTable;
    }

    public ShopTable getShopTable() {
        return this.shopTable;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultShopTableButton)) {
            return false;
        }
        DefaultShopTableButton that = (DefaultShopTableButton)obj;
        return this.shopTable.equals(that.shopTable);
    }

    public int hashCode() {
        return this.shopTable.hashCode();
    }

    @Override
    public String toString() {
        return this.shopTable.toString();
    }

    public void updateView() {
        ShopTableStatus shopTaleStatus = this.shopTable.getStatus();
        TableStatus tableStatus = shopTaleStatus.getTableStatus();
        this.setBackground(tableStatus == null ? Color.WHITE : tableStatus.getBgColor());
        this.setForeground(tableStatus == null ? Color.BLACK : tableStatus.getTextColor());
        if (this.listener != null && (this.listener.getAddedTableList().contains(shopTaleStatus.getId()) || this.listener.getReleasesTableList().contains(shopTaleStatus.getId()))) {
            this.setBackground(Color.GREEN);
            this.setForeground(Color.BLACK);
        }
        String text = "<html><center><font size='36'>";
        text = text + this.shopTable.getTableNumber();
        if (shopTaleStatus.getTicketId() != null && StringUtils.isNotEmpty((String)shopTaleStatus.getUserId())) {
            text = text + "</font><strong>" + shopTaleStatus.getUserName();
            if (!shopTaleStatus.getUserId().toString().equals(Application.getCurrentUser().getId().toString())) {
                this.setBackground(new Color(139, 0, 139));
                this.setForeground(Color.WHITE);
            }
        }
        if (StringUtils.isNotEmpty((String)shopTaleStatus.getTicketId())) {
            text = text + "<br>Token# " + shopTaleStatus.getTokenNo();
        }
        text = text + "<strong></center></html>";
        this.setText(text);
    }

    public void setUser(User user) {
        if (user != null) {
            this.user = user;
        }
    }

    public User getUser() {
        String ticketUserId;
        ShopTableStatus shopTaleStatus = this.shopTable.getStatus();
        User currentUser = Application.getCurrentUser();
        String currentUserId = currentUser.getId();
        if (currentUserId.equals(ticketUserId = shopTaleStatus.getUserId())) {
            this.user = currentUser;
        }
        if (this.user == null) {
            this.user = UserDAO.getInstance().get(this.user.getId());
        }
        return this.user;
    }

    public boolean hasUserAccess() {
        User ticketUser = this.getUser();
        if (ticketUser == null) {
            return false;
        }
        User currentUser = Application.getCurrentUser();
        if (currentUser.hasPermission(UserPermission.PERFORM_MANAGER_TASK) || currentUser.hasPermission(UserPermission.PERFORM_ADMINISTRATIVE_TASK)) {
            return true;
        }
        String password = PasswordEntryDialog.show(Application.getPosWindow(), Messages.getString("PosAction.0"));
        if (StringUtils.isEmpty((String)password)) {
            return false;
        }
        String inputUserId = UserDAO.getInstance().findUserBySecretKey(password).getId();
        if (!inputUserId.equals(ticketUser.getId())) {
            POSMessageDialog.showError(Application.getPosWindow(), "Incorrect password");
            return false;
        }
        return true;
    }

    public void initializeUser() {
        ShopTableStatus shopTaleStatus = this.shopTable.getStatus();
        String userId = shopTaleStatus.getUserId();
        if (StringUtils.isEmpty((String)userId)) {
            return;
        }
        if (this.user != null && this.user.getId().equals(userId)) {
            return;
        }
        this.user = UserDAO.getInstance().get(shopTaleStatus.getUserId());
    }

    private Ticket initializeTicket() {
        ShopTableStatus shopTaleStatus = this.shopTable.getStatus();
        String ticketId = shopTaleStatus.getTicketId();
        if (StringUtils.isEmpty((String)ticketId)) {
            this.ticket = null;
        }
        if (this.ticket != null && this.ticket.getId().equals(shopTaleStatus.getTicketId())) {
            return this.ticket;
        }
        this.ticket = TicketService.getTicket(shopTaleStatus.getTicketId());
        return this.ticket;
    }

    public Ticket getTicket() {
        return this.initializeTicket();
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
        ShopTableStatus shopTaleStatus = this.shopTable.getStatus();
        if (ticket == null) {
            shopTaleStatus.setTableStatus(TableStatus.Available);
            shopTaleStatus.setTicketId(null);
        } else {
            shopTaleStatus.setTableStatus(TableStatus.Seat);
            shopTaleStatus.setTableTicket(ticket.getId(), ticket.getTokenNo(), ticket.getOwner().getId(), ticket.getOwner().getFirstName());
        }
        this.updateView();
    }
}

