/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.ticket;

import com.floreantpos.swing.PosUIManager;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class MultiLineTableCellRenderer
extends JTextArea
implements TableCellRenderer {
    public MultiLineTableCellRenderer() {
        this(15, 2);
    }

    public MultiLineTableCellRenderer(int verticalGap, int horizontalGap) {
        this.setOpaque(true);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setSize(PosUIManager.getSize(200, 30));
        this.setText("----");
        this.setBorder(new EmptyBorder(PosUIManager.getSize(verticalGap), PosUIManager.getSize(horizontalGap), verticalGap, horizontalGap));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setFont(table.getFont());
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        if (column == 0) {
            int colWidth = table.getColumnModel().getColumn(column).getWidth();
            Dimension size = this.getSize();
            if (colWidth != size.width) {
                size.width = colWidth;
                this.setSize(size);
            }
        }
        if (value != null) {
            this.setText(value.toString());
        } else {
            this.setText("");
        }
        if (column == 0) {
            int height = this.getPreferredSize().height;
            if (table.getRowHeight(row) != height) {
                table.setRowHeight(row, height);
            }
        }
        return this;
    }
}

