/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.ticket;

import com.floreantpos.IconFactory;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.ticket.TicketViewerTableCellRenderer;
import com.floreantpos.ui.ticket.TicketViewerTableModel;
import com.floreantpos.ui.views.order.actions.TicketEditListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TicketViewerTable
extends JTable
implements ComponentListener {
    private TicketViewerTableModel model = new TicketViewerTableModel(this);
    private final DefaultListSelectionModel selectionModel;
    private final TicketViewerTableCellRenderer cellRenderer;
    public int rowTobeSelectedOnResize = -1;
    private boolean editable;
    private ArrayList<TicketEditListener> ticketEditListenerList;

    public TicketViewerTable() {
        this((Ticket)null);
        this.addComponentListener(this);
    }

    public TicketViewerTable(Ticket ticket) {
        this(ticket, 15, 2);
    }

    public TicketViewerTable(Ticket ticket, int verticalGap, int horizontalGap) {
        this.setModel(this.model);
        this.selectionModel = new DefaultListSelectionModel();
        this.selectionModel.setSelectionMode(0);
        this.setGridColor(Color.LIGHT_GRAY);
        this.setSelectionModel(this.selectionModel);
        this.setCellSelectionEnabled(false);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setAutoscrolls(true);
        this.setShowGrid(true);
        this.setBorder(null);
        this.setFocusable(false);
        this.cellRenderer = new TicketViewerTableCellRenderer(verticalGap, horizontalGap);
        this.resizeTableColumns();
        this.setTicket(ticket);
        this.ticketEditListenerList = new ArrayList();
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (this.editable && column == 0 && this.model.get(row) instanceof TicketItemDiscount) {
            return super.getCellRenderer(row, column);
        }
        return this.cellRenderer;
    }

    public TicketViewerTableCellRenderer getRenderer() {
        return this.cellRenderer;
    }

    private boolean isTicketNull() {
        Ticket ticket = this.getTicket();
        if (ticket == null) {
            return true;
        }
        return ticket.getTicketItems() == null;
    }

    public void scrollUp() {
        if (this.isTicketNull()) {
            return;
        }
        int selectedRow = this.getSelectedRow();
        if (selectedRow == 0) {
            return;
        }
        Rectangle cellRect = this.getCellRect(selectedRow - 1, 0, true);
        this.scrollRectToVisible(cellRect);
        cellRect = this.getCellRect(--selectedRow, 0, true);
        this.scrollRectToVisible(cellRect);
        this.selectionModel.addSelectionInterval(selectedRow, selectedRow);
    }

    public void scrollUpTen() {
        if (this.isTicketNull()) {
            return;
        }
        int selectedRow = this.getSelectedRow();
        if (selectedRow == 0) {
            return;
        }
        selectedRow = selectedRow - 10 < 0 ? 0 : (selectedRow -= 10);
        this.selectionModel.addSelectionInterval(selectedRow, selectedRow);
        Rectangle cellRect = this.getCellRect(selectedRow, 0, false);
        this.scrollRectToVisible(cellRect);
    }

    public void scrollDown() {
        if (this.isTicketNull()) {
            return;
        }
        int selectedRow = this.getSelectedRow();
        if (selectedRow >= this.model.getItemCount() - 1) {
            return;
        }
        Rectangle cellRect = this.getCellRect(selectedRow + 1, 0, true);
        this.scrollRectToVisible(cellRect);
        cellRect = this.getCellRect(++selectedRow, 0, true);
        this.scrollRectToVisible(cellRect);
        this.selectionModel.addSelectionInterval(selectedRow, selectedRow);
    }

    public void scrollDownTen() {
        if (this.isTicketNull()) {
            return;
        }
        int selectedRow = this.getSelectedRow();
        selectedRow = selectedRow > this.model.getItemCount() - 9 ? this.model.getRowCount() - 2 : (selectedRow += 9);
        Rectangle cellRect = this.getCellRect(selectedRow + 1, 0, true);
        this.scrollRectToVisible(cellRect);
        cellRect = this.getCellRect(++selectedRow, 0, true);
        this.scrollRectToVisible(cellRect);
        this.selectionModel.addSelectionInterval(selectedRow, selectedRow);
    }

    public void scrollLast() {
        Rectangle cellRect = this.getCellRect(this.getRowCount() - 1, 0, true);
        this.scrollRectToVisible(cellRect);
    }

    public void increaseItemAmount(TicketItem ticketItem) {
        double itemCount = ticketItem.getQuantity();
        ticketItem.setQuantity(itemCount += 1.0);
        this.fireTicketItemUpdated(this.getTicket(), ticketItem);
        this.repaint();
    }

    public boolean increaseFractionalUnit(double selectedQuantity) {
        int selectedRow = this.getSelectedRow();
        if (selectedRow < 0) {
            return false;
        }
        if (selectedRow >= this.model.getItemCount()) {
            return false;
        }
        Object object = this.model.get(selectedRow);
        if (object instanceof TicketItem) {
            TicketItem ticketItem = (TicketItem)object;
            ticketItem.setQuantity(selectedQuantity);
            return true;
        }
        return false;
    }

    public boolean increaseItemAmount() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow < 0) {
            return false;
        }
        if (selectedRow >= this.model.getItemCount()) {
            return false;
        }
        ITicketItem iTicketItem = (ITicketItem)this.model.get(selectedRow);
        if (iTicketItem.isPrintedToKitchen().booleanValue()) {
            return false;
        }
        if (iTicketItem instanceof TicketItem) {
            TicketItem ticketItem = (TicketItem)iTicketItem;
            double itemCount = ticketItem.getQuantity();
            ticketItem.setQuantity(itemCount += 1.0);
            if (ticketItem.isHasModifiers().booleanValue()) {
                List<TicketItemModifier> ticketItemModifiers = ticketItem.getTicketItemModifiers();
                for (TicketItemModifier ticketItemModifier : ticketItemModifiers) {
                    ticketItemModifier.setItemQuantity(ticketItemModifier.getItemQuantity() + 1.0);
                }
            }
            return true;
        }
        return false;
    }

    public boolean decreaseItemAmount() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow < 0) {
            return false;
        }
        if (selectedRow >= this.model.getItemCount()) {
            return false;
        }
        ITicketItem iTicketItem = (ITicketItem)this.model.get(selectedRow);
        if (iTicketItem.isPrintedToKitchen().booleanValue()) {
            return false;
        }
        if (iTicketItem instanceof TicketItem) {
            TicketItem ticketItem = (TicketItem)iTicketItem;
            double itemCount = ticketItem.getQuantity();
            if (itemCount <= 1.0) {
                return false;
            }
            ticketItem.setQuantity(itemCount -= 1.0);
            this.fireTicketItemUpdated(this.getTicket(), ticketItem);
            if (ticketItem.isHasModifiers().booleanValue()) {
                List<TicketItemModifier> ticketItemModifiers = ticketItem.getTicketItemModifiers();
                for (TicketItemModifier ticketItemModifier : ticketItemModifiers) {
                    ticketItemModifier.setItemQuantity(ticketItemModifier.getItemQuantity() - 1.0);
                }
            }
            return true;
        }
        return false;
    }

    public void setTicket(Ticket ticket) {
        this.model.setTicket(ticket);
        this.rowTobeSelectedOnResize = -1;
        Rectangle cellRect = this.getCellRect(0, 0, true);
        this.scrollRectToVisible(cellRect);
        this.selectionModel.addSelectionInterval(0, 0);
    }

    public Ticket getTicket() {
        return this.model.getTicket();
    }

    public void addTicketItem(TicketItem ticketItem) {
        ticketItem.setTicket(this.getTicket());
        this.rowTobeSelectedOnResize = this.model.addTicketItem(ticketItem);
        this.fireTicketItemUpdated(this.getTicket(), ticketItem);
    }

    public void addTicketDiscount(TicketDiscount ticketDiscount) {
        this.model.addTicketDiscount(ticketDiscount);
    }

    public Object deleteSelectedItem() {
        int selectedRow = this.getSelectedRow();
        Object delete = this.model.delete(selectedRow);
        this.rowTobeSelectedOnResize = -1;
        if (delete instanceof TicketItem) {
            this.fireTicketItemUpdated(this.getTicket(), (TicketItem)delete);
        }
        return delete;
    }

    public boolean containsTicketItem(TicketItem ticketItem) {
        return this.model.containsTicketItem(ticketItem);
    }

    public void delete(int index) {
        this.model.delete(index);
    }

    public ITicketItem get(int index) {
        return (ITicketItem)this.model.get(index);
    }

    public ITicketItem getSelected() {
        int index = this.getSelectedRow();
        return (ITicketItem)this.model.get(index);
    }

    public void addAllTicketItem(TicketItem ticketItem) {
        this.model.addAllTicketItem(ticketItem);
    }

    public void removeModifier(TicketItem parent, TicketItemModifier modifier) {
        this.model.removeModifier(parent, modifier);
    }

    public void updateView() {
        int selectedRow = this.getSelectedRow();
        this.model.update();
        try {
            this.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getActualRowCount() {
        return this.model.getActualRowCount();
    }

    public void selectLast() {
        int actualRowCount = this.getActualRowCount() - 1;
        this.selectionModel.addSelectionInterval(actualRowCount, actualRowCount);
        Rectangle cellRect = this.getCellRect(actualRowCount, 0, true);
        this.scrollRectToVisible(cellRect);
    }

    public void selectRow(int index) {
        if (index < 0 || index >= this.getActualRowCount()) {
            index = 0;
        }
        Rectangle cellRect = this.getCellRect(index, 0, true);
        this.scrollRectToVisible(cellRect);
        this.selectionModel.addSelectionInterval(index, index);
    }

    @Override
    public TicketViewerTableModel getModel() {
        return this.model;
    }

    private List<TicketItem> getRowByValue(TicketViewerTableModel model) {
        ArrayList<TicketItem> ticketItems = new ArrayList<TicketItem>();
        for (int i = 0; i <= model.getRowCount(); ++i) {
            Object value = model.get(i);
            if (!(value instanceof TicketItem)) continue;
            TicketItem ticketItem = (TicketItem)value;
            ticketItems.add(ticketItem);
        }
        return ticketItems;
    }

    public List<TicketItem> getTicketItems() {
        return this.getRowByValue(this.model);
    }

    public TicketItem getTicketItem() {
        return (TicketItem)this.getSelected();
    }

    public void setModel(TicketViewerTableModel dataModel) {
        super.setModel(dataModel);
        this.model = dataModel;
        this.revalidate();
    }

    private void resizeTableColumns() {
        this.setAutoResizeMode(4);
        this.setColumnWidth(1, PosUIManager.getSize(80));
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setMinWidth(width);
    }

    @Override
    protected void resizeAndRepaint() {
        if (this.getIgnoreRepaint()) {
            return;
        }
        super.resizeAndRepaint();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.rowTobeSelectedOnResize != -1) {
            this.selectRow(this.rowTobeSelectedOnResize);
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public void setVisibleDeleteButton(int cloumn) {
        this.editable = true;
        this.model.setEditable(this.editable);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = Integer.parseInt(e.getActionCommand());
                ITicketItem item = (ITicketItem)TicketViewerTable.this.model.get(row);
                if (item instanceof TicketItemDiscount) {
                    TicketViewerTable.this.model.delete(row);
                }
            }
        };
        ButtonColumn coloum = new ButtonColumn(this, action, cloumn){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JPanel panel = (JPanel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                int verticalGap = PosUIManager.getSize(15);
                int horizontalGap = PosUIManager.getSize(2);
                ITicketItem item = (ITicketItem)TicketViewerTable.this.model.get(row);
                PosButton button = (PosButton)panel.getComponent(0);
                button.setOpaque(false);
                button.setBorder(new EmptyBorder(verticalGap, horizontalGap, verticalGap, horizontalGap));
                if (item instanceof TicketItemDiscount) {
                    button.setIcon(IconFactory.getIcon("/ui_icons/", "delete-icon.png"));
                } else {
                    button.setIcon(null);
                }
                table.setRowHeight(row, table.getRowHeight(0));
                return panel;
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return super.getTableCellEditorComponent(table, value, false, row, column);
            }
        };
        coloum.showColumnValueInLabel(true);
    }

    public void addTicketUpdateListener(TicketEditListener l) {
        this.ticketEditListenerList.add(l);
    }

    public void removeTicketUpdateListener(TicketEditListener l) {
        this.ticketEditListenerList.remove(l);
    }

    public void fireTicketItemUpdated(Ticket ticket, TicketItem ticketItem) {
        for (TicketEditListener listener : this.ticketEditListenerList) {
            listener.itemAdded(ticket, ticketItem);
        }
    }
}

