/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.ticket;

import com.floreantpos.model.Ticket;
import com.floreantpos.model.VoidItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class VoidItemViewerTableModel
extends AbstractTableModel {
    protected VoidItem voidItem;
    protected final HashMap<String, VoidItem> tableRows = new LinkedHashMap<String, VoidItem>();
    protected String[] columnNames = new String[]{"Item Name", "Void Reason", "Item Wasted", "Unit", "Tax", "Price"};
    List<VoidItem> voidItemList = new ArrayList<VoidItem>();

    public VoidItemViewerTableModel(JTable table) {
        this(table, null);
    }

    public VoidItemViewerTableModel(JTable table, Ticket ticket) {
    }

    public VoidItem get(int index) {
        return this.voidItemList.get(index);
    }

    public void add(VoidItem group) {
        if (this.voidItemList == null) {
            this.voidItemList = new ArrayList<VoidItem>();
        }
        this.voidItemList.add(group);
        this.fireTableDataChanged();
    }

    public void remove(int index) {
        if (this.voidItemList == null) {
            return;
        }
        this.voidItemList.remove(index);
        this.fireTableDataChanged();
    }

    public List<VoidItem> getItems() {
        return this.voidItemList;
    }

    public void remove(VoidItem voidItem) {
        if (this.voidItemList == null) {
            return;
        }
        this.voidItemList.remove(voidItem);
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this.voidItemList == null) {
            return 0;
        }
        return this.voidItemList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        VoidItem voidItem = this.voidItemList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return voidItem.getMenuItemName();
            }
            case 1: {
                return voidItem.getVoidReason();
            }
            case 2: {
                return voidItem.isItemWasted();
            }
            case 3: {
                return voidItem.getQuantity();
            }
            case 4: {
                return voidItem.getTaxAmount();
            }
            case 5: {
                return voidItem.getTotalPrice();
            }
        }
        return null;
    }

    public void updateVoidItem(VoidItem voidItem) {
        VoidItem voidItemData2 = null;
        for (VoidItem voidItemData2 : this.voidItemList) {
            if (voidItemData2.getMenuItemId() != voidItem.getMenuItemId()) continue;
            voidItemData2.setQuantity(voidItemData2.getQuantity() + voidItem.getQuantity());
        }
        if (voidItemData2 != null) {
            this.voidItemList.clear();
            this.voidItemList.add(voidItemData2);
        }
        this.fireTableDataChanged();
    }

    public boolean containsVoidItem(VoidItem voidItem) {
        for (VoidItem item : this.voidItemList) {
            if (item.getId() != voidItem.getId()) continue;
            return true;
        }
        return false;
    }

    public void update() {
        this.fireTableDataChanged();
    }
}

