/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.StoreAlreadyOpenException;
import com.floreantpos.actions.DrawerAssignmentAction;
import com.floreantpos.actions.ServerSummaryReportAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.DeclaredTips;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.EmployeeInOutHistory;
import com.floreantpos.model.Shift;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.DeclaredTipsDAO;
import com.floreantpos.model.dao.EmployeeInOutHistoryDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.CashDrawerReportDialog;
import com.floreantpos.ui.dialog.ClockedInUserListDialog;
import com.floreantpos.ui.dialog.DrawerAndStaffBankReportDialog;
import com.floreantpos.ui.dialog.GratuityDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.dialog.ServerOpenTicketListDialog;
import com.floreantpos.ui.dialog.TipsDeclarationDialog;
import com.floreantpos.ui.forms.GeneratePasswordDialog;
import com.floreantpos.ui.views.LoginView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.payment.AuthorizableTicketBrowser;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftUtil;
import com.floreantpos.util.StoreUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.LogFactory;

public class ClockInOutDialog
extends POSDialog {
    private static final SimpleDateFormat timeFormat = new SimpleDateFormat("hh:mm:ss aaa");
    private static final SimpleDateFormat dateFormat2 = new SimpleDateFormat("dd MMM, hh:mm aaa");
    private Timer clockTimer = new Timer(1000, new ClockTimerHandler());
    private PosButton btnChangePassword;
    private JLabel lblPicture;
    private JLabel lblUserName;
    private JLabel lblUserType;
    private JLabel lblCurrentTimeInfo;
    private JLabel lblTime;
    private JLabel lblRestaurantName;
    private JLabel lblUser;
    private JLabel lblTerminal;
    private JLabel lblOpenStoreStatus;
    private PosButton btnOpenStore;
    private PosButton btnStoreStatus;
    private PosButton btnClockIn;
    private PosButton btnClockOut;
    private PosButton btnDriverIn;
    private PosButton btnNoSale = new PosButton(Messages.getString("ManagerDialog.1"));
    private PosButton btnCancel;
    private PosButton btnStaffBankStatus;
    private PosButton btnShowClockedInUsers;
    private PosButton btnAssignDrawer;
    private PosButton btnServerSummary;
    private PosButton btnTerminalStatus;
    private PosButton btnStartStaffBank;
    private PosButton btnOpenTickets;
    private JPanel loginRoleSelectionPanel;
    private PosButton btnTipsManagement;
    private PosButton btnDeclareTips;
    private PosButton btnAuthorize = new PosButton(POSConstants.AUTHORIZE_BUTTON_TEXT);
    private User currentUser;
    private boolean loginMode;
    private static ClockInOutDialog instance;
    private JLabel lblCurrentShift;
    private JLabel lblUserClockedStatus;
    private PosButton btnExit;
    private JPanel cashDrawerButtonPanel;

    public ClockInOutDialog() {
        super(Application.getPosWindow());
        this.setLayout(new BorderLayout(5, 5));
        int width = PosUIManager.getSize(250);
        Dimension size = Application.getPosWindow().getSize();
        String wrap = "";
        if (size.width < 1390) {
            wrap = ",wrap";
            width = 190;
        }
        JPanel contentPanel = new JPanel((LayoutManager)new MigLayout("fill,ins 10 20 10 20,hidemode 3", "[][grow][]", ""));
        JPanel leftPictureAndInfoPanel = new JPanel((LayoutManager)new MigLayout("wrap 1,filly,ins 0", "", "[grow][]"));
        JPanel userProfilePanel = new JPanel((LayoutManager)new MigLayout("wrap 1,center"));
        this.lblPicture = new JLabel("");
        this.lblPicture.setBorder(BorderFactory.createLineBorder(new Color(0.0f, 0.0f, 0.0f, 0.1f), 5));
        this.lblUserName = new JLabel("");
        this.lblUserType = new JLabel("");
        Font f = this.lblUserName.getFont().deriveFont(1);
        this.lblUserName.setFont(f);
        this.lblUserType.setFont(f);
        this.btnChangePassword = new PosButton("CHANGE PASSWORD");
        this.btnChangePassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClockInOutDialog.this.doChangePassword();
            }
        });
        userProfilePanel.add((Component)this.lblPicture, "center");
        userProfilePanel.add((Component)this.lblUserName, "center");
        userProfilePanel.add((Component)this.lblUserType, "center");
        JPanel leftProfilePanel = new JPanel(new BorderLayout());
        leftProfilePanel.setBorder(BorderFactory.createTitledBorder(null, "User Profile", 2, 2));
        JPanel changePassPanel = new JPanel((LayoutManager)new MigLayout("center,ins 0,hidemode 3,fillx", "", ""));
        changePassPanel.add((Component)this.btnChangePassword, "growx, gapleft 6,gapright 6,gapbottom 2");
        leftProfilePanel.add((Component)userProfilePanel, "Center");
        leftProfilePanel.add((Component)changePassPanel, "South");
        JPanel messagePanel = new JPanel(new BorderLayout());
        JLabel lblMessage = new JLabel();
        messagePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, "Message", 2, 2), BorderFactory.createEmptyBorder(1, 2, 1, 2)));
        leftPictureAndInfoPanel.add((Component)leftProfilePanel, "aligny top,w " + width + "!,grow");
        JTextArea txtMessage = new JTextArea(4, 4);
        txtMessage.setPreferredSize(new Dimension(0, 50));
        txtMessage.setLineWrap(true);
        messagePanel.add(lblMessage);
        contentPanel.add((Component)leftPictureAndInfoPanel, "growy");
        JPanel clockInOutActionPanel = new JPanel(new BorderLayout());
        clockInOutActionPanel.setBorder(new EmptyBorder(0, 5, 5, 5));
        this.lblCurrentTimeInfo = new JLabel();
        this.btnOpenStore = new PosButton("<html><center><h4>OPEN STORE & </h4>" + Messages.getString("ClockInOutAction.5") + "</center></html>");
        this.btnStoreStatus = new PosButton("STORE STATUS");
        this.btnOpenTickets = new PosButton("OPEN TICKETS");
        this.btnClockIn = new PosButton(Messages.getString("ClockInOutAction.5"));
        this.btnClockOut = new PosButton(Messages.getString("ClockInOutAction.6"));
        this.btnDriverIn = new PosButton("DRIVER IN");
        this.btnExit = new PosButton("EXIT");
        this.lblTime = new JLabel("");
        StringBuilder sb = new StringBuilder();
        sb.append(timeFormat.format(Calendar.getInstance().getTime()));
        this.lblTime.setText(sb.toString());
        this.lblTime.setHorizontalAlignment(0);
        JPanel centerPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)centerPanel, "grow");
        JPanel attendancePanel = new JPanel((LayoutManager)new MigLayout("wrap 1,hidemode 3,fill", "", "[][grow][][][]"));
        attendancePanel.setBorder(BorderFactory.createTitledBorder(null, "Attendance", 2, 2));
        Dimension btnSize = PosUIManager.getSize(130, 120);
        this.btnClockIn.setPreferredSize(btnSize);
        this.btnClockOut.setPreferredSize(btnSize);
        this.btnDriverIn.setPreferredSize(btnSize);
        this.btnOpenStore.setPreferredSize(btnSize);
        this.btnClockIn.setIcon(IconFactory.getIcon("/ui_icons/", "clock_out.png"));
        this.btnClockOut.setIcon(IconFactory.getIcon("/ui_icons/", "clock_out.png"));
        this.btnOpenStore.setIcon(IconFactory.getIcon("/ui_icons/", "clock_out.png"));
        this.btnClockIn.setVerticalTextPosition(3);
        this.btnClockIn.setHorizontalTextPosition(0);
        this.btnOpenStore.setHorizontalTextPosition(0);
        this.btnOpenStore.setVerticalTextPosition(3);
        this.btnClockOut.setVerticalTextPosition(3);
        this.btnClockOut.setHorizontalTextPosition(0);
        Font font = new Font(this.btnClockIn.getFont().getName(), 1, 20);
        this.btnClockIn.setFont(font);
        this.btnClockOut.setFont(font);
        this.btnDriverIn.setFont(font);
        this.btnOpenStore.setFont(font);
        this.lblOpenStoreStatus = new JLabel(" STORE IS NOT OPEN ");
        this.lblOpenStoreStatus.setFont(font);
        this.lblOpenStoreStatus.setForeground(Color.GRAY);
        this.lblOpenStoreStatus.setVisible(false);
        this.lblCurrentShift = new JLabel("<html><b>Current Shift</b></html>");
        this.lblCurrentTimeInfo.setHorizontalAlignment(4);
        this.lblUserClockedStatus = new JLabel();
        this.lblUserClockedStatus.setHorizontalAlignment(0);
        JPanel shiftInfoPanel = new JPanel(new BorderLayout());
        shiftInfoPanel.add((Component)this.lblCurrentShift, "West");
        shiftInfoPanel.add((Component)this.lblUserClockedStatus, "South");
        shiftInfoPanel.add((Component)this.lblCurrentTimeInfo, "East");
        attendancePanel.add((Component)shiftInfoPanel, "growx");
        attendancePanel.add((Component)this.lblOpenStoreStatus, "center");
        attendancePanel.add((Component)this.btnOpenStore, "center");
        attendancePanel.add((Component)this.btnClockIn, "center");
        attendancePanel.add((Component)this.btnClockOut, "center");
        this.loginRoleSelectionPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3,fillx,ins 0 5 5 5", "sg,fill", ""));
        clockInOutActionPanel.add((Component)this.loginRoleSelectionPanel, "North");
        clockInOutActionPanel.add(attendancePanel);
        this.btnAssignDrawer = new PosButton("ASSIGN DRAWER");
        this.btnServerSummary = new PosButton("SERVER SUMMARY");
        this.btnTerminalStatus = new PosButton("THIS TERMINAL STATUS");
        this.btnShowClockedInUsers = new PosButton("CLOCKED IN USERS");
        this.btnStaffBankStatus = new PosButton("STAFF BANK STATUS");
        this.btnStartStaffBank = new PosButton("START STAFF BANK");
        this.btnTipsManagement = new PosButton(POSConstants.SERVER_TIPS);
        this.btnDeclareTips = new PosButton("DECLARE TIPS");
        this.btnTipsManagement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClockInOutDialog.this.doManageGratuity();
            }
        });
        this.btnDeclareTips.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClockInOutDialog.this.doDeclareTips();
            }
        });
        this.btnAuthorize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClockInOutDialog.this.doAuthorizeTickets();
            }
        });
        this.btnNoSale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawerUtil.kickDrawer();
            }
        });
        this.btnOpenTickets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ClockInOutDialog.this.currentUser.hasPermission(UserPermission.EDIT_OTHER_USERS_TICKETS)) {
                    ServerOpenTicketListDialog dialog = new ServerOpenTicketListDialog(ClockInOutDialog.this.currentUser, null, false);
                    dialog.setTitle("Open tickets..");
                    dialog.setSize(PosUIManager.getSize(830, 550));
                    dialog.open();
                } else {
                    ServerOpenTicketListDialog dialog = new ServerOpenTicketListDialog(ClockInOutDialog.this.currentUser, ClockInOutDialog.this.currentUser, true);
                    dialog.setTitle("Open tickets..");
                    dialog.setSize(PosUIManager.getSize(830, 550));
                    dialog.open();
                }
            }
        });
        JPanel buttonUserActionPanel = new JPanel((LayoutManager)new MigLayout("center,ins 5 5 5 5,hidemode 3,fillx", "", ""));
        this.btnCancel = new PosButton("EXIT");
        this.btnCancel.setHorizontalTextPosition(2);
        JPanel panel1 = new JPanel((LayoutManager)new MigLayout("center,ins 0,hidemode 3,fillx", "", ""));
        this.cashDrawerButtonPanel = new JPanel((LayoutManager)new MigLayout("center,ins 0,hidemode 3,fillx", "", ""));
        panel1.add((Component)this.btnNoSale, "growx");
        panel1.add((Component)this.btnStoreStatus, "growx");
        panel1.add((Component)this.btnOpenTickets, "growx");
        panel1.add((Component)this.btnAuthorize, "growx");
        panel1.add((Component)this.btnShowClockedInUsers, "growx");
        this.cashDrawerButtonPanel.add((Component)this.btnTipsManagement, "growx");
        this.cashDrawerButtonPanel.add((Component)this.btnDeclareTips, "growx");
        this.cashDrawerButtonPanel.add((Component)this.btnAssignDrawer, "growx");
        this.cashDrawerButtonPanel.add((Component)this.btnServerSummary, "growx");
        this.cashDrawerButtonPanel.add((Component)this.btnTerminalStatus, "growx");
        this.cashDrawerButtonPanel.add((Component)this.btnStaffBankStatus, "growx");
        this.cashDrawerButtonPanel.add((Component)this.btnStartStaffBank, "growx");
        buttonUserActionPanel.add((Component)panel1, "growx" + wrap);
        buttonUserActionPanel.add((Component)this.cashDrawerButtonPanel, "newline,growx");
        buttonUserActionPanel.add((Component)this.btnCancel, "newline,span 9,center,growx");
        centerPanel.add((Component)buttonUserActionPanel, "South");
        centerPanel.add((Component)clockInOutActionPanel, "Center");
        contentPanel.add((Component)messagePanel, "aligny top,w " + width + "!,grow");
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.setBorder(BorderFactory.createLineBorder(this.getBackground(), 3));
        headerPanel.setBackground(Color.white);
        JLabel logoLabel = new JLabel(IconFactory.getIcon("/icons/", "header_logo.png"));
        JSeparator sep = new JSeparator();
        sep.setBackground(Color.white);
        headerPanel.add((Component)logoLabel, "West");
        headerPanel.add((Component)sep, "South");
        this.add((Component)headerPanel, "North");
        this.add(contentPanel);
        this.createFooterStatusPanel();
        this.initializeActions();
        this.showFooterTimer();
        this.clockTimer.start();
    }

    private void doDeclareTips() {
        StoreSession currentSession = StoreUtil.getCurrentStoreOperation().getCurrentData();
        List<DeclaredTips> declaredTips = DeclaredTipsDAO.getInstance().findBy(currentSession, this.currentUser);
        TipsDeclarationDialog dialog = new TipsDeclarationDialog(this.currentUser, currentSession, declaredTips);
        dialog.setTitle("DECLARE TIPS");
        dialog.setSize(PosUIManager.getSize(630, 550));
        dialog.open();
    }

    private void doAuthorizeTickets() {
        AuthorizableTicketBrowser dialog = new AuthorizableTicketBrowser(Application.getPosWindow(), this.currentUser, null);
        dialog.setDefaultCloseOperation(2);
        dialog.setLocationRelativeTo(Application.getPosWindow());
        dialog.openFullScreen();
    }

    private void doManageGratuity() {
        if (!this.currentUser.hasPermission(UserPermission.PERFORM_ADMINISTRATIVE_TASK) && !this.currentUser.hasPermission(UserPermission.PERFORM_MANAGER_TASK)) {
            POSMessageDialog.showMessage(Application.getPosWindow(), "You have no permission to manage tips.");
            return;
        }
        GratuityDialog dialog = new GratuityDialog((Window)this, this.currentUser);
        dialog.setCaption("Tips Management");
        dialog.setOkButtonText("PAY");
        dialog.setSize(PosUIManager.getSize(780, 550));
        if (dialog.isCanceled()) {
            dialog.open();
        }
    }

    protected void doShowClockedInUsers() {
        try {
            ClockedInUserListDialog userListDialog = new ClockedInUserListDialog(this.currentUser);
            userListDialog.pack();
            userListDialog.open();
            if (userListDialog.isDataUpdated()) {
                this.currentUser = UserDAO.getInstance().get(this.currentUser.getId());
                this.updateClockInOutButton(this.currentUser);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void initializeActions() {
        this.btnOpenStore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    try {
                        StoreUtil.openStore(ClockInOutDialog.this.currentUser);
                    }
                    catch (StoreAlreadyOpenException e2) {
                        POSMessageDialog.showError(ClockInOutDialog.this, e2.getMessage());
                    }
                    ClockInOutDialog.this.performClockIn(ClockInOutDialog.this.currentUser);
                    ClockInOutDialog.this.updateClockInOutButton(ClockInOutDialog.this.currentUser);
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(ClockInOutDialog.this, e2.getMessage(), e2);
                }
                ClockInOutDialog.this.updateButtonStatus();
            }
        });
        this.btnStoreStatus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClockInOutDialog.this.showDrawerAndStaffBankReportList();
            }
        });
        this.btnServerSummary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerSummaryReportAction action = new ServerSummaryReportAction(ClockInOutDialog.this.currentUser);
                action.execute();
            }
        });
        this.btnClockIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Are you sure you want to clock in?", "Confirm") != 0) {
                    return;
                }
                ClockInOutDialog.this.performClockIn(ClockInOutDialog.this.currentUser);
                ClockInOutDialog.this.updateClockInOutButton(ClockInOutDialog.this.currentUser);
            }
        });
        this.btnClockOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClockInOutDialog.this.performClockOut();
            }
        });
        this.btnDriverIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClockInOutDialog.this.performDriverIn(ClockInOutDialog.this.currentUser);
                ClockInOutDialog.this.updateClockInOutButton(ClockInOutDialog.this.currentUser);
            }
        });
        this.btnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RootView.getInstance().showView(LoginView.getInstance());
            }
        });
        this.btnAssignDrawer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ClockInOutDialog.this.currentUser.isClockedIn().booleanValue()) {
                    POSMessageDialog.showMessage("You are not clock in.\nPlease clock in to assign drawer.");
                    return;
                }
                DrawerAssignmentAction drawerAction = new DrawerAssignmentAction(Application.getInstance().getTerminal(), ClockInOutDialog.this.currentUser);
                drawerAction.execute();
                ClockInOutDialog.this.updateButtonStatus();
            }
        });
        this.btnTerminalStatus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Terminal terminal = Application.getInstance().getTerminal();
                    CashDrawerReportDialog statusDialog = new CashDrawerReportDialog(terminal.getAssignedUser(), terminal.getCurrentCashDrawer());
                    statusDialog.setTitle("DRAWER STATUS");
                    statusDialog.refreshReport();
                    statusDialog.setDefaultCloseOperation(2);
                    statusDialog.openFullScreen();
                    Application.getInstance().refreshAndGetTerminal();
                    ClockInOutDialog.this.updateButtonStatus();
                }
                catch (Exception ex) {
                    PosLog.error(this.getClass(), ex);
                }
            }
        });
        this.btnShowClockedInUsers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClockInOutDialog.this.doShowClockedInUsers();
            }
        });
        this.btnStaffBankStatus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClockInOutDialog.this.showStaffBankStatus();
            }
        });
        this.btnStartStaffBank.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ClockInOutDialog.this.currentUser.isClockedIn().booleanValue()) {
                    POSMessageDialog.showError("Can't start staff bank. You are not clocked in.");
                    return;
                }
                int option = POSMessageDialog.showYesNoQuestionDialog(ClockInOutDialog.this, "Are you sure to start staff bank?", "Confirm");
                if (option != 0) {
                    return;
                }
                ClockInOutDialog.this.performStartStaffBank(ClockInOutDialog.this.currentUser);
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClockInOutDialog.this.setCanceled(true);
                ClockInOutDialog.this.dispose();
            }
        });
    }

    private void createFooterStatusPanel() {
        JPanel statusBarContainer = new JPanel(new BorderLayout());
        statusBarContainer.add((Component)new JSeparator(0), "North");
        JPanel infoPanel = new JPanel((LayoutManager)new MigLayout("fillx, ins 5", "[]20px[]20px[]", "[]"));
        infoPanel.setOpaque(true);
        this.lblRestaurantName = new JLabel();
        Font f = this.lblRestaurantName.getFont().deriveFont(1, PosUIManager.getFontSize(10));
        this.lblTerminal = new JLabel("Terminal: " + TerminalConfig.getTerminalId());
        this.lblUser = new JLabel();
        this.lblTime = new JLabel("");
        this.lblTime.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.lblRestaurantName.setFont(f);
        this.lblUser.setFont(f);
        this.lblTerminal.setFont(f);
        this.lblTime.setFont(f);
        infoPanel.add(this.lblRestaurantName);
        infoPanel.add(this.lblTerminal);
        infoPanel.add(this.lblUser);
        statusBarContainer.add((Component)infoPanel, "West");
        statusBarContainer.add((Component)this.lblTime, "East");
        this.add((Component)statusBarContainer, "South");
        if (TerminalConfig.isKioskMode()) {
            statusBarContainer.setVisible(false);
        }
    }

    public void rendererFooterInfo() {
        User currentUser = Application.getCurrentUser();
        if (currentUser != null) {
            this.lblUser.setText("");
        } else {
            this.lblUser.setText("");
        }
        this.lblRestaurantName.setText(Application.getInstance().getStore().getName());
    }

    public static ClockInOutDialog getInstance(User user, boolean loginMode) {
        if (instance == null) {
            instance = new ClockInOutDialog();
        }
        instance.updateView(user, loginMode);
        instance.rendererUserRole();
        return instance;
    }

    private void updateView(User selectedUser, boolean isLoginMode) {
        this.currentUser = selectedUser;
        this.loginMode = isLoginMode;
        if (selectedUser == null) {
            return;
        }
        this.lblUserName.setText(selectedUser.getFullName());
        String userOtherIno = "<html><center>" + selectedUser.getType().getName();
        userOtherIno = userOtherIno + "<br>Has staff bank: " + (selectedUser.isStaffBank() != false ? "yes" : "no");
        if (selectedUser.isStaffBank().booleanValue()) {
            userOtherIno = userOtherIno + "<br>Auto start staff bank: " + (selectedUser.isAutoStartStaffBank() != false ? "yes" : "no");
        }
        userOtherIno = userOtherIno + "</center></html>";
        this.lblUserType.setText(userOtherIno);
        ImageIcon memberImage = selectedUser.getImage();
        if (memberImage != null) {
            this.lblPicture.setIcon(memberImage);
        } else {
            this.setDefaultUserPicture();
        }
        this.updateClockInOutButton(selectedUser);
        this.rendererFooterInfo();
    }

    private void rendererUserRole() {
        this.loginRoleSelectionPanel.removeAll();
        this.loginRoleSelectionPanel.setBorder(null);
        if (this.currentUser.isClockedIn().booleanValue() || !this.currentUser.hasLinkedUser()) {
            this.loginRoleSelectionPanel.setVisible(false);
            return;
        }
        List<User> linkedUserList = this.currentUser.getLinkedUsersIfExists();
        this.loginRoleSelectionPanel.setVisible(true);
        EmptyBorder emptyBorder = new EmptyBorder(2, 5, 5, 5);
        this.loginRoleSelectionPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, "CLOCK IN AS", 2, 2), emptyBorder));
        ButtonGroup roleButtonGroup = new ButtonGroup();
        for (User roleUser : linkedUserList) {
            POSToggleButton btnRole = new POSToggleButton(roleUser.getType().getName());
            btnRole.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    POSToggleButton btnRoleUser = (POSToggleButton)e.getSource();
                    ClockInOutDialog.this.currentUser = (User)btnRoleUser.getClientProperty("roleUser");
                    ClockInOutDialog.this.updateView(ClockInOutDialog.this.currentUser, ClockInOutDialog.this.loginMode);
                }
            });
            btnRole.putClientProperty("roleUser", roleUser);
            this.loginRoleSelectionPanel.add((Component)btnRole, "growx");
            roleButtonGroup.add(btnRole);
            if (roleUser.getType().getName().equals(this.currentUser.getType().getName())) {
                btnRole.setSelected(true);
            }
            btnRole.setEnabled(this.currentUser.isClockedIn() == false);
        }
    }

    private void updateClockInOutButton(User user) {
        boolean storeOpen = StoreUtil.isStoreOpen();
        this.btnClockOut.setVisible(storeOpen && user.isClockedIn() != false);
        this.btnClockIn.setVisible(storeOpen && user.isClockedIn() == false);
        this.btnDriverIn.setVisible(false);
        Date date = new Date();
        String currentDate = new SimpleDateFormat("dd MMMM, yyyy").format(date);
        if (user.isClockedIn().booleanValue()) {
            this.lblUserClockedStatus.setText("Status: Clocked in as " + user.getType().getName());
            this.lblCurrentTimeInfo.setText("<html><center><b>Clock in time</b></center>" + dateFormat2.format(user.getLastClockInTime()) + "</html>");
        } else {
            this.lblUserClockedStatus.setText("Status: Clocked out");
            this.lblCurrentTimeInfo.setText("<html><center>" + currentDate + "</center></html>");
        }
        if (user.isDriver().booleanValue() && storeOpen && user.isClockedIn().booleanValue() && !user.isAvailableForDelivery().booleanValue()) {
            this.btnDriverIn.setVisible(true);
        }
        this.updateButtonStatus();
    }

    private void setDefaultUserPicture() {
        try {
            InputStream stream = this.getClass().getResourceAsStream("/images/generic-profile-pic-v2.png");
            byte[] picture2 = IOUtils.toByteArray((InputStream)stream);
            IOUtils.closeQuietly((InputStream)stream);
            this.lblPicture.setIcon(new ImageIcon(new ImageIcon(picture2).getImage().getScaledInstance(150, 160, 4)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void showDrawerAndStaffBankReportList() {
        try {
            DrawerAndStaffBankReportDialog dialog = new DrawerAndStaffBankReportDialog(this.currentUser);
            dialog.setInfo("Cash drawer and staff bank status");
            dialog.open();
            this.updateButtonStatus();
            if (StoreUtil.isStoreOpen()) {
                return;
            }
            User currentUser = Application.getCurrentUser();
            if (currentUser == null || currentUser.getId().equals(currentUser.getId())) {
                Application.getInstance().setCurrentUser(null);
                Application.getPosWindow().rendererUserInfo();
                RootView.getInstance().showView("LOGIN_VIEW");
                this.dispose();
            }
        }
        catch (Exception ex) {
            POSMessageDialog.showError(this, ex.getMessage(), ex);
        }
    }

    private void showStaffBankStatus() {
        try {
            CashDrawerReportDialog dialog = new CashDrawerReportDialog(this.currentUser, this.currentUser.getActiveDrawerPullReport());
            dialog.setTitle("BANK STATUS");
            dialog.refreshReport();
            dialog.setDefaultCloseOperation(2);
            dialog.openFullScreen();
            this.currentUser = UserDAO.getInstance().get(this.currentUser.getId());
            this.updateClockInOutButton(this.currentUser);
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag) {
            this.startTimer();
        } else {
            this.stopTimer();
        }
    }

    private void startTimer() {
        this.clockTimer.start();
    }

    private void stopTimer() {
        this.clockTimer.stop();
    }

    private void showFooterTimer() {
        StringBuilder sb = new StringBuilder();
        sb.append(timeFormat.format(Calendar.getInstance().getTime()));
        this.lblTime.setText(sb.toString());
    }

    private void performClockOut() {
        try {
            if (TicketDAO.getInstance().hasOpenTickets(this.currentUser)) {
                ServerOpenTicketListDialog dialog = new ServerOpenTicketListDialog(this.currentUser, this.currentUser, true);
                dialog.setTitle("You have open tickets. Please review them.");
                dialog.setSize(PosUIManager.getSize(830, 550));
                dialog.open();
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Are you sure you want to clock out?", "Confirm") != 0) {
                return;
            }
            CashDrawer activeDrawerPullReport = this.currentUser.getActiveDrawerPullReport();
            if (activeDrawerPullReport != null && activeDrawerPullReport.getDrawerType() == DrawerType.STAFF_BANK && activeDrawerPullReport.isOpen()) {
                POSMessageDialog.showMessage(this, "Please close staff bank first");
                return;
            }
            this.doClockedOutUser(this.currentUser);
            this.updateClockInOutButton(this.currentUser);
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private void performClockIn(User clockInuser) {
        try {
            if (clockInuser == null) {
                return;
            }
            if (clockInuser.isClockedIn() != null && clockInuser.isClockedIn().booleanValue()) {
                POSMessageDialog.showMessage(Application.getPosWindow(), clockInuser.getFirstName() + " " + clockInuser.getLastName() + Messages.getString("ClockInOutAction.13"));
                return;
            }
            if (clockInuser.isAutoStartStaffBank().booleanValue()) {
                this.doClockedInUser(true);
            } else if (clockInuser.isStaffBank().booleanValue()) {
                final POSDialog dialog = new POSDialog((Frame)Application.getPosWindow(), true);
                dialog.setTitle(Messages.getString("ClockInOutAction.4"));
                PosButton btnStartStaffBank = new PosButton("START STAFF BANK");
                btnStartStaffBank.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ClockInOutDialog.this.doClockedInUser(true);
                        dialog.dispose();
                    }
                });
                PosButton btnClose = new PosButton("CLOSE");
                btnClose.setPreferredSize(new Dimension(150, 120));
                btnClose.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ClockInOutDialog.this.doClockedInUser(false);
                        dialog.dispose();
                    }
                });
                JPanel contentPane = (JPanel)dialog.getContentPane();
                contentPane.setBorder(new EmptyBorder(10, 10, 10, 10));
                contentPane.setLayout(new GridLayout(1, 0, 10, 10));
                contentPane.add(btnStartStaffBank);
                contentPane.add(btnClose);
                dialog.pack();
                dialog.open();
            } else {
                this.doClockedInUser(false);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private void doClockedInUser(boolean startStaffBank) {
        try {
            Shift currentShift = ShiftUtil.getCurrentShift();
            Calendar currentTime = Calendar.getInstance();
            this.currentUser.doClockIn(Application.getInstance().getTerminal(), currentShift, currentTime);
            String msg = this.currentUser.getFirstName() + " " + this.currentUser.getLastName() + Messages.getString("ClockInOutAction.16");
            if (POSMessageDialog.showMessageAndPromtToPrint(msg)) {
                ReceiptPrintService.printClockInOutReceipt(this.currentUser);
            }
            if (this.loginMode) {
                Application.getInstance().doLogin(this.currentUser);
            }
            if (startStaffBank) {
                this.performStartStaffBank(this.currentUser);
            }
            this.close();
            this.rendererUserRole();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private void close() {
    }

    private void doClockedOutUser(User user) throws Exception {
        try {
            User currentUser;
            if (user == null) {
                return;
            }
            boolean clockedIn = UserDAO.getInstance().isClockedIn(user);
            if (!clockedIn) {
                throw new PosException("User is not cloked in.");
            }
            AttendenceHistoryDAO attendenceHistoryDAO = new AttendenceHistoryDAO();
            AttendenceHistory attendenceHistory = attendenceHistoryDAO.findHistoryByClockedInTime(user);
            if (attendenceHistory == null) {
                attendenceHistory = new AttendenceHistory();
                Date lastClockInTime = user.getLastClockInTime();
                Calendar c = Calendar.getInstance();
                c.setTime(lastClockInTime);
                attendenceHistory.setClockInTime(lastClockInTime);
                attendenceHistory.setClockInHour((short)c.get(10));
                attendenceHistory.setUser(user);
                attendenceHistory.setTerminal(Application.getInstance().getTerminal());
                attendenceHistory.setShift(user.getCurrentShift());
            }
            Shift shift = user.getCurrentShift();
            Calendar calendar = Calendar.getInstance();
            user.doClockOut(attendenceHistory, shift, calendar);
            String msg = user.getFirstName() + " " + user.getLastName() + Messages.getString("ClockInOutAction.10");
            if (POSMessageDialog.showMessageAndPromtToPrint(msg)) {
                ReceiptPrintService.printClockInOutReceipt(user);
            }
            if ((currentUser = Application.getCurrentUser()) != null && currentUser.getId().equals(user.getId())) {
                Application.getInstance().setCurrentUser(null);
                Application.getPosWindow().rendererUserInfo();
                RootView.getInstance().showView(LoginView.getInstance());
                this.close();
            }
            this.rendererUserRole();
            this.close();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public void performDriverOut(User user) {
        try {
            if (user == null) {
                return;
            }
            Shift currentShift = ShiftUtil.getCurrentShift();
            Terminal terminal = Application.getInstance().getTerminal();
            Calendar currentTime = Calendar.getInstance();
            user.setAvailableForDelivery(false);
            user.setLastClockOutTime(currentTime.getTime());
            LogFactory.getLog(Application.class).info((Object)("terminal id befor saving clockIn=" + terminal.getId()));
            EmployeeInOutHistory attendenceHistory = new EmployeeInOutHistory();
            attendenceHistory.setOutTime(currentTime.getTime());
            attendenceHistory.setOutHour((short)currentTime.get(11));
            attendenceHistory.setClockOut(true);
            attendenceHistory.setUser(user);
            attendenceHistory.setTerminal(terminal);
            attendenceHistory.setShift(currentShift);
            UserDAO.getInstance().saveDriverOut(user, attendenceHistory, currentShift, currentTime);
            POSMessageDialog.showMessage("Driver " + user.getFirstName() + " " + user.getLastName() + " is out for delivery.");
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public void performDriverIn(User user) {
        try {
            if (user == null) {
                return;
            }
            if (!user.isClockedIn().booleanValue()) {
                POSMessageDialog.showMessage(this, Messages.getString("ClockInOutAction.2"));
                return;
            }
            EmployeeInOutHistoryDAO attendenceHistoryDAO = new EmployeeInOutHistoryDAO();
            EmployeeInOutHistory attendenceHistory = attendenceHistoryDAO.findDriverHistoryByClockedInTime(user);
            if (attendenceHistory == null) {
                attendenceHistory = new EmployeeInOutHistory();
                Date lastClockOutTime = user.getLastClockOutTime();
                Calendar c = Calendar.getInstance();
                c.setTime(lastClockOutTime);
                attendenceHistory.setOutTime(lastClockOutTime);
                attendenceHistory.setOutHour((short)c.get(10));
                attendenceHistory.setUser(user);
                attendenceHistory.setTerminal(Application.getInstance().getTerminal());
                attendenceHistory.setShift(user.getCurrentShift());
            }
            Shift shift = user.getCurrentShift();
            Calendar calendar = Calendar.getInstance();
            user.setAvailableForDelivery(true);
            attendenceHistory.setClockOut(false);
            attendenceHistory.setInTime(calendar.getTime());
            attendenceHistory.setInHour((short)calendar.get(11));
            UserDAO.getInstance().saveDriverIn(user, attendenceHistory, shift, calendar);
            POSMessageDialog.showMessage("Driver " + user.getFirstName() + " " + user.getLastName() + " is in after delivery");
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public boolean isLoginMode() {
        return this.loginMode;
    }

    public void setLoginMode(boolean loginMode) {
        this.loginMode = loginMode;
    }

    public void performStartStaffBank(User bankUser) {
        try {
            CashDrawer staffBankReport = new CashDrawer();
            staffBankReport.setStartTime(new Date());
            staffBankReport.setAssignedUser(bankUser);
            staffBankReport.setTerminal(Application.getInstance().getTerminal());
            staffBankReport.setStoreOperationData(StoreUtil.getCurrentStoreOperation().getCurrentData());
            staffBankReport.setDrawerType(DrawerType.STAFF_BANK);
            staffBankReport.setAssignedBy(bankUser);
            bankUser.setStaffBankStarted(true);
            bankUser.setCurrentCashDrawer(staffBankReport);
            TerminalDAO.getInstance().performBatchSave(staffBankReport, bankUser);
            POSMessageDialog.showMessage("Your staff bank has been started successfully");
            this.updateClockInOutButton(this.currentUser);
            Application.getInstance().refreshCurrentUser();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, "An error occured while starting staff bank", e);
        }
    }

    private void updateButtonStatus() {
        Terminal currentTerminal = Application.getInstance().getTerminal();
        boolean hasStoreAccess = this.currentUser.hasPermission(UserPermission.OPEN_CLOSE_STORE);
        boolean storeOpen = StoreUtil.isStoreOpen();
        boolean userClockedIn = this.currentUser.isClockedIn();
        this.btnStoreStatus.setVisible(storeOpen && hasStoreAccess && userClockedIn);
        this.btnOpenStore.setVisible(!storeOpen && hasStoreAccess);
        this.lblOpenStoreStatus.setVisible(!storeOpen && !hasStoreAccess);
        this.btnOpenTickets.setVisible(storeOpen && userClockedIn);
        this.btnShowClockedInUsers.setVisible(storeOpen);
        this.btnTipsManagement.setVisible(storeOpen && userClockedIn && this.currentUser.isManager());
        this.btnDeclareTips.setVisible(storeOpen && userClockedIn);
        this.btnAuthorize.setVisible(storeOpen && userClockedIn && this.currentUser.hasPermission(UserPermission.AUTHORIZE_TICKETS));
        this.btnStartStaffBank.setVisible(userClockedIn && this.currentUser.isStaffBank() != false && this.currentUser.isStaffBankStarted() == false);
        this.btnStaffBankStatus.setVisible(userClockedIn && this.currentUser.isStaffBankStarted() != false);
        if ((this.currentUser.isAdministrator() || this.currentUser.isManager()) && userClockedIn && currentTerminal.isHasCashDrawer().booleanValue()) {
            if (currentTerminal.isCashDrawerAssigned()) {
                this.btnAssignDrawer.setVisible(false);
                this.btnTerminalStatus.setVisible(true);
            } else {
                this.btnAssignDrawer.setVisible(true);
                this.btnTerminalStatus.setVisible(false);
            }
        } else {
            this.btnAssignDrawer.setVisible(false);
            this.btnTerminalStatus.setVisible(false);
        }
        this.cashDrawerButtonPanel.setVisible(this.btnTipsManagement.isVisible() || this.btnDeclareTips.isVisible() || this.btnAssignDrawer.isVisible() || this.btnTerminalStatus.isVisible() || this.btnStartStaffBank.isVisible() || this.btnStaffBankStatus.isVisible());
    }

    private void doChangePassword() {
        try {
            GeneratePasswordDialog changePasswordDialog;
            String message = "ENTER CURRENT PASSWORD";
            if (PasswordEntryDialog.verifyPassword(this.currentUser, POSUtil.getFocusedWindow(), message, message)) {
                changePasswordDialog = new GeneratePasswordDialog();
                changePasswordDialog.setSize(530, 340);
                changePasswordDialog.open();
                if (changePasswordDialog.isCanceled()) {
                    POSMessageDialog.showMessage(this, "Password was not changed.");
                    return;
                }
            } else {
                return;
            }
            String newPassword = changePasswordDialog.getGenPassword();
            this.currentUser.setPassword(AESencrp.encrypt(newPassword));
            UserDAO.getInstance().update(this.currentUser);
            POSMessageDialog.showMessage(this, "Successfully Updated Password.");
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, "Updated Failed Password!");
        }
    }

    private class ClockTimerHandler
    implements ActionListener {
        private ClockTimerHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClockInOutDialog.this.showFooterTimer();
        }
    }
}

