/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.model.GiftCard;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class GiftCardActivateView
extends POSDialog {
    private JTextField txtCardNumber;
    private JTextField txtHolder;
    private GiftCard giftCard;
    private FixedLengthTextField txtPinNumber;
    private GiftCardProcessor giftCardProcessor;

    public GiftCardActivateView(GiftCardProcessor giftCardProcessor) {
        this.giftCardProcessor = giftCardProcessor;
        this.init();
    }

    public GiftCardActivateView(JFrame parent) {
        this.init();
    }

    private void init() {
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Gift Card Activation");
        this.add((Component)titlePanel, "North");
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fillx,aligny center", "[][]", ""));
        JLabel lblNumberOfCard = new JLabel(Messages.getString("GiftCardActivateView.3"));
        this.txtCardNumber = new JTextField(20);
        JLabel lblHolder = new JLabel(Messages.getString("GiftCardActivateView.4"));
        this.txtHolder = new JTextField(20);
        this.txtPinNumber = new FixedLengthTextField(20);
        this.txtPinNumber.setLength(8);
        centerPanel.add((Component)lblNumberOfCard, "cell 0 0, alignx right");
        centerPanel.add((Component)this.txtCardNumber, "cell 1 0");
        centerPanel.add((Component)lblHolder, "cell 0 1,alignx right");
        centerPanel.add((Component)this.txtHolder, "cell 1 1");
        centerPanel.add((Component)new JLabel(Messages.getString("GiftCardActivateView.9")), "cell 0 2,alignx right");
        centerPanel.add((Component)this.txtPinNumber, "cell 1 2");
        this.add((Component)centerPanel, "Center");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        PosButton btnGenerate = new PosButton(Messages.getString("GiftCardActivateView.15"));
        buttonPanel.add((Component)btnGenerate, "grow");
        btnGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftCardActivateView.this.doGenerate();
            }
        });
        buttonPanel.add(new PosButton(new CloseDialogAction(this, Messages.getString("UserListDialog.5"))));
        this.add((Component)buttonPanel, "South");
        this.txtCardNumber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtils.isEmpty((String)GiftCardActivateView.this.txtCardNumber.getText())) {
                    MessageDialog.showError(Messages.getString("GiftCardActivateView.18"));
                } else {
                    GiftCardActivateView.this.giftCard = GiftCardActivateView.this.giftCardProcessor.getCard(GiftCardActivateView.this.txtCardNumber.getText());
                    if (GiftCardActivateView.this.giftCard == null) {
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardActivateView.19"));
                        return;
                    }
                    if (GiftCardActivateView.this.giftCard != null) {
                        String holder = GiftCardActivateView.this.giftCard.getOwnerName();
                        if (StringUtils.isEmpty((String)holder)) {
                            GiftCardActivateView.this.txtHolder.setText("");
                        } else {
                            GiftCardActivateView.this.txtHolder.setText(holder);
                        }
                        String pinNumber = GiftCardActivateView.this.giftCard.getPinNumber();
                        if (StringUtils.isEmpty((String)pinNumber)) {
                            GiftCardActivateView.this.txtPinNumber.setText("");
                        } else {
                            GiftCardActivateView.this.txtPinNumber.setText(pinNumber);
                        }
                    }
                }
            }
        });
    }

    public void doGenerate() {
        if (this.save()) {
            this.giftCardProcessor.activate(this.giftCard);
            POSMessageDialog.showMessage(this, Messages.getString("GiftCardActivateView.22"));
            this.dispose();
        }
    }

    private boolean save() {
        String cardNo = this.txtCardNumber.getText();
        String holder = this.txtHolder.getText();
        String pinNumber = this.txtPinNumber.getText();
        if (StringUtils.isEmpty((String)cardNo)) {
            MessageDialog.showError(Messages.getString("GiftCardActivateView.23"));
            return false;
        }
        this.giftCard = this.giftCardProcessor.getCard(cardNo);
        if (this.giftCard == null) {
            POSMessageDialog.showMessage(this, Messages.getString("GiftCardActivateView.24"));
            return false;
        }
        if (this.giftCard.isActive().booleanValue()) {
            POSMessageDialog.showMessage(this, Messages.getString("GiftCardActivateView.25"));
            return false;
        }
        if (StringUtils.isEmpty((String)holder)) {
            MessageDialog.showError(Messages.getString("GiftCardActivateView.26"));
            return false;
        }
        if (StringUtils.isEmpty((String)pinNumber)) {
            MessageDialog.showError(Messages.getString("GiftCardActivateView.27"));
            return false;
        }
        Calendar c = Calendar.getInstance();
        Date activationDate = c.getTime();
        if (this.giftCard.getDurationType().equals("DAY")) {
            c.add(5, this.giftCard.getDuration());
        } else if (this.giftCard.getDurationType().equals("MONTH")) {
            c.add(2, this.giftCard.getDuration());
        } else {
            c.add(1, this.giftCard.getDuration());
        }
        Date expiryDate = c.getTime();
        this.giftCard.setOwnerName(holder);
        this.giftCard.setActivationDate(activationDate);
        this.giftCard.setDeActivationDate(null);
        this.giftCard.setExpiryDate(expiryDate);
        this.giftCard.setActive(true);
        this.giftCard.setDisable(false);
        this.giftCard.setPinNumber(pinNumber);
        return true;
    }
}

