/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class GiftCardAddBalanceView
extends POSDialog {
    private JTextField txtCardNumber;
    private DoubleTextField txtBalance;
    private GiftCard giftCard;
    private GiftCardProcessor giftCardProcessor;
    private JComboBox<OrderType> cbOrderType;

    public GiftCardAddBalanceView(GiftCardProcessor giftCardProcessor) {
        this.giftCardProcessor = giftCardProcessor;
        this.init();
        this.initData();
        this.updateView();
    }

    public GiftCardAddBalanceView(JFrame parent) {
        super(parent);
        this.init();
        this.initData();
        this.updateView();
    }

    private void updateView() {
        String orderTypeId = TerminalConfig.getGiftOrdertype();
        ComboBoxModel model = (ComboBoxModel)this.cbOrderType.getModel();
        List dataList = model.getDataList();
        for (OrderType orderType : dataList) {
            if (!orderType.getId().equals(orderTypeId)) continue;
            this.cbOrderType.setSelectedItem(orderType);
            break;
        }
    }

    private void initData() {
        List<OrderType> orderTypes = OrderTypeDAO.getInstance().findAll();
        ComboBoxModel cbModel = new ComboBoxModel();
        for (OrderType orderType : orderTypes) {
            cbModel.addElement(orderType);
        }
        this.cbOrderType.setModel(cbModel);
    }

    private void init() {
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        TitlePanel titlePanel = new TitlePanel();
        this.cbOrderType = new JComboBox();
        titlePanel.setTitle("Add Balance");
        topPanel.add((Component)titlePanel, "span, grow, wrap");
        topPanel.add((Component)new JLabel("Ordertype"), "gapleft 30, aligny center, alignx right");
        topPanel.add(this.cbOrderType, "w 250!");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fillx,aligny center", "[][]", ""));
        JLabel lblNumberOfCard = new JLabel(Messages.getString("GiftCardAddBalanceView.3"));
        this.txtCardNumber = new JTextField(20);
        JLabel lblBalance = new JLabel(Messages.getString("GiftCardAddBalanceView.4"));
        this.txtBalance = new DoubleTextField(20);
        centerPanel.add((Component)lblNumberOfCard, "alignx right");
        centerPanel.add((Component)this.txtCardNumber, "w 250!, wrap");
        centerPanel.add((Component)lblBalance, "alignx right");
        centerPanel.add((Component)this.txtBalance, "w 250!,wrap");
        this.add((Component)centerPanel, "Center");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        PosButton btnGenerate = new PosButton(Messages.getString("GiftCardAddBalanceView.12"));
        buttonPanel.add((Component)btnGenerate, "grow");
        btnGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftCardAddBalanceView.this.doGenerate();
            }
        });
        buttonPanel.add(new PosButton(new CloseDialogAction(this, "CANCEL")));
        this.add((Component)buttonPanel, "South");
    }

    public void doGenerate() {
        if (this.save()) {
            POSMessageDialog.showMessage(this, Messages.getString("GiftCardAddBalanceView.15"));
            this.dispose();
        }
    }

    private boolean save() {
        String cardNo = this.txtCardNumber.getText();
        double balance = this.txtBalance.getDouble();
        OrderType orderType = (OrderType)this.cbOrderType.getSelectedItem();
        this.giftCard = this.giftCardProcessor.getCard(cardNo);
        if (this.giftCard == null) {
            POSMessageDialog.showMessage(this, Messages.getString("GiftCardAddBalanceView.16"));
            return false;
        }
        if (StringUtils.isEmpty((String)cardNo)) {
            MessageDialog.showError(Messages.getString("GiftCardAddBalanceView.17"));
            return false;
        }
        if (balance == 0.0) {
            MessageDialog.showError(Messages.getString("GiftCardAddBalanceView.18"));
            return false;
        }
        if (!this.giftCard.isActive().booleanValue()) {
            MessageDialog.showError(Messages.getString("GiftCardAddBalanceView.19"));
            return false;
        }
        if (orderType == null) {
            POSMessageDialog.showMessage(this, "Please select ordertype!");
            return false;
        }
        TerminalConfig.setGiftOrdertype(orderType.getId());
        Ticket ticket = new Ticket(true);
        ticket.setOrderType(orderType);
        ticket.addTable(0);
        ticket.addProperty("cardNumber", cardNo);
        ticket.setShouldIncludeInSales(false);
        ticket.setRevenue_purpose("GIFT_CARD_ADD_BALANCE");
        MenuItem giftCard = MenuItemDAO.getInstance().findByName("Gift Card");
        TicketItem ticketItem = null;
        if (giftCard != null) {
            ticketItem = giftCard.convertToTicketItem(ticket, 1.0);
        }
        if (ticketItem == null) {
            ticketItem = new TicketItem();
            ticketItem.setQuantity(1.0);
            ticketItem.setShouldPrintToKitchen(false);
            ticketItem.setName(Messages.getString("GiftCardAddBalanceView.22"));
            ticketItem.setCategoryName(Messages.getString("GiftCardAddBalanceView.23"));
            ticketItem.setGroupName(Messages.getString("GiftCardAddBalanceView.24"));
            ticketItem.setTicket(ticket);
        }
        ticketItem.setUnitPrice(balance);
        ticket.addToticketItems(ticketItem);
        ticket.calculatePrice();
        return new SettleTicketAction(ticket).performSettle();
    }
}

