/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.actions.PosAction;
import com.floreantpos.config.GiftCardConfig;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.UserPermission;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.GiftCardInfo;
import com.floreantpos.ui.dialog.GlobalInputDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.GiftCardActivateView;
import com.floreantpos.ui.views.GiftCardAddBalanceView;
import com.floreantpos.ui.views.GiftCardEditPinNumberView;
import com.floreantpos.ui.views.GiftCardTransactionInfoView;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class GiftCardManagementView
extends POSDialog {
    private PosButton btnActivate;
    private PosButton btnDeActivate;
    private PosButton btnBalance;
    private PosButton btnDisable;
    private PosButton btnCardInfo;
    private PosButton btnEditPinNumber;
    private PosButton btnTransaction;
    private GiftCardProcessor giftCardProcessor;

    public GiftCardManagementView() {
        super((Frame)POSUtil.getBackOfficeWindow(), "");
        this.init();
        this.pluginChecking();
    }

    private void pluginChecking() {
        GiftCardPaymentPlugin paymentGateway = GiftCardConfig.getPaymentGateway();
        this.giftCardProcessor = paymentGateway.getProcessor();
        if (paymentGateway != null) {
            if (!this.giftCardProcessor.supportActivation()) {
                this.btnActivate.setEnabled(false);
            }
            if (!this.giftCardProcessor.supportDeActivation()) {
                this.btnDeActivate.setEnabled(false);
            }
            if (!this.giftCardProcessor.supportDisable()) {
                this.btnDisable.setEnabled(false);
            }
            if (!this.giftCardProcessor.supportPinNumberChange()) {
                this.btnEditPinNumber.setEnabled(false);
            }
            if (!this.giftCardProcessor.supportShowTransaction()) {
                this.btnTransaction.setEnabled(false);
            }
        }
    }

    public GiftCardManagementView(JFrame parent) {
        this.init();
        this.pluginChecking();
    }

    private void init() {
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Gift Card Management");
        this.add((Component)titlePanel, "North");
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fillx,aligny center", "[]20px[]", ""));
        centerPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        GiftCardProcessAction action = new GiftCardProcessAction();
        this.btnActivate = new PosButton(Messages.getString("GiftCardManagementView.4"), action);
        this.btnDeActivate = new PosButton(Messages.getString("GiftCardManagementView.5"), action);
        this.btnBalance = new PosButton(Messages.getString("GiftCardManagementView.6"), action);
        this.btnDisable = new PosButton(Messages.getString("GiftCardManagementView.7"), action);
        this.btnCardInfo = new PosButton(Messages.getString("GiftCardManagementView.8"), action);
        this.btnEditPinNumber = new PosButton(Messages.getString("GiftCardManagementView.9"), action);
        this.btnTransaction = new PosButton(Messages.getString("GiftCardManagementView.10"), action);
        centerPanel.add((Component)this.btnActivate, "cell 0 0, growx");
        centerPanel.add((Component)this.btnBalance, "cell 1 0, growx");
        centerPanel.add((Component)this.btnDeActivate, "cell 0 1, growx");
        centerPanel.add((Component)this.btnDisable, "cell 1 1, growx");
        centerPanel.add((Component)this.btnCardInfo, "cell 0 2, growx");
        centerPanel.add((Component)this.btnEditPinNumber, "cell 1 2, growx");
        centerPanel.add((Component)this.btnTransaction, "cell 0 3, growx");
        this.add((Component)centerPanel, "Center");
        PosButton closeButton = new PosButton(new CloseDialogAction(this, Messages.getString("GiftCardManagementView.18")));
        JPanel buttonsPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        buttonsPanel.add((Component)closeButton, "alignx center");
        this.add((Component)buttonsPanel, "South");
        this.btnActivate.setAction(action);
        this.btnBalance.setAction(action);
        this.btnDeActivate.setAction(action);
        this.btnDisable.setAction(action);
        this.btnCardInfo.setAction(action);
        this.btnEditPinNumber.setAction(action);
        this.btnTransaction.setAction(action);
    }

    private void doActivateGiftCard() {
        GiftCardActivateView dialog = new GiftCardActivateView(this.giftCardProcessor);
        dialog.setTitle(Messages.getString("GiftCardManagementView.28"));
        dialog.setDefaultCloseOperation(2);
        dialog.setSize(PosUIManager.getSize(600, 400));
        dialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
        dialog.setVisible(true);
    }

    private void doEditPinNumberGiftCard() {
        GiftCardEditPinNumberView dialog = new GiftCardEditPinNumberView(this.giftCardProcessor);
        dialog.setTitle(Messages.getString("GiftCardManagementView.29"));
        dialog.setDefaultCloseOperation(2);
        dialog.setSize(PosUIManager.getSize(600, 400));
        dialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
        dialog.setVisible(true);
    }

    private void doShowCardInfo() {
        try {
            GiftCard giftCard = this.getGiftCard();
            if (giftCard == null) {
                return;
            }
            GiftCardInfo dialog = new GiftCardInfo(giftCard);
            dialog.setDefaultCloseOperation(2);
            dialog.setSize(PosUIManager.getSize(470, 400));
            dialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
            dialog.setVisible(true);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void doDisableGiftCard() {
        try {
            GiftCard giftCard = this.getGiftCard();
            if (giftCard == null) {
                return;
            }
            int value = POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("GiftCardDisableView.13"), Messages.getString("GiftCardDisableView.14"));
            if (value == 0) {
                if (giftCard.isDisable().booleanValue()) {
                    POSMessageDialog.showMessage(this, Messages.getString("GiftCardDisableView.15"));
                    return;
                }
                giftCard.setDisable(true);
                giftCard.setActive(false);
                giftCard.setDeActivationDate(new Date());
                this.giftCardProcessor.disable(giftCard);
                POSMessageDialog.showMessage(this, Messages.getString("GiftCardDisableView.16"));
                this.dispose();
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void doAddBalanceGiftCard() {
        GiftCardAddBalanceView dialog = new GiftCardAddBalanceView(this.giftCardProcessor);
        dialog.setTitle(Messages.getString("GiftCardManagementView.32"));
        dialog.setDefaultCloseOperation(2);
        dialog.setSize(PosUIManager.getSize(600, 400));
        dialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
        dialog.setVisible(true);
    }

    private void doDeActivate() {
        try {
            GiftCard giftCard = this.getGiftCard();
            if (giftCard == null) {
                return;
            }
            int value = POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("GiftCardDeActiveView.14"), Messages.getString("GiftCardDeActiveView.15"));
            if (value == 0) {
                if (!giftCard.isActive().booleanValue()) {
                    POSMessageDialog.showMessage(this, Messages.getString("GiftCardDeActiveView.16"));
                    return;
                }
                giftCard.setActive(false);
                giftCard.setDeActivationDate(new Date());
                this.giftCardProcessor.deactivate(giftCard);
                POSMessageDialog.showMessage(this, Messages.getString("GiftCardDeActiveView.17"));
                this.dispose();
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private GiftCard getGiftCard() {
        String cardNo = this.getGiftCardNumber();
        if (StringUtils.isEmpty((String)cardNo)) {
            return null;
        }
        GiftCard giftCard = this.giftCardProcessor.getCard(cardNo);
        if (giftCard == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardDeActiveView.12"));
            return null;
        }
        if (StringUtils.isEmpty((String)cardNo)) {
            MessageDialog.showError(Messages.getString("GiftCardDeActiveView.13"));
            return null;
        }
        return giftCard;
    }

    private void doShowTransactionInfo() {
        try {
            GiftCard giftCard = this.getGiftCard();
            if (giftCard == null) {
                return;
            }
            GiftCardTransactionInfoView dialog = new GiftCardTransactionInfoView(giftCard, this.giftCardProcessor);
            dialog.setTitle(Messages.getString("GiftCardTransactionDialog.16"));
            dialog.setDefaultCloseOperation(2);
            dialog.setSize(PosUIManager.getSize(900, 600));
            dialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
            dialog.setVisible(true);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private String getGiftCardNumber() {
        GlobalInputDialog inputDialog = new GlobalInputDialog();
        inputDialog.setCaption("Enter gift card number ");
        inputDialog.open();
        if (inputDialog.isCanceled()) {
            return null;
        }
        String giftCardNumber = inputDialog.getInput();
        return giftCardNumber;
    }

    private class GiftCardProcessAction
    extends PosAction {
        public GiftCardProcessAction() {
            super.setRequiredPermission(UserPermission.MANAGE_GIFT_CARD);
        }

        @Override
        public void execute() {
            ActionEvent e = super.getActionEvent();
            String actionCommand = e.getActionCommand();
            if (actionCommand.equals(Messages.getString("GiftCardManagementView.4"))) {
                GiftCardManagementView.this.doActivateGiftCard();
            } else if (actionCommand.equals(Messages.getString("GiftCardManagementView.5"))) {
                GiftCardManagementView.this.doDeActivate();
            } else if (actionCommand.equals(Messages.getString("GiftCardManagementView.6"))) {
                if (!POSUtil.checkDrawerAssignment()) {
                    return;
                }
                GiftCardManagementView.this.doAddBalanceGiftCard();
            } else if (actionCommand.equals(Messages.getString("GiftCardManagementView.7"))) {
                GiftCardManagementView.this.doDisableGiftCard();
            } else if (actionCommand.equals(Messages.getString("GiftCardManagementView.9"))) {
                GiftCardManagementView.this.doEditPinNumberGiftCard();
            } else if (actionCommand.equals(Messages.getString("GiftCardManagementView.8"))) {
                GiftCardManagementView.this.doShowCardInfo();
            } else if (actionCommand.equals(Messages.getString("GiftCardManagementView.34"))) {
                GiftCardManagementView.this.doShowTransactionInfo();
            }
        }
    }
}

