/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.ClockInOutAction;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.config.ui.DatabaseConfigurationDialog;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.main.PosWindow;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Store;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.OrderTypeLoginButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.views.IView;
import com.floreantpos.ui.views.SwitchboardView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.ViewPanel;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftException;
import com.floreantpos.util.UserNotFoundException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.logging.LogFactory;

public class LoginView
extends ViewPanel {
    public static final String VIEW_NAME = "LOGIN_VIEW";
    private PosButton btnSwitchBoard;
    private PosButton btnKitchenDisplay;
    private PosButton btnDriverView;
    private PosButton btnConfigureDatabase;
    private PosButton btnBackOffice;
    private PosButton btnShutdown;
    private PosButton btnClockOUt;
    private JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("al center center", "sg", "100"));
    private static LoginView instance;
    private JPanel mainPanel;
    private JPanel panel1 = new JPanel((LayoutManager)new MigLayout("fill, ins 0, hidemode 3", "sg, fill", ""));
    private JPanel panel2 = new JPanel((LayoutManager)new MigLayout("fill, ins 0, hidemode 3", "sg, fill", ""));
    private int width;
    private int height;
    private JPanel panel3;
    private JPanel panel4;

    private LoginView() {
        this.setLayout(new BorderLayout(5, 5));
        this.setOpaque(false);
        this.width = PosUIManager.getSize(600);
        this.height = PosUIManager.getSize(100);
        this.centerPanel.setLayout((LayoutManager)new MigLayout("al center center", "sg fill", String.valueOf(this.height)));
        this.centerPanel.setOpaque(false);
        JLabel titleLabel = new JLabel(IconFactory.getIcon("/icons/", "header_logo.png"));
        titleLabel.setOpaque(true);
        titleLabel.setBackground(Color.WHITE);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.add((Component)titleLabel, "Center");
        panel.add((Component)new JSeparator(0), "South");
        this.add((Component)panel, "North");
        this.add((Component)this.createCenterPanel(), "Center");
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Store store = Application.getInstance().getStore();
        if (store == null) {
            return;
        }
        ImageIcon icon = store.getLoginScreenBackground();
        if (icon == null) {
            return;
        }
        Image bgImage = icon.getImage();
        Dimension dimension = Application.getPosWindow().getSize();
        bgImage = POSUtil.getScaledImage(bgImage, dimension.width, dimension.height);
        g.drawImage(bgImage, 0, 0, dimension.width, dimension.height, null);
    }

    private JPanel createCenterPanel() {
        OrderServiceExtension orderService;
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setOpaque(false);
        this.btnSwitchBoard = new PosButton(POSConstants.ORDERS);
        this.btnKitchenDisplay = new PosButton(POSConstants.KITCHEN_DISPLAY_BUTTON_TEXT);
        this.btnDriverView = new PosButton(Messages.getString("LoginView.7"));
        this.btnConfigureDatabase = new PosButton(POSConstants.CONFIGURE_DATABASE);
        this.btnBackOffice = new PosButton(POSConstants.BACK_OFFICE_BUTTON_TEXT);
        this.btnShutdown = new PosButton(POSConstants.SHUTDOWN);
        this.btnClockOUt = new PosButton(new ClockInOutAction(false, true));
        this.btnBackOffice.setVisible(false);
        this.btnSwitchBoard.setVisible(false);
        this.btnKitchenDisplay.setVisible(false);
        this.btnClockOUt.setVisible(false);
        this.panel3 = new JPanel(new GridLayout(1, 0, 5, 5));
        this.panel4 = new JPanel((LayoutManager)new MigLayout("fill, ins 0, hidemode 3", "sg, fill", ""));
        this.centerPanel.add((Component)this.panel1, "cell 0 0, wrap, w " + this.width + "px, h " + this.height + "px, grow");
        this.panel3.add(this.btnSwitchBoard);
        this.panel3.add(this.btnBackOffice);
        if (TerminalConfig.isShowKDSOnLogInScreen() && TerminalConfig.isKDSenabled()) {
            this.panel3.add(this.btnKitchenDisplay);
        }
        if ((orderService = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class)) != null) {
            this.panel3.add(this.btnDriverView);
            this.btnDriverView.setVisible(false);
        }
        this.centerPanel.add((Component)this.panel3, "cell 0 2, wrap, w " + this.width + "px, h " + this.height + "px, grow");
        this.panel4.add((Component)this.btnClockOUt, "grow");
        this.panel4.add((Component)this.btnConfigureDatabase, "grow");
        this.panel4.add((Component)this.btnShutdown, "grow");
        this.centerPanel.add((Component)this.panel4, "cell 0 3, wrap, w " + this.width + "px, h " + this.height + "px, grow");
        this.btnConfigureDatabase.setVisible(true);
        this.panel3.setOpaque(false);
        this.panel4.setOpaque(false);
        this.panel1.setOpaque(false);
        this.panel2.setOpaque(false);
        this.initActionHandlers();
        this.mainPanel.add((Component)this.centerPanel, "Center");
        return this.mainPanel;
    }

    public void initializeOrderButtonPanel() {
        if (!TerminalConfig.isKioskMode() && DataProvider.get().getCurrentTerminal().isShowDbConfig().booleanValue()) {
            this.btnConfigureDatabase.setVisible(true);
        } else {
            this.btnConfigureDatabase.setVisible(false);
        }
        this.panel1.removeAll();
        this.panel2.removeAll();
        List<OrderType> orderTypes = Application.getInstance().getOrderTypes();
        int buttonCount = 0;
        for (OrderType orderType : orderTypes) {
            if (!orderType.isShowInLoginScreen().booleanValue() || !orderType.isEnabled().booleanValue()) continue;
            if (buttonCount < 3) {
                this.panel1.add((Component)new OrderTypeLoginButton(orderType), "grow");
            } else {
                this.panel2.add((Component)new OrderTypeLoginButton(orderType), "grow");
            }
            ++buttonCount;
        }
        int row = 1;
        this.centerPanel.add((Component)this.panel1, "cell 0 " + row++ + ", wrap, w " + this.width + "px, h " + this.height + "px, grow");
        if (buttonCount > 3) {
            this.centerPanel.add((Component)this.panel2, "cell 0 " + row++ + ", wrap,w " + this.width + "px, h " + this.height + "px, grow");
        }
        this.btnSwitchBoard.setVisible(true);
        this.btnKitchenDisplay.setVisible(true);
        this.btnBackOffice.setVisible(true);
        this.btnClockOUt.setVisible(true);
        this.btnDriverView.setVisible(true);
        this.centerPanel.add((Component)this.panel3, "cell 0 " + row++ + ", wrap, w " + this.width + "px, h " + this.height + "px, grow");
        this.centerPanel.add((Component)this.panel4, "cell 0 " + row++ + ", wrap, w " + this.width + "px, h " + this.height + "px, grow");
        this.centerPanel.repaint();
    }

    public void updateView() {
        this.mainPanel.repaint();
    }

    void initActionHandlers() {
        this.btnConfigureDatabase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseConfigurationDialog.show(Application.getPosWindow());
            }
        });
        this.btnBackOffice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginView.this.doBackofficeLogin();
            }
        });
        this.btnKitchenDisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TerminalConfig.setDefaultView("KD");
                LoginView.this.doLogin();
            }
        });
        this.btnDriverView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IView view = OrderServiceFactory.getOrderService().getDriverView();
                if (view == null) {
                    return;
                }
                RootView.getInstance().setAndShowHomeScreen(view);
            }
        });
        this.btnShutdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (Application.getInstance().isSystemInitialized()) {
                        User user = PasswordEntryDialog.getUser(Application.getPosWindow(), "SHUTDOWN", Messages.getString("Application.1"));
                        if (user == null) {
                            return;
                        }
                        if (!user.hasPermission(UserPermission.SHUT_DOWN)) {
                            POSMessageDialog.showMessage(Application.getPosWindow(), "You have no permission to shutdown");
                            return;
                        }
                    }
                }
                catch (Exception ex) {
                    PosLog.error(this.getClass(), ex);
                }
                Application.getInstance().shutdownPOS();
            }
        });
        this.btnSwitchBoard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TerminalConfig.setDefaultView(SwitchboardView.VIEW_NAME);
                LoginView.this.doLogin();
            }
        });
    }

    public synchronized void doLogin() {
        try {
            User user = PasswordEntryDialog.getUser(Application.getPosWindow(), Messages.getString("LoginView.1"), Messages.getString("LoginView.2"));
            if (user == null) {
                return;
            }
            Application application = Application.getInstance();
            application.doLogin(user);
        }
        catch (UserNotFoundException e) {
            LogFactory.getLog(Application.class).error((Object)e);
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("LoginView.3"));
        }
        catch (ShiftException e) {
            LogFactory.getLog(Application.class).error((Object)e);
            MessageDialog.showError(e.getMessage());
        }
        catch (Exception e1) {
            LogFactory.getLog(Application.class).error((Object)e1);
            String message = e1.getMessage();
            if (message != null && message.contains("Cannot open connection")) {
                MessageDialog.showError(Messages.getString("LoginView.4"), e1);
                DatabaseConfigurationDialog.show(Application.getPosWindow());
            }
            MessageDialog.showError(Messages.getString("LoginView.5"), e1);
        }
    }

    public synchronized void doBackofficeLogin() {
        User user = PasswordEntryDialog.getUser(Application.getPosWindow(), Messages.getString("LoginView.1"), Messages.getString("LoginView.2"));
        if (user == null) {
            return;
        }
        if (!user.hasPermission(UserPermission.VIEW_BACK_OFFICE)) {
            POSMessageDialog.showError(Messages.getString("PasswordEntryDialog.4"));
            return;
        }
        Application.getInstance().setCurrentUser(user);
        PosWindow posWindow = Application.getPosWindow();
        BackOfficeWindow window = POSUtil.getBackOfficeWindow();
        if (window == null) {
            window = new BackOfficeWindow(user);
        }
        window.addWindowListener(new BackofficeWindowCloseListener(window));
        posWindow.setVisible(false);
        window.setVisible(true);
        window.toFront();
    }

    public void setTerminalId(int terminalId) {
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    public static LoginView getInstance() {
        if (instance == null) {
            instance = new LoginView();
        }
        return instance;
    }

    public JPanel getCenterPanel() {
        return this.centerPanel;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    class BackofficeWindowCloseListener
    extends WindowAdapter {
        private BackOfficeWindow backOfficeWindow;

        public BackofficeWindowCloseListener(BackOfficeWindow backOfficeWindow) {
            this.backOfficeWindow = backOfficeWindow;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            super.windowClosing(e);
            this.backOfficeWindow.removeWindowListener(this);
            PosWindow posWindow = Application.getPosWindow();
            posWindow.setVisible(true);
        }
    }
}

