/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.swing.POSTitleLabel;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.TicketSplitView;
import com.floreantpos.ui.views.order.actions.SplitItemSelectionListener;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.beanutils.PropertyUtils;

public class ManuallySplitTicketDialog
extends POSDialog
implements SplitItemSelectionListener {
    private Ticket ticket;
    private PosButton btnCancel;
    private PosButton btnFinish;
    private POSTitleLabel lblTicketId;
    private TicketSplitView mainTicketView;
    private TicketSplitView ticketView2;
    private TransparentPanel actionButtonPanel;
    private TransparentPanel centerPanel;
    private TransparentPanel toolbarPanel;
    private TransparentPanel ticketPanel;
    private List<Ticket> splitTickets = new ArrayList<Ticket>();
    private Map<Integer, TicketButton> ticketMap = new HashMap<Integer, TicketButton>();
    private int splitQuantity;
    private ButtonGroup group;
    private JPanel topPanel;

    public ManuallySplitTicketDialog() {
        super(POSUtil.getFocusedWindow(), POSConstants.SPLIT_TICKET);
        this.initComponents();
        this.mainTicketView.setTicketView1(this.ticketView2);
        this.ticketView2.setTicketView1(this.mainTicketView);
        this.mainTicketView.setViewNumber(1);
        this.ticketView2.setViewNumber(2);
        this.setBounds(Application.getPosWindow().getBounds());
    }

    private void initComponents() {
        this.centerPanel = new TransparentPanel(new BorderLayout());
        this.createActionButtonPanel();
        this.createToolbarPanel();
        this.createTicketViewPanel();
        this.centerPanel.add((Component)this.ticketPanel, "Center");
        this.getContentPane().add((Component)this.centerPanel, "Center");
    }

    public void allowCustomerSelection(boolean b) {
        this.mainTicketView.allowCustomerSelection(b);
        this.ticketView2.allowCustomerSelection(b);
    }

    private void createToolbarPanel() {
        this.topPanel = new JPanel((LayoutManager)new MigLayout("center"));
        this.toolbarPanel = new TransparentPanel();
        this.lblTicketId = new POSTitleLabel();
        this.lblTicketId.setText(Messages.getString("SplitTicketDialog.0"));
        this.group = new ButtonGroup();
        this.toolbarPanel.add(this.lblTicketId);
        JSeparator separator = new JSeparator(1);
        separator.setPreferredSize(new Dimension(5, 50));
        this.toolbarPanel.add(separator);
        PosButton btnNewTicket = new PosButton(Messages.getString("ManuallySplitTicketDialog.1"));
        btnNewTicket.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManuallySplitTicketDialog.this.doAddNewTicketButton();
            }
        });
        PosButton btnRemoveTicket = new PosButton("");
        btnRemoveTicket.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManuallySplitTicketDialog.this.doRemoveTicketButton();
            }
        });
        btnNewTicket.setIcon(new ImageIcon(this.getClass().getResource("/images/plus.png")));
        btnRemoveTicket.setIcon(new ImageIcon(this.getClass().getResource("/images/minus2.png")));
        this.topPanel.add((Component)this.toolbarPanel, "split 2");
        this.topPanel.add(btnNewTicket);
        this.topPanel.add(btnRemoveTicket);
        this.centerPanel.add((Component)this.topPanel, "North");
    }

    private void createTicketViewPanel() {
        this.ticketPanel = new TransparentPanel((LayoutManager)new MigLayout("fill,inset 0 20 0 20, hidemode 3"));
        this.mainTicketView = new TicketSplitView(this);
        this.ticketView2 = new TicketSplitView(this);
        this.ticketPanel.add((Component)this.mainTicketView, "grow");
        this.ticketPanel.add((Component)this.ticketView2, "grow");
    }

    private void createActionButtonPanel() {
        this.actionButtonPanel = new TransparentPanel();
        this.btnFinish = new PosButton();
        this.btnFinish.setText(POSConstants.FINISH);
        this.btnFinish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManuallySplitTicketDialog.this.btnFinishActionPerformed(evt);
            }
        });
        this.actionButtonPanel.add(this.btnFinish);
        this.btnCancel = new PosButton();
        this.btnCancel.setText(POSConstants.CANCEL);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManuallySplitTicketDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.actionButtonPanel.add(this.btnCancel);
        this.getContentPane().add((Component)this.actionButtonPanel, "South");
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.setTicket(null, 0);
        this.dispose();
    }

    private synchronized void btnFinishActionPerformed(ActionEvent evt) {
        this.splitTickets.add(this.ticket);
        this.ticket.setSplitOrder(1);
        for (int i = 1; i < this.ticketMap.size(); ++i) {
            Ticket newSplitTicket = this.ticketMap.get(i + 1).getTicket();
            List<TicketItem> ticketItems = newSplitTicket.getTicketItems();
            if (newSplitTicket == null || ticketItems.isEmpty()) continue;
            newSplitTicket.setOrderType(this.ticket.getOrderType());
            this.transferTicketDiscounts(newSplitTicket);
            newSplitTicket.setSplitOrder(i + 1);
            newSplitTicket.calculatePrice();
            List deletedItems = newSplitTicket.getDeletedItems();
            if (deletedItems != null) {
                deletedItems.clear();
            }
            this.splitTickets.add(newSplitTicket);
        }
        this.updateTicketDiscounts();
        List deletedItems = this.ticket.getDeletedItems();
        if (deletedItems != null) {
            deletedItems.clear();
        }
        this.ticket.calculatePrice();
        this.setCanceled(false);
        this.dispose();
    }

    private void transferTicketDiscounts(Ticket newTicket) {
        ArrayList<TicketDiscount> newTicketDiscounts = new ArrayList<TicketDiscount>();
        try {
            List<TicketDiscount> ticketDiscounts = this.ticket.getDiscounts();
            for (TicketDiscount ticketDiscount : ticketDiscounts) {
                TicketDiscount newTicketDiscount = new TicketDiscount();
                PropertyUtils.copyProperties((Object)newTicketDiscount, (Object)ticketDiscount);
                newTicketDiscount.setId(null);
                newTicketDiscount.setCouponQuantity(ticketDiscount.getCouponQuantity() / (double)this.splitQuantity);
                newTicketDiscount.setTicket(newTicket);
                newTicketDiscounts.add(newTicketDiscount);
            }
            newTicket.setDiscounts(newTicketDiscounts);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<TicketDiscount> updateTicketDiscounts() {
        ArrayList<TicketDiscount> newTicketDiscounts = new ArrayList<TicketDiscount>();
        try {
            List<TicketDiscount> ticketDiscounts = this.ticket.getDiscounts();
            for (TicketDiscount ticketDiscount : ticketDiscounts) {
                ticketDiscount.setCouponQuantity(ticketDiscount.getCouponQuantity() / (double)this.splitQuantity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newTicketDiscounts;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket, int splitQuantity) {
        this.ticketMap.clear();
        this.ticket = ticket;
        this.splitQuantity = splitQuantity;
        if (ticket != null) {
            this.lblTicketId.setText(POSConstants.ORIGINAL_TICKET_ID + ": " + (ticket.getId() == null ? "[New Ticket]" : ticket.getId()));
            this.mainTicketView.setTicket(ticket);
            this.mainTicketView.setTotalTicketQuantity(splitQuantity);
            for (int i = 0; i < splitQuantity; ++i) {
                TicketButton btnTicket = new TicketButton(this.createNewTicket(), i + 1);
                this.ticketMap.put(i + 1, btnTicket);
                if (btnTicket.viewNumber == 2) {
                    btnTicket.setSelected(true);
                }
                if (btnTicket.viewNumber == 1) {
                    btnTicket.setVisible(false);
                }
                this.toolbarPanel.add(btnTicket);
                this.group.add(btnTicket);
            }
            this.ticketView2.setTicket(this.ticketMap.get(2).getTicket());
        }
    }

    private void doAddNewTicketButton() {
        this.splitQuantity = this.ticketMap.values().size() + 1;
        TicketButton btnTicket = new TicketButton(this.createNewTicket(), this.splitQuantity);
        this.ticketMap.put(this.splitQuantity, btnTicket);
        this.group.add(btnTicket);
        this.toolbarPanel.add(btnTicket);
        this.ticketView2.setTicket(btnTicket.getTicket());
        this.ticketView2.setViewNumber(this.splitQuantity);
        this.toolbarPanel.revalidate();
        this.toolbarPanel.repaint();
        this.mainTicketView.setTotalTicketQuantity(this.ticketMap.values().size());
        btnTicket.setSelected(true);
    }

    private void doRemoveTicketButton() {
        TicketButton btnTicket = this.ticketMap.get(this.ticketView2.getViewNumber());
        if (btnTicket.getTicket().getTicketItems().size() > 0) {
            POSMessageDialog.showMessage(Messages.getString("ManuallySplitTicketDialog.4"));
            return;
        }
        if (btnTicket.viewNumber == 2) {
            return;
        }
        int previousTicketNumber = btnTicket.viewNumber - 1;
        this.toolbarPanel.remove(btnTicket);
        this.ticketMap.remove(btnTicket.viewNumber);
        ArrayList<TicketButton> addedTicketButtons = new ArrayList<TicketButton>();
        addedTicketButtons.addAll(this.ticketMap.values());
        this.ticketMap.clear();
        int viewNumber = 1;
        for (TicketButton ticketButton : addedTicketButtons) {
            ticketButton.setViewNumber(viewNumber);
            this.ticketMap.put(viewNumber, ticketButton);
            ++viewNumber;
        }
        this.toolbarPanel.revalidate();
        this.toolbarPanel.repaint();
        TicketButton btnPrevious = this.ticketMap.get(previousTicketNumber);
        btnPrevious.setSelected(true);
        this.ticketView2.setTicket(btnPrevious.getTicket());
        this.ticketView2.setViewNumber(previousTicketNumber);
        --this.splitQuantity;
    }

    private Ticket createNewTicket() {
        ArrayList<Integer> tableNumbers = new ArrayList<Integer>();
        List<Integer> ticketTableNumbers = this.ticket.getTableNumbers();
        if (ticketTableNumbers != null) {
            tableNumbers.addAll(ticketTableNumbers);
        }
        Ticket splitTicket = this.ticket.clone(this.ticket);
        splitTicket.setId(null);
        splitTicket.setTokenNo(null);
        splitTicket.setShortId(null);
        splitTicket.setTicketItems(null);
        splitTicket.setTransactions(null);
        splitTicket.setProperties(null);
        splitTicket.setDiscounts(null);
        splitTicket.setTableNumbers(tableNumbers);
        splitTicket.setGratuity(null);
        splitTicket.calculatePrice();
        return splitTicket;
    }

    public List<Ticket> getSplitTickets() {
        return this.splitTickets;
    }

    @Override
    public void itemSelected(TicketItem ticketItem, TicketSplitView fromView, TicketSplitView toView, int itemSplitType, Double quantity) {
        this.splitQuantity = this.ticketMap.size();
        if (itemSplitType == 2) {
            this.shareTicketItemToAll(ticketItem);
        } else if (itemSplitType == 3) {
            List<Integer> viewNumbers = fromView.getViewNumbers();
            this.splitQuantity = viewNumbers.size();
            this.shareTicketItemToAll(ticketItem, viewNumbers);
        } else if (itemSplitType == 0) {
            this.splitQuantity = 2;
            ArrayList<Integer> viewNumbers = new ArrayList<Integer>();
            viewNumbers.add(fromView.getViewNumber());
            viewNumbers.add(toView.getViewNumber());
            this.shareTicketItemToAll(ticketItem, viewNumbers);
            this.shareModifiersToAll(ticketItem, this.splitQuantity);
        } else {
            this.splitQuantity = 1;
            if (ticketItem.isHasModifiers().booleanValue() && this.splitQuantity < 1) {
                return;
            }
            if (ticketItem.isTreatAsSeat().booleanValue()) {
                this.transferSeatTicketItems(ticketItem, fromView, toView);
            } else {
                List<TicketItem> viewToticketItems;
                TicketItem seatTicketItem = this.getSelectedSeatTicketItem(ticketItem);
                if (seatTicketItem != null && ((viewToticketItems = toView.getTicket().getTicketItems()).isEmpty() || seatTicketItem.getSeatNumber().intValue() != viewToticketItems.get(viewToticketItems.size() - 1).getSeatNumber().intValue())) {
                    TicketItem newSeat = this.createNewTicketItem(seatTicketItem);
                    newSeat.setTicket(toView.getTicket());
                    toView.getTicket().addToticketItems(newSeat);
                }
                this.transferTicketItem(ticketItem, fromView, toView, false, quantity);
                this.doRemoveEmptySeat(seatTicketItem, fromView.getTicket());
            }
        }
        fromView.updateModel();
        fromView.getTicketViewerTable().updateView();
        fromView.updateView();
        toView.updateModel();
        toView.getTicketViewerTable().updateView();
        toView.updateView();
    }

    private void doRemoveEmptySeat(TicketItem ticketItem, Ticket fromTicket) {
        boolean itemFound = false;
        boolean removeSeat = true;
        for (TicketItem item : fromTicket.getTicketItems()) {
            if (item == ticketItem) {
                itemFound = true;
                continue;
            }
            if (!itemFound) continue;
            if (item.isTreatAsSeat().booleanValue()) break;
            removeSeat = false;
            break;
        }
        if (removeSeat) {
            fromTicket.getTicketItems().remove(ticketItem);
        }
    }

    protected TicketItem getSelectedSeatTicketItem(TicketItem item) {
        for (TicketItem ticketItem : item.getTicket().getTicketItems()) {
            if (!ticketItem.isTreatAsSeat().booleanValue() || ticketItem.getSeatNumber().intValue() != item.getSeatNumber().intValue()) continue;
            return ticketItem;
        }
        return null;
    }

    private void transferSeatTicketItems(TicketItem ticketItem, TicketSplitView fromView, TicketSplitView toView) {
        boolean itemFound = false;
        Iterator<TicketItem> iterator = fromView.getTicket().getTicketItems().iterator();
        while (iterator.hasNext()) {
            TicketItem newTicketItem;
            TicketItem item = iterator.next();
            if (item == ticketItem) {
                itemFound = true;
                newTicketItem = this.createNewTicketItem(item);
                newTicketItem.setTicket(toView.getTicket());
                toView.getTicket().addToticketItems(newTicketItem);
                iterator.remove();
                continue;
            }
            if (!itemFound) continue;
            if (item.isTreatAsSeat().booleanValue()) break;
            newTicketItem = this.createNewTicketItem(item);
            newTicketItem.setTicket(toView.getTicket());
            toView.getTicket().addToticketItems(newTicketItem);
            iterator.remove();
        }
    }

    private void shareTicketItemToAll(TicketItem ticketItem) {
        this.shareTicketItemToAll(ticketItem, null);
    }

    private void shareTicketItemToAll(TicketItem ticketItem, List<Integer> viewNumbers) {
        Double quantityValue = null;
        quantityValue = viewNumbers != null ? this.round(ticketItem.getQuantity() / (double)viewNumbers.size()) : this.round(ticketItem.getQuantity() / (double)this.splitQuantity);
        for (TicketButton ticketButton : this.ticketMap.values()) {
            if (viewNumbers != null && ticketButton.viewNumber == 1 && !viewNumbers.contains(1)) {
                this.mainTicketView.getTicket().getTicketItems().remove(ticketItem);
                continue;
            }
            if (viewNumbers != null && !viewNumbers.contains(ticketButton.viewNumber) || ticketButton.viewNumber == 1) continue;
            TicketItem newTicketItem = this.createNewTicketItem(ticketItem);
            newTicketItem.setFractionalUnit(true);
            ticketButton.getTicket().addToticketItems(newTicketItem);
            newTicketItem.setTicket(ticketButton.getTicket());
        }
        ticketItem.setQuantity(quantityValue + (ticketItem.getQuantity() - quantityValue * (double)this.splitQuantity));
        ticketItem.setInventoryAdjustQty(0.0);
        ticketItem.setFractionalUnit(true);
    }

    private Double round(double value) {
        return NumberUtil.round(value, 4);
    }

    private void shareModifiersToAll(TicketItem ticketItem, double splitQuantity) {
    }

    public void transferTicketItem(TicketItem ticketItem, TicketSplitView fromTicketView, TicketSplitView toTicketView, boolean fullTicketItem, Double quantity) {
        TicketItem newTicketItem = this.createNewTicketItem(ticketItem);
        newTicketItem.setPrintedToKitchen(ticketItem.isPrintedToKitchen());
        double ticketItemQuantity = this.round(ticketItem.getQuantity());
        if (Double.isInfinite(quantity)) {
            return;
        }
        if (quantity % 1.0 != 0.0) {
            newTicketItem.setFractionalUnit(true);
        }
        quantity = NumberUtil.roundToTwoDigit(quantity);
        newTicketItem.setMenuItemId(ticketItem.getMenuItemId());
        newTicketItem.setQuantity(quantity);
        toTicketView.getTicketViewerTable().addTicketItem(newTicketItem);
        if (ticketItemQuantity > quantity && !fullTicketItem) {
            double itemQuantity = ticketItem.getQuantity();
            ticketItem.setQuantity(itemQuantity - quantity);
            if (ticketItem.getQuantity() % 1.0 != 0.0) {
                ticketItem.setFractionalUnit(true);
            }
        } else {
            fromTicketView.getTicketViewerTable().delete(ticketItem.getTableRowNum());
        }
    }

    private TicketItem createNewTicketItem(TicketItem ticketItem) {
        try {
            TicketItem newTicketItem = ticketItem.cloneAsNew();
            newTicketItem.setQuantity(this.round(ticketItem.getQuantity() / (double)this.splitQuantity));
            if (newTicketItem.getQuantity() % 1.0 != 0.0) {
                newTicketItem.setFractionalUnit(true);
            }
            return newTicketItem;
        }
        catch (Exception exception) {
            return ticketItem;
        }
    }

    private class TicketButton
    extends POSToggleButton
    implements ActionListener {
        private Ticket ticket;
        private int viewNumber;

        TicketButton(Ticket ticket, int viewNumber) {
            this.ticket = ticket;
            this.viewNumber = viewNumber;
            this.setFont(this.getFont().deriveFont(1, PosUIManager.getFontSize(18)));
            this.setText("<html><body><center><h1>" + viewNumber + "</h1></center></body></html>");
            this.addActionListener(this);
        }

        public void setViewNumber(int viewNumber) {
            this.viewNumber = viewNumber;
            this.setText("<html><body><center><h1>" + viewNumber + "</h1></center></body></html>");
        }

        public Ticket getTicket() {
            return this.ticket;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TicketButton ticketButton = (TicketButton)ManuallySplitTicketDialog.this.ticketMap.get(this.viewNumber);
            Ticket ticket = ticketButton.getTicket();
            if (ticket != null) {
                ManuallySplitTicketDialog.this.ticketView2.setTicket(ticket);
                ManuallySplitTicketDialog.this.ticketView2.setViewNumber(this.viewNumber);
            }
        }
    }
}

