/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.POSConstants;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.util.NumberUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;

public class MergeTicketDialog
extends POSDialog {
    private List<Ticket> tickets;
    private Ticket mainTicket;
    private JTextField tfSubtotal;
    private JTextField tfTax;
    private JTextField tfDiscount;
    private JTextField tfTotal;

    public MergeTicketDialog(List<Ticket> tickets, Ticket mainTicket) {
        this.tickets = tickets;
        this.mainTicket = mainTicket;
        this.doMergeTickets();
        this.initComponents();
        this.updateView();
    }

    private void doMergeTickets() {
        try {
            this.mainTicket.getDiscounts().clear();
            Iterator<Ticket> iterator = this.tickets.iterator();
            while (iterator.hasNext()) {
                List<TicketDiscount> discounts;
                Ticket ticket = iterator.next();
                if (ticket.equals(this.mainTicket)) {
                    iterator.remove();
                    continue;
                }
                List<TicketItem> ticketItems = ticket.getTicketItems();
                if (ticketItems != null && ticketItems.size() > 0) {
                    for (TicketItem ticketItem : ticketItems) {
                        TicketItem cloneTicketItem = ticketItem.cloneAsNew();
                        cloneTicketItem.setTicket(this.mainTicket);
                        this.mainTicket.addToticketItems(cloneTicketItem);
                    }
                }
                if ((discounts = ticket.getDiscounts()) != null && discounts.size() > 0) {
                    ticket.getDiscounts().clear();
                }
                List<Integer> tableNumbers = ticket.getTableNumbers();
                for (Integer table : tableNumbers) {
                    if (this.mainTicket.getTableNumbers().contains(table)) continue;
                    this.mainTicket.getTableNumbers().add(table);
                }
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(10, 10));
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Merge preview");
        this.add((Component)titlePanel, "North");
        TransparentPanel ticketTableViewPanel = new TransparentPanel(new BorderLayout(5, 5));
        ticketTableViewPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        TicketViewerTable ticketViewerTable = new TicketViewerTable();
        ticketViewerTable.getModel().setTicket(this.mainTicket);
        PosScrollPane scrollPane = new PosScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setViewportView(ticketViewerTable);
        ticketTableViewPanel.add((Component)scrollPane, "Center");
        TransparentPanel ticketTotalPanel = new TransparentPanel((LayoutManager)new MigLayout("wrap 2,right,inset 5 5 5 "));
        JLabel lblSubtotal = new JLabel(POSConstants.SUBTOTAL + ":");
        JLabel lblDiscount = new JLabel(POSConstants.DISCOUNT + ":");
        JLabel lblTax = new JLabel(POSConstants.TAX + ":");
        JLabel lblTotal = new JLabel(POSConstants.TOTAL + ":");
        this.tfSubtotal = new JTextField();
        this.tfSubtotal.setHorizontalAlignment(11);
        this.tfSubtotal.setColumns(10);
        this.tfTax = new JTextField();
        this.tfTax.setHorizontalAlignment(11);
        this.tfTax.setColumns(10);
        this.tfDiscount = new JTextField();
        this.tfDiscount.setHorizontalAlignment(11);
        this.tfDiscount.setColumns(10);
        this.tfTotal = new JTextField();
        this.tfTotal.setHorizontalAlignment(11);
        this.tfTotal.setColumns(10);
        lblSubtotal.setHorizontalAlignment(4);
        ticketTotalPanel.add(lblSubtotal);
        this.tfSubtotal.setEditable(false);
        ticketTotalPanel.add(this.tfSubtotal);
        lblDiscount.setHorizontalAlignment(4);
        ticketTotalPanel.add(lblDiscount);
        this.tfDiscount.setEditable(false);
        ticketTotalPanel.add(this.tfDiscount);
        lblTax.setHorizontalAlignment(4);
        ticketTotalPanel.add(lblTax);
        this.tfTax.setEditable(false);
        ticketTotalPanel.add(this.tfTax);
        lblTotal.setHorizontalAlignment(4);
        ticketTotalPanel.add(lblTotal);
        this.tfTotal.setEditable(false);
        ticketTotalPanel.add(this.tfTotal);
        ticketTableViewPanel.add((Component)ticketTotalPanel, "South");
        this.add((Component)ticketTableViewPanel, "Center");
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("center"));
        PosButton btnOk = new PosButton("Done");
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergeTicketDialog.this.doMergeTicket();
            }
        });
        PosButton btnCancel = new PosButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergeTicketDialog.this.setCanceled(true);
                MergeTicketDialog.this.dispose();
            }
        });
        bottomPanel.add(btnOk);
        bottomPanel.add(btnCancel);
        this.add((Component)bottomPanel, "South");
        this.resizeColumnWidth(ticketViewerTable);
    }

    private void doMergeTicket() {
        try {
            TicketDAO.getInstance().saveMergedTickets(this.tickets, this.mainTicket);
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    public void updateView() {
        if (this.mainTicket == null || this.mainTicket.getTicketItems() == null || this.mainTicket.getTicketItems().size() <= 0) {
            this.tfSubtotal.setText("");
            this.tfDiscount.setText("");
            this.tfTax.setText("");
            this.tfTotal.setText("");
            return;
        }
        this.mainTicket.calculatePrice();
        this.tfSubtotal.setText(NumberUtil.formatNumber(this.mainTicket.getSubtotalAmount()));
        this.tfDiscount.setText(NumberUtil.formatNumber(this.mainTicket.getDiscountAmount()));
        this.tfTax.setText(NumberUtil.formatNumber(this.mainTicket.getTaxAmount()));
        this.tfTotal.setText(NumberUtil.formatNumber(this.mainTicket.getTotalAmountWithTips()));
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(200);
        columnWidth.add(100);
        columnWidth.add(100);
        return columnWidth;
    }

    public Ticket getMainTicket() {
        return this.mainTicket;
    }
}

