/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.GroupSettleTicketAction;
import com.floreantpos.actions.MergeTicketsAction;
import com.floreantpos.actions.RefundAction;
import com.floreantpos.actions.SendToKitchenAction;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.actions.ShowOrderInfoAction;
import com.floreantpos.actions.SplitTicketAction;
import com.floreantpos.actions.TicketCloseAction;
import com.floreantpos.actions.TicketEditAction;
import com.floreantpos.actions.TicketReorderAction;
import com.floreantpos.actions.TicketTransferAction;
import com.floreantpos.actions.TransferTicketItemsAction;
import com.floreantpos.actions.VoidPaymentAction;
import com.floreantpos.actions.VoidTicketAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.swing.OrderTypeButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TicketListUpdateListener;
import com.floreantpos.ui.order.TicketListView;
import com.floreantpos.ui.views.order.DefaultOrderServiceExtension;
import com.floreantpos.ui.views.order.ViewPanel;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXCollapsiblePane;

public class SwitchboardView
extends ViewPanel
implements TicketListUpdateListener {
    public static final String VIEW_NAME = POSConstants.ORDERS;
    private PosButton btnEditTicket = new PosButton(POSConstants.EDIT_TICKET_BUTTON_TEXT);
    private PosButton btnSendTicket = new PosButton("SEND");
    private PosButton btnGroupSettle = new PosButton(POSConstants.GROUP_SETTLE_BUTTON_TEXT);
    private PosButton btnOrderInfo = new PosButton(POSConstants.ORDER_INFO_BUTTON_TEXT);
    private PosButton btnReorder = new PosButton("REORDER");
    private PosButton btnTransferServer = new PosButton("TRANSFER SERVER");
    private PosButton btnSettleTicket = new PosButton(POSConstants.SETTLE_TICKET_BUTTON_TEXT);
    private PosButton btnSplitTicket = new PosButton(POSConstants.SPLIT_TICKET_BUTTON_TEXT);
    private PosButton btnMergeTickets = new PosButton("MERGE");
    private PosButton btnVoidTicket = new PosButton(POSConstants.VOID_TICKET_BUTTON_TEXT);
    private PosButton btnRefundTicket = new PosButton(POSConstants.REFUND_BUTTON_TEXT);
    private PosButton btnReversePayment = new PosButton();
    private PosButton btnCloseOrder = new PosButton(POSConstants.CLOSE_ORDER_BUTTON_TEXT);
    private PosButton btnTransferItems = new PosButton("TRANSFER ITEMS");
    private TicketListView ticketList = new TicketListView();
    private TitledBorder ticketsListPanelBorder;
    private static SwitchboardView instance;

    private SwitchboardView() {
        this.initComponents();
        this.initActions();
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
    }

    private void initActions() {
        this.btnEditTicket.setAction(new TicketEditAction(this.ticketList));
        this.btnGroupSettle.addActionListener(new GroupSettleTicketAction(this.ticketList));
        this.btnOrderInfo.addActionListener(new ShowOrderInfoAction(this.ticketList));
        this.btnReorder.addActionListener(new TicketReorderAction(this.ticketList));
        this.btnTransferServer.addActionListener(new TicketTransferAction(this.ticketList));
        this.btnSettleTicket.setAction(new SettleTicketAction(this.ticketList));
        this.btnSplitTicket.addActionListener(new SplitTicketAction(this.ticketList));
        this.btnMergeTickets.addActionListener(new MergeTicketsAction());
        this.btnVoidTicket.setAction(new VoidTicketAction(this.ticketList));
        this.btnRefundTicket.setAction(new RefundAction(this.ticketList));
        this.btnCloseOrder.setAction(new TicketCloseAction(this.ticketList));
        this.btnReversePayment.setAction(new VoidPaymentAction(this.ticketList));
        this.btnSendTicket.setAction(new SendToKitchenAction(this.ticketList));
        this.btnTransferItems.addActionListener(new TransferTicketItemsAction());
    }

    public static SwitchboardView getInstance() {
        if (instance == null) {
            instance = new SwitchboardView();
        }
        return instance;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(10, 10));
        JPanel centerPanel = new JPanel(new BorderLayout(5, 5));
        centerPanel.add((Component)this.createActivityPanel(), "Center");
        centerPanel.add((Component)this.createRightOrdersPanel(), "East");
        this.add((Component)centerPanel, "Center");
    }

    private JPanel createRightOrdersPanel() {
        JPanel rightOrderButtonPanel = new JPanel(new BorderLayout(20, 20));
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(null, "-", 2, 0);
        rightOrderButtonPanel.setBorder(new CompoundBorder(titledBorder2, new EmptyBorder(0, 2, 2, 2)));
        JPanel orderPanel = new JPanel((LayoutManager)new MigLayout("ins 2 2 0 2, fill, hidemode 3, flowy", "fill, grow", ""));
        List<OrderType> orderTypes = Application.getInstance().getOrderTypes();
        for (OrderType orderType : orderTypes) {
            orderPanel.add((Component)new OrderTypeButton(orderType), "grow");
        }
        rightOrderButtonPanel.add(orderPanel);
        rightOrderButtonPanel.setMinimumSize(PosUIManager.getSize(120, 0));
        return rightOrderButtonPanel;
    }

    private JPanel createActivityPanel() {
        JPanel ticketsAndActivityPanel = new JPanel(new BorderLayout(5, 5));
        this.ticketsListPanelBorder = BorderFactory.createTitledBorder(null, POSConstants.OPEN_TICKETS_AND_ACTIVITY, 2, 0);
        ticketsAndActivityPanel.setBorder(new CompoundBorder(this.ticketsListPanelBorder, new EmptyBorder(2, 1, 2, 1)));
        ticketsAndActivityPanel.add((Component)this.ticketList, "Center");
        JPanel activityPanel = new JPanel(new BorderLayout(2, 5));
        JPanel innerActivityPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3, fill, ins 0", "fill, grow", ""));
        JPanel firstRowButtonPanel = new JPanel(new GridLayout(1, 0, 5, 5));
        final JXCollapsiblePane secondRowButtonPanel = new JXCollapsiblePane();
        secondRowButtonPanel.setAnimated(false);
        secondRowButtonPanel.setCollapsed(true);
        secondRowButtonPanel.setVisible(false);
        secondRowButtonPanel.getContentPane().setLayout(new GridLayout(1, 0, 5, 5));
        if (Application.getInstance().getTerminal().isHasCashDrawer().booleanValue()) {
            firstRowButtonPanel.add(this.btnOrderInfo);
            firstRowButtonPanel.add(this.btnEditTicket);
            firstRowButtonPanel.add(this.btnSendTicket);
            firstRowButtonPanel.add(this.btnSettleTicket);
            firstRowButtonPanel.add(this.btnSplitTicket);
            firstRowButtonPanel.add(this.btnCloseOrder);
            secondRowButtonPanel.getContentPane().add(this.btnMergeTickets);
            secondRowButtonPanel.getContentPane().add(this.btnTransferServer);
            secondRowButtonPanel.getContentPane().add(this.btnTransferItems);
            secondRowButtonPanel.getContentPane().add(this.btnGroupSettle);
            secondRowButtonPanel.getContentPane().add(this.btnReorder);
        } else {
            firstRowButtonPanel.add(this.btnOrderInfo);
            firstRowButtonPanel.add(this.btnEditTicket);
            firstRowButtonPanel.add(this.btnSendTicket);
            firstRowButtonPanel.add(this.btnTransferServer);
            firstRowButtonPanel.add(this.btnCloseOrder);
            firstRowButtonPanel.add(this.btnSplitTicket);
            firstRowButtonPanel.add(this.btnMergeTickets);
            secondRowButtonPanel.getContentPane().add(this.btnTransferItems);
            secondRowButtonPanel.getContentPane().add(this.btnReorder);
        }
        innerActivityPanel.add(firstRowButtonPanel);
        innerActivityPanel.add((Component)secondRowButtonPanel, "newline");
        this.ticketList.addTicketListUpateListener(this);
        final PosButton btnMore = new PosButton(POSConstants.MORE_ACTIVITY_BUTTON_TEXT);
        btnMore.setPreferredSize(new Dimension(PosUIManager.getSize(50), 0));
        btnMore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean collapsed = secondRowButtonPanel.isCollapsed();
                secondRowButtonPanel.setVisible(collapsed);
                secondRowButtonPanel.setCollapsed(!collapsed);
                if (collapsed) {
                    btnMore.setText(POSConstants.LESS_ACTIVITY_BUTTON_TEXT);
                } else {
                    btnMore.setText(POSConstants.MORE_ACTIVITY_BUTTON_TEXT);
                }
            }
        });
        OrderServiceExtension orderServiceExtension = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
        if (orderServiceExtension == null) {
            this.btnReversePayment.setEnabled(false);
            orderServiceExtension = new DefaultOrderServiceExtension();
        }
        activityPanel.add(innerActivityPanel);
        activityPanel.add((Component)btnMore, "East");
        ticketsAndActivityPanel.add((Component)activityPanel, "South");
        return ticketsAndActivityPanel;
    }

    public void updateView() {
        Set<UserPermission> permissions;
        User user = Application.getCurrentUser();
        UserType userType = user.getType();
        if (userType != null && (permissions = userType.getPermissions()) != null) {
            this.btnEditTicket.setEnabled(false);
            this.btnGroupSettle.setEnabled(false);
            this.btnReorder.setEnabled(false);
            this.btnTransferServer.setEnabled(false);
            this.btnSettleTicket.setEnabled(false);
            this.btnSplitTicket.setEnabled(false);
            for (UserPermission permission : permissions) {
                if (permission.equals(UserPermission.VOID_TICKET)) {
                    this.btnVoidTicket.setEnabled(true);
                    continue;
                }
                if (permission.equals(UserPermission.SETTLE_TICKET)) {
                    this.btnSettleTicket.setEnabled(true);
                    this.btnGroupSettle.setEnabled(true);
                    continue;
                }
                if (permission.equals(UserPermission.SPLIT_TICKET)) {
                    this.btnSplitTicket.setEnabled(true);
                    continue;
                }
                if (permission.equals(UserPermission.CREATE_TICKET)) {
                    this.btnEditTicket.setEnabled(true);
                    continue;
                }
                if (permission.equals(UserPermission.REOPEN_TICKET)) {
                    this.btnReorder.setEnabled(true);
                    continue;
                }
                if (!permission.equals(UserPermission.TRANSFER_TICKET)) continue;
                this.btnTransferServer.setEnabled(true);
            }
        }
        if (!this.isDataInitialized()) {
            this.updateTicketList();
            this.setDataInitialized(true);
            this.setDataInitializedForUser(Application.getCurrentUser());
        } else if (!Application.getCurrentUser().equals(this.getDataInitializedForUser())) {
            this.updateTicketList();
            this.setDataInitialized(true);
            this.setDataInitializedForUser(Application.getCurrentUser());
        }
    }

    public synchronized void updateTicketList() {
        this.ticketList.updateTicketList();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateView();
            this.ticketList.setAutoUpdateCheck(true);
        } else {
            this.ticketList.setAutoUpdateCheck(false);
        }
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    @Override
    public void refresh() {
        this.setDataInitialized(false);
        this.updateView();
    }

    @Override
    public void ticketListUpdated() {
        String paymentStatusFilter = TerminalConfig.getPaymentStatusFilter().getDisplayString();
        String orderTypeFilter = TerminalConfig.getOrderTypeFilter();
        String title = POSConstants.OPEN_TICKETS_AND_ACTIVITY + " [" + Messages.getString("SwitchboardView.27") + ": " + paymentStatusFilter + ", " + orderTypeFilter + " ]";
        this.ticketsListPanelBorder.setTitle(title);
    }

    @Override
    public DataChangeListener getDataChangeListener() {
        return this.ticketList;
    }
}

