/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.MultipleNumberSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.ui.views.order.actions.SplitItemSelectionListener;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class TicketSplitView
extends TransparentPanel
implements TableModelListener {
    private Ticket ticket;
    public static final String VIEW_NAME = "TICKET_FOR_SPLIT_VIEW";
    private TicketSplitView ticketView1;
    private PosButton btnScrollDown;
    private PosButton btnScrollUp;
    private PosButton btnTransferToTicket1;
    private PosButton btnHalf;
    private PosButton btnShared;
    private JScrollPane scrollPane;
    private JTextField tfDiscount;
    private JTextField tfSubtotal;
    private JTextField tfTax;
    private JTextField tfTotal;
    private TicketViewerTable ticketViewerTable;
    private int viewNumber = 1;
    protected int splitNumber;
    private SplitItemSelectionListener listener;
    private PosButton btnCustomQty;
    private int noOfCustomSplit;
    private int totalTicketQuantity;
    private List<Integer> selectedTicketNumbers;
    private JPanel customerInfoPanel;
    private JLabel lblCustomerName;
    private PosButton btnChangeMember;

    public TicketSplitView(SplitItemSelectionListener listener) {
        this.listener = listener;
        this.initComponents();
        this.setOpaque(true);
        this.setTicket(this.ticket);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createTitledBorder(null, POSConstants.TICKET, 2, 0));
        this.setPreferredSize(PosUIManager.getSize(280, 463));
        TransparentPanel ticketTableViewPanel = new TransparentPanel(new BorderLayout());
        ticketTableViewPanel.setBorder(new EmptyBorder(0, 5, 0, 0));
        int rightGap = PosUIManager.getSize(60) + 10;
        TransparentPanel ticketTotalPanel = new TransparentPanel((LayoutManager)new MigLayout("wrap 2,right,inset 5 5 5 " + rightGap + " "));
        TransparentPanel rightButtonPanel = new TransparentPanel((LayoutManager)new MigLayout("wrap 1,fill,hidemode 3,inset 1"));
        JLabel lblSubtotal = new JLabel(POSConstants.SUBTOTAL + ":");
        JLabel lblTotal = new JLabel(POSConstants.TOTAL + ":");
        JLabel lblDiscount = new JLabel(POSConstants.DISCOUNT + ":");
        JLabel lblTax = new JLabel(POSConstants.TAX + ":");
        this.tfSubtotal = new JTextField();
        this.tfSubtotal.setHorizontalAlignment(11);
        this.tfSubtotal.setColumns(10);
        this.tfTax = new JTextField();
        this.tfTax.setHorizontalAlignment(11);
        this.tfTax.setColumns(10);
        this.tfDiscount = new JTextField();
        this.tfDiscount.setHorizontalAlignment(11);
        this.tfDiscount.setColumns(10);
        this.tfTotal = new JTextField();
        this.tfTotal.setHorizontalAlignment(11);
        this.tfTotal.setColumns(10);
        this.btnScrollUp = new PosButton();
        this.btnScrollDown = new PosButton();
        this.btnTransferToTicket1 = new PosButton();
        this.scrollPane = new JScrollPane();
        this.ticketViewerTable = new TicketViewerTable();
        lblSubtotal.setHorizontalAlignment(4);
        ticketTotalPanel.add(lblSubtotal);
        this.tfSubtotal.setEditable(false);
        ticketTotalPanel.add(this.tfSubtotal);
        lblDiscount.setHorizontalAlignment(4);
        ticketTotalPanel.add(lblDiscount);
        this.tfDiscount.setEditable(false);
        ticketTotalPanel.add(this.tfDiscount);
        lblTax.setHorizontalAlignment(4);
        ticketTotalPanel.add(lblTax);
        this.tfTax.setEditable(false);
        ticketTotalPanel.add(this.tfTax);
        lblTotal.setHorizontalAlignment(4);
        ticketTotalPanel.add(lblTotal);
        this.tfTotal.setEditable(false);
        ticketTotalPanel.add(this.tfTotal);
        this.btnScrollUp.setIcon(IconFactory.getIcon("/ui_icons/", "up.png"));
        this.btnScrollUp.setPreferredSize(PosUIManager.getSize(60, 50));
        this.btnScrollUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TicketSplitView.this.doScrollUp(evt);
            }
        });
        rightButtonPanel.add((Component)this.btnScrollUp, "grow");
        this.btnScrollDown.setIcon(IconFactory.getIcon("/ui_icons/", "down.png"));
        this.btnScrollDown.setPreferredSize(PosUIManager.getSize(60, 50));
        this.btnScrollDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TicketSplitView.this.doScrollDown(evt);
            }
        });
        rightButtonPanel.add((Component)this.btnScrollDown, "grow");
        this.btnTransferToTicket1.setPreferredSize(PosUIManager.getSize(60, 50));
        this.btnTransferToTicket1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TicketSplitView.this.btnTransferToTicket1ActionPerformed(1);
            }
        });
        rightButtonPanel.add((Component)this.btnTransferToTicket1, "grow");
        this.btnHalf = new PosButton();
        this.btnHalf.setText("1/2");
        this.btnHalf.setPreferredSize(PosUIManager.getSize(60, 50));
        this.btnHalf.setFont(new Font("Tahoma", 1, 18));
        this.btnHalf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TicketSplitView.this.btnTransferToTicket1ActionPerformed(0);
            }
        });
        rightButtonPanel.add((Component)this.btnHalf, "grow");
        this.btnShared = new PosButton(">>>");
        this.btnShared.setFont(new Font("Tahoma", 1, 18));
        this.btnShared.setPreferredSize(PosUIManager.getSize(60, 50));
        this.btnShared.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TicketSplitView.this.btnTransferToTicket1ActionPerformed(2);
            }
        });
        rightButtonPanel.add((Component)this.btnShared, "grow");
        this.btnCustomQty = new PosButton("...");
        this.btnCustomQty.setFont(new Font("Tahoma", 1, 18));
        this.btnCustomQty.setPreferredSize(PosUIManager.getSize(60, 50));
        this.btnCustomQty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TicketSplitView.this.btnTransferToTicket1ActionPerformed(3);
            }
        });
        rightButtonPanel.add((Component)this.btnCustomQty, "grow");
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.scrollPane.setViewportView(this.ticketViewerTable);
        ticketTableViewPanel.add((Component)this.scrollPane, "Center");
        this.add((Component)rightButtonPanel, "East");
        this.add((Component)ticketTotalPanel, "South");
        this.add((Component)ticketTableViewPanel, "Center");
    }

    private void createCustomerInfoPanel() {
        JPanel memberInfoPanel = new JPanel(new BorderLayout());
        memberInfoPanel.setBackground(Color.red);
        this.btnChangeMember = new PosButton("Change Member");
        this.lblCustomerName = new JLabel();
        this.customerInfoPanel = new JPanel((LayoutManager)new MigLayout("", "", "grow"));
        JLabel lblMemName = new JLabel("Member:");
        this.customerInfoPanel.add(lblMemName);
        this.customerInfoPanel.add((Component)this.lblCustomerName, "grow");
        memberInfoPanel.add((Component)this.customerInfoPanel, "Center");
        memberInfoPanel.add((Component)this.btnChangeMember, "East");
        this.btnChangeMember.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TicketSplitView.this.doChangeMember();
            }
        });
        this.add((Component)memberInfoPanel, "North");
    }

    private void btnTransferToTicket1ActionPerformed(int itemSplitType) {
        try {
            int selectedRow;
            ITicketItem object;
            if (this.ticketView1 != null && this.ticketView1.isVisible() && (object = this.ticketViewerTable.get(selectedRow = this.ticketViewerTable.getSelectedRow())) instanceof TicketItem) {
                TicketItem ticketItem = (TicketItem)object;
                double ticketItemQuantity = ticketItem.getQuantity();
                double splitQuantity = 1.0;
                if (itemSplitType == 1) {
                    if (ticketItemQuantity < 1.0) {
                        splitQuantity = ticketItemQuantity;
                    }
                } else if (itemSplitType == 0) {
                    splitQuantity = ticketItemQuantity / 2.0;
                } else if (itemSplitType == 3) {
                    ArrayList<Integer> viewNumbers = new ArrayList<Integer>();
                    for (int i = 0; i < this.totalTicketQuantity; ++i) {
                        viewNumbers.add(i + 1);
                    }
                    if (viewNumbers.size() < 2) {
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please choose more than two split.");
                        return;
                    }
                    MultipleNumberSelectionDialog dialog = new MultipleNumberSelectionDialog(viewNumbers);
                    dialog.pack();
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    this.selectedTicketNumbers = dialog.getViewNumbers();
                    if (this.selectedTicketNumbers == null || this.selectedTicketNumbers.isEmpty()) {
                        return;
                    }
                }
                this.listener.itemSelected((TicketItem)object, this, this.ticketView1, itemSplitType, splitQuantity);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    public void allowCustomerSelection(boolean b) {
        if (b) {
            this.createCustomerInfoPanel();
        }
    }

    public int getNoOfCustomSplit() {
        return this.noOfCustomSplit;
    }

    public List<Integer> getViewNumbers() {
        return this.selectedTicketNumbers;
    }

    private void doScrollDown(ActionEvent evt) {
        this.ticketViewerTable.scrollDown();
    }

    private void doScrollUp(ActionEvent evt) {
        this.ticketViewerTable.scrollUp();
    }

    public void updateModel() {
        this.ticket.calculatePrice();
    }

    public void updateView() {
        if (this.ticket == null || this.ticket.getTicketItems() == null || this.ticket.getTicketItems().size() <= 0) {
            this.tfSubtotal.setText("");
            this.tfDiscount.setText("");
            this.tfTax.setText("");
            this.tfTotal.setText("");
            if (this.ticket != null && this.customerInfoPanel != null) {
                Customer customer = this.ticket.getCustomer();
                if (customer != null) {
                    this.updateCustomerInfo(customer);
                } else {
                    this.lblCustomerName.setText(this.ticket.getProperty("CUSTOMER_NAME"));
                }
            }
            return;
        }
        this.ticket.calculatePrice();
        if (this.customerInfoPanel != null) {
            Customer customer = this.ticket.getCustomer();
            if (customer != null) {
                this.updateCustomerInfo(customer);
            } else {
                this.lblCustomerName.setText(this.ticket.getProperty("CUSTOMER_NAME"));
            }
        }
        this.tfSubtotal.setText(NumberUtil.formatNumber(this.ticket.getSubtotalAmount()));
        this.tfDiscount.setText(NumberUtil.formatNumber(this.ticket.getDiscountAmount()));
        this.tfTax.setText(NumberUtil.formatNumber(this.ticket.getTaxAmount()));
        this.tfTotal.setText(NumberUtil.formatNumber(this.ticket.getTotalAmountWithTips()));
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket _ticket) {
        this.ticket = _ticket;
        this.ticketViewerTable.setTicket(_ticket);
        this.updateView();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.ticket == null || this.ticket.getTicketItems() == null || this.ticket.getTicketItems().size() <= 0) {
            this.tfSubtotal.setText("");
            this.tfDiscount.setText("");
            this.tfTax.setText("");
            this.tfTotal.setText("");
            return;
        }
        this.ticket.calculatePrice();
        this.tfSubtotal.setText(NumberUtil.formatNumber(this.ticket.getSubtotalAmount()));
        this.tfDiscount.setText(NumberUtil.formatNumber(this.ticket.getDiscountAmount()));
        this.tfTax.setText(NumberUtil.formatNumber(this.ticket.getTaxAmount()));
        this.tfTotal.setText(NumberUtil.formatNumber(this.ticket.getTotalAmountWithTips()));
    }

    public TicketSplitView getTicketView1() {
        return this.ticketView1;
    }

    public void setTicketView1(TicketSplitView ticketView1) {
        this.ticketView1 = ticketView1;
    }

    public int getViewNumber() {
        return this.viewNumber;
    }

    public TicketViewerTable getTicketViewerTable() {
        return this.ticketViewerTable;
    }

    public void setViewNumber(int viewNumber) {
        this.viewNumber = viewNumber;
        if (viewNumber != 1) {
            this.btnShared.setVisible(false);
            this.btnHalf.setVisible(false);
            this.btnCustomQty.setVisible(false);
        }
        String title = Messages.getString("TicketForSplitView.1") + viewNumber;
        if (viewNumber == 1) {
            title = Messages.getString("TicketSplitView.14");
        }
        TitledBorder titledBorder = new TitledBorder(title);
        titledBorder.setTitleJustification(2);
        this.setBorder(titledBorder);
        switch (viewNumber) {
            case 1: {
                this.btnTransferToTicket1.setIcon(IconFactory.getIcon("next.png"));
                break;
            }
            case 2: {
                this.btnTransferToTicket1.setIcon(IconFactory.getIcon("previous.png"));
            }
        }
    }

    public void setTotalTicketQuantity(int size) {
        this.totalTicketQuantity = size;
    }

    private void doChangeMember() {
        try {
            CustomerSelectorDialog dialog = CustomerSelectorFactory.createCustomerSelectorDialog(this.ticket.getOrderType());
            dialog.setCreateNewTicket(false);
            if (this.ticket != null) {
                dialog.setTicket(this.ticket);
            }
            dialog.openUndecoratedFullScreen();
            if (!dialog.isCanceled()) {
                Customer selectedCustomer = dialog.getSelectedCustomer();
                this.ticket.setCustomer(selectedCustomer);
                this.updateCustomerInfo(selectedCustomer);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    private void updateCustomerInfo(Customer customer) {
        String memberId = StringUtils.isNotEmpty((String)customer.getMemberId()) ? customer.getMemberId() + "/" : "";
        this.lblCustomerName.setText(memberId + customer.getName());
    }
}

