/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.POSConstants;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.TicketTransferView;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class TransferTicketDialog
extends POSDialog {
    private List<Ticket> tickets;
    private TicketTransferView leftTicketView;
    private TicketTransferView rightTicketView;

    public TransferTicketDialog(List<Ticket> tickets) {
        this.tickets = tickets;
        this.initComponents();
        this.initData();
    }

    private void initData() {
        this.leftTicketView.setSelectTicketButton(0);
        this.rightTicketView.setSelectTicketButton(1);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Transfer ticket items");
        this.add((Component)titlePanel, "North");
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout((LayoutManager)new MigLayout("fill", "[fill, grow][fill, grow]", ""));
        this.leftTicketView = new TicketTransferView(this.tickets, TicketTransferView.ORIENTATION.LEFT);
        this.rightTicketView = new TicketTransferView(this.tickets, TicketTransferView.ORIENTATION.RIGHT);
        this.leftTicketView.setOtherTicketView(this.rightTicketView);
        this.rightTicketView.setOtherTicketView(this.leftTicketView);
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.leftTicketView, "Center");
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add((Component)this.rightTicketView, "Center");
        centerPanel.add((Component)leftPanel, "");
        centerPanel.add((Component)rightPanel, "wrap");
        this.add((Component)centerPanel, "Center");
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("center"));
        PosButton btnOk = new PosButton("Done");
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferTicketDialog.this.doOk();
            }
        });
        PosButton btnCancel = new PosButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferTicketDialog.this.setCanceled(true);
                TransferTicketDialog.this.dispose();
            }
        });
        bottomPanel.add(btnOk);
        bottomPanel.add(btnCancel);
        this.add((Component)bottomPanel, "South");
    }

    private void doOk() {
        try {
            int option;
            List<Ticket> renderedTickets = this.rightTicketView.getTickets();
            ArrayList<Ticket> deleteTickets = new ArrayList<Ticket>();
            Iterator<Ticket> iterator = renderedTickets.iterator();
            while (iterator.hasNext()) {
                Ticket ticket = iterator.next();
                if (ticket.getTicketItems().size() > 0) continue;
                deleteTickets.add(ticket);
                iterator.remove();
            }
            if (deleteTickets.size() > 0 && (option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Some ticket contains no items. Do you want to delete those tickets?", "No items")) != 0) {
                return;
            }
            TicketDAO.getInstance().saveOrUpdateTransferedTicketsList(deleteTickets, renderedTickets);
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception e2) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e2);
        }
    }

    public List<Ticket> getTickets() {
        return this.tickets;
    }

    public void setTickets(List<Ticket> tickets) {
        this.tickets = tickets;
    }
}

