/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.SelectionView;
import com.floreantpos.ui.views.order.actions.CategorySelectionListener;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;

public class CategoryView
extends SelectionView
implements ActionListener {
    private Vector<CategorySelectionListener> listenerList = new Vector();
    private ButtonGroup categoryButtonGroup;
    public static final String VIEW_NAME = "CATEGORY_VIEW";

    public CategoryView() {
        super(POSConstants.CATEGORIES, new GridLayout(0, 1, 5, 5), 100, 100);
        this.dataModel = new PaginatedListModel(5);
        this.categoryButtonGroup = new ButtonGroup();
        this.setPreferredSize(new Dimension(PosUIManager.getSize(120, 100)));
    }

    public void initialize() {
        if (this.isInitialized()) {
            // empty if block
        }
        OrderType orderType = OrderView.getInstance().getCurrentTicket().getOrderType();
        MenuCategoryDAO categoryDAO = MenuCategoryDAO.getInstance();
        this.dataModel.setCurrentRowIndex(0);
        categoryDAO.findActiveCategories(this.dataModel, orderType);
        this.setDataModel(this.dataModel);
        if (this.dataModel.getSize() == 0) {
            return;
        }
        this.setInitialized(true);
        CategoryButton categoryButton = (CategoryButton)this.getFirstItemButton();
        if (categoryButton != null) {
            categoryButton.setSelected(true);
            this.fireCategorySelected(categoryButton.foodCategory);
        }
        if (this.dataModel.getSize() <= 1) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
        }
    }

    @Override
    protected AbstractButton createItemButton(Object item) {
        MenuCategory menuCategory = (MenuCategory)item;
        CategoryButton button = new CategoryButton(this, menuCategory);
        this.categoryButtonGroup.add(button);
        return button;
    }

    public void addCategorySelectionListener(CategorySelectionListener listener) {
        this.listenerList.add(listener);
    }

    public void removeCategorySelectionListener(CategorySelectionListener listener) {
        this.listenerList.remove(listener);
    }

    private void fireCategorySelected(MenuCategory foodCategory) {
        for (CategorySelectionListener listener : this.listenerList) {
            listener.categorySelected(foodCategory);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CategoryButton button = (CategoryButton)e.getSource();
        if (button.isSelected()) {
            this.fireCategorySelected(button.foodCategory);
        }
    }

    @Override
    protected void scrollDown() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        MenuCategoryDAO.getInstance().findActiveCategories(this.dataModel, OrderView.getInstance().getCurrentTicket().getOrderType());
        this.setDataModel(this.dataModel);
    }

    @Override
    protected void scrollUp() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        MenuCategoryDAO.getInstance().findActiveCategories(this.dataModel, OrderView.getInstance().getCurrentTicket().getOrderType());
        this.setDataModel(this.dataModel);
    }

    private static class CategoryButton
    extends POSToggleButton {
        MenuCategory foodCategory;

        CategoryButton(CategoryView view, MenuCategory menuCategory) {
            this.foodCategory = menuCategory;
            this.setText("<html><body><center>" + menuCategory.getDisplayName() + "</center></body></html>");
            if (menuCategory.getButtonColor() != null) {
                this.setBackground(menuCategory.getButtonColor());
            }
            if (menuCategory.getTextColor() != null) {
                this.setForeground(menuCategory.getTextColor());
            }
            this.addActionListener(view);
        }
    }
}

