/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.customer.CustomerSelector;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.main.Application;
import com.floreantpos.main.PosWindow;
import com.floreantpos.model.Customer;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.IView;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.util.DatabaseConnectionException;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import com.floreantpos.util.TicketAlreadyExistsException;
import java.awt.Component;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JOptionPane;

public class DefaultOrderServiceExtension
extends OrderServiceExtension {
    @Override
    public boolean requireLicense() {
        return false;
    }

    @Override
    public String getProductName() {
        return Messages.getString("DefaultOrderServiceExtension.0");
    }

    @Override
    public String getDescription() {
        return Messages.getString("DefaultOrderServiceExtension.1");
    }

    @Override
    public void createNewTicket(OrderType ticketType, List<ShopTable> selectedTables, Customer customer) throws TicketAlreadyExistsException {
        this.createNewTicket(ticketType, selectedTables, customer, 0);
    }

    @Override
    public void setCustomerToTicket(String ticketId) {
    }

    @Override
    public void setDeliveryDate(String ticketId) {
    }

    @Override
    public void assignDriver(String ticketId) {
    }

    @Override
    public boolean finishOrder(String ticketId) {
        Ticket ticket = TicketDAO.getInstance().get(ticketId);
        int due = (int)POSUtil.getDouble(ticket.getDueAmount());
        if (due != 0) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("DefaultOrderServiceExtension.2"));
            return false;
        }
        int option = JOptionPane.showOptionDialog(Application.getPosWindow(), Messages.getString("DefaultOrderServiceExtension.3") + ticket.getId() + Messages.getString("DefaultOrderServiceExtension.4"), Messages.getString("DefaultOrderServiceExtension.5"), 2, 1, null, null, null);
        if (option != 0) {
            return false;
        }
        OrderController.closeOrder(ticket);
        return true;
    }

    @Override
    public void createCustomerMenu(JMenu menu) {
    }

    @Override
    public void initBackoffice(BackOfficeWindow backOfficeWindow) {
    }

    @Override
    public void initConfigurationView(JDialog dialog) {
    }

    @Override
    public String getId() {
        return String.valueOf("DefaultOrderServiceExtension".hashCode());
    }

    @Override
    public IView getDeliveryDispatchView(OrderType orderType) {
        return null;
    }

    @Override
    public CustomerSelector createNewCustomerSelector() {
        return null;
    }

    @Override
    public CustomerSelector createCustomerSelectorView() {
        return null;
    }

    @Override
    public void openDeliveryDispatchDialog(OrderType orderType) {
    }

    @Override
    public IView getDriverView() {
        return null;
    }

    @Override
    public List<AbstractAction> getSpecialFunctionActions() {
        return null;
    }

    @Override
    public boolean hasValidLicense() {
        return true;
    }

    @Override
    public void initUI(PosWindow posWindow) {
    }

    @Override
    public String getProductVersion() {
        return null;
    }

    @Override
    public Component getParent() {
        return null;
    }

    @Override
    public void createNewTicket(OrderType ticketType, List<ShopTable> selectedTables, Customer selectedCustomer, int numberOfGuests) throws TicketAlreadyExistsException {
        try {
            if (ticketType.isShowGuestSelection().booleanValue() && numberOfGuests == 0) {
                numberOfGuests = PosGuiUtil.captureGuestNumber();
            }
            if (TerminalConfig.isActiveCustomerDisplay()) {
                DrawerUtil.setCustomerDisplayMessage(TerminalConfig.getCustomerDisplayPort(), "Welcome");
            }
            if (ticketType.isRequiredCustomerData().booleanValue() && selectedCustomer == null && (selectedCustomer = PosGuiUtil.captureCustomer(ticketType)) == null) {
                return;
            }
            Ticket ticket = new Ticket(true);
            ticket.setOrderType(ticketType);
            ticket.setNumberOfGuests(numberOfGuests);
            ticket.setCustomer(selectedCustomer);
            ticket.setShouldIncludeInSales(true);
            if (selectedTables != null) {
                for (ShopTable shopTable : selectedTables) {
                    shopTable.setTableStatus(TableStatus.Seat);
                    SalesArea salesArea = shopTable.getSalesArea();
                    if (salesArea != null) {
                        ticket.setSalesArea(salesArea);
                        ticket.setSalesAreaId(salesArea.getId());
                    }
                    ticket.addTable(shopTable.getTableNumber());
                }
            }
            OrderView.getInstance().setCurrentTicket(ticket);
            RootView.getInstance().showView("ORDER_VIEW");
        }
        catch (DatabaseConnectionException e) {
            POSMessageDialog.showError("Database connection failure. Please check connection.");
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
    }

    @Override
    public void showDeliveryInfo(Ticket ticket, OrderType orderType, Customer customer) {
    }
}

