/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ScrollableFlowPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.SelectionView;
import com.floreantpos.ui.views.order.actions.ItemSelectionListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import org.hibernate.exception.JDBCConnectionException;

public class MenuItemView
extends SelectionView {
    public static final String VIEW_NAME = "ITEM_VIEW";
    private Vector<ItemSelectionListener> listenerList = new Vector();
    private MenuGroup menuGroup;

    public MenuItemView() {
        super(POSConstants.ITEMS, new FlowLayout(), PosUIManager.getSize(TerminalConfig.getMenuItemButtonWidth()), PosUIManager.getSize(TerminalConfig.getMenuItemButtonHeight()));
        this.dataModel = new PaginatedListModel();
        this.btnPrev.setText("<< PREVIOUS");
        this.btnNext.setText("NEXT >>");
    }

    public MenuGroup getMenuGroup() {
        return this.menuGroup;
    }

    public void setMenuGroup(MenuGroup menuGroup) {
        this.menuGroup = menuGroup;
        this.reset();
        if (menuGroup == null) {
            return;
        }
        try {
            Terminal terminal = Application.getInstance().getTerminal();
            OrderType orderType = OrderView.getInstance().getCurrentTicket().getOrderType();
            this.dataModel.setPageSize(1);
            this.dataModel.setCurrentRowIndex(0);
            this.dataModel.setNumRows(MenuPageDAO.getInstance().getRowCount(terminal, menuGroup, (Object)orderType));
            MenuPageDAO.getInstance().loadItems(terminal, menuGroup, orderType, null, this.dataModel);
            this.setDataModel(this.dataModel);
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    @Override
    protected void renderItems() {
        this.reset();
        if (this.dataModel.getSize() == 0) {
            this.setTitle(POSConstants.ITEMS);
            this.revalidate();
            this.repaint();
            return;
        }
        this.btnPrev.setText("<< " + POSConstants.CAPITAL_PREV);
        MenuPage menuPage = (MenuPage)this.dataModel.getElementAt(0);
        this.setTitle(menuPage.getName());
        int rows = menuPage.getRows();
        int cols = menuPage.getCols();
        double widthPercentage = 100.0 / (double)rows;
        double heightPercentage = 100.0 / (double)cols;
        MigLayout migLayout = new MigLayout("hidemode 0, center,wrap " + cols);
        if (menuPage.isFlixibleButtonSize().booleanValue()) {
            migLayout.setLayoutConstraints((Object)"fill");
            migLayout.setColumnConstraints((Object)"fill,grow");
            migLayout.setRowConstraints((Object)"fill,grow");
        }
        this.selectionButtonsPanel.setLayout((LayoutManager)migLayout);
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                String constraint = String.format("cell %s %s", col, row);
                constraint = menuPage.isFlixibleButtonSize() != false ? constraint + String.format(", w %s, h %s", widthPercentage, heightPercentage) : constraint + String.format(", w %s!, h %s!", menuPage.getButtonWidth(), menuPage.getButtonHeight());
                MenuPageItem itemForCell = menuPage.getItemForCell(col, row);
                if (itemForCell == null) {
                    this.selectionButtonsPanel.add((Component)new JLabel(), constraint);
                    continue;
                }
                if (itemForCell.getMenuItemId() == null || !itemForCell.getMenuItem().isVisible().booleanValue()) continue;
                AbstractButton itemButton = this.createItemButton(itemForCell);
                this.selectionButtonsPanel.add((Component)itemButton, constraint);
            }
        }
        this.revalidate();
        this.repaint();
        this.btnNext.setVisible(this.dataModel.hasNext());
        this.btnPrev.setVisible(this.dataModel.hasPrevious());
    }

    public void rendererVariants(MenuItem parentItem) {
        List<MenuItem> variants = parentItem.getVariants();
        this.reset();
        ScrollableFlowPanel flowPanel = new ScrollableFlowPanel();
        this.selectionButtonsPanel.setLayout((LayoutManager)new MigLayout("fill"));
        for (MenuItem variant : variants) {
            AbstractButton itemButton = this.createItemButton(variant);
            if (itemButton == null) continue;
            flowPanel.add(itemButton);
        }
        PosScrollPane scrollPane = new PosScrollPane(flowPanel);
        scrollPane.setBorder(null);
        this.selectionButtonsPanel.add((Component)scrollPane, "span,grow");
        this.revalidate();
        this.repaint();
        this.btnNext.setVisible(false);
        this.btnPrev.setVisible(true);
        this.btnPrev.setText("BACK");
        this.setTitle(parentItem.getName());
    }

    @Override
    protected AbstractButton createItemButton(Object item) {
        if (item instanceof MenuPageItem) {
            return new PageItemButton((MenuPageItem)item);
        }
        if (item instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)item;
            if (!menuItem.isVisible().booleanValue()) {
                return null;
            }
            menuItem.setMenuGroup(this.menuGroup);
            ItemButton itemButton = new ItemButton(menuItem);
            return itemButton;
        }
        return null;
    }

    public void addItemSelectionListener(ItemSelectionListener listener) {
        this.listenerList.add(listener);
    }

    public void removeItemSelectionListener(ItemSelectionListener listener) {
        this.listenerList.remove(listener);
    }

    private void fireItemSelected(MenuItem foodItem) {
        for (ItemSelectionListener listener : this.listenerList) {
            listener.itemSelected(foodItem);
        }
    }

    @Override
    protected void scrollDown() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        OrderType orderType = OrderView.getInstance().getCurrentTicket().getOrderType();
        MenuPageDAO.getInstance().loadItems(Application.getInstance().getTerminal(), this.menuGroup, orderType, (Boolean)false, this.dataModel);
        this.setDataModel(this.dataModel);
    }

    @Override
    protected void scrollUp() {
        if (this.btnPrev.getText().equals("BACK")) {
            this.renderItems();
            return;
        }
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        OrderType orderType = OrderView.getInstance().getCurrentTicket().getOrderType();
        MenuPageDAO.getInstance().loadItems(Application.getInstance().getTerminal(), this.menuGroup, orderType, (Boolean)false, this.dataModel);
        this.setDataModel(this.dataModel);
    }

    private class PageItemButton
    extends PosButton
    implements ActionListener,
    MouseListener {
        MenuItem menuItem;
        MenuPageItem pageItem;

        PageItemButton(MenuPageItem pageItem) {
            Color textColor;
            this.pageItem = pageItem;
            if (pageItem == null) {
                this.setVisible(false);
                return;
            }
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setPreferredSize(MenuItemView.this.getButtonSize());
            ImageIcon image = pageItem.getImage(MenuItemView.this.getButtonSize().width, pageItem.isShowImageOnly() != false ? MenuItemView.this.getButtonSize().height : 100);
            String buttonText = "<html><body><center>" + pageItem.getMenuItemName() + "</center></body></html>";
            if (image != null) {
                if (pageItem.isShowImageOnly().booleanValue()) {
                    this.setIcon(image);
                } else {
                    this.setIcon(image);
                    this.setText(buttonText);
                }
            } else {
                this.setText(buttonText);
            }
            Color buttonColor = pageItem.getButtonColor();
            if (buttonColor != null) {
                this.setBackground(buttonColor);
            }
            if ((textColor = pageItem.getTextColor()) != null) {
                this.setForeground(textColor);
            }
            this.addActionListener(this);
            this.addMouseListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OrderView.getInstance().is_86Mode()) {
                return;
            }
            try {
                if (this.menuItem == null) {
                    this.menuItem = new MenuItem(this.pageItem.getMenuItemId());
                }
                MenuItemView.this.fireItemSelected(this.menuItem);
            }
            catch (JDBCConnectionException x) {
                POSMessageDialog.showError("Database connection lost. Please try again.");
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (OrderView.getInstance().is_86Mode()) {
                MenuItem menuItem;
                menuItem.setEnable((menuItem = this.pageItem.getMenuItem()).isEnable() == false);
                this.setEnabled(menuItem.isEnable());
                MenuItemDAO.getInstance().update(menuItem);
                return;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class ItemButton
    extends PosButton
    implements ActionListener,
    MouseListener {
        MenuItem menuItem;

        ItemButton(MenuItem menuItem) {
            Color textColor;
            this.menuItem = menuItem;
            if (menuItem == null) {
                this.setVisible(false);
                return;
            }
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setPreferredSize(MenuItemView.this.getButtonSize());
            ImageIcon image = menuItem.getImage(MenuItemView.this.getButtonSize().width, menuItem.isShowImageOnly() != false ? MenuItemView.this.getButtonSize().height : 100);
            String buttonText = "<html><body><center>" + menuItem.getDisplayName() + "</center></body></html>";
            if (image != null) {
                if (menuItem.isShowImageOnly().booleanValue()) {
                    this.setIcon(image);
                } else {
                    this.setIcon(image);
                    this.setText(buttonText);
                }
            } else {
                this.setText(buttonText);
            }
            Color buttonColor = menuItem.getButtonColor();
            if (buttonColor != null) {
                this.setBackground(buttonColor);
            }
            if ((textColor = menuItem.getTextColor()) != null) {
                this.setForeground(textColor);
            }
            this.addActionListener(this);
            this.addMouseListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OrderView.getInstance().is_86Mode()) {
                return;
            }
            try {
                MenuItemView.this.fireItemSelected(this.menuItem);
            }
            catch (JDBCConnectionException x) {
                POSMessageDialog.showError("Database connection lost. Please try again.");
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (OrderView.getInstance().is_86Mode()) {
                this.menuItem.setEnable(this.menuItem.isEnable() == false);
                this.setEnabled(this.menuItem.isEnable());
                MenuItemDAO.getInstance().update(this.menuItem);
                return;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

