/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order.modifier;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.DefaultMenuModifier;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.modifier.ModifierGroupSelectionListener;
import com.floreantpos.ui.views.order.modifier.ModifierGroupView;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionListener;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionModel;
import com.floreantpos.ui.views.order.modifier.ModifierView;
import com.floreantpos.ui.views.order.modifier.TicketItemModifierTableView;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class ModifierSelectionDialog
extends POSDialog
implements ModifierGroupSelectionListener,
ModifierSelectionListener {
    private ModifierSelectionModel modifierSelectionModel;
    private ModifierGroupView modifierGroupView;
    private ModifierView modifierView;
    private TicketItemModifierTableView ticketItemModifierView;
    private JPanel westPanel = new JPanel(new BorderLayout(5, 5));
    private TransparentPanel buttonPanel;
    private PosButton btnSave;
    private PosButton btnCancel;

    public ModifierSelectionDialog(ModifierSelectionModel modifierSelectionModel) {
        super((Frame)Application.getPosWindow(), true);
        this.modifierSelectionModel = modifierSelectionModel;
        this.initComponents();
        this.initData();
    }

    private void initData() {
        MenuItem menuItem = this.modifierSelectionModel.getMenuItem();
        if (this.modifierSelectionModel.getTicketItem().getTicketItemModifiers() == null) {
            List<MenuItemModifierSpec> groupList = menuItem.getMenuItemModiferSpecs();
            Multiplier defaultMultiplier = MultiplierDAO.getInstance().getDefaultMutltiplier();
            for (MenuItemModifierSpec group : groupList) {
                List<DefaultMenuModifier> defaultModifierList;
                if (!group.isEnable().booleanValue() || (defaultModifierList = group.getDefaultModifierList()) == null) continue;
                for (DefaultMenuModifier defaultModifier : defaultModifierList) {
                    MenuModifier modifier = defaultModifier.getModifier();
                    Multiplier multiplier = defaultModifier.getMultiplier();
                    if (multiplier == null) {
                        multiplier = defaultMultiplier;
                    }
                    modifier.setMenuItemModifierGroup(group);
                    this.addToTicket(modifier, multiplier, defaultModifier.getQuantity());
                }
            }
        }
    }

    private void initComponents() {
        this.setTitle(Messages.getString("ModifierSelectionDialog.0"));
        this.setLayout(new BorderLayout(PosUIManager.getSize(5), PosUIManager.getSize(5)));
        this.modifierGroupView = new ModifierGroupView(this.modifierSelectionModel);
        this.modifierView = new ModifierView(this.modifierSelectionModel);
        this.ticketItemModifierView = new TicketItemModifierTableView(this.modifierSelectionModel);
        this.buttonPanel = new TransparentPanel();
        this.buttonPanel.setLayout((LayoutManager)new MigLayout("fill, ins 4", "fill", ""));
        this.westPanel.add(this.ticketItemModifierView);
        this.add((Component)this.modifierGroupView, "East");
        this.add(this.modifierView);
        this.add((Component)this.westPanel, "West");
        this.createButtonPanel();
        this.setBounds(Application.getPosWindow().getBounds());
        this.ticketItemModifierView.addModifierSelectionListener(this);
        this.modifierGroupView.addModifierGroupSelectionListener(this);
        this.modifierView.addModifierSelectionListener(this);
        this.modifierGroupView.selectFirst();
    }

    public void createButtonPanel() {
        this.btnSave = new PosButton(Messages.getString("ModifierSelectionDialog.4"));
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModifierSelectionDialog.this.doFinishModifierSelection();
            }
        });
        this.btnCancel = new PosButton(POSConstants.CANCEL.toUpperCase());
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModifierSelectionDialog.this.setCanceled(true);
                ModifierSelectionDialog.this.dispose();
            }
        });
        this.buttonPanel.add(this.btnCancel);
        this.buttonPanel.add(this.btnSave);
    }

    public ModifierGroupView getModifierGroupView() {
        return this.modifierGroupView;
    }

    public void setModifierGroupView(ModifierGroupView modifierGroupView) {
        this.modifierGroupView = modifierGroupView;
    }

    public ModifierView getModifierView() {
        return this.modifierView;
    }

    public void setModifierView(ModifierView modifierView) {
        this.modifierView = modifierView;
    }

    private void doFinishModifierSelection() {
        List<MenuItemModifierSpec> menuItemModiferGroups = this.modifierSelectionModel.getMenuItem().getMenuItemModiferSpecs();
        if (menuItemModiferGroups == null) {
            this.dispose();
            return;
        }
        boolean finishGroupSelection = true;
        for (MenuItemModifierSpec menuItemModifierGroup : menuItemModiferGroups) {
            if (!menuItemModifierGroup.isEnable().booleanValue() || ModifierSelectionDialog.isRequiredModifiersAdded(this.modifierSelectionModel.getTicketItem(), menuItemModifierGroup)) continue;
            this.showModifierSelectionMessage(menuItemModifierGroup);
            this.modifierGroupView.setSelectedModifierGroup(menuItemModifierGroup);
            finishGroupSelection = false;
        }
    }

    @Override
    public void modifierGroupSelected(MenuItemModifierSpec menuModifierGroup) {
        this.modifierView.setModifierGroup(menuModifierGroup);
    }

    @Override
    public void modifierSelected(MenuModifier modifier, Multiplier multiplier) {
        this.addToTicket(modifier, multiplier);
    }

    private void jumpToNextGroup(MenuModifier modifier) {
        TicketItem ticketItem = this.modifierSelectionModel.getTicketItem();
        MenuItemModifierSpec menuItemModifierGroup = modifier.getMenuItemModifierGroup();
        int freeModifiers = ticketItem.countModifierFromGroup(menuItemModifierGroup);
        int minQuantity = menuItemModifierGroup.getMinQuantity();
        int maxQuantity = menuItemModifierGroup.getMaxQuantity();
        if (maxQuantity < minQuantity) {
            maxQuantity = minQuantity;
        }
        if (menuItemModifierGroup.isJumpGroup().booleanValue() && freeModifiers == maxQuantity) {
            if (this.modifierGroupView.hasNextMandatoryGroup()) {
                this.modifierGroupView.selectNextGroup();
                this.updateView();
                return;
            }
            this.doFinishModifierSelection();
        }
    }

    private void addToTicket(MenuModifier modifier, Multiplier multiplier) {
        this.addToTicket(modifier, multiplier, 1.0);
    }

    private void addToTicket(MenuModifier modifier, Multiplier multiplier, Double quantity) {
        TicketItem ticketItem = this.modifierSelectionModel.getTicketItem();
        MenuItemModifierSpec menuItemModifierGroup = modifier.getMenuItemModifierGroup();
        int numOfModifiers = ticketItem.countModifierFromGroup(menuItemModifierGroup);
        int minQuantity = menuItemModifierGroup.getMinQuantity();
        int maxQuantity = menuItemModifierGroup.getMaxQuantity();
        if (maxQuantity < minQuantity) {
            maxQuantity = minQuantity;
        }
        if (numOfModifiers >= maxQuantity) {
            POSMessageDialog.showError("You have added maximum number of allowed modifiers from group " + modifier.getMenuItemModifierGroup().getDisplayName());
            return;
        }
        TicketItemModifier ticketItemModifier = ticketItem.findTicketItemModifierFor(modifier, multiplier);
        if (ticketItemModifier == null) {
            OrderType type = ticketItem.getTicket().getOrderType();
            TicketItemModifier ticketitemModifier = ticketItem.addTicketItemModifier(modifier, 1, type, multiplier);
            ticketitemModifier.setItemQuantity(quantity);
        } else {
            ticketItemModifier.setItemCount(ticketItemModifier.getItemCount() + 1);
        }
        this.updateView();
        if (numOfModifiers + 1 == maxQuantity) {
            this.modifierGroupSelectionDone(modifier.getMenuItemModifierGroup());
        }
    }

    private void updateView() {
        this.modifierSelectionModel.getTicketItem().calculatePrice();
        this.modifierView.updateView();
        this.ticketItemModifierView.updateView();
    }

    @Override
    public void clearModifiers(MenuItemModifierSpec modifierGroup) {
        TicketItem ticketItem = this.modifierSelectionModel.getTicketItem();
        List<TicketItemModifier> ticketItemModifiers = ticketItem.getTicketItemModifiers();
        if (ticketItemModifiers != null) {
            Iterator<TicketItemModifier> iterator = ticketItemModifiers.iterator();
            while (iterator.hasNext()) {
                TicketItemModifier ticketItemModifier = iterator.next();
                if (ticketItemModifier.isPrintedToKitchen().booleanValue()) continue;
                iterator.remove();
            }
        }
        this.updateView();
    }

    @Override
    public void modifierGroupSelectionDone(MenuItemModifierSpec modifierGroup) {
        if (!ModifierSelectionDialog.isRequiredModifiersAdded(this.modifierSelectionModel.getTicketItem(), modifierGroup)) {
            this.showModifierSelectionMessage(modifierGroup);
            this.modifierGroupView.setSelectedModifierGroup(modifierGroup);
            return;
        }
        if (modifierGroup.isJumpGroup().booleanValue() && this.modifierGroupView.hasNextMandatoryGroup()) {
            this.modifierGroupView.selectNextGroup();
        }
    }

    @Override
    public void finishModifierSelection() {
        TicketItem ticketItem = this.modifierSelectionModel.getTicketItem();
        List<MenuItemModifierSpec> menuItemModiferGroups = this.modifierSelectionModel.getMenuItem().getMenuItemModiferSpecs();
        if (menuItemModiferGroups == null) {
            this.setCanceled(false);
            this.dispose();
            return;
        }
        if (!menuItemModiferGroups.isEmpty()) {
            for (MenuItemModifierSpec menuItemModifierGroup : menuItemModiferGroups) {
                if (ticketItem.requiredModifiersAdded(menuItemModifierGroup)) continue;
                this.modifierGroupSelected(menuItemModifierGroup);
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select minimum quantity of each group!");
                return;
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    public ModifierSelectionModel getModifierSelectionModel() {
        return this.modifierSelectionModel;
    }

    public void setModifierSelectionModel(ModifierSelectionModel modifierSelectionModel) {
        this.modifierSelectionModel = modifierSelectionModel;
    }

    public static boolean isRequiredModifiersAdded(TicketItem ticketItem, MenuItemModifierSpec menuItemModifierGroup) {
        return ticketItem.requiredModifiersAdded(menuItemModifierGroup);
    }

    private void showModifierSelectionMessage(MenuItemModifierSpec menuItemModifierGroup) {
        String displayName = menuItemModifierGroup.getName();
        int minQuantity = menuItemModifierGroup.getMinQuantity();
        POSMessageDialog.showError(Messages.getString("ModifierSelectionDialog.5") + minQuantity + Messages.getString("ModifierSelectionDialog.6") + displayName);
    }

    @Override
    public void modifierRemoved(TicketItemModifier modifier) {
        MenuItemModifierSpec group = MenuItemModifierSpecDAO.getInstance().get(modifier.getGroupId());
        this.modifierView.setModifierGroup(group);
    }
}

