/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.ActionCommand;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.config.CardConfig;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.TransactionListView;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.AuthorizationDialog;
import com.floreantpos.ui.views.payment.CardProcessor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class AuthorizableTicketBrowser
extends POSDialog {
    private TransactionListView authClosedListView = new TransactionListView();
    private TransactionListView authWaitingListView = new TransactionListView();
    private JPanel tabbedPane;
    private POSToggleButton btnShowCaptureWaiting = new POSToggleButton(Messages.getString("AuthorizableTicketBrowser.12"));
    private POSToggleButton btnShowCaptured = new POSToggleButton(Messages.getString("AuthorizableTicketBrowser.13"));
    private User currentUser;
    private Terminal drawerTerminal;

    public AuthorizableTicketBrowser(JFrame parent, User currentUser, Terminal drawerTerminal) {
        this.currentUser = currentUser;
        this.drawerTerminal = drawerTerminal;
        this.init();
    }

    private void init() {
        this.setTitle(POSConstants.AUTHORIZE_BUTTON_TEXT);
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("TicketAuthorizationDialog.0"));
        this.add((Component)titlePanel, "North");
        this.tabbedPane = new JPanel(new BorderLayout());
        JPanel toggleButtonActionPanel = new JPanel((LayoutManager)new MigLayout("", "sg,fill", ""));
        ButtonGroup group = new ButtonGroup();
        group.add(this.btnShowCaptureWaiting);
        group.add(this.btnShowCaptured);
        this.btnShowCaptureWaiting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuthorizableTicketBrowser.this.tabbedPane.remove(AuthorizableTicketBrowser.this.authClosedListView);
                AuthorizableTicketBrowser.this.tabbedPane.add(AuthorizableTicketBrowser.this.authWaitingListView);
                AuthorizableTicketBrowser.this.tabbedPane.revalidate();
                AuthorizableTicketBrowser.this.tabbedPane.repaint();
            }
        });
        this.btnShowCaptured.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuthorizableTicketBrowser.this.tabbedPane.remove(AuthorizableTicketBrowser.this.authWaitingListView);
                AuthorizableTicketBrowser.this.tabbedPane.add(AuthorizableTicketBrowser.this.authClosedListView);
                AuthorizableTicketBrowser.this.tabbedPane.revalidate();
                AuthorizableTicketBrowser.this.tabbedPane.repaint();
            }
        });
        toggleButtonActionPanel.add(this.btnShowCaptureWaiting);
        toggleButtonActionPanel.add(this.btnShowCaptured);
        this.btnShowCaptureWaiting.setSelected(true);
        this.tabbedPane.add((Component)toggleButtonActionPanel, "North");
        this.tabbedPane.add(this.authWaitingListView);
        this.authWaitingListView.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 8));
        this.authClosedListView.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 8));
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        ActionHandler actionHandler = new ActionHandler();
        buttonPanel.add((Component)new PosButton(ActionCommand.EDIT_TIPS, actionHandler), "grow");
        buttonPanel.add((Component)new PosButton(ActionCommand.CAPTURE, actionHandler), "grow");
        buttonPanel.add((Component)new PosButton(ActionCommand.CAPTURE_ALL, actionHandler), "grow");
        buttonPanel.add((Component)new PosButton(ActionCommand.VOID_TRANS, actionHandler), "grow");
        buttonPanel.add(new PosButton(new CloseDialogAction(this)));
        this.tabbedPane.add((Component)buttonPanel, "South");
        JPanel authClosedTab = new JPanel(new BorderLayout());
        JPanel buttonPanel2 = new JPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        buttonPanel2.add((Component)new PosButton(ActionCommand.VOID_TRANS, actionHandler), "grow");
        buttonPanel2.add(new PosButton(new CloseDialogAction(this)));
        authClosedTab.add(this.authClosedListView);
        authClosedTab.add((Component)buttonPanel2, "South");
        this.add(this.tabbedPane);
        this.updateTransactiontList();
    }

    public void updateTransactiontList() {
        User owner = null;
        if (!this.currentUser.isAdministrator() && !this.currentUser.isManager()) {
            owner = this.currentUser;
        }
        this.authWaitingListView.setTransactions(PosTransactionDAO.getInstance().findUnauthorizedTransactions(owner));
        this.authClosedListView.setTransactions(PosTransactionDAO.getInstance().findCapturedTransactions(owner));
    }

    private boolean confirmAuthorize(String message) {
        int option = JOptionPane.showConfirmDialog(this, message, Messages.getString("TicketAuthorizationDialog.1"), 2);
        return option == 0;
    }

    private void doAuthorize() {
        try {
            List<PosTransaction> transactions = this.authWaitingListView.getSelectedTransactions();
            if (transactions == null || transactions.size() == 0) {
                POSMessageDialog.showMessage(this, Messages.getString("TicketAuthorizationDialog.2"));
                return;
            }
            if (!this.confirmAuthorize(Messages.getString("TicketAuthorizationDialog.3"))) {
                return;
            }
            AuthorizationDialog authorizingDialog = new AuthorizationDialog(this, transactions);
            authorizingDialog.setVisible(true);
            this.updateTransactiontList();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, "We are sorry, an unexpected error has occured.");
            PosLog.error(this.getClass(), e);
        }
    }

    public void doAuthorizeAll() {
        try {
            List<PosTransaction> transactions = this.authWaitingListView.getAllTransactions();
            if (transactions == null || transactions.size() == 0) {
                POSMessageDialog.showMessage(this, Messages.getString("TicketAuthorizationDialog.5"));
                return;
            }
            if (!this.confirmAuthorize(Messages.getString("TicketAuthorizationDialog.6"))) {
                return;
            }
            AuthorizationDialog authorizingDialog = new AuthorizationDialog(this, transactions);
            authorizingDialog.setVisible(true);
            this.updateTransactiontList();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, "We are sorry, an unexpected error has occured.");
            PosLog.error(this.getClass(), e);
        }
    }

    private void doEditTips() {
        try {
            PosTransaction transaction = this.authWaitingListView.getFirstSelectedTransaction();
            if (transaction == null) {
                return;
            }
            Ticket ticket = TicketDAO.getInstance().loadFullTicket(transaction.getTicket().getId());
            Set<PosTransaction> transactions = ticket.getTransactions();
            for (PosTransaction posTransaction : transactions) {
                if (!transaction.getId().equals(posTransaction.getId())) continue;
                transaction = posTransaction;
                break;
            }
            double oldTipsAmount = transaction.getTipsAmount();
            double newTipsAmount = NumberSelectionDialog2.show(this, Messages.getString("TicketAuthorizationDialog.8"), oldTipsAmount);
            if (Double.isNaN(newTipsAmount)) {
                return;
            }
            transaction.setTipsAmount(newTipsAmount);
            transaction.setAmount(transaction.getAmount() - oldTipsAmount + newTipsAmount);
            if (ticket.hasGratuity()) {
                double ticketTipsAmount = ticket.getGratuity().getAmount();
                double ticketPaidAmount = ticket.getPaidAmount();
                double newTicketTipsAmount = ticketTipsAmount - oldTipsAmount + newTipsAmount;
                double newTicketPaidAmount = ticketPaidAmount - oldTipsAmount + newTipsAmount;
                ticket.setGratuityAmount(newTicketTipsAmount);
                ticket.setPaidAmount(newTicketPaidAmount);
            } else {
                ticket.setGratuityAmount(newTipsAmount);
                ticket.setPaidAmount(ticket.getPaidAmount() + newTipsAmount);
            }
            ticket.calculatePrice();
            TicketDAO.getInstance().saveOrUpdate(ticket);
            this.updateTransactiontList();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, "We are sorry, an unexpected error has occured.");
            PosLog.error(this.getClass(), e);
        }
    }

    private void doVoidTransaction() {
        try {
            PosTransaction transaction = this.authWaitingListView.getSelectedTransaction();
            if (this.btnShowCaptured.isSelected()) {
                transaction = this.authClosedListView.getSelectedTransaction();
            }
            if (transaction == null) {
                POSMessageDialog.showMessage(this, "Please select transaction to void");
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("AuthorizableTicketBrowser.14"), Messages.getString("AuthorizableTicketBrowser.15"));
            if (option != 0) {
                return;
            }
            CardProcessor cardProcessor = CardConfig.getPaymentGateway().getProcessor();
            cardProcessor.voidTransaction(transaction);
            PosTransactionDAO.getInstance().saveOrUpdate(transaction);
            POSMessageDialog.showMessage(this, "Transaction voided");
            this.updateTransactiontList();
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, "We are sorry, voiding transaction failed because of an unexpected error.");
            PosLog.error(this.getClass(), e);
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActionCommand command = ActionCommand.valueOf(e.getActionCommand());
            try {
                switch (command) {
                    case EDIT_TIPS: {
                        AuthorizableTicketBrowser.this.doEditTips();
                        break;
                    }
                    case CAPTURE: {
                        AuthorizableTicketBrowser.this.doAuthorize();
                        break;
                    }
                    case CAPTURE_ALL: {
                        AuthorizableTicketBrowser.this.doAuthorizeAll();
                        break;
                    }
                    case VOID_TRANS: {
                        AuthorizableTicketBrowser.this.doVoidTransaction();
                        break;
                    }
                }
            }
            catch (Exception e2) {
                POSMessageDialog.showError(AuthorizableTicketBrowser.this, e2.getMessage(), e2);
            }
        }
    }
}

