/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.CardConfig;
import com.floreantpos.config.GiftCardConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.extension.InginicoPlugin;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.TransactionCompletionDialog;
import com.floreantpos.ui.views.TicketDetailView;
import com.floreantpos.ui.views.payment.AuthorizationCodeDialog;
import com.floreantpos.ui.views.payment.CardInputListener;
import com.floreantpos.ui.views.payment.CardInputProcessor;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.ui.views.payment.ConfirmPayDialog;
import com.floreantpos.ui.views.payment.CustomPaymentSelectionDialog;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.ui.views.payment.GroupPaymentView;
import com.floreantpos.ui.views.payment.ManualCardEntryDialog;
import com.floreantpos.ui.views.payment.PaymentProcessWaitDialog;
import com.floreantpos.ui.views.payment.PosPaymentWaitDialog;
import com.floreantpos.ui.views.payment.SwipeCardDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;

public class GroupSettleTicketDialog
extends POSDialog
implements CardInputListener {
    public static final String LOYALTY_DISCOUNT_PERCENTAGE = "loyalty_discount_percentage";
    public static final String LOYALTY_POINT = "loyalty_point";
    public static final String LOYALTY_COUPON = "loyalty_coupon";
    public static final String LOYALTY_DISCOUNT = "loyalty_discount";
    public static final String LOYALTY_ID = "loyalty_id";
    public static final String VIEW_NAME = "PAYMENT_VIEW";
    private GroupPaymentView paymentView;
    private List<Ticket> tickets;
    private TicketDetailView ticketDetailView;
    private JScrollPane ticketScrollPane;
    private double totalTenderAmount;
    private PaymentType paymentType;
    private JTextField tfSubtotal;
    private JTextField tfDiscount;
    private JTextField tfDeliveryCharge;
    private JTextField tfTax;
    private JTextField tfTotal;
    private JTextField tfGratuity;
    private JTextField tfServiceCharge;
    private JTextField tfRefund;
    private String ticketNumbers = "";
    private List<Integer> tableNumbers = new ArrayList<Integer>();
    private String customerName;
    private double totalDueAmount;
    private JLabel lblCustomer;
    private JLabel lblTable;
    private JLabel labelTicketNumber;
    private JLabel labelTableNumber;
    private JLabel labelCustomer;
    public static PosPaymentWaitDialog waitDialog = new PosPaymentWaitDialog();
    private User currentUser;
    private JLabel lblDeliveryCharge;
    private JLabel lblServiceCharge;
    private JLabel lblRefund;
    private JLabel lblGratuity;

    public GroupSettleTicketDialog(List<Ticket> tickets, User currentUser) {
        this.tickets = tickets;
        this.currentUser = currentUser;
        for (Ticket ticket : tickets) {
            if (!ticket.getOrderType().isConsolidateItemsInReceipt().booleanValue()) continue;
            ticket.consolidateTicketItems();
        }
        this.setTitle(Messages.getString("SettleTicketDialog.6"));
        this.getContentPane().setLayout(new BorderLayout());
        this.ticketDetailView = new TicketDetailView();
        this.ticketScrollPane = new PosScrollPane(this.ticketDetailView);
        JPanel centerPanel = new JPanel(new BorderLayout(5, 5));
        centerPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 0));
        centerPanel.add((Component)this.createTicketInfoPanel(), "North");
        centerPanel.add((Component)this.ticketScrollPane, "Center");
        centerPanel.add((Component)this.createTotalViewerPanel(), "South");
        this.paymentView = new GroupPaymentView(this);
        this.paymentView.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.getContentPane().add((Component)centerPanel, "Center");
        this.getContentPane().add((Component)this.paymentView, "East");
        this.setSize(Application.getPosWindow().getSize());
        this.updateView();
        this.paymentView.updateView();
        this.paymentView.setDefaultFocus();
    }

    public void updateView() {
        if (this.tickets == null && !this.tickets.isEmpty()) {
            this.tfSubtotal.setText("");
            this.tfDiscount.setText("");
            this.tfDeliveryCharge.setText("");
            this.tfTax.setText("");
            this.tfTotal.setText("");
            this.tfServiceCharge.setText("");
            this.tfRefund.setText("");
            this.tfGratuity.setText("");
            return;
        }
        double subtotalAmount = 0.0;
        double discountAmount = 0.0;
        double deliveryCharge = 0.0;
        double taxAmount = 0.0;
        double serviceChargeAmount = 0.0;
        double refundAmount = 0.0;
        double gratuityAmount = 0.0;
        double totalAmount = 0.0;
        for (Ticket ticket : this.tickets) {
            subtotalAmount += ticket.getSubtotalAmount().doubleValue();
            discountAmount += ticket.getDiscountAmount().doubleValue();
            deliveryCharge += ticket.getDeliveryCharge().doubleValue();
            serviceChargeAmount += ticket.getServiceCharge().doubleValue();
            refundAmount += ticket.getRefundAmount().doubleValue();
            taxAmount += ticket.getTaxAmount().doubleValue();
            if (ticket.getGratuity() != null) {
                gratuityAmount = ticket.getGratuity().getAmount();
            }
            totalAmount += ticket.getTotalAmountWithTips().doubleValue();
            this.totalDueAmount += ticket.getDueAmount().doubleValue();
            this.ticketNumbers = this.ticketNumbers + "[" + (ticket.getId() == null ? "New Ticket" : ticket.getId()) + "], ";
            List<Integer> tableNumbers = ticket.getTableNumbers();
            if (tableNumbers != null && tableNumbers.size() > 0) {
                for (Integer tableNumber : tableNumbers) {
                    if (tableNumbers.contains(tableNumber)) continue;
                    tableNumbers.add(tableNumber);
                }
            }
            this.customerName = ticket.getProperty("CUSTOMER_NAME");
        }
        this.tfSubtotal.setText(NumberUtil.formatNumber(subtotalAmount));
        this.tfDiscount.setText(NumberUtil.formatNumber(discountAmount));
        if (Application.getInstance().isPriceIncludesTax()) {
            this.tfTax.setText(Messages.getString("TicketView.35"));
        } else {
            this.tfTax.setText(NumberUtil.formatNumber(taxAmount));
        }
        if (deliveryCharge > 0.0) {
            this.tfDeliveryCharge.setText(NumberUtil.formatNumber(deliveryCharge));
        } else {
            this.lblDeliveryCharge.setVisible(false);
            this.tfDeliveryCharge.setVisible(false);
        }
        if (serviceChargeAmount > 0.0) {
            this.tfServiceCharge.setText(NumberUtil.formatNumber(serviceChargeAmount));
        } else {
            this.lblServiceCharge.setVisible(false);
            this.tfServiceCharge.setVisible(false);
        }
        if (refundAmount > 0.0) {
            this.tfRefund.setText(NumberUtil.formatNumber(refundAmount));
        } else {
            this.lblRefund.setVisible(false);
            this.tfRefund.setVisible(false);
        }
        if (gratuityAmount > 0.0) {
            this.tfGratuity.setText(NumberUtil.formatNumber(gratuityAmount));
        } else {
            this.lblGratuity.setVisible(false);
            this.tfGratuity.setVisible(false);
        }
        this.tfTotal.setText(NumberUtil.formatNumber(totalAmount));
        this.labelTicketNumber.setText(this.ticketNumbers.substring(0, this.ticketNumbers.length() - 2));
        this.labelTableNumber.setText(this.tableNumbers.toString());
        if (this.tableNumbers.isEmpty()) {
            this.labelTableNumber.setVisible(false);
            this.lblTable.setVisible(false);
        }
        this.labelCustomer.setText(this.customerName);
        if (this.customerName == null) {
            this.labelCustomer.setVisible(false);
            this.lblCustomer.setVisible(false);
        }
        this.ticketDetailView.setTickets(this.tickets);
    }

    private JPanel createTicketInfoPanel() {
        JLabel lblTicket = new JLabel();
        lblTicket.setText(Messages.getString("SettleTicketDialog.0"));
        this.labelTicketNumber = new JLabel();
        this.lblTable = new JLabel();
        this.lblTable.setText(POSConstants.TABLES);
        this.labelTableNumber = new JLabel();
        this.lblCustomer = new JLabel();
        this.lblCustomer.setText("Customer:");
        this.labelCustomer = new JLabel();
        TransparentPanel ticketInfoPanel = new TransparentPanel((LayoutManager)new MigLayout("wrap 2,fill, hidemode 3", "[][grow]", ""));
        ticketInfoPanel.add(lblTicket);
        ticketInfoPanel.add((Component)this.labelTicketNumber, "grow");
        ticketInfoPanel.add(this.lblTable);
        ticketInfoPanel.add((Component)this.labelTableNumber, "grow");
        ticketInfoPanel.add(this.lblCustomer);
        ticketInfoPanel.add((Component)this.labelCustomer, "grow");
        return ticketInfoPanel;
    }

    private JPanel createTotalViewerPanel() {
        JLabel lblSubtotal = new JLabel();
        lblSubtotal.setHorizontalAlignment(4);
        lblSubtotal.setText(POSConstants.SUBTOTAL + ": " + CurrencyUtil.getCurrencySymbol());
        this.tfSubtotal = new JTextField(10);
        this.tfSubtotal.setHorizontalAlignment(11);
        this.tfSubtotal.setEditable(false);
        JLabel lblDiscount = new JLabel();
        lblDiscount.setHorizontalAlignment(4);
        lblDiscount.setText(Messages.getString("TicketView.9") + " " + CurrencyUtil.getCurrencySymbol());
        this.tfDiscount = new JTextField(10);
        this.tfDiscount.setHorizontalAlignment(11);
        this.tfDiscount.setEditable(false);
        this.lblDeliveryCharge = new JLabel();
        this.lblDeliveryCharge.setHorizontalAlignment(4);
        this.lblDeliveryCharge.setText("Delivery Charge: " + CurrencyUtil.getCurrencySymbol());
        this.lblDeliveryCharge.setVisible(true);
        this.tfDeliveryCharge = new JTextField(10);
        this.tfDeliveryCharge.setHorizontalAlignment(11);
        this.tfDeliveryCharge.setEditable(false);
        this.tfDeliveryCharge.setVisible(true);
        JLabel lblTax = new JLabel();
        lblTax.setHorizontalAlignment(4);
        lblTax.setText(POSConstants.TAX + ": " + CurrencyUtil.getCurrencySymbol());
        this.tfTax = new JTextField();
        this.tfTax.setEditable(false);
        this.tfTax.setHorizontalAlignment(11);
        this.lblServiceCharge = new JLabel();
        this.lblServiceCharge.setHorizontalAlignment(4);
        this.lblServiceCharge.setText("Service Charge: " + CurrencyUtil.getCurrencySymbol());
        this.lblServiceCharge.setVisible(true);
        this.tfServiceCharge = new JTextField();
        this.tfServiceCharge.setEditable(false);
        this.tfServiceCharge.setVisible(true);
        this.tfServiceCharge.setHorizontalAlignment(11);
        this.lblRefund = new JLabel();
        this.lblRefund.setHorizontalAlignment(4);
        this.lblRefund.setText("Refund: " + CurrencyUtil.getCurrencySymbol());
        this.lblRefund.setVisible(true);
        this.tfRefund = new JTextField();
        this.tfRefund.setEditable(false);
        this.tfRefund.setVisible(true);
        this.tfRefund.setHorizontalAlignment(11);
        this.lblGratuity = new JLabel();
        this.lblGratuity.setHorizontalAlignment(4);
        this.lblGratuity.setText(Messages.getString("SettleTicketDialog.5") + ": " + CurrencyUtil.getCurrencySymbol());
        this.lblGratuity.setVisible(true);
        this.tfGratuity = new JTextField();
        this.tfGratuity.setEditable(false);
        this.tfGratuity.setVisible(true);
        this.tfGratuity.setHorizontalAlignment(11);
        JLabel lblTotal = new JLabel();
        lblTotal.setFont(lblTotal.getFont().deriveFont(1, 18.0f));
        lblTotal.setHorizontalAlignment(4);
        lblTotal.setText(POSConstants.TOTAL + ": " + CurrencyUtil.getCurrencySymbol());
        this.tfTotal = new JTextField(10);
        this.tfTotal.setFont(this.tfTotal.getFont().deriveFont(1, 18.0f));
        this.tfTotal.setHorizontalAlignment(11);
        this.tfTotal.setEditable(false);
        TransparentPanel ticketAmountPanel = new TransparentPanel((LayoutManager)new MigLayout("hidemode 3,ins 2 2 3 2,alignx trailing,fill", "[grow][]", ""));
        ticketAmountPanel.add((Component)lblSubtotal, "growx,aligny center");
        ticketAmountPanel.add((Component)this.tfSubtotal, "growx,aligny center");
        ticketAmountPanel.add((Component)lblDiscount, "newline,growx,aligny center");
        ticketAmountPanel.add((Component)this.tfDiscount, "growx,aligny center");
        ticketAmountPanel.add((Component)lblTax, "newline,growx,aligny center");
        ticketAmountPanel.add((Component)this.tfTax, "growx,aligny center");
        ticketAmountPanel.add((Component)this.lblDeliveryCharge, "newline,growx,aligny center");
        ticketAmountPanel.add((Component)this.tfDeliveryCharge, "growx,aligny center");
        ticketAmountPanel.add((Component)this.lblServiceCharge, "newline,growx,aligny center");
        ticketAmountPanel.add((Component)this.tfServiceCharge, "growx,aligny center");
        ticketAmountPanel.add((Component)this.lblRefund, "newline,growx,aligny center");
        ticketAmountPanel.add((Component)this.tfRefund, "growx,aligny center");
        ticketAmountPanel.add((Component)this.lblGratuity, "newline,growx,aligny center");
        ticketAmountPanel.add((Component)this.tfGratuity, "growx,aligny center");
        ticketAmountPanel.add((Component)lblTotal, "newline,growx,aligny center");
        ticketAmountPanel.add((Component)this.tfTotal, "growx,aligny center");
        return ticketAmountPanel;
    }

    public void doGroupSettle(PaymentType paymentType) {
        try {
            if (this.tickets == null) {
                return;
            }
            this.paymentType = paymentType;
            this.totalTenderAmount = this.paymentView.getTenderedAmount();
            this.totalDueAmount = NumberUtil.roundToTwoDigit(this.totalDueAmount);
            if (this.totalTenderAmount < this.totalDueAmount) {
                POSMessageDialog.showMessage("Partial payment not allowed.");
                return;
            }
            PosTransaction transaction = null;
            switch (paymentType) {
                case CASH: {
                    if (!this.confirmPayment()) {
                        return;
                    }
                    transaction = paymentType.createTransaction();
                    transaction.setCaptured(true);
                    this.settleTicket(transaction);
                    break;
                }
                case CUSTOM_PAYMENT: {
                    CustomPaymentSelectionDialog customPaymentDialog = new CustomPaymentSelectionDialog();
                    customPaymentDialog.setTitle(Messages.getString("SettleTicketDialog.8"));
                    customPaymentDialog.pack();
                    customPaymentDialog.open();
                    if (customPaymentDialog.isCanceled()) {
                        return;
                    }
                    if (!this.confirmPayment()) {
                        return;
                    }
                    transaction = paymentType.createTransaction();
                    CustomPaymentTransaction customPaymentTransaction = (CustomPaymentTransaction)transaction;
                    customPaymentTransaction.setCustomPaymentFieldName(customPaymentDialog.getPaymentFieldName());
                    customPaymentTransaction.setCustomPaymentName(customPaymentDialog.getPaymentName());
                    customPaymentTransaction.setCustomPaymentRef(customPaymentDialog.getPaymentRef());
                    customPaymentTransaction.setCaptured(true);
                    this.settleTicket(customPaymentTransaction);
                    break;
                }
                case CREDIT_CARD: 
                case DEBIT_CARD: {
                    this.payUsingCard(this.totalTenderAmount);
                    break;
                }
                case GIFT_CERTIFICATE: {
                    this.doPayByGiftCard(this.totalTenderAmount);
                    break;
                }
            }
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    private boolean confirmPayment() {
        if (!TerminalConfig.isUseSettlementPrompt()) {
            return true;
        }
        ConfirmPayDialog confirmPayDialog = new ConfirmPayDialog();
        confirmPayDialog.setAmount(this.totalTenderAmount);
        confirmPayDialog.open();
        return !confirmPayDialog.isCanceled();
    }

    public void settleTicket(PosTransaction posTransaction) {
        try {
            ArrayList<PosTransaction> transactionList = new ArrayList<PosTransaction>();
            this.totalTenderAmount = this.paymentView.getTenderedAmount();
            for (Ticket ticket : this.tickets) {
                PosTransaction transaction = null;
                if (this.totalTenderAmount <= 0.0) break;
                transaction = (PosTransaction)SerializationUtils.clone((Serializable)posTransaction);
                transaction.setTicket(ticket);
                this.setTransactionAmounts(transaction);
                PosTransactionService transactionService = PosTransactionService.getInstance();
                transactionService.settleTicket(ticket, transaction, this.currentUser);
                transactionList.add(transaction);
                if (!DataProvider.get().getCurrentTerminal().isAutoPrintReceipt()) continue;
                GroupSettleTicketDialog.printTicket(ticket, transaction);
            }
            this.showTransactionCompleteMsg(this.totalDueAmount, this.totalTenderAmount, this.tickets, transactionList);
            this.setCanceled(false);
            this.dispose();
        }
        catch (UnknownHostException e) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("SettleTicketDialog.12"));
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    public void showTransactionCompleteMsg(double dueAmount, double tenderedAmount, List<Ticket> tickets, List<PosTransaction> transactions) {
        TransactionCompletionDialog dialog = new TransactionCompletionDialog(transactions);
        dialog.setTickets(tickets);
        double paidAmount = 0.0;
        double ticketsDueAmount = 0.0;
        double changeAmount = 0.0;
        for (PosTransaction transaction : transactions) {
            paidAmount += transaction.getAmount().doubleValue();
            dialog.setCard(transaction.isCard());
            changeAmount += transaction.getChangeAmount().doubleValue();
        }
        dialog.setTenderedAmount(tenderedAmount);
        dialog.setTotalAmount(dueAmount);
        dialog.setPaidAmount(paidAmount);
        for (Ticket tTicket : tickets) {
            ticketsDueAmount += tTicket.getDueAmount().doubleValue();
        }
        dialog.setDueAmount(ticketsDueAmount);
        dialog.setChangeAmount(changeAmount);
        dialog.updateView();
        dialog.pack();
        dialog.open();
    }

    public static void printTicket(Ticket ticket, PosTransaction transaction) {
        try {
            if (ticket.needsKitchenPrint()) {
                ReceiptPrintService.printToKitchen(ticket);
            }
            ReceiptPrintService.printTransaction(transaction);
            if (transaction instanceof CashTransaction) {
                DrawerUtil.kickDrawer();
            }
        }
        catch (Exception ee) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.PRINT_ERROR, ee);
        }
    }

    private void payUsingCard(double tenderedAmount) throws Exception {
        try {
            PaymentGatewayPlugin paymentGateway = CardConfig.getPaymentGateway();
            if (paymentGateway instanceof InginicoPlugin) {
                waitDialog.setVisible(true);
                if (!waitDialog.isCanceled()) {
                    this.dispose();
                }
                return;
            }
            if (!paymentGateway.shouldShowCardInputProcessor()) {
                PosTransaction transaction = this.paymentType.createTransaction();
                if (!this.confirmPayment()) {
                    return;
                }
                Ticket ticket = this.tickets.get(0);
                transaction.setTenderAmount(this.totalTenderAmount);
                if (this.totalTenderAmount >= this.getDueAmount()) {
                    transaction.setAmount(this.getDueAmount());
                } else {
                    transaction.setAmount(this.totalTenderAmount);
                }
                transaction.setTicket(ticket);
                transaction.setCaptured(false);
                transaction.setCardMerchantGateway(paymentGateway.getProductName());
                if (ticket.getOrderType().isPreAuthCreditCard().booleanValue()) {
                    paymentGateway.getProcessor().preAuth(transaction);
                } else {
                    paymentGateway.getProcessor().chargeAmount(transaction);
                }
                this.settleTicket(transaction);
                return;
            }
            CardReader cardReader = CardConfig.getCardReader();
            switch (cardReader) {
                case SWIPE: {
                    SwipeCardDialog swipeCardDialog = new SwipeCardDialog(this, this.paymentType);
                    swipeCardDialog.pack();
                    swipeCardDialog.open();
                    break;
                }
                case MANUAL: {
                    ManualCardEntryDialog dialog = new ManualCardEntryDialog(this, this.paymentType);
                    dialog.pack();
                    dialog.open();
                    break;
                }
                case EXTERNAL_TERMINAL: {
                    AuthorizationCodeDialog authorizationCodeDialog = new AuthorizationCodeDialog(this, this.paymentType);
                    authorizationCodeDialog.pack();
                    authorizationCodeDialog.open();
                    break;
                }
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void cardInputted(CardInputProcessor inputter, PaymentType selectedPaymentType, String cardType) {
        PaymentProcessWaitDialog waitDialog = new PaymentProcessWaitDialog(this);
        try {
            waitDialog.setVisible(true);
            switch (selectedPaymentType) {
                case GIFT_CERTIFICATE: {
                    this.giftCardInputted(inputter, selectedPaymentType, cardType);
                    return;
                }
                case CREDIT_CARD: 
                case DEBIT_CARD: {
                    this.creditCardInputted(inputter, selectedPaymentType, cardType);
                    return;
                }
            }
            return;
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getMessage());
            return;
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
            return;
        }
        finally {
            waitDialog.setVisible(false);
        }
    }

    private void creditCardInputted(CardInputProcessor inputter, PaymentType selectedPaymentType, String cardType) {
        PosTransaction transaction = this.paymentType.createTransaction();
        PaymentGatewayPlugin paymentGateway = CardConfig.getPaymentGateway();
        if (paymentGateway == null) {
            throw new PosException("No credit card payment gateway is configured.");
        }
        CardProcessor cardProcessor = paymentGateway.getProcessor();
        if (inputter instanceof SwipeCardDialog) {
            SwipeCardDialog swipeCardDialog = (SwipeCardDialog)inputter;
            String cardString = swipeCardDialog.getCardString();
            if (StringUtils.isEmpty((String)cardString) || cardString.length() < 16) {
                throw new RuntimeException(Messages.getString("SettleTicketDialog.16"));
            }
            if (!this.confirmPayment()) {
                return;
            }
            transaction.setCardType(cardType);
            transaction.setCardTrack(cardString);
            transaction.setCaptured(false);
            transaction.setCardMerchantGateway(paymentGateway.getProductName());
            transaction.setCardReader(CardReader.SWIPE.name());
            this.settleTicket(cardProcessor, transaction);
        } else if (inputter instanceof ManualCardEntryDialog) {
            ManualCardEntryDialog mDialog = (ManualCardEntryDialog)inputter;
            transaction.setCaptured(false);
            transaction.setCardMerchantGateway(paymentGateway.getProductName());
            transaction.setCardReader(CardReader.MANUAL.name());
            transaction.setCardNumber(mDialog.getCardNumber());
            transaction.setCardExpMonth(mDialog.getExpMonth());
            transaction.setCardExpYear(mDialog.getExpYear());
            this.settleTicket(cardProcessor, transaction);
        } else if (inputter instanceof AuthorizationCodeDialog) {
            PosTransaction selectedTransaction = selectedPaymentType.createTransaction();
            AuthorizationCodeDialog authDialog = (AuthorizationCodeDialog)inputter;
            String authorizationCode = authDialog.getAuthorizationCode();
            if (StringUtils.isEmpty((String)authorizationCode)) {
                throw new PosException(Messages.getString("SettleTicketDialog.17"));
            }
            selectedTransaction.setCardType(cardType);
            selectedTransaction.setCaptured(true);
            selectedTransaction.setAuthorizable(false);
            selectedTransaction.setCardReader(CardReader.EXTERNAL_TERMINAL.name());
            selectedTransaction.setCardAuthCode(authorizationCode);
            this.settleTicket(selectedTransaction);
        }
    }

    private void giftCardInputted(CardInputProcessor inputter, PaymentType selectedPaymentType, String cardType) throws Exception {
        PosTransaction transaction = this.paymentType.createTransaction();
        GiftCardPaymentPlugin giftCardPaymentGateway = GiftCardConfig.getPaymentGateway();
        if (giftCardPaymentGateway == null) {
            throw new PosException("No payment gateway is configured for gift card.");
        }
        GiftCardProcessor giftCardProcessor = giftCardPaymentGateway.getProcessor();
        if (inputter instanceof SwipeCardDialog) {
            SwipeCardDialog swipeGiftCardDialog = (SwipeCardDialog)inputter;
            String giftCardNo = swipeGiftCardDialog.getCardString();
            giftCardProcessor.validateCardNo(giftCardNo);
            double amount = giftCardProcessor.getBalance(giftCardNo);
            if (this.totalTenderAmount > amount) {
                POSMessageDialog.showMessage("Not enough balance.");
                return;
            }
            transaction.setCardType(cardType);
            transaction.setGiftCertNumber(giftCardNo);
            transaction.setCardMerchantGateway(giftCardPaymentGateway.getProductName());
            transaction.setCardReader(CardReader.SWIPE.name());
            transaction.setTenderAmount(this.totalTenderAmount);
            giftCardProcessor.chargeAmount(transaction);
            this.settleTicket(transaction);
        } else if (inputter instanceof ManualCardEntryDialog) {
            ManualCardEntryDialog mDialog = (ManualCardEntryDialog)inputter;
            String cardNumber = mDialog.getCardNumber();
            giftCardProcessor.validateCardNo(cardNumber);
            double amount = giftCardProcessor.getBalance(cardNumber);
            if (this.totalTenderAmount > amount) {
                POSMessageDialog.showMessage("Not enough balance.");
                return;
            }
            transaction.setCardMerchantGateway(giftCardPaymentGateway.getProductName());
            transaction.setCardReader(CardReader.MANUAL.name());
            transaction.setGiftCertNumber(cardNumber);
            transaction.setCardExpMonth(mDialog.getExpMonth());
            transaction.setCardExpYear(mDialog.getExpYear());
            transaction.setTenderAmount(this.totalTenderAmount);
            giftCardProcessor.chargeAmount(transaction);
            this.settleTicket(transaction);
        } else {
            throw new PosException("Not configured.");
        }
    }

    private void settleTicket(CardProcessor cardProcessor, PosTransaction transaction) {
        try {
            ArrayList<PosTransaction> transactionList = new ArrayList<PosTransaction>();
            this.totalTenderAmount = this.paymentView.getTenderedAmount();
            for (Ticket ticket : this.tickets) {
                PosTransaction cardTransaction = new PosTransaction();
                if (this.totalTenderAmount <= 0.0) break;
                cardTransaction = (PosTransaction)SerializationUtils.clone((Serializable)transaction);
                cardTransaction.setId(null);
                cardTransaction.setTicket(ticket);
                this.setTransactionAmounts(cardTransaction);
                if (ticket.getOrderType().isPreAuthCreditCard().booleanValue()) {
                    cardProcessor.preAuth(cardTransaction);
                } else {
                    cardProcessor.chargeAmount(cardTransaction);
                }
                PosTransactionService transactionService = PosTransactionService.getInstance();
                transactionService.settleTicket(ticket, cardTransaction, this.currentUser);
                transactionList.add(cardTransaction);
                GroupSettleTicketDialog.printTicket(ticket, cardTransaction);
            }
            this.showTransactionCompleteMsg(this.totalDueAmount, this.totalTenderAmount, this.tickets, transactionList);
            this.setCanceled(false);
            this.dispose();
        }
        catch (UnknownHostException e) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("SettleTicketDialog.12"));
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    private void setTransactionAmounts(PosTransaction transaction) {
        if (this.tickets.get(this.tickets.size() - 1).getId() == transaction.getTicket().getId()) {
            if (this.totalTenderAmount > this.totalDueAmount) {
                transaction.setTenderAmount(this.totalTenderAmount - this.totalDueAmount + transaction.getTicket().getDueAmount());
                transaction.setAmount(transaction.getTicket().getDueAmount());
            } else {
                transaction.setTenderAmount(transaction.getTicket().getDueAmount());
                transaction.setAmount(transaction.getTicket().getDueAmount());
            }
            String ticketNumbers = "";
            for (Ticket ticket : this.tickets) {
                ticketNumbers = ticketNumbers + "[" + ticket.getId() + "]";
            }
            ticketNumbers = ticketNumbers.substring(0, ticketNumbers.length() > 215 ? 215 : ticketNumbers.length());
            ticketNumbers = ticketNumbers + (ticketNumbers.length() == 215 ? "...." : "");
            transaction.getTicket().addProperty("GROUP_SETTLE_TICKETS", "#CHK " + ticketNumbers);
        } else {
            transaction.setTenderAmount(transaction.getTicket().getDueAmount());
            transaction.setAmount(transaction.getTicket().getDueAmount());
        }
    }

    public List<Ticket> getTickets() {
        return this.tickets;
    }

    public double getDueAmount() {
        return this.totalDueAmount;
    }

    private void doPayByGiftCard(double tenderedAmount) throws Exception {
        try {
            GiftCardPaymentPlugin giftCardPaymentPlugin = GiftCardConfig.getPaymentGateway();
            if (giftCardPaymentPlugin == null) {
                throw new PosException("Gift card payment gateway is not configured.");
            }
            SwipeCardDialog swipeGiftCardDialog = new SwipeCardDialog(this, this.paymentType);
            swipeGiftCardDialog.setAuthorizationEntryVisible(false);
            swipeGiftCardDialog.pack();
            swipeGiftCardDialog.open();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }
}

